

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_getDdbMoveStatusOfSubStore.sp] ---------- 

--			ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_getDdbMoveStatusOfSubStore.sp,v $ $Id: MM_getDdbMoveStatusOfSubStore.sp,v 1.7.192.3 2020/09/30 22:10:51 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_getDdbMoveStatusOfSubStore')
BEGIN
	print '>>> Drop Stored Procedure: MM_getDdbMoveStatusOfSubStore <<<'
	drop procedure MM_getDdbMoveStatusOfSubStore
END
IF EXISTS (select * from GxQscripts where name='MM_getDdbMoveStatusOfSubStore')
	delete from GxQscripts where name = 'MM_getDdbMoveStatusOfSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_getDdbMoveStatusOfSubStore')
	delete from GXDBVersions where aliasname = 'MM_getDdbMoveStatusOfSubStore'
GO
print '... Creating Procedure: MM_getDdbMoveStatusOfSubStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_getDdbMoveStatusOfSubStore
  @i_substoreIdListXml XML
AS
  DECLARE @o_substoreAndStatusXml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
; with subStoreId_cte
AS	(
	SELECT ISNULL(param.value('@val', 'INT'), 0) AS substoreId
	FROM @i_substoreIdListXml.nodes('/EVGui_sidbSubStoreMoveStatusReq/substoreIdList') AS messageXML(param)
),
runningDDBMoveJobs_cte
AS (
	SELECT  J.jobId, J.state, T.TargetMAClientId, c.displayName AS targetMAName, T.TargetStorePath, T.SubStoreId, ROW_NUMBER() OVER (PARTITION  BY T.subStoreId ORDER BY J.JobId DESC) AS rowNum
	FROM	MMSIDBSubStoreToTransferStream T
			INNER JOIN JMJobInfo J ON J.jobId =  T.JobId
			INNER JOIN APP_Client C ON C.id = T.TargetMAClientId
WHERE	J.state IN (1 , 2,3,5,6,7,8,13) --DDBMOVE_IN_PROGRESS, DDBMOVE_SUSPENDED
)
SELECT	S.subStoreId as '@subStoreId',
		ISNULL(T.state, -1) as '@statusId'	,
		ISNULL(T.JobId, -1) as '@jobId',
		ISNULL(T.TargetMAClientId, 0) as '@targetMaId',
		ISNULL(T.targetMAName,'') as    '@targetMaName',
		T.TargetStorePath as  '@targetPath'
FROM	subStoreId_cte S
		LEFT JOIN runningDDBmoveJobs_cte T ON T.SubStoreId = S.substoreId AND T.rowNum = 1
FOR XML PATH ('substoreIdStatusList'), root('EVGui_sidbSubStoreMoveStatusResp')

IF EXISTS (select * from GxQscripts where name = 'MM_getDdbMoveStatusOfSubStore')
	delete from GxQscripts where name = 'MM_getDdbMoveStatusOfSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_getDdbMoveStatusOfSubStore')
	delete from GXDBVersions where aliasname = 'MM_getDdbMoveStatusOfSubStore'
GO

insert into GXDBVersions values(2, 'MM_getDdbMoveStatusOfSubStore',  '00010007019200030000', 'MM_getDdbMoveStatusOfSubStore', '00010007019200030000')
GO

