

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvReports.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvReports()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvReports <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvReports')
	drop procedure MM_SProvReports
IF EXISTS (select * from GxQscripts where name='MM_SProvReports')
	delete from GxQscripts where name = 'MM_SProvReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvReports')
	delete from GXDBVersions where aliasname = 'MM_SProvReports'
GO
print '... Creating Procedure: MM_SProvReports'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvReports
  @ipxml XML,
  @opxml XML OUTPUT
AS
	SET NOCOUNT ON
	DECLARE @SProvVendorId int
	DECLARE @SProvUserId int
	DECLARE @SProvArrayId int
	DECLARE @SProvHostId int
	DECLARE @vendorId INT
	DECLARE @arrayId INT
	DECLARE @SPoolId INT
	SET @vendorId = (SELECT A.ref.value('@vendorId', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo') A(ref));
	SET @arrayId = (SELECT A.ref.value('@arrayNum', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/arrayList[1]') A(ref));
	SET @SPoolId = (SELECT A.ref.value('@storagePoolId', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/arrayList[1]/poolList[1]') A(ref));
	IF @vendorId IS NULL
	BEGIN
					SET @opxml =
					(SELECT 'Invalid vendor ID' AS errorString, -1 AS errorCode FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
	END
	ELSE
	BEGIN
	SET @opxml =
		(SELECT
			(SELECT Id AS '@vendorId',
					Name AS '@vendorName',
					(SELECT SMArr.ArrayName AS '@arrayName',
							SMArr.Id AS '@arrayNum',
							SMArr.ClientId AS 'client/@clientId',
							(SELECT SMSPool.Id AS '@storagePoolId',
									SMSPool.Name AS '@storagePoolName',
									SMSPool.ClientId AS '@arrayNum',
									SMSPool.UsedSpaceMB AS '@usedSpace',
									SMSPool.TotalSpaceMB AS '@totalSpace',
									(SELECT SMVol.Id AS '@volumeId',
											SMVol.Name AS '@volumeName',
											SMVol.UsedSpaceMB AS '@usedSpace',
											SMVol.TotalSpaceMB AS '@totalSpace',
											(SELECT SMLn.Name AS '@lunName',
													SMLn.Id AS '@lunId',
													SMLn.UsedSpaceBytes AS '@usedSpace',
													SMLn.TotalSpaceBytes AS '@totalSpace'
											FROM SMLUN SMLn(NOLOCK) INNER JOIN SProvLUN SPrvLn (NOLOCK) ON SPrvLn.LUNId = SMLn.Id
											WHERE SMLn.ArrayVolumeId = SMVol.Id
											FOR XML PATH('lunList'), TYPE)
											FROM SMArrayVolume SMVol(NOLOCK) INNER JOIN SProvArrayVolume SPrvVol (NOLOCK) ON SPrvVol.VolumeId = SMVol.Id
											WHERE SMVol.StoragePoolId = SMSPool.Id
											FOR XML PATH('volumeList'), TYPE)
									FROM SMStoragePool SMSPool (NOLOCK) WHERE SMSPool.Id = @SPoolId OR @SPoolId IS NULL     AND SMSPool.ClientId = SMArr.ClientId
									FOR XML PATH('poolList'), TYPE)
							FROM SMArray SMArr (NOLOCK) INNER JOIN SProvArray SPrvArr (NOLOCK) ON SPrvArr.ArrayNum = SMArr.Id
							WHERE SMArr.Id = @arrayId OR @arrayId IS NULL
							FOR XML PATH('arrayList'), TYPE)
							FROM SMVendor WHERE Id = @vendorId
							FOR XML PATH('arrayFamilyList'), TYPE),
							'' AS errorString,
							0 AS errorCode
							FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
	END

IF EXISTS (select * from GxQscripts where name = 'MM_SProvReports')
	delete from GxQscripts where name = 'MM_SProvReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvReports')
	delete from GXDBVersions where aliasname = 'MM_SProvReports'
GO

insert into GXDBVersions values(2, 'MM_SProvReports',  '00000000000000000000', 'MM_SProvReports', '00000000000000000000')
GO

