

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvRegisterHosts.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvRegisterHosts()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvRegisterHosts <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvRegisterHosts')
	drop procedure MM_SProvRegisterHosts
IF EXISTS (select * from GxQscripts where name='MM_SProvRegisterHosts')
	delete from GxQscripts where name = 'MM_SProvRegisterHosts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvRegisterHosts')
	delete from GXDBVersions where aliasname = 'MM_SProvRegisterHosts'
GO
print '... Creating Procedure: MM_SProvRegisterHosts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvRegisterHosts
  @ipxml xml,
  @outxml xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @enabled INT
DECLARE @clientId INT
DECLARE @editDesc nvarchar(MAX)
DECLARE @userId INT
DECLARE @SProvHostsXML XML
--<StorageProvisioning_MMSProvInfo>
--	<endPointList address="iqn1" addressType="3">
--		<client clientId="5" />
--	</endPointList>
--	<endPointList address="iqn2" addressType="3">
--		<client clientId="5" />
--	</endPointList>
--	<endPointList address="iqn3" addressType="3">
--		<client clientId="5" />
--	</endPointList>
--	<endPointList address="fc1" addressType="4">
--		<client clientId="5" />
--	</endPointList>
--	<endPointList address="fc2" addressType="4">
--		<client clientId="5" />
--	</endPointList>
--	<endPointList address="fc3" addressType="4">
--		<client clientId="5" />
--	</endPointList>
--	<hostList>
--		<client clientId="5" />
--		<group userGroupId="1" />
--		<user userId="1" />
--	</hostList>
--</StorageProvisioning_MMSProvInfo>
SET @enabled=1
SET @clientId = (SELECT A.ref.value('(client/@clientId)[1]', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/hostList') A(ref));
SET @userId = (SELECT A.ref.value('(user/@userId)[1]', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/hostList') A(ref));
DECLARE @tblIdentifiers TABLE (ClientId INT, AddressType INT, IdAddress nvarchar(1000), unid uniqueidentifier, SMEndPointId INT DEFAULT -1, EnabledFld INT DEFAULT 1)
--Clean all endpoints associated with the client and that particular user
DELETE FROM SProvEndPoint WHERE ClientId = @clientId AND UserId = @userId
--Don't delete anything from SMEndPoint.
--DELETE FROM SMEndPoint WHERE ClientId = @clientId
--Insert into the temp table
INSERT INTO @tblIdentifiers(ClientId, AddressType, IdAddress, unid)
SELECT
A.ref.value('(client/@clientId)[1]', 'int'),
A.ref.value('(@addressType)[1]', 'int'),
A.ref.value('(@address)[1]', 'nvarchar(1000)'),
NEWID()
FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/endPointList') A(ref)
--Insert into SMEndPoint
INSERT INTO SMEndPoint(ClientId, AddressType, Address, ReserveFieldStr)
SELECT tblIds.ClientId, tblIds.AddressType, tblIds.IdAddress, CONVERT(NVARCHAR(1024), unid) FROM @tblIdentifiers tblIds
LEFT OUTER JOIN SMEndPoint SMEndPt ON SMEndPt.Address = tblIds.IdAddress AND
									  SMEndPt.ClientId = tblIds.ClientId AND
									  SMEndPt.AddressType = tblIds.AddressType
WHERE SMEndPt.Address IS NULL AND SMEndPt.ClientId IS NULL AND SMEndPt.AddressType IS NULL
--Update the temp table with the newly inserted id's of SMEndPoint
UPDATE @tblIdentifiers SET SMEndPointId = SMEndPoint.Id
FROM @tblIdentifiers A, SMEndPoint
WHERE SMEndPoint.ReserveFieldStr = CONVERT(NVARCHAR(1024), A.unid)
--If the endpoint is already present in the SMEndPoint table the above query will not update the SMEndPointId of @tblIdentifiers,
--that is because if the endpoint is already present we donot insert the same EP again. Therefore the unique id is not inserted
--that is needed for comparison in the above query 'WHERE SMEndPoint.ReserveFieldStr = CONVERT(NVARCHAR(1024), A.unid)'
--Therefore if the EP is already present just update the SMEndPointId of @tblIdentifiers with that present in the SMEndPoint table
UPDATE @tblIdentifiers SET SMEndPointId = SMEndPt.Id
FROM SMEndPoint SMEndPt INNER JOIN @tblIdentifiers tblIds ON SMEndPt.Address = tblIds.IdAddress AND
															 SMEndPt.ClientId = tblIds.ClientId AND
															 SMEndPt.AddressType = tblIds.AddressType
--Clean up SMEndPoint
UPDATE SMEndPoint SET ReserveFieldStr = ''
FROM @tblIdentifiers A, SMEndPoint
WHERE SMEndPoint.ReserveFieldStr = CONVERT(NVARCHAR(1024), A.unid)
--Insert the temp table data into SProvEndPoint
INSERT INTO SProvEndPoint(ClientId, EndPointId, Enabled, UserId)
SELECT ClientId, SMEndPointId, EnabledFld, @userId FROM @tblIdentifiers
--While editing hosts only end points are added. When adding New Host end points are added along with the Host.
IF NOT EXISTS(SELECT * FROM SProvHost WHERE ClientId = @clientId AND UserId = @userId)
	BEGIN
		INSERT INTO SProvHost(ClientId, UserId, GroupId, Description, Enabled)
		SELECT
		A.ref.value('(client/@clientId)[1]', 'int'),
		A.ref.value('(user/@userId)[1]', 'int'),
		A.ref.value('(group/@userGroupId)[1]', 'int'),
		A.ref.value('@description', 'nvarchar(MAX)'),
		@enabled
		FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/hostList') A(ref)
	END
ELSE
	BEGIN
		--Edit the description if provided
		SET @editDesc = (SELECT A.ref.value('@description', 'nvarchar(MAX)') FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/hostList') A(ref))
		UPDATE SProvHost SET Description = @editDesc WHERE ClientId = @clientId
	END
SET @SProvHostsXML = (SELECT	name AS '@host',
								net_hostname AS '@hostName'
					  FROM APP_Client
					  FOR XML PATH ('regHostInfo')
					  )
SET @outxml = (SELECT  @SProvHostsXML
			   FOR XML PATH ('StorageProvisioning_MMSProvGUIResponseHostsTable')
			   )

IF EXISTS (select * from GxQscripts where name = 'MM_SProvRegisterHosts')
	delete from GxQscripts where name = 'MM_SProvRegisterHosts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvRegisterHosts')
	delete from GXDBVersions where aliasname = 'MM_SProvRegisterHosts'
GO

insert into GXDBVersions values(2, 'MM_SProvRegisterHosts',  '00000000000000000000', 'MM_SProvRegisterHosts', '00000000000000000000')
GO

