

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvOperations.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvOperations()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvOperations <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvOperations')
	drop procedure MM_SProvOperations
IF EXISTS (select * from GxQscripts where name='MM_SProvOperations')
	delete from GxQscripts where name = 'MM_SProvOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvOperations')
	delete from GXDBVersions where aliasname = 'MM_SProvOperations'
GO
print '... Creating Procedure: MM_SProvOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvOperations
  @xmlip XML,
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
--LUN Import Operation
DECLARE @tmpTbl TABLE
(arrayId INT,
 arrayName NVARCHAR(1024),
 storagePoolId INT,
 storagePoolName NVARCHAR(1024),
 volumeId INT,
 volumeName NVARCHAR(1024),
 lunId INT,
 lunName NVARCHAR(1024),
 osType NVARCHAR(1024),
 clientId INT)
DECLARE @OpType INT
DECLARE @OsType INT = 0
DECLARE @errCode    INT = 0
DECLARE @errMsg     VARCHAR(255) = ''
SET @OpType = (SELECT  A.ref.value('@operation', 'int') FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') A(ref))
IF @OpType = 51
	BEGIN
		DECLARE @tmpOpXML XML
		INSERT INTO @tmpTbl
			SELECT SMArr.Id,
				   SMArr.ArrayName,
				   SMStoragePl.Id,
				   SMStoragePl.Name,
				   SMArrVol.Id,
				   SMArrVol.Name,
				   SMLn.Id,
				   SMLn.Name,
				   SMLn.ReserveFieldStr,
				   SMArr.ClientId
				   FROM SMArray SMArr WITH (NOLOCK)
				   INNER JOIN SMStoragePool SMStoragePl WITH (NOLOCK) ON SMArr.ClientId = SMStoragePl.ClientId
				   INNER JOIN SMArrayVolume SMArrVol WITH (NOLOCK) ON SMStoragePl.Id = SMArrVol.StoragePoolId
				   INNER JOIN SMLUN SMLn WITH (NOLOCK) ON SMArrVol.Id = SMLn.ArrayVolumeId
				   LEFT OUTER JOIN SProvLUN SProvLn WITH (NOLOCK) ON SMLn.Id = SProvLn.LUNId
				   INNER JOIN SMControlHost SMCtrlHost WITH (NOLOCK) ON SMArr.ClientId = SMCtrlHost.ClientId
				   INNER JOIN SProvArray SPrvArray WITH (NOLOCK) ON SPrvArray.ArrayNum = SMArr.Id
				   WHERE SProvLn.LUNId IS NULL
				   AND SMLn.DeleteTime IS NULL
				   AND SMCtrlHost.SMHostFlags <> 4
				   AND SMLn.Id > 0
				   --AND SMArrVol.Flags <> MM_SPROV_READONLY_VOLUMES
		SET @tmpOpXML = (SELECT T_IMP.arrayId AS '@arrayId',
								T_IMP.arrayName AS '@arrayName',
								T_IMP.storagePoolId AS '@storagePoolId',
								T_IMP.storagePoolName AS '@storagePoolName',
								T_IMP.volumeId AS '@volumeId',
								T_IMP.volumeName AS '@volumeName',
								T_IMP.lunId AS '@lunId',
								T_IMP.lunName AS '@lunName',
								T_IMP.osType AS '@osType',
								S_HOST.SnapVendorName AS '@vendorName',
								S_VEN.Id AS '@vendorId'
						 FROM @tmpTbl T_IMP INNER JOIN SMControlHost S_HOST ON S_HOST.ClientId = T_IMP.clientId
											INNER JOIN SMVendor S_VEN ON S_VEN.Name = S_HOST.SnapVendorName
						 FOR XML PATH ('lunsToImport'))
		SET @xmlop = (SELECT @tmpOpXML FOR XML PATH ('StorageProvisioning_MMSProvLUNImport'))
	END
ELSE IF @OpType = 52
	BEGIN
		--Process lun entries
		DECLARE @UserId INT
		SET @UserId = (SELECT  A.ref.value('@userId', 'int') FROM @xmlip.nodes('/StorageProvisioning_MMSProvLUNImport') A(ref))
		DECLARE @tmpSprovLun TABLE(LunId INT, VolId INT, SpoolId INT, ClientId INT, ArrayNum INT, UserId INT, Criteria INT, ExpirationDate datetime, HWatermark INT, LWatermark INT, Enabled INT, Status INT, osId INT)
		--Insert into the table variable
		INSERT INTO @tmpSprovLun(LunId, UserId, Criteria, ExpirationDate, HWatermark, LWatermark, Enabled, Status, osId)
			SELECT  A.ref.value('@lunId', 'int') AS LunId, @UserId, 0, DATEADD(DAY, 90, GETUTCDATE()), 90, 75, 1, 1,
			A.ref.value('@osId', 'int') AS osType
			FROM @xmlip.nodes('/StorageProvisioning_MMSProvLUNImport/lunsToImport') A(ref)
		--update volume id
		UPDATE @tmpSprovLun SET VolId = SMLN.ArrayVolumeId
							FROM SMLUN AS SMLN WITH (NOLOCK)
							INNER JOIN @tmpSprovLun tmpSPLN
							ON SMLN.Id = tmpSPLN.LunId
		--update storage pool id
		UPDATE @tmpSprovLun SET SpoolId = SMArrVol.StoragePoolId
							FROM SMArrayVolume AS SMArrVol WITH (NOLOCK)
							INNER JOIN @tmpSprovLun tmpSPLN
							ON SMArrVol.Id = tmpSPLN.VolId
		--update client id
		UPDATE @tmpSprovLun SET ClientId = SMStPool.ClientId
							FROM SMStoragePool AS SMStPool WITH (NOLOCK)
							INNER JOIN @tmpSprovLun tmpSPLN
							ON SMStPool.Id = tmpSPLN.SpoolId
		--update SMArray id
		UPDATE @tmpSprovLun SET ArrayNum = SMArr.Id
							FROM SMArray AS SMArr WITH (NOLOCK)
							INNER JOIN @tmpSprovLun tmpSPLN
							ON SMArr.ClientId = tmpSPLN.ClientId
		--Update Storage Provisioning tables
		--insert into SProvArray			-> This is an admin operation
		--INSERT INTO SProvArray(ArrayNum, HighWaterMark, WarningWaterMark, Enabled)
		--	SELECT DISTINCT tmpSP.ArrayNum, tmpSP.HWatermark, tmpSP.LWatermark, tmpSP.Enabled FROM @tmpSprovLun tmpSP
		--	LEFT OUTER JOIN SProvArray A ON tmpSP.ArrayNum = A.ArrayNum
		--	WHERE A.ArrayNum IS NULL
		--SET @errCode = @@ERROR
		--IF @errCode > 0
		--BEGIN
		--	SET @errMsg = 'Error while inserting into SProvArray'
		--	GOTO ERR_EXIT
		--END
		--insert into SProvStoragePool
		INSERT INTO SProvStoragePool(StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled)
			SELECT DISTINCT tmpSP.SpoolId, tmpSP.ArrayNum, tmpSP.HWatermark, tmpSP.LWatermark, tmpSP.Enabled FROM @tmpSprovLun tmpSP
			LEFT OUTER JOIN SProvStoragePool A ON tmpSP.SpoolId = A.StoragePoolId
			WHERE A.StoragePoolId IS NULL
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Error while inserting into SProvStoragePool'
			GOTO ERR_EXIT
		END
		--insert into SProvArrayVolume. we are importing volumes as well
		INSERT INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, UserId)
			SELECT DISTINCT tmpSP.VolId, tmpSP.SpoolId, tmpSP.ArrayNum, tmpSP.Enabled, @UserId FROM @tmpSprovLun tmpSP
			LEFT OUTER JOIN SProvArrayVolume A ON tmpSP.VolId = A.VolumeId
			WHERE A.VolumeId IS NULL
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Error while inserting into SProvArrayVolume'
			GOTO ERR_EXIT
		END
		--insert into SProvLun
		INSERT INTO SProvLUN(LUNId, VolumeId, StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled, UserId, Criteria, ExpirationDate, OSType, Status)
			SELECT tmpSP.LunId, tmpSP.VolId, tmpSP.SpoolId, tmpSP.ArrayNum, tmpSP.HWatermark, tmpSP.LWatermark, tmpSP.Enabled, @UserId, tmpSP.Criteria, tmpSP.ExpirationDate, tmpSP.osId, tmpSP.Status
			FROM @tmpSprovLun tmpSP
			LEFT OUTER JOIN SProvLUN A ON tmpSP.LunId = A.LUNId
			WHERE A.LUNId IS NULL
		SET @errCode = @@ERROR
		IF @errCode > 0
		BEGIN
			SET @errMsg = 'Error while inserting into SProvLUN'
			GOTO ERR_EXIT
		END
		SET @errMsg = 'Successfully Imported the selected LUNs'
		SET @errCode = 0
		SET @xmlop  = (SELECT @OpType AS '@OpType',
							  @errCode AS '@errorCode',
							  @errMsg AS '@errorString'
					   FOR XML PATH ('StorageProvisioning_MMSProvLUNImport'))
		RETURN
		ERR_EXIT:
			SELECT @OpType AS '@OpType',
				   @errCode AS '@errorCode'	,
				   @errMsg AS '@errorString'
			FOR XML PATH ('StorageProvisioning_MMSProvLUNImport')
		RETURN
	END
ELSE IF @OpType = 53
	BEGIN
		DECLARE @users XML
		DECLARE @usersList XML
		SET @users = (SELECT name AS '@userName',
					  id AS '@userId'
					  FROM UMUsers
					  FOR XML PATH('user'))
		SET @usersList = (SELECT @users
						  FOR XML PATH('userList'))
		SET @xmlop = (SELECT @usersList FOR XML PATH('StorageProvisioning_MMSProvGroupInfo'))
	END
ELSE IF @OpType = 54
	BEGIN
		DECLARE @lunId INT
		DECLARE @user INT
		DECLARE @mntInfo XML
		DECLARE @lunInfo XML
		DECLARE @epInfo XML
		SET @lunId = (SELECT  A.ref.value('@lunId', 'int') FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/lunList') A(ref))
		DECLARE @TSProvTbl TABLE
		(
			lunId INT,
			lunName nvarchar(1024),
			volumeId INT,
			volumeName nvarchar(1024),
			arrayName nvarchar(1024),
			usedSpace BIGINT,
			totalSpace BIGINT,
			osType nvarchar(1024),
			lunPath nvarchar(2048)
		)
		DECLARE @TSProvLunMap TABLE
		(
			lunId INT,
			epId INT,
			epName nvarchar(1024),
			mntHostId INT,
			mntHostName nvarchar(1024),
			protocolId INT
		)
		INSERT INTO @TSProvTbl (lunId)
			SELECT @lunId
		UPDATE @TSProvTbl SET lunName = smLn.Name,
							  lunPath = smLn.Path,
							  usedSpace = smLn.UsedSpaceBytes,
							  totalSpace = smLn.TotalSpaceBytes,
							  volumeId = smLn.ArrayVolumeId,
							  volumeName = smArrVol.Name,
							  arrayName = smArr.ArrayName,
							  osType = smLn.ReserveFieldStr
		FROM SMLUN smLn INNER JOIN @TSProvTbl ON [@TSProvTbl].lunId = smLn.Id
						INNER JOIN SMArrayVolume smArrVol ON smLn.ArrayVolumeId = smArrVol.Id
						INNER JOIN SMArray smArr ON smArrVol.ClientId = smArr.ClientId
		INSERT INTO @TSProvLunMap(lunId, epId, mntHostId, protocolId)
			SELECT LUNId, ENdPointId, MountHostId, ProtocolId FROM SProvMountLUN WHERE LUNId = @lunId
		UPDATE @TSProvLunMap SET epName = smEndPt.Address
			FROM SMEndPoint smEndPt INNER JOIN @TSProvLunMap ON [@TSProvLunMap].epId = smEndPt.Id
		UPDATE @TSProvLunMap SET mntHostName = appClnt.name
			FROM APP_Client appClnt INNER JOIN @TSProvLunMap ON [@TSProvLunMap].mntHostId = appClnt.Id
		SET @mntInfo = (
						SELECT lunId AS '@lunId',
							   epId AS '@endPointId',
							   protocolId AS '@protocolId'
							   FROM @TSProvLunMap
							   FOR XML PATH('mountList')
						)
		SET @lunInfo = (
						SELECT lunId AS '@lunId',
							   lunName AS '@lunName',
							   usedSpace AS '@usedSpace',
							   totalSpace AS '@totalSpace',
							   lunPath AS '@lunPath',
							   osType AS '@osTypeName',
							   volumeName AS 'reserve/@reserveString',
							   arrayName AS 'reserve/@reserveString2',
							   @mntInfo
						FROM @TSProvTbl
						FOR XML PATH ('lunList')
						)
		SET @epInfo = (
						SELECT epId AS '@endPointId',
							   epName AS '@address',
							   protocolId AS '@addressType',
							   mntHostName AS 'client/@clientName',
							   mntHostId AS 'client/@clientId'
						FROM @TSProvLunMap
						FOR XML PATH('endPointList')
						)
		SET @xmlop = (SELECT @lunInfo, @epInfo FOR XML PATH('StorageProvisioning_MMSProvInfo'))
	END
ELSE IF @OpType = 55
	BEGIN
		DECLARE @hostId INT
		SET @hostId = (SELECT  A.ref.value('@clientId', 'int') FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/hostList/client') A(ref))
		DECLARE @mountList XML
		DECLARE @lunList XML
		SET @mountList =
		(SELECT DISTINCT MntLUN.LUNId AS '@lunId',
						 MntLUN.ProtocolId AS '@protocolId',
						 SMLN.Name AS '@errorString',
						 MntLun.MountHostId AS 'mountHost/@clientId',
						 MntLUN.UserId AS 'user/@userId'
		 FROM SProvMountLUN MntLUN INNER JOIN SProvLUN SprvLUN ON MntLUN.LUNId = SprvLUN.LUNId
								   INNER JOIN SMLUN SMLN ON SMLN.Id = SprvLUN.LUNId
								   INNER JOIN APP_Client APPClnt ON APPClnt.id = MntLUN.MountHostId
		 WHERE MntLUN.MountHostId = 1
		 FOR XML PATH('mountList'))
		 SET @lunList = (SELECT @mountList FOR XML PATH('lunList'))
		 SET @xmlop = (SELECT @lunList FOR XML PATH('StorageProvisioning_MMSProvInfo'))
	 END
ELSE IF @OpType = 56
	BEGIN
		SET @userId = (SELECT R.ref.value('@userId', 'INT') FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref))
		DECLARE @lunTbl TABLE
		(
			lunId INT,
			lunName NVARCHAR(1024),
			lunPath NVARCHAR(2048),
			arrayName NVARCHAR(2048),
			volumeId INT,
			userId INT
		)
		DECLARE @mntLunTbl TABLE
		(
			mntLunId INT,
			lunId INT,
			userId INT,
			mountHostId INT,
			mountHostname nvarchar(1024),
			epId INT,
			protocolId INT
		)
		INSERT INTO @lunTbl(lunId)
			SELECT
			R.ref.value('@lunId', 'INT')
			FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
		UPDATE @lunTbl
			SET volumeId = SMLN.ArrayVolumeId
		FROM SMLUN SMLN INNER JOIN @lunTbl lnTbl ON lnTbl.lunId = SMLN.Id
		UPDATE @lunTbl
			SET lunName = SMLN.Name,
				userId = lnMntTbl.UserId,
				lunPath = SMLN.Path,
				arrayName = SMCtrlHost.SMArrayId
		FROM SMLUN SMLN INNER JOIN @lunTbl lnTbl ON lnTbl.lunId = SMLN.Id
						INNER JOIN SProvMountLUN lnMntTbl ON lnTbl.lunId = lnMntTbl.LUNId
						INNER JOIN SMArrayVolume SMArrVol ON lnTbl.volumeId = SMArrVol.Id
						INNER JOIN SMControlHost SMCtrlHost ON SMArrVol.ClientId = SMCtrlHost.ClientId
		INSERT INTO @mntLunTbl(mntLunId, lunId, userId, mountHostId, epId, protocolId)
			SELECT MountLunId, LUNId, UserId, MountHostId, EndPointId, ProtocolId FROM SProvMountLUN WHERE LUNId IN(SELECT LUNId FROM @lunTbl) AND UserId = @userId
		UPDATE @mntLunTbl
			SET mountHostname = appClnt.name
		FROM APP_Client appClnt INNER JOIN @mntLunTbl mntLnTbl ON mntLnTbl.mountHostId = appClnt.id
		SET @xmlop = (
						SELECT(
						SELECT lunId AS '@lunId',
							   lunName AS '@lunName',
							   lunPath AS '@lunPath',
							   arrayName AS '@errorString',
							   userId AS 'user/@userId',
							   (SELECT mntLnTbl.mntLunId AS '@mountLunId',
									   mntLnTbl.lunId AS '@lunId',
									   mntLnTbl.epId AS '@endPointId',
									   mntLnTbl.protocolId AS '@protocolId',
									   mntLnTbl.mountHostId AS 'mountHost/@clientId',
									   mntLnTbl.mountHostname AS 'mountHost/@clientName',
									   mntLnTbl.userId AS 'user/@userId'
									   FROM @mntLunTbl mntLnTbl WHERE lnTbl.lunId = mntLnTbl.lunId AND mntLnTbl.userId = @UserId
									   FOR XML PATH('mountList'), TYPE)
									   FROM @lunTbl lnTbl WHERE lnTbl.userId = @UserId FOR XML PATH('lunList'), TYPE)
							   FOR XML PATH ('StorageProvisioning_MMSProvInfo')
						 )
	END
ELSE IF @OpType=57
	BEGIN
		DECLARE @capTbl TABLE
		(
			SMArrayId INT,
			ClientID INT,
			SProvCapabilitySet INT DEFAULT 0,
			LastDataCollectTime INT,
			ArrayName NVARCHAR(1024),
			VendorName NVARCHAR(1024)
		)
		INSERT INTO @capTbl(SMArrayId, ClientID, LastDataCollectTime, ArrayName, VendorName)
		SELECT SM_ARR.Id, SM_ARR.ClientId, dbo.GetUnixTime(SM_ARR.UpdateTime), SM_HOST.SMArrayId, SM_HOST.SnapVendorName
		FROM SMArray SM_ARR INNER JOIN SMControlHost SM_HOST ON SM_ARR.ClientId = SM_HOST.ClientId
							INNER JOIN SMVendor S_VEN ON S_VEN.Name = SM_HOST.SnapVendorName
		WHERE S_VEN.IsProvisionCapable = 1 AND
			  SM_HOST.SMHostFlags NOT IN(1, 4) AND
			  ((SM_HOST.SnapVendorName <> 'NetApp') OR ((SM_HOST.SMHostFlags & 16) = 16) OR ((SM_HOST.SMHostFlags & 8) = 8))
		--Update the SProvCapabilitySet field
		UPDATE @capTbl SET SProvCapabilitySet = SP_ARR.Enabled
		FROM SProvArray SP_ARR INNER JOIN @capTbl T_CAP ON SP_ARR.ArrayNum = T_CAP.SMArrayId
		SET @xmlop = (SELECT
						(SELECT
							(SELECT cpTbl.ArrayName AS '@arrayName',
									cpTbl.SMArrayId AS '@arrayNum',
									cpTbl.SProvCapabilitySet AS '@enabled',
									cpTbl.LastDataCollectTime AS '@status',
									cpTbl.ClientID AS 'client/@clientId'
									FROM @capTbl cpTbl FOR XML PATH('arrayList'), TYPE)
							  FOR XML PATH('arrayFamilyList'), TYPE)
						  FOR XML PATH('StorageProvisioning_MMSProvInfo'))
	END
ELSE IF @OpType=58
	BEGIN
		--<StorageProvisioning_MMSProvInfo>
		--	<sprovParam operation="58">
		--		<sprovCommon>
		--			<logonUser userId="2" />
		--		</sprovCommon>
		--	</sprovParam>
		--	<arrayFamilyList>
		--		<arrayList arrayNum="1" />
		--		<arrayList arrayNum="2" />
		--		<arrayList arrayNum="3" />
		--	</arrayFamilyList>
		--</StorageProvisioning_MMSProvInfo>
		DECLARE @prFC INT
		DECLARE @prISCSI INT
		--Insert protocol information into SProvProtocol tbl.
		SET IDENTITY_INSERT SProvProtocol ON
		BEGIN
			IF NOT EXISTS(SELECT * FROM SProvProtocol WHERE Name = 'iSCSI')
			BEGIN
				INSERT INTO
				SProvProtocol(ProtocolId, Name, Enabled)
				VALUES(3, 'iSCSI', 1)
			END
			IF NOT EXISTS(SELECT * FROM SProvProtocol WHERE Name = 'FC')
			BEGIN
				INSERT INTO
				SProvProtocol(ProtocolId, Name, Enabled)
				VALUES(4, 'FC', 1)
			END
		END
		SET IDENTITY_INSERT SProvProtocol OFF
		--Get the ISCSI and FC protocol Ids
		SET @prISCSI = (SELECT ProtoColId FROM SProvProtocol WHERE Name = 'iSCSI')
		SET @prFC = (SELECT ProtoColId FROM SProvProtocol WHERE Name = 'FC')
		DECLARE @arrTbl TABLE(
			ArrayId INT,
			ProtocolId INT
		)
		--ISCSI
		INSERT INTO @arrTbl
			SELECT
			R.ref.value('@arrayNum', 'INT'), @prISCSI
			FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/arrayFamilyList/arrayList') R(ref)
		--FC
		INSERT INTO @arrTbl
			SELECT
			R.ref.value('@arrayNum', 'INT'), @prFC
			FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/arrayFamilyList/arrayList') R(ref)
		INSERT INTO SProvArray(ArrayNum, HighWaterMark, WarningWaterMark, Enabled)
		SELECT DISTINCT ArrayId, 90, 75, 1  FROM @arrTbl arrTbl LEFT OUTER JOIN SProvArray SP_ARR ON arrTbl.ArrayId = SP_ARR.ArrayNum
		WHERE SP_ARR.ArrayNum IS NULL
		--If entry already exists update the Enabled field in SProvArray and SMArray table
		UPDATE SProvArray SET Enabled = 1 WHERE ArrayNum in (Select ArrayId from @arrTbl) AND Enabled = 0
		SET @xmlop = (SELECT 0 AS '@errorCode',
							 'Successfully added capabilities to the arrays' AS '@errorString'
					  FOR XML PATH('StorageProvisioning_MMSProvInfo'))
	END
ELSE IF @OpType=59
	BEGIN
		SET @errCode = 0
		SET @errMsg = 'Successfully Deconfigured the array for Storage Provisioning'
		UPDATE SProvArray SET Enabled = 0 WHERE ArrayNum in(
			SELECT
			R.ref.value('@arrayNum', 'INT')
			FROM @xmlip.nodes('/StorageProvisioning_MMSProvInfo/arrayFamilyList/arrayList') R(ref))
		SET @xmlop = (SELECT @errCode AS '@errorCode',
							 @errMsg AS '@errorString'
					  FOR XML PATH('StorageProvisioning_MMSProvInfo'))
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvOperations')
	delete from GxQscripts where name = 'MM_SProvOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvOperations')
	delete from GXDBVersions where aliasname = 'MM_SProvOperations'
GO

insert into GXDBVersions values(2, 'MM_SProvOperations',  '00000000000000000000', 'MM_SProvOperations', '00000000000000000000')
GO

