

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvListAllocationPolicies.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvListAllocationPolicies()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvListAllocationPolicies <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvListAllocationPolicies')
	drop procedure MM_SProvListAllocationPolicies
IF EXISTS (select * from GxQscripts where name='MM_SProvListAllocationPolicies')
	delete from GxQscripts where name = 'MM_SProvListAllocationPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvListAllocationPolicies')
	delete from GXDBVersions where aliasname = 'MM_SProvListAllocationPolicies'
GO
print '... Creating Procedure: MM_SProvListAllocationPolicies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvListAllocationPolicies
  @userId INT = 0,
  @xmlip XML,
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
--Sample input XML
--'<StorageProvisioning_MMSProvPolicyInfo>
--	<policyList policyId = "1"/>
--	<policyList policyId = "2"/>
--</StorageProvisioning_MMSProvPolicyInfo>'
DECLARE @isPolicyIdsPassed INT = 0
DECLARE @isUserIdPassed INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorString VARCHAR(1024) = ''
DECLARE @currentDate DATETIME
SET @currentDate = GETUTCDATE()
DECLARE @policyTbl TABLE
(
	policyId nvarchar(1024),
	userId INT,
	remainingQuota BIGINT
)
-----------------------------------------------INSERT INTO THE POLICY TEMP TABLE-----------------------------------------------
INSERT INTO @policyTbl
	SELECT
	R.ref.value('@policyId', 'INT'),
	@userId,
	0
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvPolicyInfo/policyList') R(ref)
------------------------------------------END: INSERT INTO THE POLICY TEMP TABLE-----------------------------------------------
IF @userId > 0
BEGIN
	SET @isUserIdPassed = 1
END
IF EXISTS (SELECT 1 FROM @policyTbl)
BEGIN
	SET @isPolicyIdsPassed = 1
END
ELSE
BEGIN
	IF (@isUserIdPassed = 1)
		BEGIN
			INSERT INTO @policyTbl(policyId)
			(SELECT policyId FROM SprovPolicyToUserMap
			--This where clause gets the list of all policies that are associated with a group to which the user is associated to
			WHERE userOrGroupId IN(
								SELECT DISTINCT SP_GRP.userOrGroupId FROM
								SprovPolicyToUserMap SP_GRP INNER JOIN UMUserGroup U_USRGRP ON SP_GRP.userOrGroupId = U_USRGRP.groupId
								WHERE SP_GRP.isGroup = 1 AND U_USRGRP.userId = @userId
								) AND
								isGroup = 1
			) UNION--AND policyId IN --This where clause gets the list of all policies that are associated with a user directly
			(
				SELECT policyId FROM SprovPolicyToUserMap WHERE userOrGroupId = @userId AND isGroup = 0
			)
		END
END
IF(@isUserIdPassed = 1 AND @isPolicyIdsPassed = 1)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid input'
	GOTO ERR_EXIT
END
--user id is passed when we want to get the list of all policies associated with that user. That is the only use case where we user id is passed.
--when user id is passed we calculate the remaining quota for the user.
--At this point @policyTbl should have some entries if either userId or policyId is passed. If both are not passed @policyTbl is empty(invalid input and should error out).
--If userId is passed get the remaining quota for the user.
IF (@isUserIdPassed = 1)
BEGIN
	DECLARE @policyInfo TABLE
	(
		policyId INT,
		userId INT,
		policyQuota BIGINT,
		totalQuotaUsedForUser BIGINT,
		remainingQuota BIGINT
		PRIMARY KEY(policyId)
	)
	--Set the totalQuotaUsedForUser to be equal to 0 initially
	--Set the remaining quota to be equal to the actual policy quota initially
	INSERT INTO @policyInfo (policyId, userId, policyQuota, totalQuotaUsedForUser, remainingQuota)
	SELECT policyId, createdby, userQuotaInBytes, 0, userQuotaInBytes FROM SprovAllocationPolicy WHERE policyId IN
	(SELECT policyId FROM @policyTbl)
	DECLARE @policyToLunInfo TABLE
	(
		policyId INT,
		userId INT,
		totalQuotaUsedForUser BIGINT
		PRIMARY KEY(policyId)
	)
	INSERT INTO @policyToLunInfo (policyId, totalQuotaUsedForUser, userId)
	SELECT SP_LUN.PolicyId, SUM(TotalSpaceBytes), @userId
	FROM SMLUN SM_LUN INNER JOIN SProvLUN SP_LUN ON SP_LUN.LUNId = SM_LUN.Id
	WHERE SP_LUN.UserId = @userId AND
		  SP_LUN.PolicyId IN (SELECT policyId FROM @policyInfo) AND
		  SP_LUN.ExpirationDate > @currentDate
	GROUP BY (SP_LUN.PolicyId)
	--If @policyToLunInfo is empty no luns have been created under this policy for the given user
	IF EXISTS(SELECT 1 FROM @policyToLunInfo)
	BEGIN
		--Update totalQuotaUsedForUser
		UPDATE @policyInfo
		SET totalQuotaUsedForUser = A.totalQuotaUsedForUser
		FROM @policyToLunInfo A INNER JOIN @policyInfo B ON B.policyId = A.policyId
		--Update remainingQuota
		UPDATE @policyInfo
		SET remainingQuota = policyQuota - totalQuotaUsedForUser
	END
	--update @policyTbl
	UPDATE @policyTbl
	SET remainingQuota = A.remainingQuota
	FROM @policyInfo A INNER JOIN @policyTbl B ON A.policyId = B.policyId
END
--If @userId is not passed (and policyId's passed or not passed).
IF(@userId = 0)
BEGIN
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 (SELECT S_POL.policyId AS '@policyId',
							 S_POL.policyName AS '@policyName',
							 S_POL.description AS '@description',
							 S_POL.userQuotaInBytes/(1024*1024*1024) AS '@userQuotaInGB',
							 /*dbo.GetUnixTime(S_POL.expirationPeriod)*/S_POL.expirationPeriod AS '@expirationPeriod',
							 S_POL.policyTypeId AS '@policyTypeId',
							 S_POLTYPE.policyTypeName AS '@policyTypeName',
							 S_POL.createdby AS 'createdBy/@userId',
							 (SELECT
								  (SELECT filerId AS '@arrayName',
										  1 AS '@flags',
										  selectionType AS '@selectionType',
										  filerType AS 'reserve/@reserveString'
								   FROM SprovAllocationPolicyFilerProp S_POLARRAY WHERE S_POLARRAY.policyId = S_POL.policyId
								   FOR XML PATH('includeExcludeArrayList'), TYPE),
								  (SELECT filerId AS '@arrayName',
										  2 AS '@flags',
										  filerType AS 'reserve/@reserveString'
								   FROM SprovAllocationPolicyFilerFilter S_POLARRAYFILTER WHERE S_POLARRAYFILTER.policyId = S_POL.policyId
								   FOR XML PATH('includeExcludeArrayList'), TYPE),
								  (SELECT aggregateName AS '@storagePoolName',
										  1 AS '@flags'
								   FROM SprovAllocationPolicyResourcePool S_POOL WHERE S_POOL.policyId = S_POL.policyId
								   FOR XML PATH('includeExcludeStoragePoolList'), TYPE),
								  (SELECT aggregateName AS '@storagePoolName',
										  2 AS '@flags'
								   FROM SprovAllocationPolicyResourcePoolFilter S_POOLFILTER WHERE S_POOLFILTER.policyId = S_POL.policyId
								   FOR XML PATH('includeExcludeStoragePoolList'), TYPE)
							    FOR XML PATH('includeExcludeList'), TYPE),
							   (SELECT userOrGroupId AS '@userOrGroupId',
									   isGroup AS '@isGroup',
									   (CASE WHEN (isGroup = 1)
												THEN (SELECT name FROM UMGroups WHERE id = S_POL2USERMAP.userOrGroupId)
											 WHEN (isGroup = 0)
												THEN (SELECT name FROM UMUsers WHERE id = S_POL2USERMAP.userOrGroupId)
											 ELSE 'Unknown'
										END) AS '@userOrGroupName'
								FROM SprovPolicyToUserMap S_POL2USERMAP WHERE S_POL2USERMAP.policyId = S_POL.policyId
								FOR XML PATH('userOrGroupList'), TYPE),
								(SELECT SM_LUN.Id AS '@lunId',
										SM_LUN.Name AS '@lunName'
								 FROM SProvLUN SP_LUN INNER JOIN SMLUN SM_LUN ON SP_LUN.LUNId = SM_LUN.Id WHERE SP_LUN.PolicyId = S_POL.policyId
								 FOR XML PATH('lunList'), TYPE)
					   FROM SprovAllocationPolicy S_POL INNER JOIN SprovAllocationPolicyType S_POLTYPE ON S_POLTYPE.policyTypeId = S_POL.policyTypeId
					   WHERE (@isPolicyIdsPassed = 0 OR S_POL.policyId IN (SELECT policyId FROM @policyTbl)) AND S_POL.policyId > 0
			     	   FOR XML PATH('policyList'), TYPE)
			  FOR XML PATH('StorageProvisioning_MMSProvPolicyInfo'))
END
----If @userId is passed (and policyId's passed or not passed).
ELSE IF(@userId > 0)
BEGIN
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 (SELECT SP_POL.policyId AS '@policyId',
							 SP_POL.policyName AS '@policyName',
							 SP_POL.description AS '@description',
							 SP_POL.userQuotaInBytes/(1024*1024*1024) AS '@userQuotaInGB',
							 /*dbo.GetUnixTime(expirationPeriod)*/ expirationPeriod AS '@expirationPeriod',
							 CAST(T_POL.remainingQuota/CAST(1024*1024*1024 AS DECIMAL(12, 2)) AS DECIMAL(12, 4)) AS '@remainingQuotaInGB',
							 SP_POL.policyTypeId AS '@policyTypeId'
					   FROM SprovAllocationPolicy SP_POL INNER JOIN @policyTbl T_POL ON T_POL.policyId = SP_POL.policyId
					   WHERE SP_POL.policyId IN
					   (
						   (SELECT policyId FROM SprovPolicyToUserMap
							--This where clause gets the list of all policies that are associated with a group to which the user is associated to
							WHERE userOrGroupId IN(
													SELECT DISTINCT SP_GRP.userOrGroupId FROM
													SprovPolicyToUserMap SP_GRP INNER JOIN UMUserGroup U_USRGRP ON SP_GRP.userOrGroupId = U_USRGRP.groupId
													WHERE SP_GRP.isGroup = 1 AND U_USRGRP.userId = @userId
						  						  ) AND
												  isGroup = 1
							) UNION--AND policyId IN --This where clause gets the list of all policies that are associated with a user directly
							(
								SELECT policyId FROM SprovPolicyToUserMap WHERE userOrGroupId = @userId AND isGroup = 0
							)
						) --AND ((@isPolicyIdsPassed = 0) OR SP_POL.policyId IN (SELECT policyId FROM @policyTbl))
					   --(SELECT policyId FROM SprovPolicyToUserMap WHERE userOrGroupId = @userId AND isGroup = 0 AND (@isPolicyIdsPassed = 0 OR policyId IN (SELECT policyId FROM @policyTbl)))
			     	   FOR XML PATH('policyList'), TYPE)
			  FOR XML PATH('StorageProvisioning_MMSProvPolicyInfo'))
END
RETURN
ERR_EXIT:
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString'
			  FOR XML PATH('StorageProvisioning_MMSProvPolicyInfo'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvListAllocationPolicies')
	delete from GxQscripts where name = 'MM_SProvListAllocationPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvListAllocationPolicies')
	delete from GXDBVersions where aliasname = 'MM_SProvListAllocationPolicies'
GO

insert into GXDBVersions values(2, 'MM_SProvListAllocationPolicies',  '00000000000000000000', 'MM_SProvListAllocationPolicies', '00000000000000000000')
GO

