

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvHostReports.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvHostReports()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvHostReports <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvHostReports')
	drop procedure MM_SProvHostReports
IF EXISTS (select * from GxQscripts where name='MM_SProvHostReports')
	delete from GxQscripts where name = 'MM_SProvHostReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvHostReports')
	delete from GXDBVersions where aliasname = 'MM_SProvHostReports'
GO
print '... Creating Procedure: MM_SProvHostReports'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvHostReports
  @ipxml XML,
  @opxml XML OUTPUT
AS
	SET NOCOUNT ON
	DECLARE @vendorId INT
	DECLARE @arrayId INT
	DECLARE @controlHostId INT
	SET @vendorId = ISNULL((SELECT A.ref.value('@vendorId', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo') A(ref)), 0);
	SET @arrayId = ISNULL((SELECT A.ref.value('@arrayNum', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/arrayList[1]') A(ref)), 0);
	DECLARE @regHosts TABLE (clientId INTEGER, name NVARCHAR(2048))
	DECLARE @userToRegHostMap TABLE (clientId INTEGER, userId INTEGER, userName NVARCHAR(2048))
	INSERT INTO @regHosts
	SELECT DISTINCT id, name FROM APP_Client APPCLNT INNER JOIN SProvHost SPRVHost ON APPCLNT.id = SPRVHost.ClientId
	INSERT INTO @userToRegHostMap(clientId, userId)
	SELECT SPRVHst.ClientId, SPRVHst.UserId FROM SProvHost SPRVHst INNER JOIN APP_Client APPCLNT ON APPCLNT.id = SPRVHst.ClientId
	UPDATE @userToRegHostMap SET userName = UMUsr.name FROM UMUsers UMUsr INNER JOIN @userToRegHostMap usrToHostMp ON usrToHostMp.userId = UMUsr.id
	SET @opxml = (
	SELECT
			(SELECT APPCLT.name AS 'regHost/@clientName',
					APPCLT.id AS 'regHost/@clientId',
					(SELECT usrToHostMap.userId AS '@userId',
							usrToHostMap.userName AS '@userName'
							FROM @userToRegHostMap usrToHostMap WHERE usrToHostMap.clientId = APPCLT.id
							FOR XML PATH('userList'), TYPE),
					(SELECT DISTINCT
							SPrvArr.ArrayNum AS '@arrayNum',
							SMArr.ClientId AS '@arrayClientId',
							SMArr.ArrayName AS '@arrayName',
							SPrvLn.LUNId AS '@lunId',
							SMLn.Name AS '@lunName',
							SPrvMntLun.ProtocolId AS '@protocolId',
							SMLn.TotalSpaceBytes AS '@lunSize',
							SMLn.FreeSpaceBytes AS '@lunFreeSpace',
							usrToHost.userName AS '@userName',
							usrToHost.UserId AS '@userId'
							FROM SProvArray SPrvArr
							INNER JOIN SMArray SMArr ON SPrvArr.ArrayNum = SMArr.Id
							INNER JOIN SProvLUN SPrvLn ON SPrvLn.ArrayNum = SPrvArr.ArrayNum
							INNER JOIN SMLUN SMLn ON SMLn.Id = SPrvLn.LUNId
							INNER JOIN SProvMountLUN SPrvMntLun ON SPrvMntLun.LUNId = SPrvLn.LUNId
							LEFT JOIN @userToRegHostMap usrToHost ON usrToHost.userId = SPrvLn.UserId
							WHERE SPrvMntLun.MountHostId = APPCLT.id
							AND (@arrayId = SMArr.Id OR (@arrayId = 0 AND APPCLT.id IN (SELECT DISTINCT ClientId FROM SProvHost)))
							AND usrToHost.userId = SPrvLn.UserId
							FOR XML PATH('hostParams'), TYPE)
					FROM APP_Client APPCLT INNER JOIN SProvMountLun SPMntLn ON SPMntLn.MountHostId = APPCLT.id
					INNER JOIN SProvLUN SPLn ON SPMntLn.LUNId = SPLn.LUNId
					--WHERE @arrayId = SPLn.ArrayNum OR (@arrayId = 0 AND APPCLT.id IN (SELECT DISTINCT ClientId FROM SProvHost))
					GROUP BY APPCLT.id, APPCLT.name
					FOR XML PATH('hostList'), TYPE)
					FOR XML PATH('StorageProvisioning_MMSProvRegHostReports')
		)
	IF EXISTS (select * from GxQscripts where name = 'MM_SProvHostReports')
		delete from GxQscripts where name = 'MM_SProvHostReports'

IF EXISTS (select * from GxQscripts where name = 'MM_SProvHostReports')
	delete from GxQscripts where name = 'MM_SProvHostReports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvHostReports')
	delete from GXDBVersions where aliasname = 'MM_SProvHostReports'
GO

insert into GXDBVersions values(2, 'MM_SProvHostReports',  '00000000000000000000', 'MM_SProvHostReports', '00000000000000000000')
GO

