

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvGetUsers.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvGetUsers()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvGetUsers <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvGetUsers')
	drop procedure MM_SProvGetUsers
IF EXISTS (select * from GxQscripts where name='MM_SProvGetUsers')
	delete from GxQscripts where name = 'MM_SProvGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetUsers')
	delete from GXDBVersions where aliasname = 'MM_SProvGetUsers'
GO
print '... Creating Procedure: MM_SProvGetUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvGetUsers
  @xmlop xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @table TABLE(userId INT, capability INT)
DECLARE @tmptable TABLE(userId INT, capability INT)
DECLARE @cap INT = 0
DECLARE @sprovUserPermId NVARCHAR(1024) = ''
DECLARE @sprovAdminPermId NVARCHAR(1024) = ''
SET @sprovUserPermId = (SELECT id FROM UMPermissions WHERE permissionName = 'Storage Provisioning User')
SET @sprovAdminPermId = (SELECT id FROM UMPermissions WHERE permissionName = 'Storage Provisioning Administrator')
INSERT INTO @table(userId, capability) SELECT id, 0 FROM UMUsers WHERE id > 0
INSERT INTO @tmptable(userId, capability) SELECT id, 0 FROM UMUsers WHERE id > 0
WHILE EXISTS(SELECT * FROM @table WHERE userId > 0)
BEGIN
	SET @cap = 0
	DECLARE @user INT
	SELECT @user = (SELECT top 1 userId FROM @table ORDER BY userId ASC)
	EXEC sec_userHasCapability @user, 0, @cap output, 0, 0, @sprovAdminPermId
	IF(@cap = 1) --if the user is an admin
		BEGIN
		UPDATE @tmptable SET capability = 1 WHERE userId = @user
		END
	IF(@cap <> 1) --if he is not an admin check if he is a user
		BEGIN
		EXEC sec_userHasCapability @user, 0, @cap OUTPUT, 0, 0, @sprovUserPermId
		IF(@cap = 1)
			BEGIN
			UPDATE @tmptable SET capability = 2 WHERE userId = @user
			END
		END
	DELETE @table WHERE userId = @user
END
SET @xmlop = (SELECT
				(SELECT tbl.capability AS '@flags' ,
						tbl.userId AS 'user/@userId',
						UMUsr.login AS 'user/@userName'
				 FROM @tmptable tbl INNER JOIN UMUsers UMUsr ON UMUsr.id = tbl.userId
				 WHERE tbl.capability <> 0
				 FOR XML PATH ('userList'), TYPE)
			   FOR XML PATH ('StorageProvisioning_MMSProvGroupInfo'))

IF EXISTS (select * from GxQscripts where name = 'MM_SProvGetUsers')
	delete from GxQscripts where name = 'MM_SProvGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetUsers')
	delete from GXDBVersions where aliasname = 'MM_SProvGetUsers'
GO

insert into GXDBVersions values(2, 'MM_SProvGetUsers',  '00000000000000000000', 'MM_SProvGetUsers', '00000000000000000000')
GO

