

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvGetStoragePools.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvGetStoragePools()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvGetStoragePools <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvGetStoragePools')
	drop procedure MM_SProvGetStoragePools
IF EXISTS (select * from GxQscripts where name='MM_SProvGetStoragePools')
	delete from GxQscripts where name = 'MM_SProvGetStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetStoragePools')
	delete from GXDBVersions where aliasname = 'MM_SProvGetStoragePools'
GO
print '... Creating Procedure: MM_SProvGetStoragePools'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvGetStoragePools
  @ipxml xml,
  @opxml xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @includeString nvarchar(1024) = ''
DECLARE @excludeString nvarchar(1024) = ''
DECLARE @isArrayIdsPassed INT = 0
DECLARE @isIncludeFilterPassed INT = 0
DECLARE @isExcludeFilterPassed INT = 0
DECLARE @arrayTbl TABLE
(
	arrayId INT
)
DECLARE @includeFilterTbl TABLE
(
	includeString NVARCHAR(1024)
)
DECLARE @excludeFilterTbl TABLE
(
	excludeString NVARCHAR(1024)
)
DECLARE @includeFilterTblDetails TABLE
(
	includeString NVARCHAR(1024),
	arrayName NVARCHAR(1024)
)
DECLARE @excludeFilterTblDetails TABLE
(
	excludeString NVARCHAR(1024),
	arrayName NVARCHAR(1024)
)
--If actual array Ids are passed populate the @arrayTbl temp table
INSERT INTO @arrayTbl
	SELECT
	R.ref.value('@arrayNum', 'INT')
	FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/arrayList') R(ref)
--Include and exclude filters
SET @includeString = ISNULL((SELECT A.ref.value('@reserveString', 'nvarchar(1024)') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/reserve') A(ref)), '')
SET @excludeString = ISNULL((SELECT A.ref.value('@reserveString2', 'nvarchar(1024)') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo/reserve') A(ref)), '')
--If include strings are passed populate the @includeFilterTbl temp table
INSERT INTO @includeFilterTbl(includeString)
SELECT _ID FROM dbo.SplitStringByDelimiter(@includeString, ',')
--If exclude strings are passed populate the @excludeFilterTbl temp table
INSERT INTO @excludeFilterTbl(excludeString)
SELECT _ID FROM dbo.SplitStringByDelimiter(@excludeString, ',')
--Update the arrayName field for both @includeFilterTbl and @excludeFilterTbl
INSERT INTO @includeFilterTblDetails
SELECT T_IFTBL.includeString, S_ARR.ArrayName FROM @includeFilterTbl T_IFTBL INNER JOIN SMArray S_ARR ON S_ARR.ArrayName LIKE T_IFTBL.includeString
INSERT INTO @excludeFilterTblDetails
SELECT T_EFTBL.excludeString, S_ARR.ArrayName FROM @excludeFilterTbl T_EFTBL INNER JOIN SMArray S_ARR ON S_ARR.ArrayName LIKE T_EFTBL.excludeString
IF EXISTS (SELECT 1 FROM @arrayTbl)
BEGIN
	SET @isArrayIdsPassed = 1
END
IF EXISTS (SELECT 1 FROM @includeFilterTbl)
BEGIN
	SET @isIncludeFilterPassed = 1
END
IF EXISTS (SELECT 1 FROM @excludeFilterTbl)
BEGIN
	SET @isExcludeFilterPassed = 1
END
--SELECT @includeString AS 'INCLUDE', @excludeString AS 'EXCLUDE', @isArrayIdsPassed AS 'isArrayPassed', @isExcludeFilterPassed AS 'isEFPassed', @isIncludeFilterPassed AS 'isIFPassed'
--SELECT * FROM @includeFilterTblDetails
--SELECT * FROM @excludeFilterTblDetails
--SET @opxml = (SELECT
--				(SELECT SMARR.ArrayName AS '@arrayName',
--						SMARR.Id AS '@arrayNum',
--						SMARR.ClientId AS 'client/@clientId',
--						(SELECT POOL.Id AS '@storagePoolId',
--								POOL.Name AS '@storagePoolName',
--								POOL.ClientId AS 'client/@clientId'
--						 FROM SMStoragePool POOL (NOLOCK) INNER JOIN SMArray ARR ON ARR.ClientId = POOL.ClientId
--						 WHERE POOL.ClientId = SMARR.ClientId
--					     FOR XML PATH ('poolList'), TYPE)
--				 FROM SMArray SMARR INNER JOIN SMControlHost SMHOST ON SMHOST.ClientId = SMARR.ClientId
--				 WHERE (@includeString='' OR SMARR.ArrayName LIKE '%' + @includeString + '%') AND
--					   (@isArrayIdsPassed = 0 OR SMARR.Id IN (SELECT arrayId FROM @arrayTbl) ) AND
--					   (@excludeString='' OR SMARR.ArrayName NOT LIKE '%' + @excludeString + '%')
--				 FOR XML PATH('arrayList'), TYPE)
--			   FOR XML PATH('StorageProvisioning_MMSProvArrayFamilyInfo'))
SET @opxml = (SELECT
				(SELECT SMARR.ArrayName AS '@arrayName',
						SMARR.Id AS '@arrayNum',
						SMARR.ClientId AS 'client/@clientId',
						(SELECT POOL.Id AS '@storagePoolId',
								POOL.Name AS '@storagePoolName',
								SMARR.Id AS '@arrayNum',
								POOL.ClientId AS 'client/@clientId'
						 FROM SMStoragePool POOL (NOLOCK) INNER JOIN SMArray ARR ON ARR.ClientId = POOL.ClientId
						 WHERE POOL.ClientId = SMARR.ClientId
					     FOR XML PATH ('poolList'), TYPE)
				 FROM SMArray SMARR INNER JOIN SMControlHost SMHOST ON SMHOST.ClientId = SMARR.ClientId
									INNER JOIN SProvArray SP_ARR ON SP_ARR.ArrayNum = SMARR.Id
									INNER JOIN SMArrayCtrlHostMap SMCtrlHostMap ON SMHOST.ControlHostId = SMCtrlHostMap.ControlHostId
				 WHERE (@isIncludeFilterPassed = 0 OR SMARR.ArrayName IN (SELECT arrayName FROM @includeFilterTblDetails)) AND
					   (@isArrayIdsPassed = 0 OR SMARR.Id IN (SELECT arrayId FROM @arrayTbl) ) AND
					   (@isExcludeFilterPassed = 0 OR SMARR.ArrayName NOT IN ((SELECT arrayName FROM @excludeFilterTblDetails))) AND
					   ((SMHOST.SnapVendorName <> 'NetApp') OR ((SMHOST.SMHostFlags & 16) = 16) OR ((SMHOST.SMHostFlags & 8) = 8))
				 FOR XML PATH('arrayList'), TYPE)
			   FOR XML PATH('StorageProvisioning_MMSProvArrayFamilyInfo'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvGetStoragePools')
	delete from GxQscripts where name = 'MM_SProvGetStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetStoragePools')
	delete from GXDBVersions where aliasname = 'MM_SProvGetStoragePools'
GO

insert into GXDBVersions values(2, 'MM_SProvGetStoragePools',  '00000000000000000000', 'MM_SProvGetStoragePools', '00000000000000000000')
GO

