

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvGetLunsInfo.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvGetLunsInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvGetLunsInfo <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvGetLunsInfo')
	drop procedure MM_SProvGetLunsInfo
IF EXISTS (select * from GxQscripts where name='MM_SProvGetLunsInfo')
	delete from GxQscripts where name = 'MM_SProvGetLunsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetLunsInfo')
	delete from GXDBVersions where aliasname = 'MM_SProvGetLunsInfo'
GO
print '... Creating Procedure: MM_SProvGetLunsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvGetLunsInfo
  @ipxml xml,
  @opxml xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @UserId int
DECLARE @SProvLunXML XML
SET @UserId = (SELECT A.ref.value('@userId', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/lunList/user') A(ref));
DECLARE @currentDate DATETIME
SET @currentDate = GETUTCDATE()
DECLARE @TSProvTbl TABLE
(
	SMLUNId	int PRIMARY KEY,
	SMArrayID int,
	SProvFlags int,
	APPClientId int,
	SProvProtocolId int,
	SProvName nvarchar(1000),
	SProvSize bigint,
	SProvExpirationDate int,
	SProvMountPath nvarchar(1000),
	SProvHostName nvarchar(1000),
	SProvArrayName nvarchar(1000),
	SProvOwner nvarchar(1000),
	SProvProtocol nvarchar(1000),
	SProvLunDescription nvarchar(MAX),
	SProvVolume	nvarchar(2048),
	SProvVolumeId INT,
	SProvPolicyId INT,
	SProvRemainingQuota BIGINT
)
DECLARE @TSProvLnMntMap TABLE
(
	SMLUNId	int,
	MntHostId INT,
	MntHostName nvarchar(1024),
	MntHostPath nvarchar(2048),
	MntProtocolId INT,
	EndPtId INT,
	EndPtName nvarchar(2048),
	MntLunId INT
)
DECLARE @PolicyToUserMap TABLE
(
	PolicyId INT,
	PolicyQuota BIGINT,
	TotalQuotaUsed BIGINT DEFAULT 0,
	RemainingQuota BIGINT DEFAULT 0
)
--Insert the import policy entry into @PolicyToUserMap. All imported LUNs are associated to policy with id = -2
INSERT INTO @PolicyToUserMap (PolicyId, PolicyQuota, TotalQuotaUsed, RemainingQuota) VALUES (-2, 0, 0, 0)
DECLARE @curTime DATETIME = GETUTCDATE()
/*UPDATE Expiration*/
INSERT INTO @TSProvTbl(SMLUNId, SProvExpirationDate, SMArrayID, SProvLunDescription, SProvPolicyId)
(SELECT LunId, dbo.GetUnixTime(ExpirationDate), ArrayNum, Description, PolicyId
 FROM SProvLun WITH (NOLOCK)
 WHERE UserId = @UserId AND
 Enabled = 1)
 --AND dbo.GetUnixTime(ExpirationDate) > dbo.GetUnixTime(@curTime))
--Insert mount details
INSERT INTO @TSProvLnMntMap (SMLUNId, MntHostId, MntHostPath, MntProtocolId, EndPtId, MntLunId)
(SELECT LUNId, MountHostId, MountPath, ProtocolId, EndPointId, MountLunId FROM SProvMountLUN WHERE UserId = @UserId)
UPDATE @TSProvLnMntMap
SET MntHostName = APPCnt.name
FROM APP_Client APPCnt
INNER JOIN @TSProvLnMntMap lnMap ON lnMap.MntHostId = APPCnt.id
UPDATE @TSProvLnMntMap
SET EndPtName = smEndPt.Address
FROM SMEndPoint smEndPt
WHERE [@TSProvLnMntMap].EndPtId = smEndPt.Id
/*UPDATE Name, Size and Flags*/
UPDATE @TSProvTbl
SET SProvName = SMLN.Name,
	SProvSize = SMLN.TotalSpaceBytes,
	SProvFlags = SMLN.Flags
FROM SMLUN SMLN WITH (NOLOCK)
WHERE [@TSProvTbl].SMLUNId = SMLN.Id
/*UPDATE/SET the expired flag if the LUN has expired*/
UPDATE @TSProvTbl
SET SProvFlags = 16
WHERE SProvExpirationDate < dbo.GetUnixTime(GETUTCDATE())
/*UPDATE Mount Path, APPClientId and Protocol Id*/
--UPDATE @TSProvTbl
--SET SProvMountPath = SProvMntLn.MountPath,
--	APPClientId = SProvMntLn.MountHostId,
--	SProvProtocolId = SProvMntLn.ProtocolId
--FROM SProvMountLUN SProvMntLn WITH (NOLOCK)
--WHERE [@TSProvTbl].SMLUNId = SProvMntLn.LUNId
/*UPDATE Array*/
UPDATE @TSProvTbl
SET SProvArrayName = SMArrayTbl.ArrayName
FROM SMArray SMArrayTbl WITH (NOLOCK)
WHERE [@TSProvTbl].SMArrayID = SMArrayTbl.Id
/*UPDATE Host*/
UPDATE @TSProvTbl
SET SProvHostName = APPClntTbl.name
FROM APP_Client APPClntTbl WITH (NOLOCK)
WHERE [@TSProvTbl].APPClientId = APPClntTbl.id
/*UPDATE Protocol*/
UPDATE @TSProvTbl
SET SProvProtocol = SProvPtcl.Name
FROM SProvProtocol SProvPtcl WITH (NOLOCK)
WHERE [@TSProvTbl].SProvProtocolId = SProvPtcl.ProtocolId
/*UPDATE OWNER*/
UPDATE @TSProvTbl
SET SProvOwner = UmUsrs.login
FROM UMUsers UmUsrs INNER JOIN SProvLUN SPrvLN ON SPrvLN.UserId = UmUsrs.id
					INNER JOIN @TSProvTbl tsprovtbl ON tsprovtbl.SMLUNId = SPrvLN.LUNId
/**/
/*UPDATE Volume ID and Volume name*/
UPDATE @TSProvTbl
SET SProvVolumeId = SMLn.ArrayVolumeId
FROM SMLUN SMLn INNER JOIN @TSProvTbl sprovTbl
ON sprovTbl.SMLUNId = SMLn.Id
UPDATE @TSProvTbl
SET SProvVolume = SMArrVol.Name
FROM SMArrayVolume SMArrVol INNER JOIN @TSProvTbl
ON [@TSProvTbl].SProvVolumeId = SMArrVol.Id
/**/
/*Get the Policy Details*/
INSERT INTO @PolicyToUserMap(PolicyId)
(SELECT policyId FROM SprovPolicyToUserMap
--This where clause gets the list of all policies that are associated with a group to which the user is associated to
WHERE userOrGroupId IN(
					SELECT DISTINCT SP_GRP.userOrGroupId FROM
					SprovPolicyToUserMap SP_GRP INNER JOIN UMUserGroup U_USRGRP ON SP_GRP.userOrGroupId = U_USRGRP.groupId
					WHERE SP_GRP.isGroup = 1 AND U_USRGRP.userId = @userId
					) AND
					isGroup = 1
) UNION--AND policyId IN --This where clause gets the list of all policies that are associated with a user directly
(
	SELECT policyId FROM SprovPolicyToUserMap WHERE userOrGroupId = @userId AND isGroup = 0
)
--Set the total quota used for this user for each policy he is assigned to in @PolicyToUserMap table
UPDATE @PolicyToUserMap
SET TotalQuotaUsed =
				ISNULL((SELECT SUM(S_LUN.TotalSpaceBytes)
						FROM SMLUN S_LUN INNER JOIN SProvLUN SP_LUN ON SP_LUN.LUNId = S_LUN.Id
						WHERE SP_LUN.PolicyId = [@PolicyToUserMap].PolicyId AND SP_LUN.UserId = @UserId AND SP_LUN.ExpirationDate > @currentDate), 0)
--Set the actual policy quota
UPDATE @PolicyToUserMap
SET PolicyQuota = S_POL.userQuotaInBytes
FROM SprovAllocationPolicy S_POL INNER JOIN @PolicyToUserMap T_POL ON T_POL.PolicyId = S_POL.policyId
--Calculate the remaining quota
UPDATE @PolicyToUserMap
SET RemainingQuota = PolicyQuota - TotalQuotaUsed
/**/
SET @SProvLunXML = (SELECT	sprovTbl.SMLUNId AS '@lunId',
							sprovTbl.SMArrayID AS '@arrayNum',
 							sprovTbl.SProvName AS '@lunName',
							sprovTbl.SProvSize AS '@lunSize',
							sprovTbl.SProvExpirationDate AS '@expirationDate',
							sprovTbl.SProvArrayName AS '@arrayName',
							sprovTbl.SProvOwner AS '@owner',
							sprovTbl.SProvVolume AS '@volume',
							sprovTbl.SProvLunDescription AS '@description',
							sprovTbl.SProvFlags AS 'reserve/@reserveInt',
							(
								SELECT A.MntHostName AS '@mountHostName',
										   A.MntHostId AS '@mountHostId',
										   A.MntHostPath AS '@mountPath',
										   A.MntLunId AS '@MountLunId'
								FROM (
									SELECT lnMap.MntHostName ,
										   lnMap.MntHostId ,
										   lnMap.MntHostPath ,
										   lnMap.MntLunId,
										   ROW_NUMBER() OVER(PARTITION BY lnMap.MntHostId ORDER BY lnMap.MntHostId) rn
										   --MntProtocolId AS'@protocolId',
										   --EndPtId AS '@endPointId',
										   --EndPtName AS '@endPointName'
									FROM @TSProvLnMntMap lnMap
									WHERE lnMap.SMLUNId = sprovTbl.SMLUNId
								) A
								WHERE rn = 1
								FOR XML PATH ('mountInfo'), TYPE
							 ),
							(SELECT S_POL.policyId AS '@policyId',
									S_POL.policyName AS '@policyName',
									S_POL.expirationPeriod AS '@expirationPeriod',
									CAST(T_POLMAP.RemainingQuota/CAST(1024*1024*1024 AS DECIMAL(12, 2)) AS DECIMAL(12, 4)) AS '@remainingQuotaInGB'
							 FOR XML PATH('policyInfo'), TYPE)
							FROM @TSProvTbl sprovTbl INNER JOIN SprovAllocationPolicy S_POL ON S_POL.policyId = sprovTbl.SProvPolicyId
													 INNER JOIN @PolicyToUserMap T_POLMAP ON T_POLMAP.PolicyId = S_POL.policyId
					FOR XML PATH ('lunInfo'), TYPE
					)
SET @opxml = (SELECT  @SProvLunXML
			  FOR XML PATH ('StorageProvisioning_MMSProvGUIResponseLunsTable')
			  )

IF EXISTS (select * from GxQscripts where name = 'MM_SProvGetLunsInfo')
	delete from GxQscripts where name = 'MM_SProvGetLunsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetLunsInfo')
	delete from GXDBVersions where aliasname = 'MM_SProvGetLunsInfo'
GO

insert into GXDBVersions values(2, 'MM_SProvGetLunsInfo',  '00000000000000000000', 'MM_SProvGetLunsInfo', '00000000000000000000')
GO

