

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvGetHostsInfo.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvGetHostsInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvGetHostsInfo <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvGetHostsInfo')
	drop procedure MM_SProvGetHostsInfo
IF EXISTS (select * from GxQscripts where name='MM_SProvGetHostsInfo')
	delete from GxQscripts where name = 'MM_SProvGetHostsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetHostsInfo')
	delete from GXDBVersions where aliasname = 'MM_SProvGetHostsInfo'
GO
print '... Creating Procedure: MM_SProvGetHostsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvGetHostsInfo
  @ipxml xml,
  @opxml xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @UserId int
DECLARE @SProvHostsXML XML
SET @UserId = (SELECT A.ref.value('@userId', 'int') FROM @ipxml.nodes('/StorageProvisioning_MMSProvInfo/lunList/user') A(ref));
DECLARE @TSProvHostsTbl TABLE
(
	APPClientId int,
	UserId int,
	SProvHostName nvarchar(1000),
	SProvLunsMappedToHost int DEFAULT 0,
	SProvHostDescription nvarchar(MAX)
)
INSERT INTO @TSProvHostsTbl(APPClientId, SProvHostName)
	(SELECT id, name FROM APP_Client WHERE EXISTS
		(SELECT ClientId FROM SProvHost WHERE SProvHost.ClientId = APP_Client.id AND UserId = @UserId))
/*UPDATE Number of Luns Mapped*/
UPDATE @TSProvHostsTbl
	   SET SProvLunsMappedToHost = (SELECT COUNT(MountHostId) FROM SProvMountLun SMMNTLN WHERE [@TSProvHostsTbl].APPClientId = SMMNTLN.MountHostId AND UserId = @UserId)
/*Update the userId field*/
UPDATE @TSProvHostsTbl
	   SET [@TSProvHostsTbl].UserId = SProvHost.UserId FROM SProvHost, @TSProvHostsTbl WHERE [@TSProvHostsTbl].APPClientId = SProvHost.ClientId AND SProvHost.UserId = @UserId
/*Update the description field*/
UPDATE @TSProvHostsTbl
	   SET [@TSProvHostsTbl].SProvHostDescription = (SELECT SProvHost.Description FROM SProvHost WHERE SProvHost.ClientId = [@TSProvHostsTbl].APPClientId AND SProvHost.UserId = @UserId)
SET @SProvHostsXML = (SELECT	SProvHostName AS '@host',
								SProvLunsMappedToHost AS '@lunsMounted',
								APPClientId AS '@appClientId',
								SProvHostDescription AS '@description'
					  FROM @TSProvHostsTbl WHERE UserId = @UserId
					  FOR XML PATH ('regHostInfo')
					  )
SET @opxml = (SELECT  @SProvHostsXML
			  FOR XML PATH ('StorageProvisioning_MMSProvGUIResponseHostsTable')
			  )

IF EXISTS (select * from GxQscripts where name = 'MM_SProvGetHostsInfo')
	delete from GxQscripts where name = 'MM_SProvGetHostsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetHostsInfo')
	delete from GXDBVersions where aliasname = 'MM_SProvGetHostsInfo'
GO

insert into GXDBVersions values(2, 'MM_SProvGetHostsInfo',  '00000000000000000000', 'MM_SProvGetHostsInfo', '00000000000000000000')
GO

