

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvGetArrays.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvGetArrays()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvGetArrays <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvGetArrays')
	drop procedure MM_SProvGetArrays
IF EXISTS (select * from GxQscripts where name='MM_SProvGetArrays')
	delete from GxQscripts where name = 'MM_SProvGetArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetArrays')
	delete from GXDBVersions where aliasname = 'MM_SProvGetArrays'
GO
print '... Creating Procedure: MM_SProvGetArrays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvGetArrays
  @ipxml XML,
  @opxml XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @vendorTbl TABLE
(
	vendorId INT,
	vendorName NVARCHAR(1024) default ''
)
DECLARE @SProvVendorIds NVARCHAR(1024) = ''
DECLARE @isVendorIdsPassed INT = 0
SET @SProvVendorIds = ISNULL((SELECT A.ref.value('@vendorName', 'NVARCHAR(1024)') FROM @ipxml.nodes('/StorageProvisioning_MMSProvArrayFamilyInfo') A(ref)), '');
INSERT INTO @vendorTbl(vendorId)
SELECT _ID FROM dbo.SplitStringByDelimiter(@SProvVendorIds, ',')
UPDATE @vendorTbl SET vendorName = S_VEN.Name
FROM SMVendor S_VEN INNER JOIN @vendorTbl T_VEN ON T_VEN.vendorId = S_VEN.Id
--SELECT @SProvVendorIds
--SELECT * FROM @vendorTbl
IF EXISTS (SELECT 1 FROM @vendorTbl)
BEGIN
	SET @isVendorIdsPassed = 1
END
SET @opxml =
(SELECT (SELECT S_ARR.ArrayName AS '@arrayName',
				SMCtrlHostMap.ArrayId AS '@arrayNum',
				SMCtrlHost.SnapVendorName AS 'reserve/@reserveString'
		FROM SMControlHost SMCtrlHost INNER JOIN SMArrayCtrlHostMap SMCtrlHostMap ON SMCtrlHost.ControlHostId = SMCtrlHostMap.ControlHostId
									  INNER JOIN SProvArray SPrArr ON SPrArr.ArrayNum = SMCtrlHostMap.ArrayId
									  INNER JOIN SMArray S_ARR ON S_ARR.Id = SPrArr.ArrayNum
									  INNER JOIN SMVendor S_VEN ON S_VEN.Name = SMCtrlHost.SnapVendorName
		WHERE (@isVendorIdsPassed = 0 OR (SMCtrlHost.SnapVendorName IN (SELECT vendorName FROM @vendorTbl))) AND
			   SMCtrlHost.SMHostFlags NOT IN(1, 4) AND
				  --AND SMCtrlHost.SMHostFlags NOT IN(1, 4) AND (SMCtrlHost.SMHostFlags & 4) = 0
				  --AND (SMCtrlHost.SMHostFlags & CVSM_CTRLHOST_7MODE_FILER_DB) = CVSM_CTRLHOST_7MODE_FILER_DB
			    ((SMCtrlHost.SnapVendorName <> 'NetApp') OR ((SMCtrlHost.SMHostFlags & 16) = 16) OR ((SMCtrlHost.SMHostFlags & 8) = 8)) AND
				S_VEN.IsProvisionCapable = 1 AND
			    SPrArr.Enabled = 1
		FOR XML PATH ('arrayList'), TYPE)
FOR XML PATH ('StorageProvisioning_MMSProvArrayFamilyInfo'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvGetArrays')
	delete from GxQscripts where name = 'MM_SProvGetArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvGetArrays')
	delete from GXDBVersions where aliasname = 'MM_SProvGetArrays'
GO

insert into GXDBVersions values(2, 'MM_SProvGetArrays',  '00000000000000000000', 'MM_SProvGetArrays', '00000000000000000000')
GO

