

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvEditAllocationPolicy.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvEditAllocationPolicy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvEditAllocationPolicy <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvEditAllocationPolicy')
	drop procedure MM_SProvEditAllocationPolicy
IF EXISTS (select * from GxQscripts where name='MM_SProvEditAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvEditAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvEditAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvEditAllocationPolicy'
GO
print '... Creating Procedure: MM_SProvEditAllocationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvEditAllocationPolicy
  @xmlip XML,
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
--Sample input XML
--'<StorageProvisioning_MMSProvAllocationPolicy policyId="7" policyName="BasicPolicy" description="Description" policyTypeId="1" userQuotaInGB="20" expirationPeriod="1468511445" >
--	<includeExcludeList>
--		<includeExcludeArrayList arrayName = "%hfiler1%" flags="2" selectionType="3">
--			<reserve reserveString="NetApp"/>
--		</includeExcludeArrayList>
--		<includeExcludeArrayList arrayName = "%hfiler%" flags="1" selectionType="3">
--			<reserve reserveString="NetApp"/>
--		</includeExcludeArrayList>
--		<includeExcludeStoragePoolList storagePoolName = "dev_n_test" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "SystemAggr_DoNotUse" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "dev_n_test_1" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "SystemAggr_DoNotUse" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "%System%" flags="2"/>
--	</includeExcludeList>
--	<userOrGroupList userOrGroupId = "1" isGroup = "1"/>
--	<userOrGroupList userOrGroupId = "2" isGroup = "1"/>
--	<userOrGroupList userOrGroupId = "3" isGroup = "1"/>
--</StorageProvisioning_MMSProvAllocationPolicy>'
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(1024) = ''
DECLARE @policyId INT
DECLARE @selectionType INT = 0
DECLARE @dummyArrayNum INT = 0
DECLARE @dummyStoragePoolId INT = 0
DECLARE @createdBy INT = 0
DECLARE @newPolicyQuota BIGINT = 0
DECLARE @currentPolicyQuota BIGINT = 0
SET @createdBy = ISNULL((SELECT R.ref.value('@userId', 'INT')
						FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/createdBy') R(ref)),0)
SET @policyId = ISNULL((SELECT R.ref.value('@policyId', 'INT')
						FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy') R(ref)), 0)
SET @newPolicyQuota	= ISNULL((SELECT R.ref.value('@userQuotaInGB', 'INT')
						FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy') R(ref)),0)
IF @policyId <= 0 OR @policyId IS NULL
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Invalid Policy ID'
	GOTO ERR_EXIT
END
IF NOT EXISTS (SELECT 1 FROM SprovAllocationPolicy WHERE policyId = @policyId)
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Policy ID does not exist!'
	GOTO ERR_EXIT
END
SET @currentPolicyQuota = (SELECT TOP 1 userQuotaInBytes FROM SprovAllocationPolicy WHERE policyId = @policyId)
SET @newPolicyQuota = @newPolicyQuota * 1024 * 1024 * 1024
DECLARE @policyTbl TABLE
(
	policyId INT,
	policyName nvarchar(1024),
	policyDescription nvarchar(2048),
	policyType INT,
	userQuotaInGB BIGINT,
	policyExpiration INT,
	createdBy INT
)
DECLARE @arrayTable TABLE
(
	arrayName nvarchar(1024) default '',
	arrayNum INT,
	flags INT,
	vendor nvarchar(1024) default '',
	selectionType INT
)
DECLARE @storagePoolTable TABLE
(
	storagePoolId INT,
	storagePoolName nvarchar(1024),
	flags INT,
	arrayNum INT
)
DECLARE @usersTbl TABLE
(
	userOrGroupId INT,
	isGroup INT
)
DECLARE @usersToQuotaMap TABLE
(
	userId INT,
	totalQuotaUsed BIGINT,
	isQuotaExceeded BIT DEFAULT 0
)
-----------------------------------------------UPDATE THE POLICY PROPERTIES-----------------------------------------------
INSERT INTO @policyTbl
	SELECT
	R.ref.value('@policyId', 'INT'),
	R.ref.value('@policyName', 'nvarchar(1024)'),
	R.ref.value('@description', 'nvarchar(2048)'),
	R.ref.value('@policyTypeId', 'INT'),
	R.ref.value('@userQuotaInGB', 'BIGINT'),
	R.ref.value('@expirationPeriod', 'INT'),
	@createdBy
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy') R(ref)
-----------------------------------------------END: UPDATE THE POLICY PROPERTIES-----------------------------------------------
-----------------------------------------------UPDATE THE ARRAY PROPERTIES OF THE POLICY-----------------------------------------------
INSERT INTO @arrayTable
	SELECT
	ISNULL(R.ref.value('@arrayName', 'nvarchar(1024)'), ''),
	R.ref.value('@arrayNum', 'INT'),
	R.ref.value('@flags', 'INT'),
	ISNULL(R.ref.value('reserve[1]/@reserveString', 'nvarchar(1024)'), ''),
	R.ref.value('@selectionType', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/includeExcludeList/includeExcludeArrayList') R(ref)
-----------------------------------------------END:UPDATE THE ARRAY PROPERTIES OF THE POLICY-----------------------------------------------
-----------------------------------------------UPDATE THE STORAGE POOL PROPERTIES OF THE POLICY-----------------------------------------------
INSERT INTO @storagePoolTable
	SELECT
	R.ref.value('@storagePoolId', 'INT'),
	R.ref.value('@storagePoolName', 'nvarchar(1024)'),
	R.ref.value('@flags', 'INT'),
	R.ref.value('@arrayNum', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/includeExcludeList/includeExcludeStoragePoolList') R(ref)
-----------------------------------------------END:UPDATE THE STORAGE POOL PROPERTIES OF THE POLICY-----------------------------------------------
-----------------------------------------------UPDATE THE USERS/GROUPS FOR THE POLICY-----------------------------------------------
INSERT INTO @usersTbl
	SELECT
	R.ref.value('@userOrGroupId', 'INT'),
	R.ref.value('@isGroup', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/userOrGroupList') R(ref)
-----------------------------------------------END:UPDATE THE USERS/GROUPS FOR THE POLICY-----------------------------------------------
SET @selectionType = ISNULL ((SELECT TOP 1 selectionType FROM @arrayTable), 0)
IF @selectionType = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Unable to create a new policy type. Invalid Selection Type!'
	GOTO ERR_EXIT
END
--If the quota has decreased check if any user has exceeded the edited quota size. If any user has exceeded the quota size
--fail the edit operation
IF (@newPolicyQuota < @currentPolicyQuota)
BEGIN
	DECLARE @maxQuotaUsed BIGINT
	INSERT INTO @usersToQuotaMap (userId)
	SELECT userOrGroupId FROM @usersTbl WHERE isGroup = 0
	INSERT INTO @usersToQuotaMap (userId)
	SELECT userId
	FROM UMUserGroup WHERE groupId IN (SELECT userOrGroupId FROM @usersTbl WHERE isGroup = 1) AND
						   userId NOT IN (SELECT userId FROM @usersToQuotaMap)
	--Get the total quota used by each user for this particular policy id (@policyId)
	UPDATE @usersToQuotaMap
	SET totalQuotaUsed =
				  ISNULL((SELECT SUM(S_LUN.TotalSpaceBytes)
						  FROM SMLUN S_LUN INNER JOIN SProvLUN SP_LUN ON SP_LUN.LUNId = S_LUN.Id
						  WHERE SP_LUN.PolicyId = @policyId AND SP_LUN.UserId = [@usersToQuotaMap].userId), 0)
	UPDATE @usersToQuotaMap SET isQuotaExceeded = 1
	WHERE totalQuotaUsed > @newPolicyQuota
	SET @maxQuotaUsed = ISNULL((SELECT MAX(totalQuotaUsed) FROM @usersToQuotaMap), 0)
	IF EXISTS (SELECT 1 FROM @usersToQuotaMap WHERE isQuotaExceeded = 1)
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'The policy quota cannot be decreased to a size lesser than ' +
							CONVERT (VARCHAR(32), (CAST(@maxQuotaUsed/CAST(1024*1024*1024 AS DECIMAL(12, 2)) AS DECIMAL(12, 4)))) +
							'GB'
		GOTO ERR_EXIT
	END
END
--Debugging
--SELECT * FROM @policyTbl
--SELECT * FROM @arrayTable
--SELECT * FROM @storagePoolTable
--SELECT * FROM @usersTbl
--RETURN 0
--UPDATE SprovAllocationPolicy
--For exclude list we are not populating the arrayNum. Therefore arrayNum in this case is NULL. For now we are assigning the storage pool id
--of some storage pool in the include list
--DECLARE @dummyPoolNum INT = (SELECT TOP 1 arrayNum FROM @storagePoolTable WHERE arrayNum IS NOT NULL)
UPDATE @storagePoolTable SET arrayNum = @dummyArrayNum WHERE arrayNum IS NULL
UPDATE @storagePoolTable SET storagePoolId = @dummyStoragePoolId WHERE storagePoolId IS NULL
---------------------
UPDATE SprovAllocationPolicy SET policyName = T_POL.policyName,
								 userQuotaInBytes = T_POL.userQuotaInGB * 1024 * 1024 * 1024,
								 expirationPeriod = T_POL.policyExpiration /*dbo.getdatetime(T_POL.policyExpiration)*/,
								 description = T_POL.policyDescription,
								 modifiedTime = GETUTCDATE()
FROM @policyTbl T_POL INNER JOIN SprovAllocationPolicy S_POL ON S_POL.policyId = T_POL.policyId
WHERE S_POL.policyId = @policyId
--Delete old entries for array/pool/user properties for this policy id
DELETE FROM SprovAllocationPolicyFilerProp WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyFilerFilter WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyResourcePool WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyResourcePoolFilter WHERE policyId = @policyId
DELETE FROM SprovPolicyToUserMap WHERE policyId = @policyId
--Make entries into SprovAllocationPolicyFilerProp
INSERT INTO SprovAllocationPolicyFilerProp(policyId, filerId, filerType, selectionType, arrayNum)
SELECT @policyId, arrayName, vendor, selectionType,
(SELECT (CASE WHEN @selectionType <> 1 THEN @dummyArrayNum ELSE arrayNum END))
FROM @arrayTable WHERE flags = 1
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert array details into SprovAllocationPolicyFilerProp table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyFilerFilter
INSERT INTO SprovAllocationPolicyFilerFilter(policyId, filerId, filerType, arrayNum)
SELECT @policyId, arrayName, vendor, @dummyArrayNum FROM @arrayTable WHERE flags = 2
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert array details into SprovAllocationPolicyFilerFilter table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyResourcePool
INSERT INTO SprovAllocationPolicyResourcePool(policyId, aggregateName, arrayNum, aggregateId)
SELECT @policyId, storagePoolName, arrayNum, storagePoolId FROM @storagePoolTable WHERE flags = 1
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert resource pool details into SprovAllocationPolicyResourcePool table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyResourcePoolFilter
INSERT INTO SprovAllocationPolicyResourcePoolFilter(policyId, aggregateName, arrayNum, aggregateId)
SELECT @policyId, storagePoolName, arrayNum, @dummyStoragePoolId FROM @storagePoolTable WHERE flags = 2
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert resource pool details into SprovAllocationPolicyResourcePoolFilter table'
	GOTO ERR_EXIT
END
--Make entries into SprovPolicyToUserMap
INSERT INTO SprovPolicyToUserMap(policyId, isGroup, userOrGroupId)
SELECT @policyId, isGroup, userOrGroupId FROM @usersTbl
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert user details into SprovPolicyToUserMap table'
	GOTO ERR_EXIT
END
SET @errorCode = 0
SET @errorString = 'Successfully inserted policy details'
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 @policyId AS '@policyId',
					 policyDescription AS '@description',
					 userQuotaInGB AS '@userQuotaInGB',
					 policyExpiration AS '@expirationPeriod',
					 policyType AS '@policyTypeId',
					 @createdBy AS 'createdBy/@userId',
					 (SELECT
						  (SELECT filerId AS '@arrayName',
								  1 AS '@flags',
								  filerType AS 'reserve/@reserveString'
								  FROM SprovAllocationPolicyFilerProp S_POLARRAY WHERE S_POLARRAY.policyId = @policyId
								  FOR XML PATH('includeExcludeArrayList'), TYPE),
						  (SELECT filerId AS '@arrayName',
								  2 AS '@flags',
								  filerType AS 'reserve/@reserveString'
								  FROM SprovAllocationPolicyFilerFilter S_POLARRAYFILTER WHERE S_POLARRAYFILTER.policyId = @policyId
								  FOR XML PATH('includeExcludeArrayList'), TYPE),
						  (SELECT aggregateName AS '@storagePoolName',
								  1 AS '@flags',
								  arrayNum AS '@arrayNum'
								  FROM SprovAllocationPolicyResourcePool S_POOL WHERE S_POOL.policyId = @policyId
								  FOR XML PATH('includeExcludeStoragePoolList'), TYPE),
						  (SELECT aggregateName AS '@storagePoolName',
								  2 AS '@flags',
								  arrayNum AS '@arrayNum'
								  FROM SprovAllocationPolicyResourcePoolFilter S_POOLFILTER WHERE S_POOLFILTER.policyId = @policyId
								  FOR XML PATH('includeExcludeStoragePoolList'), TYPE)
					   FOR XML PATH('includeExcludeList'), TYPE),
					   (SELECT userOrGroupId AS '@userOrGroupId',
							   isGroup AS '@isGroup'
							   FROM SprovPolicyToUserMap S_POL2USERMAP WHERE S_POL2USERMAP.policyId = @policyId
						FOR XML PATH('userOrGroupList'), TYPE)
			   FROM @policyTbl FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN
ERR_EXIT:
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString'
			  FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN

IF EXISTS (select * from GxQscripts where name = 'MM_SProvEditAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvEditAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvEditAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvEditAllocationPolicy'
GO

insert into GXDBVersions values(2, 'MM_SProvEditAllocationPolicy',  '00000000000000000000', 'MM_SProvEditAllocationPolicy', '00000000000000000000')
GO

