

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvDeleteAllocationPolicy.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvDeleteAllocationPolicy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvDeleteAllocationPolicy <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvDeleteAllocationPolicy')
	drop procedure MM_SProvDeleteAllocationPolicy
IF EXISTS (select * from GxQscripts where name='MM_SProvDeleteAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvDeleteAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvDeleteAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvDeleteAllocationPolicy'
GO
print '... Creating Procedure: MM_SProvDeleteAllocationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvDeleteAllocationPolicy
  @xmlip XML,
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
--Sample input XML
--'<StorageProvisioning_MMSProvAllocationPolicy policyId="45"/>'
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(1024) = ''
DECLARE @policyId INT = 0
SET @policyId = ISNULL((SELECT R.ref.value('@policyId', 'INT')FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy') R(ref)), 0)
IF ((@policyId = 0) OR (@policyId < 0))
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Invalid policy ID'
	GOTO ERR_EXIT
END
ELSE
BEGIN
	--Check if policy Id exists
	IF NOT EXISTS(SELECT 1 FROM SprovAllocationPolicy WHERE policyId = @policyId)
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Policy ID: ' + CONVERT(NVARCHAR(1024), @policyId) + ' does not exist.'
		GOTO ERR_EXIT
	END
	--Check if LUNs are associated with this policy
	IF EXISTS(SELECT 1 FROM SProvLUN WHERE PolicyId = @policyId)
	BEGIN
		DECLARE @policyName NVARCHAR(1024) = (SELECT policyName FROM SprovAllocationPolicy WHERE policyId = @policyId)
		SET @errorCode = -1
		SET @errorString = 'There are LUNs associated with Policy: ' + @policyName + '. Please delete the LUNs and try again.'
		GOTO ERR_EXIT
	END
	ELSE
	BEGIN
		DELETE FROM SprovAllocationPolicyFilerProp WHERE policyId = @policyId
		DELETE FROM SprovAllocationPolicyFilerFilter WHERE policyId = @policyId
		DELETE FROM SprovAllocationPolicyResourcePool WHERE policyId = @policyId
		DELETE FROM SprovAllocationPolicyResourcePoolFilter WHERE policyId = @policyId
		DELETE FROM SprovPolicyToUserMap WHERE policyId = @policyId
		DELETE FROM SprovAllocationPolicy WHERE policyId = @policyId
	END
END
SET @errorCode = 0
SET @errorString = 'Successfully deleted policy details'
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 @policyId AS '@policyId'
					 FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN
ERR_EXIT:
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 @policyId AS '@policyId'
			  FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvDeleteAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvDeleteAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvDeleteAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvDeleteAllocationPolicy'
GO

insert into GXDBVersions values(2, 'MM_SProvDeleteAllocationPolicy',  '00000000000000000000', 'MM_SProvDeleteAllocationPolicy', '00000000000000000000')
GO

