

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvCreateAllocationPolicy.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: MM_SProvCreateAllocationPolicy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvCreateAllocationPolicy <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvCreateAllocationPolicy')
	drop procedure MM_SProvCreateAllocationPolicy
IF EXISTS (select * from GxQscripts where name='MM_SProvCreateAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvCreateAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvCreateAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvCreateAllocationPolicy'
GO
print '... Creating Procedure: MM_SProvCreateAllocationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvCreateAllocationPolicy
  @xmlip XML,
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
--Sample input XML
--'<StorageProvisioning_MMSProvAllocationPolicy policyName="BasicPolicy" description="Description" policyTypeId="1" userQuotaInGB="20" expirationPeriod="1468511445" >
--	<includeExcludeList>
--		<includeExcludeArrayList arrayName = "%hfiler1%" flags="2" selectionType="3">
--			<reserve reserveString="NetApp"/>
--		</includeExcludeArrayList>
--		<includeExcludeArrayList arrayName = "%hfiler%" flags="1" selectionType="3">
--			<reserve reserveString="NetApp"/>
--		</includeExcludeArrayList>
--		<includeExcludeStoragePoolList storagePoolName = "dev_n_test" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "SystemAggr_DoNotUse" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "dev_n_test_1" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "SystemAggr_DoNotUse" flags="1"/>
--		<includeExcludeStoragePoolList storagePoolName = "%System%" flags="2"/>
--	</includeExcludeList>
--	<userOrGroupList userOrGroupId = "1" isGroup = "1"/>
--	<userOrGroupList userOrGroupId = "2" isGroup = "1"/>
--	<userOrGroupList userOrGroupId = "3" isGroup = "1"/>
--</StorageProvisioning_MMSProvAllocationPolicy>'
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(1024) = ''
DECLARE @selectionType INT = 0
DECLARE @dummyArrayNum INT = 0
DECLARE @dummyStoragePoolId INT = 0
DECLARE @createdBy INT = 0
SET @createdBy = ISNULL((SELECT R.ref.value('@userId', 'INT')
						FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/createdBy') R(ref)),0)
DECLARE @policyTbl TABLE
(
	policyName nvarchar(1024),
	policyDescription nvarchar(2048),
	policyType INT,
	userQuotaInGB BIGINT,
	policyExpiration INT,
	createdBy INT
)
DECLARE @arrayTable TABLE
(
	arrayName nvarchar(1024) default '',
	flags INT,
	vendor nvarchar(1024) default '',
	selectionType INT,
	arrayNum INT
)
DECLARE @storagePoolTable TABLE
(
	storagePoolId INT,
	storagePoolName nvarchar(1024),
	flags INT,
	arrayNum INT
)
DECLARE @usersTbl TABLE
(
	userOrGroupId INT,
	isGroup INT
)
-----------------------------------------------UPDATE THE POLICY PROPERTIES-----------------------------------------------
INSERT INTO @policyTbl
	SELECT
	R.ref.value('@policyName', 'nvarchar(1024)'),
	R.ref.value('@description', 'nvarchar(2048)'),
	R.ref.value('@policyTypeId', 'INT'),
	R.ref.value('@userQuotaInGB', 'BIGINT'),
	R.ref.value('@expirationPeriod', 'INT'),
	@createdBy
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy') R(ref)
-----------------------------------------------END: UPDATE THE POLICY PROPERTIES-----------------------------------------------
-----------------------------------------------UPDATE THE ARRAY PROPERTIES OF THE POLICY-----------------------------------------------
INSERT INTO @arrayTable
	SELECT
	ISNULL(R.ref.value('@arrayName', 'nvarchar(1024)'), ''),
	R.ref.value('@flags', 'INT'),
	ISNULL(R.ref.value('reserve[1]/@reserveString', 'nvarchar(1024)'), ''),
	R.ref.value('@selectionType', 'INT'),
	R.ref.value('@arrayNum', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/includeExcludeList/includeExcludeArrayList') R(ref)
-----------------------------------------------END:UPDATE THE ARRAY PROPERTIES OF THE POLICY-----------------------------------------------
-----------------------------------------------UPDATE THE STORAGE POOL PROPERTIES OF THE POLICY-----------------------------------------------
INSERT INTO @storagePoolTable
	SELECT
	R.ref.value('@storagePoolId', 'INT'),
	R.ref.value('@storagePoolName', 'nvarchar(1024)'),
	R.ref.value('@flags', 'INT'),
	R.ref.value('@arrayNum', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/includeExcludeList/includeExcludeStoragePoolList') R(ref)
-----------------------------------------------END:UPDATE THE STORAGE POOL PROPERTIES OF THE POLICY-----------------------------------------------
-----------------------------------------------UPDATE THE USERS/GROUPS FOR THE POLICY-----------------------------------------------
INSERT INTO @usersTbl
	SELECT
	R.ref.value('@userOrGroupId', 'INT'),
	R.ref.value('@isGroup', 'INT')
	FROM @xmlip.nodes('/StorageProvisioning_MMSProvAllocationPolicy/userOrGroupList') R(ref)
-----------------------------------------------END:UPDATE THE USERS/GROUPS FOR THE POLICY-----------------------------------------------
SET @selectionType = ISNULL ((SELECT TOP 1 selectionType FROM @arrayTable), 0)
IF @selectionType = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Unable to create a new policy. Invalid Selection Type!'
	GOTO ERR_EXIT
END
--Debugging
--SELECT * FROM @policyTbl
--SELECT * FROM @arrayTable
--SELECT * FROM @storagePoolTable
--SELECT * FROM @usersTbl
--RETURN 0
--MAKE ENTRIES INTO SprovAllocationPolicy, SprovAllocationPolicyFilerProp, SprovAllocationPolicyFilerFilter, SprovAllocationPolicyResourcePool, SprovAllocationPolicyResourcePoolFilter
--Make entries into SProvAllocationPolicy
--For exclude list we are not populating the arrayNum. Therefore arrayNum in this case is NULL. We are assigning the array num
--of 'DUMMY ARRAY' array in SMArray
--DECLARE @dummyPoolNum INT = (SELECT TOP 1 arrayNum FROM @storagePoolTable WHERE arrayNum IS NOT NULL)
UPDATE @storagePoolTable SET arrayNum = @dummyArrayNum WHERE arrayNum IS NULL
UPDATE @storagePoolTable SET storagePoolId = @dummyStoragePoolId WHERE storagePoolId IS NULL
---------------------
BEGIN TRY
INSERT INTO SprovAllocationPolicy (policyName, description, policyTypeId, userQuotaInBytes, expirationPeriod, createdby)
SELECT policyName, policyDescription, policyType, userQuotaInGB*1024*1024*1024, policyExpiration /*dbo.getdatetime(policyExpiration)*/, createdBy FROM @policyTbl
END TRY
BEGIN CATCH
	SET @errorCode = -1
	SET @errorString = 'Unable to create a new policy. Error Code [' + CONVERT(VARCHAR(256), (SELECT ERROR_NUMBER())) + ']'
	IF EXISTS (SELECT 1 FROM SprovAllocationPolicy WHERE policyName = (SELECT TOP 1 policyName FROM @policyTbl))
	BEGIN
		SET @errorString = 'Please choose a different policy name. Policy name exists. Error Code [' + CONVERT(VARCHAR(256), (SELECT ERROR_NUMBER())) + '].'
	END
	GOTO ERR_EXIT
END CATCH
DECLARE @policyId INT = 0
SET @policyId = (SELECT IDENT_CURRENT('SprovAllocationPolicy'))
IF @policyId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Unable to insert policy details into SprovAllocationPolicy table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyFilerProp
INSERT INTO SprovAllocationPolicyFilerProp(policyId, filerId, filerType, selectionType, arrayNum)
SELECT @policyId, arrayName, vendor, selectionType,
	   (SELECT (CASE WHEN @selectionType <> 1 THEN @dummyArrayNum ELSE arrayNum END))
	   FROM @arrayTable WHERE flags = 1
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert array details into SprovAllocationPolicyFilerProp table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyFilerFilter
INSERT INTO SprovAllocationPolicyFilerFilter(policyId, filerId, filerType, arrayNum)
SELECT @policyId, arrayName, vendor, @dummyArrayNum
	   FROM @arrayTable WHERE flags = 2
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert array details into SprovAllocationPolicyFilerFilter table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyResourcePool
INSERT INTO SprovAllocationPolicyResourcePool(policyId, aggregateName, arrayNum, aggregateId)
SELECT @policyId, storagePoolName, arrayNum, storagePoolId FROM @storagePoolTable WHERE flags = 1
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert resource pool details into SprovAllocationPolicyResourcePool table'
	GOTO ERR_EXIT
END
--Make entries into SprovAllocationPolicyResourcePoolFilter
INSERT INTO SprovAllocationPolicyResourcePoolFilter(policyId, aggregateName, arrayNum, aggregateId)
SELECT @policyId, storagePoolName, arrayNum, @dummyStoragePoolId FROM @storagePoolTable WHERE flags = 2
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert resource pool details into SprovAllocationPolicyResourcePoolFilter table'
	GOTO ERR_EXIT
END
--Make entries into SprovPolicyToUserMap
INSERT INTO SprovPolicyToUserMap(policyId, isGroup, userOrGroupId)
SELECT @policyId, isGroup, userOrGroupId FROM @usersTbl
IF @@ERROR <> 0
BEGIN
	SET @errorCode = @@ERROR
	SET @errorString = 'Unable to insert user details into SprovPolicyToUserMap table'
	GOTO ERR_EXIT
END
SET @errorCode = 0
SET @errorString = 'Successfully inserted policy details'
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString',
					 @policyId AS '@policyId',
					 policyDescription AS '@description',
					 userQuotaInGB AS '@userQuotaInGB',
					 policyExpiration AS '@expirationPeriod',
					 policyType AS '@policyTypeId',
					 @createdBy AS 'createdBy/@userId',
					 (SELECT
						  (SELECT filerId AS '@arrayName',
								  1 AS '@flags',
								  filerType AS 'reserve/@reserveString'
								  FROM SprovAllocationPolicyFilerProp S_POLARRAY WHERE S_POLARRAY.policyId = @policyId
								  FOR XML PATH('includeExcludeArrayList'), TYPE),
						  (SELECT filerId AS '@arrayName',
								  2 AS '@flags',
								  filerType AS 'reserve/@reserveString'
								  FROM SprovAllocationPolicyFilerFilter S_POLARRAYFILTER WHERE S_POLARRAYFILTER.policyId = @policyId
								  FOR XML PATH('includeExcludeArrayList'), TYPE),
						  (SELECT aggregateName AS '@storagePoolName',
								  1 AS '@flags',
								  arrayNum AS '@arrayNum'
								  FROM SprovAllocationPolicyResourcePool S_POOL WHERE S_POOL.policyId = @policyId
								  FOR XML PATH('includeExcludeStoragePoolList'), TYPE),
						  (SELECT aggregateName AS '@storagePoolName',
								  2 AS '@flags',
								  arrayNum AS '@arrayNum'
								  FROM SprovAllocationPolicyResourcePoolFilter S_POOLFILTER WHERE S_POOLFILTER.policyId = @policyId
								  FOR XML PATH('includeExcludeStoragePoolList'), TYPE)
					   FOR XML PATH('includeExcludeList'), TYPE),
					   (SELECT userOrGroupId AS '@userOrGroupId',
							   isGroup AS '@isGroup'
							   FROM SprovPolicyToUserMap S_POL2USERMAP WHERE S_POL2USERMAP.policyId = @policyId
						FOR XML PATH('userOrGroupList'), TYPE)
			   FROM @policyTbl FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN
ERR_EXIT:
--Cleanup
DELETE FROM SprovAllocationPolicyFilerProp WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyFilerFilter WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyResourcePool WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicyResourcePoolFilter WHERE policyId = @policyId
DELETE FROM SprovPolicyToUserMap WHERE policyId = @policyId
DELETE FROM SprovAllocationPolicy WHERE policyId = @policyId
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorString AS '@errorString'
			   FROM @policyTbl FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicy'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SProvCreateAllocationPolicy')
	delete from GxQscripts where name = 'MM_SProvCreateAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvCreateAllocationPolicy')
	delete from GXDBVersions where aliasname = 'MM_SProvCreateAllocationPolicy'
GO

insert into GXDBVersions values(2, 'MM_SProvCreateAllocationPolicy',  '00000000000000000000', 'MM_SProvCreateAllocationPolicy', '00000000000000000000')
GO

