

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SProvAddPolicyType.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: MM_SProvAddPolicyType()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SProvAddPolicyType <<<'

IF EXISTS (select * from sysobjects where name='MM_SProvAddPolicyType')
	drop procedure MM_SProvAddPolicyType
IF EXISTS (select * from GxQscripts where name='MM_SProvAddPolicyType')
	delete from GxQscripts where name = 'MM_SProvAddPolicyType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvAddPolicyType')
	delete from GXDBVersions where aliasname = 'MM_SProvAddPolicyType'
GO
print '... Creating Procedure: MM_SProvAddPolicyType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SProvAddPolicyType
  @ipxml xml,
  @opxml xml OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode INT = 0
DECLARE @errorString VARCHAR(1024) = ''
DECLARE @policyTypeName VARCHAR(1024) = ''
DECLARE @policyTypeDescription VARCHAR(1024) = ''
DECLARE @createdBy INT = 0
DECLARE @policyTypeId INT = 0
SET @policyTypeName = ISNULL((SELECT A.ref.value('@policyTypeName', 'VARCHAR(1024)')
					          FROM @ipxml.nodes('/StorageProvisioning_MMSProvAllocationPolicyType') A(ref)), '');
SET @policyTypeDescription = ISNULL((SELECT A.ref.value('@description', 'VARCHAR(1024)')
						             FROM @ipxml.nodes('/StorageProvisioning_MMSProvAllocationPolicyType') A(ref)), '');
SET @createdBy = ISNULL((SELECT A.ref.value('@userId', 'INT')
						 FROM @ipxml.nodes('/StorageProvisioning_MMSProvAllocationPolicyType/createdBy') A(ref)), 0);
IF @policyTypeName = '' OR @createdBy = 0
BEGIN
SET @errorCode = -1
SET @errorString = 'Invalid Input!'
GOTO ERR_EXIT
END
BEGIN TRY
INSERT INTO SprovAllocationPolicyType (policyTypeName, description, createdBy, createdTime, modifiedTime) VALUES
									  (@policyTypeName, @policyTypeDescription, @createdBy, GETUTCDATE(), GETUTCDATE())
END TRY
BEGIN CATCH
	SET @errorCode = (SELECT ERROR_NUMBER())
	SET @errorString = 'Unable to create a new policy type'
	GOTO ERR_EXIT
END CATCH
SET @policyTypeId = (SELECT IDENT_CURRENT('SprovAllocationPolicyType'))
IF @policyTypeId = 0
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Unable to insert policy type details into SprovAllocationPolicyType table'
	GOTO ERR_EXIT
END
SET @errorCode = 0
SET @errorString = 'Successfully inserted policy type details into SprovAllocationPolicyType table'
SET @opxml =
(SELECT @errorCode AS '@errorCode',
		@errorString AS '@errorString',
		policyTypeId AS '@policyTypeId',
		policyTypeName AS '@policyTypeName',
		description AS '@description',
		createdBy AS 'createdBy/@userId'
 FROM SprovAllocationPolicyType WHERE policyTypeId = @policyTypeId
 FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicyType'))
RETURN
ERR_EXIT:
SET @opxml =
(SELECT @errorCode AS '@errorCode',
		@errorString AS '@errorString'
FOR XML PATH('StorageProvisioning_MMSProvAllocationPolicyType'))
RETURN

IF EXISTS (select * from GxQscripts where name = 'MM_SProvAddPolicyType')
	delete from GxQscripts where name = 'MM_SProvAddPolicyType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SProvAddPolicyType')
	delete from GXDBVersions where aliasname = 'MM_SProvAddPolicyType'
GO

insert into GXDBVersions values(2, 'MM_SProvAddPolicyType',  '00000000000000000000', 'MM_SProvAddPolicyType', '00000000000000000000')
GO

