

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLSetArrayDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLSetArrayDetails.sp,v $ $Id: MM_SMXMLSetArrayDetails.sp,v 1.33.2.23.4.1 2021/01/15 11:01:05 mmani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMXMLSetArrayDetails')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLSetArrayDetails <<<'
	drop procedure MM_SMXMLSetArrayDetails
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLSetArrayDetails')
	delete from GxQscripts where name = 'MM_SMXMLSetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLSetArrayDetails')
	delete from GXDBVersions where aliasname = 'MM_SMXMLSetArrayDetails'
GO
print '... Creating Procedure: MM_SMXMLSetArrayDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMXMLSetArrayDetails
  @i_xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- MMSMSetArrayDetailsReq
DECLARE @copyId					INTEGER = 0
DECLARE @appId					INTEGER = 0
DECLARE @assocType				INTEGER = 0
DECLARE @add					INTEGER = 0
	-- MMSMSetArrayDetailsReq.MMSMArrayInfo
	DECLARE @vendorId				INTEGER = 0
	DECLARE @vendorName				NVARCHAR(128) = N''
	DECLARE @arrayId				INTEGER = 0
	DECLARE @clientId				INTEGER = 0
	DECLARE @arrayName				NVARCHAR(1024) = N''
	DECLARE @ctrlHostName			NVARCHAR(1024) = N''
	DECLARE @userName				NVARCHAR(1024) = N''
	DECLARE @userPswd				NVARCHAR(2048) = N''
	DECLARE @passwordEdit			INTEGER = 0
	DECLARE @isEnabled				INTEGER = 0
	DECLARE @offlineCode			INTEGER = 0
	DECLARE @offlineReason			NVARCHAR(1024) = N''
	DECLARE @arrayType				INTEGER = 0
	DECLARE @description			NVARCHAR(1024) = N''
	DECLARE @arrayInfoType			INTEGER = 0
	DECLARE @aiFlags				INTEGER = 0
	-- MMSMSetArrayDetailsReq.MMSMArrayDG
	DECLARE @arrayDGName			NVARCHAR(1024) = N''
	DECLARE @useDevicesFromThisDG	INTEGER = 0
	DECLARE @disableDG				INTEGER = 0
	DECLARE @adgOverridden			INTEGER = 0
	DECLARE @adgFlags				INTEGER = 0
	-- MMSMSetArrayDetailsReq.MMSMHostDG
	DECLARE @deviceGroupOption		INTEGER = 0
	DECLARE @hostDGName				NVARCHAR(1024) = N''
	DECLARE @useOnlySpouseDevices	INTEGER = 0
	DECLARE @doNotMoveDevices		INTEGER = 0
	DECLARE @hdgOverridden			INTEGER = 0
	DECLARE @hdgFlags				INTEGER = 0
	DECLARE @clientLevelId			INTEGER = 0
DECLARE @flags				INTEGER = 0
DECLARE @uniqueIdentifier			NVARCHAR(1024) = N''
DECLARE @l_credentialId				INTEGER = -1
DECLARE @l_curCredentialId			INTEGER = -1
DECLARE @l_credentialAssocId		INTEGER = -1
DECLARE @l_curCredentialAssocId		INTEGER = -1
DECLARE @regionId					NVARCHAR(MAX)  = N''
DECLARE @xmlResp			XML
DECLARE	@tblArrayConfigs TABLE (
							configId				INTEGER,
							configName				NVARCHAR(256),
							masterConfigId			INTEGER,
							configType				INTEGER,
							assocType				INTEGER,
							value					NVARCHAR(MAX),
							isEnabled				INTEGER,
							isOverridden			INTEGER,
							flags					INTEGER,
							isUpdated				INTEGER)
DECLARE	@tblArrayConfigsList TABLE (
							configId				INTEGER,
							configName				NVARCHAR(256),
							masterConfigId			INTEGER,
							configType				INTEGER,
							assocType				INTEGER,
							elementOrder			INTEGER,
							value					NVARCHAR(MAX),
							isEnabled				INTEGER,
							isOverridden			INTEGER,
							flags					INTEGER,
							isUpdated				INTEGER,
							refType					INTEGER,
							refId					INTEGER,
							existingConfigId		INTEGER,
							existingArrayId			INTEGER,
							existingHostAlias		INTEGER
							  )
DECLARE	@tblArrayAliases TABLE (
							protocol				INTEGER,
							alias					NVARCHAR(256))
DECLARE @tblArrAliasEndPointMap TABLE (
					SMConfigListId	INT,
					SMHostAliasId	INT,
					SMEndPointId	INT,
					SMEndPtAddrType INT,
					toBeDeleted		INT
				)
-- Constants for Array Type
DECLARE @MMSM_ART_ARRAY			INTEGER = 0
DECLARE @MMSM_ART_DFM			INTEGER = 1
DECLARE @MMSM_ART_PRIMARY		INTEGER = 2
-- Constants for Vendor name
DECLARE @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME NVARCHAR(64) = 'NetApp'
DECLARE	@SM_SNAPSHOT_ENGINE_DELL_ISILON_VENDORNAME NVARCHAR(16) = 'Dell EMC Isilon'
DECLARE	@SM_SNAPSHOT_ENGINE_NETAPP_FALSHRAY_VENDORNAME NVARCHAR(64) = 'NetApp FlashRay'
-- Constants for Array Info Type
DECLARE @MMSM_AIT_AVAILABLE INTEGER = 0
DECLARE @MMSM_AIT_ASSOCIATED INTEGER = 1
-- Constants for Config Value Type
DECLARE @MMSM_CT_NONE			INTEGER = 0
DECLARE @MMSM_CT_BOOL			INTEGER = 1
DECLARE @MMSM_CT_INT			INTEGER = 2
DECLARE @MMSM_CT_UINT			INTEGER = 3
DECLARE @MMSM_CT_LONG			INTEGER = 4
DECLARE @MMSM_CT_ULONG			INTEGER = 5
DECLARE @MMSM_CT_LONGLONG		INTEGER = 6
DECLARE @MMSM_CT_ULONGLONG		INTEGER = 7
DECLARE @MMSM_CT_STRING			INTEGER = 8
DECLARE @MMSM_CT_IP_ADDR		INTEGER = 9
DECLARE @MMSM_CT_LIST			INTEGER = 10
DECLARE @MMSM_CT_COMBO			INTEGER = 11
DECLARE @MMSM_CT_PSWD			INTEGER = 12
DECLARE @MMSM_CT_ENC_STRING		INTEGER = 13
-- Constants for Assoc Type
DECLARE @MMSM_AT_NONE			INTEGER = 0
DECLARE @MMSM_AT_TEMPL			INTEGER = 1
DECLARE @MMSM_AT_VENDOR			INTEGER = 2
DECLARE @MMSM_AT_ARRAY			INTEGER = 3
DECLARE @MMSM_AT_CTRL_HOST		INTEGER = 4
DECLARE @MMSM_AT_SUBCLT_POLICY	INTEGER = 5
DECLARE @MMSM_AT_COPY			INTEGER = 6
DECLARE @MMSM_AT_CLIENT_GROUP	INTEGER = 7
DECLARE @MMSM_AT_CLIENT			INTEGER = 8
DECLARE @MMSM_AT_SUBCLIENT		INTEGER = 9
-- Constants for Array Configs
DECLARE	@SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES_KEY NVARCHAR(64) = 'SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES'
DECLARE	@SMCONFIG_NAME_ARRAY_HOST_ALIASES_KEY NVARCHAR(64) = 'SMCONFIG_NAME_ARRAY_HOST_ALIASES'
DECLARE @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID					INTEGER = 164 /*SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID*/
-- Delimiter for the list value
DECLARE @defaultVaultDelimeter VARCHAR(10) = '#:SMCFG:#'
	-- HDS-GAD
	DECLARE	@IsHDS_VSM INTEGER = 0
-- Get the input parameters from the XML input str
SET @copyId = ISNULL ( ( SELECT R.ref.value('@copyId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @appId = ISNULL ( ( SELECT R.ref.value('@appId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @assocType = ISNULL ( ( SELECT R.ref.value('@assocType', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), @MMSM_AT_ARRAY )
SET @add = ISNULL ( ( SELECT R.ref.value('@add', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 1 )
SET @clientLevelId =  ISNULL ( ( SELECT R.ref.value('@clientId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @vendorId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/vendor' ) R ( ref ) ), 0 )
SET @vendorName = ISNULL ( ( SELECT R.ref.value('@name', 'NVARCHAR(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/vendor' ) R ( ref ) ), N'' )
SET @arrayId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/arrayName' ) R ( ref ) ), 0 )
SET @clientId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/client' ) R ( ref ) ), 0 )
SET @arrayName = ISNULL ( ( SELECT R.ref.value('@name', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/arrayName' ) R ( ref ) ), N'' )
SET @ctrlHostName = ISNULL ( ( SELECT R.ref.value('@ctrlHostName', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
SET @userName = ISNULL ( ( SELECT R.ref.value('@userName', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/userPswd' ) R ( ref ) ), N'' )
SET @userPswd = ISNULL ( ( SELECT R.ref.value('@password', 'NVARCHAR(2048)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/userPswd' ) R ( ref ) ), N'' )
SET @passwordEdit = ISNULL ( ( SELECT R.ref.value('@passwordEdit', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), 0 )
SET @isEnabled = ISNULL ( ( SELECT R.ref.value('@isEnabled', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), 1 )
SET @offlineReason = ISNULL ( ( SELECT R.ref.value('@offlineReason', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
SET @arrayType = ISNULL ( ( SELECT R.ref.value('@arrayType', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), @MMSM_ART_ARRAY )
SET @description = ISNULL ( ( SELECT R.ref.value('@description', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
SET @arrayInfoType = ISNULL ( ( SELECT R.ref.value('@arrayInfoType', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), @MMSM_AIT_AVAILABLE )
SET @aiFlags = ISNULL ( ( SELECT R.ref.value('@flags', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), 0 )
SET @arrayDGName = ISNULL ( ( SELECT R.ref.value('@arrayDGName', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/arrayDG' ) R ( ref ) ), N'' )
SET @useDevicesFromThisDG = ISNULL ( ( SELECT R.ref.value('@useDevicesFromThisDG', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/arrayDG' ) R ( ref ) ), 0 )
SET @disableDG = ISNULL ( ( SELECT R.ref.value('@disableDG', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/arrayDG' ) R ( ref ) ), 0 )
SET @adgOverridden = ISNULL ( ( SELECT R.ref.value('@isOverridden', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/arrayDG' ) R ( ref ) ), 0 )
SET @adgFlags = ISNULL ( ( SELECT R.ref.value('@flags', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/arrayDG' ) R ( ref ) ), 0 )
SET @deviceGroupOption = ISNULL ( ( SELECT R.ref.value('@deviceGroupOption', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), N'' )
SET @hostDGName = ISNULL ( ( SELECT R.ref.value('@hostDGName', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), N'' )
SET @useOnlySpouseDevices = ISNULL ( ( SELECT R.ref.value('@useOnlySpouseDevices', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), 0 )
SET @doNotMoveDevices = ISNULL ( ( SELECT R.ref.value('@doNotMoveDevices', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), 1 )
SET @hdgOverridden = ISNULL ( ( SELECT R.ref.value('@isOverridden', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), 0 )
SET @hdgFlags = ISNULL ( ( SELECT R.ref.value('@flags', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/hostDG' ) R ( ref ) ), 0 )
SET @uniqueIdentifier = ISNULL ( ( SELECT R.ref.value('@uniqueIdentifier', 'NVARCHAR(2048)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
SET @l_credentialId = ISNULL( ( SELECT R.ref.value('@credentialId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/savedCredential' ) R ( ref ) ), -1)
SET @regionId = ISNULL (( SELECT R.ref.value('@regionId', 'NVARCHAR(MAX)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/region' ) R ( ref ) ), N'' )
IF @copyId > 0
BEGIN
		SELECT	@copyId = defaultSnapCopy FROM archGroup (NOLOCK) WHERE id = @copyId
END
DECLARE @currTime INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @arrayDGOptions INTEGER = 0
DECLARE @tblArrayDG TABLE (name NVARCHAR(1024), masterConfigId INTEGER)
DECLARE @tblHostDG TABLE (name NVARCHAR(1024), masterConfigId INTEGER)
DECLARE @ErrMsg NVARCHAR(1024) = N''
DECLARE @arrCfgListEmpty NVARCHAR(1024) = N'##CV_SM_EMPTY_LIST##'
DECLARE @HostAliasMasterCfgId INTEGER = 0
DECLARE @HostAliasAutoUpdateMasterCfgId INTEGER = 0
DECLARE @errorCode INTEGER = 0
DECLARE @currArrayName NVARCHAR(1024) = N''
DECLARE @duplicateAliasName NVARCHAR(1024) = N''
DECLARE	@userId INT
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMSetArrayDetailsReq/processinginstructioninfo/user') R ( ref )), 0)
DECLARE @isMultiTenantSite INT = 0
SET @isMultiTenantSite = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_SNAP_MULTI_TENANT_SITE'), 0)
BEGIN TRY
    -- Get user group of array
	declare @tblUserGroup table (groupId int)
	insert into @tblUserGroup
	select R.ref.value('@userGroupId', 'INTEGER')
	from	@i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/arraySecurity/associatedUserGroups' ) R ( ref )
    -- Delete current user group for array and reset to new ones
		delete @tblUserGroup from @tblUserGroup a, UMGroups (NOLOCK) b where a.groupId = b.id AND (a.groupId = dbo.GetMasterGroupID() OR  b.name = 'View All')
delete from UMGroupAssociation where type1 = 9615 /*ARRAY_ITEM*/ and id1 = @arrayId
insert into UMGroupAssociation select groupId, 9615 /*ARRAY_ITEM*/, @arrayId, 0, 0, 0, 0, 0, 0, 0
	from @tblUserGroup
	SET @disableDG = 0
	INSERT	INTO @tblArrayConfigs
	SELECT	ISNULL ( ( R2.ref2.value('@id', 'INTEGER') ), 0 ),
			ISNULL ( ( R2.ref2.value('@name', 'NVARCHAR(256)') ), N'' ),
			ISNULL ( ( R.ref.value('@masterConfigId', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@type', 'INTEGER') ), 0 ),
			@assocType,
			ISNULL ( ( R.ref.value('@value', 'NVARCHAR(MAX)') ), N'' ),
			ISNULL ( ( R.ref.value('@isEnabled', 'INTEGER') ), 1 ),
			ISNULL ( ( R.ref.value('@isOverridden', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@flags', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@isUpdated', 'INTEGER') ), 0 )
	FROM	@i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/configs/configList' ) R ( ref ) CROSS APPLY ref.nodes('./name') R2 (ref2)
	WHERE	ISNULL ( ( R.ref.value('@type', 'INTEGER') ), 0 ) <> @MMSM_CT_LIST/*MMSM_CT_LIST*/
	INSERT	INTO @tblArrayConfigsList
	SELECT	ISNULL ( ( R2.ref2.value('@id', 'INTEGER') ), 0 ),
			ISNULL ( ( R1.ref1.value('@name', 'NVARCHAR(256)') ), N'' ),
			ISNULL ( ( R.ref.value('@masterConfigId', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@type', 'INTEGER') ), 0 ),
			@assocType,
			(ROW_NUMBER() OVER (PARTITION BY ISNULL ( ( R.ref.value('@masterConfigId', 'INTEGER') ), 0 ) order by ISNULL ( ( R.ref.value('@masterConfigId', 'INTEGER') ), 0 )))*10,
			ISNULL ( ( R2.ref2.value('@name', 'NVARCHAR(256)') ), @arrCfgListEmpty ),
			ISNULL ( ( R.ref.value('@isEnabled', 'INTEGER') ), 1 ),
			ISNULL ( ( R.ref.value('@isOverridden', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@flags', 'INTEGER') ), 0 ),
			ISNULL ( ( R.ref.value('@isUpdated', 'INTEGER') ), 0 ),
			0, 0, 0, 0, 0
	FROM	@i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/configs/configList' ) R ( ref )
			CROSS APPLY ref.nodes('./name') R1 (ref1)
			OUTER APPLY ref.nodes('./values') R2 (ref2)
	WHERE	ISNULL ( ( R.ref.value('@type', 'INTEGER') ), 0 ) = @MMSM_CT_LIST/*@MMSM_CT_LIST*/
	IF @add = 1
	BEGIN
		INSERT INTO		@tblArrayConfigs
		SELECT			0, MCONFIG.Name, MCONFIG.Id, MCONFIG.Type, @assocType,
						( CASE
							WHEN MCONFIG.Type = @MMSM_CT_BOOL THEN
								( CASE WHEN MCONFIG.DefaultInt = 0 THEN N'false' ELSE N'true' END )
							WHEN MCONFIG.Type = @MMSM_CT_INT THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultInt )
							WHEN MCONFIG.Type = @MMSM_CT_UINT THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultInt )
							WHEN MCONFIG.Type = @MMSM_CT_LONG THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultLL )
							WHEN MCONFIG.Type = @MMSM_CT_ULONG THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultLL )
							WHEN MCONFIG.Type = @MMSM_CT_LONGLONG THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultLL )
							WHEN MCONFIG.Type = @MMSM_CT_ULONGLONG THEN CONVERT ( NVARCHAR(1024), MCONFIG.DefaultLL )
							WHEN MCONFIG.Type = @MMSM_CT_STRING THEN MCONFIG.DefaultStr
							WHEN MCONFIG.Type = @MMSM_CT_IP_ADDR THEN MCONFIG.DefaultStr
							WHEN MCONFIG.Type = @MMSM_CT_PSWD THEN MCONFIG.DefaultStr
						END ),
						VENDOR.IsEnabled, 0, 0, 0
		FROM			SMMasterConfigs MCONFIG (NOLOCK) JOIN SMVendor VENDOR (NOLOCK) ON MCONFIG.VendorId = VENDOR.Id AND VENDOR.Name = @vendorName
		WHERE			MCONFIG.Id NOT IN (SELECT masterConfigId FROM @tblArrayConfigs)
						AND MCONFIG.Type <> @MMSM_CT_LIST
		INSERT INTO		@tblArrayConfigsList
		SELECT			0, MCONFIG.Name, MCONFIG.Id, MCONFIG.Type, @assocType,
						ISNULL(VAL.Id *10,0) , ISNULL(VAL.Data, @arrCfgListEmpty),
						VENDOR.IsEnabled, 0, 0, 0, 0, 0, 0, 0, 0
		FROM			SMMasterConfigs MCONFIG (NOLOCK) JOIN SMVendor VENDOR (NOLOCK) ON MCONFIG.VendorId = VENDOR.Id AND VENDOR.Name = @vendorName
		OUTER APPLY		dbo.SplitStringMaxLen( MCONFIG.DefaultStr,'#:SMCFG:#') VAL
		WHERE			MCONFIG.Id NOT IN (SELECT masterConfigId FROM @tblArrayConfigsList)
						AND MCONFIG.Type = @MMSM_CT_LIST
	END
	INSERT INTO @tblArrayAliases
	SELECT R.ref.value('@interfaceType', 'INTEGER') AS Id,
	R.ref.value('@arrayInterface', 'NVARCHAR(1024)') AS Alias
	FROM @i_xmlTextInput.nodes('/EVGui_MMSMSetArrayDetailsReq/info/aliasList') R(ref)
	-- HDS-GAD
	IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE masterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID AND LEN(value) > 0)
		OR (@add = 0 AND EXISTS (SELECT 1 FROM SMConfigs (NOLOCK) WHERE ArrayId = @arrayId AND MasterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID AND LEN(ValueStr) > 0))
		SET @IsHDS_VSM = 1
	--Do not allow arrays with duplicate names to be added across vendors
	--If Mulitsite is on, then allow duplicate arrays to be added  only with NetApp and not across vendors
	IF @add = 1 AND @IsHDS_VSM = 0 AND EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ((LEN(@arrayName) > 0 AND SMArrayId = @arrayName) OR (LEN(@arrayName) = 0 AND SMHostName = @ctrlHostName))
		AND (SnapVendorName <> @vendorName OR (SnapVendorName = @vendorName AND @isMultiTenantSite = 0)
		OR  (SnapVendorName = @vendorName AND
			((SnapVendorName = @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME AND @isMultiTenantSite = 1 AND  ((LEN(@uniqueIdentifier) >0 AND UniqueIdentifier = @uniqueIdentifier) OR LEN(@uniqueIdentifier) = 0 )) OR
			 (SnapVendorName <> @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME)))))
	BEGIN
		SELECT	1 AS '@errorCode', 'Array already exists' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
	ELSE IF @add = 0 AND @arrayId <= 0
	BEGIN
		SELECT	2 AS '@errorCode', 'No Array Db id given for modification' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
		ELSE IF @add = 0 AND NOT EXISTS (SELECT * FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayId)
	BEGIN
		SELECT	3 AS '@errorCode', 'Array not found for modification' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
	IF @IsHDS_VSM = 1
	BEGIN
		IF @add = 0 AND @assocType = @MMSM_AT_ARRAY
		BEGIN
			DECLARE @newCfgValue NVARCHAR(MAX) = ISNULL((SELECT value FROM @tblArrayConfigs WHERE masterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID AND assocType = @MMSM_AT_ARRAY),'')
			DECLARE @existingCfgValue NVARCHAR(MAX) = ISNULL((SELECT ValueStr FROM SMConfigs (NOLOCK) WHERE ArrayId = @arrayId AND MasterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID AND assocType = @MMSM_AT_ARRAY), '')
			-- Do not allow editing of the array config physical array id
			-- If the value is not set, we allow to set the physical array serial id.
			IF (@existingCfgValue <> '') AND ( @newCfgValue <> @existingCfgValue)
			BEGIN
				SELECT	10 AS '@errorCode', 'Editing the physical array serial id is not allowed.' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
			DECLARE @VSMarray NVARCHAR(MAX) = ISNULL((SELECT TOP 1 CTRL.SMArrayId FROM SMControlHost CTRL (NOLOCK) INNER JOIN SMConfigs CFG (NOLOCK) ON CTRL.ControlHostId = CFG.ArrayId AND CFG.MasterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID
												WHERE CFG.ValueStr = @arrayName), '')
			-- If we are setting this config, then we need to check if there is any other VSM using this array as the base array
			IF @existingCfgValue = '' AND @VSMarray <> ''
			BEGIN
				SELECT	10 AS '@errorCode', 'Editing the physical array serial id is not allowed as this array is added as a base array for array[' + @VSMarray +']'AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
		-- If editing the array, exclude the current array from the validation
		IF EXISTS (SELECT	ARRAY.ControlHostId
				FROM	SMControlHost ARRAY (NOLOCK)
						INNER JOIN SMConfigs CFG (NOLOCK) ON ARRAY.ControlHostId = CFG.ArrayId AND CFG.MasterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID
						INNER JOIN @tblArrayConfigs TCFG ON TCFG.MasterConfigId = @SMCONFIG_HDS_PHYSICAL_ARRAY_SERIAL_ID
				WHERE	ARRAY.SMArrayId = @arrayName AND CFG.ValueStr = TCFG.value
						AND CFG.assocType = @MMSM_AT_ARRAY
						AND (( @add = 0 AND @arrayId <> ARRAY.ControlHostId) OR (@add = 1)))
		BEGIN
			SELECT	10 AS '@errorCode', 'Already an array exists with same v_serial id and physical serial id.' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
	END
	IF EXISTS (SELECT * FROM SMSnapShotEngine (NOLOCK) WHERE Capabilities & 64 > 0 AND SnapVendorName = @vendorName)
	INSERT	INTO @tblArrayDG
	SELECT	MC.Name, MC.Id
		FROM	SMMasterConfigs MC (NOLOCK) INNER JOIN SMVendor VEN (NOLOCK) ON MC.VendorId = VEN.Id
	WHERE	VEN.name = @vendorName
			AND MC.ShowInGUI = 2
	IF EXISTS (SELECT * FROM SMSnapShotEngine (NOLOCK) WHERE Capabilities & 512 > 0 AND SnapVendorName = @vendorName)
	INSERT	INTO @tblHostDG
	SELECT	MC.Name, MC.Id
		FROM	SMMasterConfigs MC (NOLOCK) INNER JOIN SMVendor VEN (NOLOCK) ON MC.VendorId = VEN.Id
	WHERE	VEN.name = @vendorName
			AND MC.ShowInGUI = 3
	SELECT @HostAliasAutoUpdateMasterCfgId = MCONFIG.Id FROM SMMasterConfigs MCONFIG (NOLOCK) INNER JOIN SMVendor VENDOR (NOLOCK) ON MCONFIG.VendorId = VENDOR.Id
	WHERE MCONFIG.KeyName = @SMCONFIG_NAME_AUTO_UPDATE_ARRAY_HOST_ALIASES_KEY AND VENDOR.Name = @vendorName
	SELECT @HostAliasMasterCfgId  = MCONFIG.Id FROM SMMasterConfigs MCONFIG (NOLOCK) INNER JOIN SMVendor VENDOR (NOLOCK) ON MCONFIG.VendorId = VENDOR.Id
	WHERE MCONFIG.KeyName = @SMCONFIG_NAME_ARRAY_HOST_ALIASES_KEY AND VENDOR.Name = @vendorName
	-- Add
	IF @add = 1
	BEGIN
		IF @useDevicesFromThisDG = 1
			SET @arrayDGOptions = @arrayDGOptions | 1	-- useDevicesFromThisDG = true
		IF @disableDG = 1
			SET @arrayDGOptions = @arrayDGOptions | 2	-- disableDG = true
		INSERT	INTO SMControlHost (SnapShotEngineId, SnapVendorName, SMArrayId,
							SMHostName, SMHostPortNumber, SMHostUserName,
							SMHostPassword, SMHostFlags, SMHostStatus,
									SMHostDescription, SnapShotEngineName, SMHostOption, SMHostIP, Flags, UniqueIdentifier)
		VALUES	(0, @vendorName, @arrayName,
					@ctrlHostName, 0, @userName,
					@userPswd, @arrayType, @isEnabled,
					@description, @vendorName, @arrayDGOptions, @offlineReason, @aiFlags, @uniqueIdentifier)
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Failed to add new Array info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		SET @arrayId = SCOPE_IDENTITY()
		INSERT INTO @tblArrayAliases VALUES(0, @arrayName)
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Unable to add the alias name. Failed to add new Array info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		-- Array DG
		IF EXISTS (SELECT * FROM @tblArrayDG)
		BEGIN
			-- Array DG Name
			INSERT	INTO SMConfigs
			SELECT	ADG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, 0, 0, @arrayDGName, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblArrayDG ADG
			WHERE	ADG.name = N'Storage Device Group'
			-- Use Devices From This DG
			INSERT	INTO SMConfigs
			SELECT	ADG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, @useDevicesFromThisDG, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblArrayDG ADG
			WHERE	ADG.name = N'Use Devices only from this Group'
			-- Disable Device Group
			INSERT	INTO SMConfigs
			SELECT	ADG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, @disableDG, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblArrayDG ADG
			WHERE	ADG.name = N'Disable Device Group'
			IF @assocType <> @MMSM_AT_ARRAY AND @adgOverridden = 1
			BEGIN
				-- Array DG Name
				INSERT	INTO SMConfigs
				SELECT	ADG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, 0, 0, @arrayDGName, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblArrayDG ADG
				WHERE	ADG.name = N'Storage Device Group'
				-- Use Devices From This DG
				INSERT	INTO SMConfigs
				SELECT	ADG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, @useDevicesFromThisDG, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblArrayDG ADG
				WHERE	ADG.name = N'Use Devices only from this Group'
				-- Disable Device Group
				INSERT	INTO SMConfigs
				SELECT	ADG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_ARRAY THEN @arrayId WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, @disableDG, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblArrayDG ADG
				WHERE	ADG.name = N'Disable Device Group'
			END
		END
		-- Host DG
		IF EXISTS (SELECT * FROM @tblHostDG)
		BEGIN
			-- Host Device Group Options
			INSERT	INTO SMConfigs
			SELECT	HDG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, @deviceGroupOption, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblHostDG HDG
			WHERE	HDG.name = N'Host Device Group Options'
			-- Host Device Group
			INSERT	INTO SMConfigs
			SELECT	HDG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, 0, 0, @hostDGName, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblHostDG HDG
			WHERE	HDG.name = N'Host Device Group'
			-- Use only Spouse Devices
			INSERT	INTO SMConfigs
			SELECT	HDG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, @useOnlySpouseDevices, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblHostDG HDG
			WHERE	HDG.name = N'Use only Spouse Devices'
			-- Do not move Source and Target Device across Group
			INSERT	INTO SMConfigs
			SELECT	HDG.masterConfigId, @arrayId, @arrayId, @assocType, 1, 1, 0, @doNotMoveDevices, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
			FROM	@tblHostDG HDG
			WHERE	HDG.name = N'Do not move Source and Target Device across Group'
			IF @assocType <> @MMSM_AT_ARRAY AND @hdgOverridden = 1
			BEGIN
				-- Host Device Group Options
				INSERT	INTO SMConfigs
				SELECT	HDG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, @deviceGroupOption, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblHostDG HDG
				WHERE	HDG.name = N'Host Device Group Options'
				-- Host Device Group
				INSERT	INTO SMConfigs
				SELECT	HDG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, 0, 0, @hostDGName, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblHostDG HDG
				WHERE	HDG.name = N'Host Device Group'
				-- Use only Spouse Devices
				INSERT	INTO SMConfigs
				SELECT	HDG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, @useOnlySpouseDevices, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblHostDG HDG
				WHERE	HDG.name = N'Use only Spouse Devices'
				-- Do not move Source and Target Device across Group
				INSERT	INTO SMConfigs
				SELECT	HDG.masterConfigId, @arrayId,
						(CASE WHEN @assocType = @MMSM_AT_ARRAY THEN @arrayId WHEN @assocType = @MMSM_AT_COPY THEN @copyId WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
						@assocType, 1, 1, 0, @doNotMoveDevices, 0, N'', @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
				FROM	@tblHostDG HDG
				WHERE	HDG.name = N'Do not move Source and Target Device across Group'
			END
		END
				-- For NetApp arrays add an SMMetaData entry for DFM Name
			-- DECLARE @NewControlHostId INTEGER = @arrayId
			-- SET @NewControlHostId = (SELECT ControlHostId from SMControlHost WHERE SMArrayId = @arrayName)
		IF @vendorName = @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME AND @arrayType <> @MMSM_ART_DFM
		BEGIN
				IF NOT EXISTS (SELECT * FROM SMMETADATA (NOLOCK) WHERE RefType = 5 AND RefId = @arrayId)
			BEGIN
				INSERT INTO SMMetaData(MetaDataType, RefType, RefId, PruneFlags, MetaData)
					VALUES (0, 5, @arrayId, 4, '1#3#49|::||::||..|')
			END
		END
		IF EXISTS(SELECT * FROM @tblArrayAliases)
		BEGIN
			IF @IsHDS_VSM = 1
			BEGIN
			INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
			FROM    (SELECT DISTINCT alias FROM @tblArrayAliases ) I_ALIAS
							LEFT OUTER JOIN SMHostAlias HA (NOLOCK) ON I_ALIAS.alias = HA.AliasName AND HA.RefId = @arrayId AND HA.RefType = 5/*SM_MRT_ARRAY*/
				WHERE	HA.AliasName IS NULL
			END
			ELSE
			BEGIN
				IF @isMultiTenantSite = 0
				BEGIN
				INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
				FROM    (SELECT DISTINCT alias FROM @tblArrayAliases ) I_ALIAS
							LEFT OUTER JOIN SMHostAlias HA (NOLOCK) ON I_ALIAS.alias = HA.AliasName
				WHERE	HA.AliasName IS NULL
					IF @clientId > 0
					BEGIN
						INSERT INTO SMEndPoint
						SELECT @clientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.alias,
						GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
						FROM (SELECT DISTINCT protocol, alias FROM @tblArrayAliases
						WHERE protocol > 0) I_ALIAS
							LEFT OUTER JOIN SMEndPoint EP (NOLOCK) ON I_ALIAS.alias = EP.Address
						WHERE EP.Address IS null
					END
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SET @xmlResp = (SELECT	@errorCode AS '@errorCode', 'Failed to add array aliases to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' ))
						SELECT @xmlResp
						RETURN
					END
			END
				ELSE
				BEGIN
					INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
					FROM    (SELECT DISTINCT alias FROM @tblArrayAliases ) I_ALIAS
								LEFT OUTER JOIN SMHostAlias HA (NOLOCK) ON I_ALIAS.alias = HA.AliasName AND HA.RefId = @arrayId
					WHERE	HA.AliasName IS NULL
					IF @clientId > 0
					BEGIN
						INSERT INTO SMEndPoint
						SELECT @clientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.alias,
						GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
						FROM (SELECT DISTINCT protocol, alias FROM @tblArrayAliases
						WHERE protocol > 0) I_ALIAS
							LEFT OUTER JOIN SMEndPoint EP (NOLOCK) ON I_ALIAS.alias = EP.Address AND @clientId = EP.ClientId
						WHERE EP.Address IS null
					END
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SET @xmlResp = (SELECT	@errorCode AS '@errorCode', 'Failed to add array aliases to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' ))
						SELECT @xmlResp
						RETURN
					END
				END
			END
			IF @clientId > 0
			BEGIN
				INSERT INTO SMEndPoint
				SELECT @clientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.alias,
				GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
				FROM (SELECT DISTINCT protocol, alias FROM @tblArrayAliases
				WHERE protocol > 0) I_ALIAS
					LEFT OUTER JOIN SMEndPoint EP (NOLOCK) ON I_ALIAS.alias = EP.Address
				WHERE EP.Address IS null
			END
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SET @xmlResp = (SELECT	@errorCode AS '@errorCode', 'Failed to add array aliases to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' ))
				SELECT @xmlResp
				RETURN
			END
		END
		/* Update the entries in the table variable @tblArrayConfigsList with the proper reftype and refid  -- START*/
		IF @HostAliasMasterCfgId > 0
		BEGIN
			--Remove the blank entry from the configslist as we always have atleast 1 alias
			DELETE FROM @tblArrayConfigsList WHERE masterConfigId = @HostAliasMasterCfgId AND value = @arrCfgListEmpty
			IF @isMultiTenantSite = 0
			BEGIN
			-- Add the new Host aliases that the user has entered in the SMHostAlias table, if they do not exist already
			INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
			FROM    (SELECT DISTINCT value as alias FROM @tblArrayConfigsList where masterConfigId = @HostAliasMasterCfgId) I_ALIAS
			LEFT OUTER JOIN SMHostAlias HA WITH(NOLOCK) ON I_ALIAS.alias = HA.AliasName
			WHERE HA.AliasName IS null
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add Host Alias info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
			END
			ELSE
			BEGIN
				-- Add the new Host aliases that the user has entered in the SMHostAlias table.
				INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
				FROM    (SELECT DISTINCT value as alias FROM @tblArrayConfigsList where masterConfigId = @HostAliasMasterCfgId) I_ALIAS
				LEFT OUTER JOIN SMHostAlias HA WITH(NOLOCK) ON I_ALIAS.alias = HA.AliasName AND HA.RefId = @arrayId
				WHERE HA.AliasName IS null
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add Host Alias info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			-- Remove the entries that the user has entered as they are already added in the table SMHostAlias
			DELETE FROM @tblArrayConfigsList WHERE masterConfigId = @HostAliasMasterCfgId
			-- For Array Host Alias, look in the SMHostAlias table and add all the entries as a config
			INSERT INTO @tblArrayConfigsList
			SELECT		0, '', @HostAliasMasterCfgId, @MMSM_CT_LIST,@assocType,
						(ROW_NUMBER() OVER (PARTITION BY hAlias.RefId ORDER BY hAlias.Id) )*10 as rnum,
						hAlias.AliasName,
						1, 0, 0 ,0, 1, hAlias.Id, 0, 0, 0
			FROM		SMHostAlias (NOLOCK) hAlias
WHERE		hAlias.RefId = @arrayId and hAlias.RefType = 5/*SM_MRT_ARRAY*/
						AND hAlias.AliasName <> @arrayName
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add host alias configuration info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
		/* Update the entries in the table variable @tblArrayConfigsList with the proper reftype and refid -- END*/
		INSERT	INTO SMConfigs
		SELECT	masterConfigId, @arrayId, @arrayId, @MMSM_AT_ARRAY, 1, 1, 0,
									( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
											ELSE 0 END ),
									( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
									( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
									@currTime, 0, 2, newid(), 0, 0, 0, 0, N''
		FROM	@tblArrayConfigs
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Failed to add array configuration info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		INSERT	INTO SMConfigsList
		SELECT	masterConfigId, @arrayId, @arrayId, @MMSM_AT_ARRAY,
				elementOrder, 1, 1, 0,
				0, 0, value,
				@currTime, 0, 2, newid(), refType, refId
		FROM	@tblArrayConfigsList
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Failed to add array configuration info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Use target devices from Host Device Group')
		BEGIN
			UPDATE	SMControlHost
			SET		DeviceGroupName = tAC.value
			FROM	@tblArrayConfigs tAC
			WHERE	tAC.configName = N'Use target devices from Host Device Group'
					AND ControlHostId = @arrayId
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add host device group array configuration info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
		IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Storage Device Group')
		BEGIN
			UPDATE	SMControlHost
			SET		DeviceGroupName = tAC.value
			FROM	@tblArrayConfigs tAC
			WHERE	tAC.configName = N'Storage Device Group'
					AND ControlHostId = @arrayId
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add device group array configuration info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
		IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Use Devices only from this Group')
		BEGIN
			UPDATE	SMControlHost
			SET		SMHostOption = (CASE WHEN tAC.value = N'true' THEN 1 ELSE 0 END)
			FROM	@tblArrayConfigs tAC
			WHERE	tAC.configName = N'Use Devices only from this Group'
					AND ControlHostId = @arrayId
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add device group option array configuration info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
		-- Overridden Configs
		INSERT	INTO SMConfigs
		SELECT	masterConfigId, @arrayId, (CASE WHEN @assocType = @MMSM_AT_COPY THEN @copyId
												WHEN @assocType = @MMSM_AT_CLIENT THEN @clientLevelId
												WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @appId END),
									assocType, 1, 1, 0,
									( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
											ELSE 0 END ),
									( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
									( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
									@currTime, 0, 2, newid(), 0, 0, 0, 0, N''
		FROM	@tblArrayConfigs
		WHERE	isOverridden = 1
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Failed to add overridden array configuration info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		INSERT	INTO SMConfigsList
		SELECT	masterConfigId, @arrayId, (CASE WHEN @copyId > 0 THEN @copyId ELSE @appId END), assocType,
				elementOrder, 1, 1, 0,
				0, 0, value,
				@currTime, 0, 2, newid(), refType, refId
		FROM	@tblArrayConfigsList
		WHERE	isOverridden = 1  AND masterConfigId NOT IN (@HostAliasMasterCfgId)
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SELECT	@errorCode AS '@errorCode', 'Failed to add overridden array configuration info to DB' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		END
	-- Edit
	ELSE
	BEGIN
		SET @currArrayName = ISNULL((SELECT SMArrayId FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayId),'N/A')
		IF @useDevicesFromThisDG = 1
			SET @arrayDGOptions = @arrayDGOptions | 1	-- useDevicesFromThisDG = true
		IF @disableDG = 1
			SET @arrayDGOptions = @arrayDGOptions | 2	-- disableDG = true
		DECLARE @enableArrayNameChange bigint = 0
		SELECT	@enableArrayNameChange = (MAX(capabilities)|MIN(capabilities))
			FROM	SMSnapShotEngine (NOLOCK)
		WHERE	SnapVendorName = @vendorName
		-- IF @assocType = @MMSM_AT_ARRAY
		BEGIN
			UPDATE	SMControlHost SET	SMHostName = @ctrlHostName,
										SMHostFlags = ( CASE
															WHEN @arrayType >= 4
															THEN ((SMHostFlags & (POWER(2, 2) - 1)) | @arrayType)
															ELSE ((SMHostFlags & ~(POWER(2, 2) - 1)) | @arrayType)
														END ),
										SMHostStatus = @isEnabled,
										SMHostDescription = @description,
										SMHostOption = ( CASE
															WHEN SnapVendorName = @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME AND SMHostFlags & @MMSM_ART_DFM = @MMSM_ART_DFM
															THEN SMHostOption
															ELSE @arrayDGOptions
														END ),
										SMHostIP = @offlineReason,
										Flags  = @aiFlags,
										UniqueIdentifier = (CASE WHEN LEN(@uniqueIdentifier) > 0 THEN @uniqueIdentifier ELSE uniqueIdentifier END)
			WHERE	ControlHostId = @arrayId
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to update Array info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
			IF @passwordEdit = 1
			BEGIN
				UPDATE	SMControlHost SET	SMHostUserName = @userName,
											SMHostPassword = @userPswd
				WHERE	ControlHostId = @arrayId
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to update Array Password to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			DECLARE @oldUserName NVARCHAR = N''
				SELECT @oldUserName = SMHostUserName FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayId
			IF (@userName <> '' AND @oldUserName <> @userName)
			BEGIN
				UPDATE	SMControlHost SET	SMHostUserName = @userName
				WHERE	ControlHostId = @arrayId
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to update User Name to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
		END
		IF EXISTS (SELECT * FROM @tblArrayConfigs)
		BEGIN
			IF @assocType = @MMSM_AT_ARRAY
			BEGIN
				UPDATE	SMConfigs
				SET		ValueInt = ( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
											ELSE 0 END ),
						ValueLL = ( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
						ValueStr = ( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
						Modified = @currTime
					FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON (CFG.ConfigId = tAC.configId OR CFG.MasterConfigId = tAC.masterConfigId) AND CFG.AssocType = tAC.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @arrayId
						AND CFG.AssocType = @MMSM_AT_ARRAY
						AND ((ConfigType NOT IN (12, @MMSM_CT_ENC_STRING)) OR (isUpdated = 1))
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Use target devices from Host Device Group' AND assocType = @MMSM_AT_ARRAY)
				BEGIN
					UPDATE	SMControlHost
					SET		DeviceGroupName = tAC.value
						FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
								INNER JOIN SMControlHost CTRLHOST (NOLOCK) ON CTRLHOST.ControlHostId = CFG.ArrayId
					WHERE	tAC.configName = N'Use target devices from Host Device Group'
							AND tAC.assocType = @MMSM_AT_ARRAY
							AND CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update host device group array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
				END
				IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Storage Device Group' AND assocType = @MMSM_AT_ARRAY)
				BEGIN
					UPDATE	SMControlHost
					SET		DeviceGroupName = tAC.value
						FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
								INNER JOIN SMControlHost CTRLHOST (NOLOCK) ON CTRLHOST.ControlHostId = CFG.ArrayId
					WHERE	tAC.configName = N'Storage Device Group'
							AND tAC.assocType = @MMSM_AT_ARRAY
							AND CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update device group array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
				END
				IF EXISTS (SELECT * FROM @tblArrayConfigs WHERE configName = N'Use Devices only from this Group' AND assocType = @MMSM_AT_ARRAY)
				BEGIN
					UPDATE	SMControlHost
					SET		SMHostOption = (CASE WHEN tAC.value = N'true' THEN 1 ELSE 0 END)
						FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
								INNER JOIN SMControlHost CTRLHOST (NOLOCK) ON CTRLHOST.ControlHostId = CFG.ArrayId
					WHERE	tAC.configName = N'Use Devices only from this Group'
							AND tAC.assocType = @MMSM_AT_ARRAY
							AND CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update device group option array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
				END
			END
			ELSE IF @assocType = @MMSM_AT_COPY
			BEGIN
				UPDATE	SMConfigs
				SET		ValueInt = ( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
											ELSE 0 END ),
						ValueLL = ( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
						ValueStr = ( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
						Modified = @currTime
					FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @copyId
						AND CFG.AssocType = @MMSM_AT_COPY
						AND tAC.isOverridden = 1
						AND ((ConfigType NOT IN (12, @MMSM_CT_ENC_STRING)) OR (isUpdated = 1))
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigs
				SELECT	tAC.masterConfigId, @arrayId, (CASE WHEN @copyId > 0 THEN @copyId ELSE @appId END), tAC.assocType, 1, 1, 0,
											( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
													WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
													ELSE 0 END ),
											( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
											( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
											@currTime, 0, 2, newid(), 0, 0, 0, 0, N''
					FROM	@tblArrayConfigs tAC LEFT OUTER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
				WHERE	CFG.ConfigId IS null
						AND CFG.AssocType IS null
						AND tAC.isOverridden = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add overridden array configuration info to DB for Copy' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				DELETE	SMConfigs
					FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON tAC.configId = CFG.ConfigId AND tAC.assocType = CFG.AssocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @copyId
						AND CFG.AssocType = @MMSM_AT_COPY
						AND tAC.isOverridden = 0
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete overridden array configuration info to DB for Copy' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			ELSE IF @assocType = @MMSM_AT_CLIENT
			BEGIN
					UPDATE	SMConfigs
					SET		ValueInt = ( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
												WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
												ELSE 0 END ),
							ValueLL = ( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
							ValueStr = ( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
							Modified = @currTime
						FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
					WHERE	CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @clientLevelId
							AND CFG.AssocType = @MMSM_AT_CLIENT
							AND tAC.isOverridden = 1
							AND ((ConfigType NOT IN (12, @MMSM_CT_ENC_STRING)) OR (isUpdated = 1))
					IF @@ERROR > 0
					BEGIN
						SELECT	@@ERROR AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					INSERT	INTO SMConfigs
					SELECT	tAC.masterConfigId, @arrayId, @clientLevelId, tAC.assocType, 1, 1, 0,
												( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
														WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
														ELSE 0 END ),
												( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
												( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
												@currTime, 0, 2, newid(), 0, 0, 0, 0, N''
						FROM	@tblArrayConfigs tAC LEFT OUTER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
					WHERE	CFG.ConfigId IS null
							AND CFG.AssocType IS null
							AND tAC.isOverridden = 1
					IF @@ERROR > 0
					BEGIN
						SELECT	@@ERROR AS '@errorCode', 'Failed to add overridden array configuration info to DB for Instance\Client' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					DELETE	SMConfigs
						FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON tAC.configId = CFG.ConfigId AND tAC.assocType = CFG.AssocType
					WHERE	CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @clientLevelId
							AND CFG.AssocType = @MMSM_AT_CLIENT
							AND tAC.isOverridden = 0
					IF @@ERROR > 0
					BEGIN
						SELECT	@@ERROR AS '@errorCode', 'Failed to delete overridden array configuration info to DB for Instance\Client' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
			END
			ELSE IF @assocType = @MMSM_AT_SUBCLIENT
			BEGIN
				UPDATE	SMConfigs
				SET		ValueInt = ( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
											ELSE 0 END ),
						ValueLL = ( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
						ValueStr = ( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
						Modified = @currTime
					FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @appId
						AND CFG.AssocType = @MMSM_AT_SUBCLIENT
						AND tAC.isOverridden = 1
						AND ((ConfigType NOT IN (12, @MMSM_CT_ENC_STRING)) OR (isUpdated = 1))
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigs
				SELECT	tAC.masterConfigId, @arrayId, (CASE WHEN @copyId > 0 THEN @copyId ELSE @appId END), tAC.assocType, 1, 1, 0,
											( CASE WHEN configType IN (1) THEN ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
													WHEN ConfigType IN (2, 3, 4, 5) THEN CONVERT(INTEGER, value)
													ELSE 0 END ),
											( CASE WHEN ConfigType IN (6, 7) THEN CONVERT(BIGINT, value) ELSE 0 END ),
											( CASE WHEN ConfigType IN (8, 9, 12, @MMSM_CT_ENC_STRING) THEN value ELSE N'' END ),
											@currTime, 0, 2, newid(), 0, 0, 0, 0, N''
					FROM	@tblArrayConfigs tAC LEFT OUTER JOIN SMConfigs CFG (NOLOCK) ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
				WHERE	CFG.ConfigId IS null
						AND CFG.AssocType IS null
						AND tAC.isOverridden = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add overridden array configuration info to DB for Instance\Subclient' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				DELETE	SMConfigs
					FROM	@tblArrayConfigs tAC INNER JOIN SMConfigs CFG (NOLOCK) ON tAC.configId = CFG.ConfigId AND tAC.assocType = CFG.AssocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @appId
						AND CFG.AssocType = @MMSM_AT_SUBCLIENT
						AND tAC.isOverridden = 0
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete overridden array configuration info to DB for Instance\Subclient' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
		END
		IF EXISTS (SELECT * FROM @tblArrayConfigsList)
		BEGIN
			IF @assocType = @MMSM_AT_ARRAY
			BEGIN
				DELETE	SMConfigsList
				FROM	SMConfigsList CFG (NOLOCK) INNER JOIN @tblArrayConfigsList tACL ON CFG.MasterConfigId = tACL.masterConfigId AND CFG.AssocType = tACL.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @arrayId
						AND CFG.AssocType = @MMSM_AT_ARRAY
						AND tACL.isUpdated = 1
						AND CFG.MasterConfigId NOT IN (@HostAliasMasterCfgId)
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigsList
				SELECT	masterConfigId, @arrayId, @arrayId, @MMSM_AT_ARRAY,
						elementOrder, 1, 1, 0,
						0, 0, value,
						@currTime, 0, 2, newid(), refType, refId
				FROM	@tblArrayConfigsList
				WHERE	isUpdated = 1
				AND		masterConfigId NOT IN (@HostAliasMasterCfgId)
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				/*HOST ALIAS EDIT -- START*/
				IF @HostAliasMasterCfgId > 0
				BEGIN
					INSERT INTO @tblArrAliasEndPointMap
					SELECT	DISTINCT CFG.ConfigId,CFG.RefId, ISNULL(ENDPT.Id,0), ISNULL(ENDPT.AddressType,0), 0
					FROM	SMConfigsList (NOLOCK) CFG
							INNER JOIN SMControlHost (NOLOCK) CTRL ON CFG.ArrayId = CTRL.ControlHostId
							LEFT JOIN SMEndPoint (NOLOCK) ENDPT ON ENDPT.ClientId =  CTRL.ClientId AND ENDPT.Address = CFG.valuestr
					WHERE
							CFG.MasterConfigId = @HostAliasMasterCfgId
							AND CTRL.ControlHostId = @arrayId
					UPDATE	@tblArrAliasEndPointMap
					SET		toBeDeleted = 1
					FROM	@tblArrAliasEndPointMap TEMP INNER JOIN SMConfigsList (NOLOCK) CFG ON TEMP.SMConfigListId = CFG.ConfigId
					WHERE	CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
							AND CFG.MasterConfigId = @HostAliasMasterCfgId
							AND CFG.ConfigId NOT IN ( SELECT configId FROM @tblArrayConfigsList WHERE masterConfigId = @HostAliasMasterCfgId )
					DELETE	SMEndPoint
					FROM	SMEndPoint (NOLOCK) ENDPT
							INNER JOIN @tblArrAliasEndPointMap TEMP ON TEMP.SMEndPointId = ENDPT.Id
					WHERE	TEMP.toBeDeleted = 1
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					DELETE	SMHostAlias
					FROM	SMHostAlias (NOLOCK) H_ALIAS
							INNER JOIN @tblArrAliasEndPointMap TEMP ON TEMP.SMHostAliasId = H_ALIAS.Id
					WHERE	TEMP.toBeDeleted = 1
							AND H_ALIAS.AliasName <> @arrayName
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					DELETE	SMConfigsList
					FROM	SMConfigsList (NOLOCK) CFG
							INNER JOIN @tblArrAliasEndPointMap TEMP ON TEMP.SMConfigListId = CFG.ConfigId
					WHERE	TEMP.toBeDeleted = 1
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					--The array name cannot be added as a host alias
					IF EXISTS (SELECT * FROM @tblArrayConfigsList WHERE value = @arrayName )
					BEGIN
						SELECT	6 AS '@errorCode', 'Array name [' + @arrayName + '] cannot be added as an alias. Failed to update Host Alias for array [' + @currArrayName + ']' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					IF (@isMultiTenantSite = 0 OR @vendorName <> @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME)
					BEGIN
					--Checks to see whether this alias has been already added or not
					-- Here the existingConfigId will be the config id of the existing config.
					-- existingHostAlias will be set when the config entered is the array id of any array
 					UPDATE	a
					SET		existingConfigId = ISNULL(list.ConfigId,0),
							existingArrayId = ISNULL(list.ArrayId, 0),
							existingHostAlias = CASE WHEN LIST.ArrayId IS NULL THEN 1 ELSE 0 END
					FROM	@tblArrayConfigsList A INNER JOIN SMHostAlias ALIAS (NOLOCK)  ON A.value = ALIAS.aliasname
								LEFT JOIN SMConfigsList LIST(NOLOCK) ON LIST.Refid = ALIAS.Id AND ALIAS.RefType = 5/*SM_MRT_ARRAY*/
					-- Check whether the configs that are being added are not already present for this array
					SET @duplicateAliasName = ''
					SET @duplicateAliasName = ISNULL((SELECT TOP 1 value FROM @tblArrayConfigsList
												WHERE configId <> existingConfigId AND existingArrayId = @arrayId), '')
					IF LEN(@duplicateAliasName) > 0
					BEGIN
						SELECT	5 AS '@errorCode', 'Alias [' + @duplicateAliasName + '] found to be duplicate. Failed to update Host Alias for array [' + @currArrayName + ']' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					-- Check that the configs are not duplicate across arrays and also the array id of any array is not entered
					SET @duplicateAliasName = ''
					SET @duplicateAliasName = ISNULL((SELECT TOP 1 value FROM @tblArrayConfigsList WHERE ( configId <> existingConfigId and existingConfigId>0) OR existingHostAlias = 1),'')
					IF LEN(@duplicateAliasName) > 0
					BEGIN
						DECLARE @tempArrayName NVARCHAR(1024) = N''
							SET @tempArrayName = ISNULL( (SELECT TOP 1 SMArrayId FROM SMControlHost (NOLOCK) WHERE ControlHostId = ISNULL((SELECT TOP 1 refid FROM SMHostAlias (NOLOCK) WHERE AliasName = @duplicateAliasName AND RefType = 5/*SM_MRT_ARRAY*/),0)),'')
						SELECT	5 AS '@errorCode', 'Alias [' + @duplicateAliasName + '] is associated with array [' + @tempArrayName
													+ ']. Failed to update Host Alias info for array[' + @currArrayName + '].'AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					END
					IF (SELECT COUNT(DISTINCT value) FROM @tblArrayConfigsList where masterConfigId = @HostAliasMasterCfgId) <> (SELECT COUNT(value) FROM @tblArrayConfigsList where masterConfigId = @HostAliasMasterCfgId)
					BEGIN
						SELECT	9 AS '@errorCode', 'Duplicate alias found. Failed to update Host Alias for array [' + @currArrayName + ']' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					UPDATE	SMConfigsList
					SET		ValueStr = tAC.value,
							ElementOrder = tAC.elementOrder,
							Modified = @currTime
					FROM	SMConfigsList (NOLOCK) CFG
							INNER JOIN @tblArrayConfigsList tAC ON CFG.ConfigId = tAC.configId AND CFG.AssocType = tAC.assocType
					WHERE	CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
							AND tAC.ConfigId > 0
							AND CFG.MasterConfigId = @HostAliasMasterCfgId
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to update array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					UPDATE	SMHostAlias
					SET		AliasName = CFG.ValueStr
					FROM	SMHostAlias (NOLOCK) H_ALIAS INNER JOIN SMConfigsList (NOLOCK) CFG ON CFG.RefId = H_ALIAS.Id AND CFG.RefType = 1
					WHERE	CFG.ArrayId = @arrayId
							AND	CFG.AssocId = @arrayId
							AND CFG.AssocType = @MMSM_AT_ARRAY
							AND CFG.MasterConfigId = @HostAliasMasterCfgId
							AND CFG.ConfigId > 0
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to edit Host Alias info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					UPDATE	SMEndPoint
					SET Address = CFG.ValueStr
					FROM	SMEndPoint (NOLOCK) ENDPT
							INNER JOIN @tblArrAliasEndPointMap TEMP ON TEMP.SMEndPointId = ENDPT.Id
							INNER JOIN SMConfigsList (NOLOCK) CFG ON CFG.ConfigId = TEMP.SMConfigListId
					WHERE	CFG.MasterConfigId = @HostAliasMasterCfgId
					-- Add the new Host aliases that the user has entered in the SMHostAlias table, if they do not exist already
					INSERT  INTO SMHostAlias
SELECT  5/*SM_MRT_ARRAY*/, @arrayId, 0, 0, tAC.value, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
					FROM    @tblArrayConfigsList tAC
					WHERE	tAC.configId = 0 AND tAC.masterConfigId = @HostAliasMasterCfgId
							and tAC.value <> @arrCfgListEmpty
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to edit Host Alias info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
					INSERT	INTO SMConfigsList
					SELECT	masterConfigId, @arrayId, @arrayId, @MMSM_AT_ARRAY,
							elementOrder, 1, 1, 0,
							0, 0, H_ALIAS.AliasName,
							@currTime, 0, 2, newid(), 1, H_ALIAS.Id
					FROM	@tblArrayConfigsList tACL, SMHostAlias (NOLOCK) H_ALIAS
					WHERE	tACL.configId = 0 AND tACL.masterConfigId = @HostAliasMasterCfgId
AND H_ALIAS.RefType = 5 AND H_ALIAS.RefId = @arrayId
							AND H_ALIAS.AliasName = tACL.value
							AND	H_ALIAS.AliasName NOT IN (SELECT SMArrayId FROM SMControlHost (READUNCOMMITTED) WHERE ControlHostId = @arrayId)
					SET @errorCode = @@ERROR
					IF @errorCode > 0
					BEGIN
						SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
						FOR XML PATH ( 'CVGui_GenericResp' )
						RETURN
					END
				END
				/*HOST ALIAS EDIT -- END*/
			END
			ELSE IF @assocType = @MMSM_AT_COPY
			BEGIN
				DELETE	SMConfigsList
				FROM	SMConfigsList CFG (NOLOCK) INNER JOIN @tblArrayConfigsList tACL ON CFG.MasterConfigId = tACL.masterConfigId AND CFG.AssocType = tACL.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @copyId
						AND CFG.AssocType = @MMSM_AT_COPY
						AND tACL.isOverridden = 1
						AND tACL.isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigsList
				SELECT	masterConfigId, @arrayId, (CASE WHEN @copyId > 0 THEN @copyId ELSE @appId END), @MMSM_AT_COPY,
						elementOrder, 1, 1, 0,
						0, 0, value,
						@currTime, 0, 2, newid(), refType, refId
				FROM	@tblArrayConfigsList
				WHERE	isOverridden = 1
						AND isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				DELETE	SMConfigsList
					FROM	@tblArrayConfigsList tACL INNER JOIN SMConfigsList CFG (NOLOCK) ON tACL.masterConfigId = CFG.MasterConfigId AND tACL.assocType = CFG.AssocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @copyId
						AND CFG.AssocType = @MMSM_AT_COPY
						AND tACL.isOverridden = 0
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete overridden array configuration info to DB for Copy' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			ELSE IF @assocType = @MMSM_AT_SUBCLIENT
			BEGIN
				DELETE	SMConfigsList
				FROM	SMConfigsList CFG (NOLOCK) INNER JOIN @tblArrayConfigsList tACL ON CFG.MasterConfigId = tACL.masterConfigId AND CFG.AssocType = tACL.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @appId
						AND CFG.AssocType = @MMSM_AT_SUBCLIENT
						AND tACL.isOverridden = 1
						AND tACL.isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigsList
				SELECT	masterConfigId, @arrayId, (CASE WHEN @copyId > 0 THEN @copyId ELSE @appId END), @MMSM_AT_SUBCLIENT,
						elementOrder, 1, 1, 0,
						0, 0, value,
						@currTime, 0, 2, newid(), refType, refId
				FROM	@tblArrayConfigsList
				WHERE	isOverridden = 1
						AND isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				DELETE	SMConfigsList
					FROM	@tblArrayConfigsList tACL INNER JOIN SMConfigsList CFG (NOLOCK) ON tACL.masterConfigId = CFG.MasterConfigId AND tACL.assocType = CFG.AssocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @appId
						AND CFG.AssocType = @MMSM_AT_SUBCLIENT
						AND tACL.isOverridden = 0
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete overridden array configuration info to DB for Copy' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			ELSE IF @assocType = @MMSM_AT_CLIENT
			BEGIN
				DELETE	SMConfigsList
				FROM	SMConfigsList CFG (NOLOCK) INNER JOIN @tblArrayConfigsList tACL ON CFG.MasterConfigId = tACL.masterConfigId AND CFG.AssocType = tACL.assocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @clientLevelId
						AND CFG.AssocType = @MMSM_AT_CLIENT
						AND tACL.isOverridden = 1
						AND tACL.isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				INSERT	INTO SMConfigsList
				SELECT	masterConfigId, @arrayId, @clientLevelId, @MMSM_AT_CLIENT,
						elementOrder, 1, 1, 0,
						0, 0, value,
						@currTime, 0, 2, newid(), refType, refId
				FROM	@tblArrayConfigsList
				WHERE	isOverridden = 1
						AND isUpdated = 1
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				DELETE	SMConfigsList
					FROM	@tblArrayConfigsList tACL INNER JOIN SMConfigsList CFG (NOLOCK) ON tACL.masterConfigId = CFG.MasterConfigId AND tACL.assocType = CFG.AssocType
				WHERE	CFG.ArrayId = @arrayId
						AND	CFG.AssocId = @clientLevelId
						AND CFG.AssocType = @MMSM_AT_CLIENT
						AND tACL.isOverridden = 0
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SELECT	@errorCode AS '@errorCode', 'Failed to delete overridden array configuration info to DB for client' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
		END
		DECLARE @HostAliasAutoUpdateCfgValue INT = 1
		SET @HostAliasAutoUpdateCfgValue = ISNULL ( (	SELECT ( CASE WHEN value = N'true' THEN 1 ELSE 0 END )
											FROM @tblArrayConfigs WHERE masterConfigId = @HostAliasAutoUpdateMasterCfgId), 1)
		-- Check the config whether to auto update the host alias is set or not. If it is set to true, save the host aliases present in the list sent by engine
		IF EXISTS(SELECT * FROM @tblArrayAliases) AND @HostAliasAutoUpdateCfgValue = 1 AND @HostAliasMasterCfgId > 0
		BEGIN
			IF @isMultiTenantSite = 1
			BEGIN
			INSERT  INTO SMHostAlias
SELECT  5, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
				FROM    (SELECT DISTINCT alias FROM @tblArrayAliases ) I_ALIAS
				LEFT OUTER JOIN SMHostAlias HA WITH(NOLOCK) ON I_ALIAS.alias = HA.AliasName  AND HA.RefId = @arrayId
				WHERE HA.AliasName IS null
				IF @clientId > 0
				BEGIN
					INSERT INTO SMEndPoint
					SELECT @clientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.alias,
					GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
					FROM (SELECT DISTINCT protocol, alias FROM @tblArrayAliases
					WHERE protocol > 0) I_ALIAS
						LEFT OUTER JOIN SMEndPoint EP (NOLOCK) ON I_ALIAS.alias = EP.Address AND @clientId = EP.ClientId
					WHERE EP.Address IS null
				END
				SET @errorCode = @@ERROR
				IF @errorCode > 0
				BEGIN
					SET @xmlResp = (SELECT	@errorCode AS '@errorCode', 'Failed to add array aliases to DB' AS '@errorMessage'
					FOR XML PATH ( 'CVGui_GenericResp' ))
					SELECT @xmlResp
					RETURN
				END
			END
			ELSE
			BEGIN
			INSERT  INTO SMHostAlias
SELECT  5, @arrayId, 0, 0, I_ALIAS.alias, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
			FROM    (SELECT DISTINCT alias FROM @tblArrayAliases ) I_ALIAS
			LEFT OUTER JOIN SMHostAlias HA WITH(NOLOCK) ON I_ALIAS.alias = HA.AliasName
			WHERE HA.AliasName IS null
			IF @clientId > 0
			BEGIN
				INSERT INTO SMEndPoint
				SELECT @clientId, 0, 0, 0, 0, 0, 0, I_ALIAS.protocol, I_ALIAS.alias,
				GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
				FROM (SELECT DISTINCT protocol, alias FROM @tblArrayAliases
				WHERE protocol > 0) I_ALIAS
					LEFT OUTER JOIN SMEndPoint EP (NOLOCK) ON I_ALIAS.alias = EP.Address
				WHERE EP.Address IS null
			END
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SET @xmlResp = (SELECT	@errorCode AS '@errorCode', 'Failed to add array aliases to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' ))
				SELECT @xmlResp
				RETURN
			END
			END
			INSERT	INTO SMConfigsList
			SELECT	@HostAliasMasterCfgId, @arrayId, @arrayId, @MMSM_AT_ARRAY,
					0, 1, 1, 0,
					0, 0, H_ALIAS.AliasName,
					@currTime, 0, 2, newid(), 1, H_ALIAS.Id
			FROM	SMHostAlias (NOLOCK) H_ALIAS
						LEFT OUTER JOIN SMConfigsList (NOLOCK) CFG ON H_ALIAS.Id = CFG.RefId AND H_ALIAS.RefType = 5/*SM_MRT_ARRAY*/
WHERE   H_ALIAS.RefType = 5
					AND H_ALIAS.RefId = @arrayId
					AND CFG.ValueStr IS NULL
					AND H_ALIAS.AliasName NOT IN (SELECT SMArrayId FROM SMControlHost (READUNCOMMITTED) WHERE ControlHostId = @arrayId)
			SET @errorCode = @@ERROR
			IF @errorCode > 0
			BEGIN
				SELECT	@errorCode AS '@errorCode', 'Failed to add (while editing) array configuration info to DB' AS '@errorMessage'
				FOR XML PATH ( 'CVGui_GenericResp' )
				RETURN
			END
		END
	END
	-- Call the SP MM_SMSetArrayController for setting the Array Controller details
	DECLARE @retVal INTEGER = 0
	DECLARE @tblRtn TABLE (retVal integer, errorStr nvarchar(1024))
	SET @retVal = 0
    INSERT INTO @tblRtn
	EXEC @retVal = MM_SMXMLSetArrayController @i_xmlTextInput, @arrayId
    IF @retVal <> 0
	BEGIN
		SET @xmlResp = (SELECT	retVal  AS '@errorCode', errorStr AS '@errorMessage'
						FROM @tblRtn
						FOR XML PATH ( 'CVGui_GenericResp' ))
		SELECT @xmlResp
		RETURN
	END
	------------------------------------------------------------------------------------------------------
	---- Add or Update the Credential Manager association (Currently done only for Hedvig, Alibaba, Azure RM and Amazon )
	---- Add	: AddNewAssoc + Update Array					: -1 -> xx
	---- Reset	: DeleteOldAssoc + Update Array					: xx -> -1
	---- Update : DeleteOldAssoc + AddNewAssoc + Update Array	: xx -> yy
	---- For Azure RM (Common::VSVendor_AZURE_V2), EntityProperties::SetArrayDetails() sets Vendor ID as SM_VENDOR_VSA_VVOL_ID amd Vendor Name as SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME
	---- Since the same Vendor ID SM_VENDOR_VSA_VVOL_ID is used for VMWare as well as Nutanix, we will check Vendor Name to unqiuely identity Azure Resource Manager
	---- For both Alibaba (Common::VSVendor_ALIBABA_CLOUD) and Amazon(Common::VSVendor_AMAZON), EntityProperties::SetArrayDetails() sets Vendor ID as SM_VENDOR_AMAZON_ID
	---- If @l_curCredentialId and @l_credentialId both turns out to be -1 then no changes will take place
	------------------------------------------------------------------------------------------------------
IF ( (47 = @vendorId) OR ('Commvault Distributed Storage' = @vendorName)  --Hedvig
OR ('Microsoft Azure' = @vendorName) --Azure RM
OR (28 = @vendorId) --Alibaba and Amazon
	   )
	BEGIN
		---- 1. Get the current association Id configured in ControlHost entry.
		SET @l_curCredentialAssocId = ISNULL((SELECT CredentialId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @arrayId), -1)
		---- 2. Get the current credential Id if exists..
		IF ( @l_curCredentialAssocId > 0)
		BEGIN
			SET @l_curCredentialId = ISNULL((SELECT credentialId FROM APP_CredentialAssoc WITH (READUNCOMMITTED) WHERE assocId = @l_curCredentialAssocId), -1)
		END
		---- 3. Check only when credentials differs.. Same creds will need no changes..
		IF ( @l_curCredentialId <> @l_credentialId )
		BEGIN
			---- 3.1 Check & remove the existing assoc entry if any exists..
			IF( @l_curCredentialAssocId > 0 )
			BEGIN
				DELETE	ACA
				FROM	APP_CredentialAssoc	ACA
				WHERE	ACA.assocId = @l_curCredentialAssocId
AND ACA.entityType = 153
							AND	ACA.entityId = @arrayId
				SET @errorCode = @@ERROR
				IF @errorCode <> 0
				BEGIN
					SELECT	@errorCode AS '@errorCode',
							'Failed to remove credential association for array-[' + CONVERT(VARCHAR(1024), @arrayId) + '], credentialId-[' + CONVERT(VARCHAR(1024), @l_curCredentialAssocId) + ']' AS '@errorMessage'
					FOR		XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END
			---- 3.2 Add a new association for the new array-credential combination.
			IF ( @l_credentialId > 0 )
			BEGIN
				INSERT	INTO APP_CredentialAssoc (credentialId, entityType, entityId)
VALUES (@l_credentialId, 153, @arrayId)
				SET @errorCode = @@ERROR
				IF @errorCode <> 0
				BEGIN
					SELECT	@errorCode AS '@errorCode',
							'Failed to add credential association for array-[' + CONVERT(VARCHAR(1024), @arrayId) + '], credentialId-[' + CONVERT(VARCHAR(1024), @l_credentialId) + ']' AS '@errorMessage'
					FOR		XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
				SET @l_credentialAssocId = SCOPE_IDENTITY()
			END
			---- 3.3 Update the ControlHost entry with the new association Id..
			IF ( @l_curCredentialAssocId <> @l_credentialAssocId )
			BEGIN
				UPDATE	SMControlHost
				SET		CredentialId = @l_credentialAssocId
				WHERE	ControlHostId = @arrayId
				SET @errorCode = @@ERROR
				IF @errorCode <> 0
				BEGIN
					SELECT	@errorCode AS '@errorCode',
							'Failed to update array-[' + CONVERT(VARCHAR(1024), @arrayId) + '] with credential association id-[' + CONVERT(VARCHAR(1024), @l_credentialAssocId) + ']' AS '@errorMessage'
					FOR		XML PATH ( 'CVGui_GenericResp' )
					RETURN
				END
			END	---- if update array
		END	---- if assoc differs
	END ---- if Hedvig
	--SP23 - Once we have set the arraydetails, if the region is set for the array (currently supported only from Command Center), then create appropriate entries
	IF @regionId != N''
	BEGIN
		--Step1: Add/update array, we need to ensure that there is no other array with conflicting IP exists in the same region
		IF @add = 0 --Edit case - the @tblArrayAliases is not populated
		BEGIN
			INSERT INTO @tblArrayAliases
			SELECT 0,AliasName FROM SMHostAlias (NOLOCK) WHERE RefId = @arrayId
		END
		DECLARE @conflictArrayName NVARCHAR(2048) = N''
		SELECT @conflictArrayName = (SELECT SMArrayId FROM SMControlHost (NOLOCK) WHERE COntrolHostId = TMP1.ControlHostId) FROM APP_AdvanceSettings (NOLOCK) APPADV
		INNER JOIN
		(SELECT ControlHostId FROM SMControlHost T1 (NOLOCK) INNER JOIN @tblArrayAliases T2 ON T1.SMArrayId = T2.alias
		UNION
		SELECT RefId AS ControlHostId FROM SMHostAlias T1 (NOLOCK) INNER JOIN @tblArrayAliases T2 ON T1.AliasName = T2.alias
		UNION
		SELECT T3.ControlHostId FROM SMArray T1 (NOLOCK) INNER JOIN @tblArrayAliases T2 ON T1.ArrayName = T2.alias INNER JOIN SMArrayCtrlHostMap T3 (NOLOCK) ON T1.Id = T3.ArrayId) TMP1
ON APPADV.entityId = TMP1.ControlHostId AND APPADV.value = @regionId AND APPADV.entityType = 153 /*ARRAY_ENTITY*/ AND APPADV.keyName = 'Region Id' AND deleted = 0 AND enabled = 1
		WHERE TMP1.ControlHostId <> @arrayId AND @regionId > 0
		IF @conflictArrayName != N''
		BEGIN
			SET @errorCode = 1
			SELECT	@errorCode AS '@errorCode', 'Array ['+ @conflictArrayName +'] with conflicitng alias already exists in the same region' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			RETURN
		END
		--Step2: If there are no conflicts found, then proceed with INSERT/UPDATE operations
		--INSERT - If there are no exisitng associations, INSERT
IF	NOT EXISTS (SELECT 1 FROM APP_AdvanceSettings (NOLOCK) WHERE entityId = @arrayId AND entityType = 153 /*ARRAY_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1) /* no association is made yet*/
		BEGIN
			INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@arrayId, 'Region Id', N'INTEGER', N'CommServDB.Client', @regionId, 1, 0, 153 /*ARRAY_ENTITY*/, 0, 0)
		END
		--UPDATE - If the association exists and it is for a different region, then update
ELSE IF EXISTS (SELECT 1 FROM APP_AdvanceSettings (NOLOCK) WHERE entityId = @arrayId AND value <> @regionId AND entityType = 153 /*ARRAY_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1)
		BEGIN
			UPDATE APP_AdvanceSettings SET value = @regionId
WHERE entityId = @arrayId AND entityType = 153 /*ARRAY_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1
		END
		/*--Step 3: If MS is enabled, set the region for the client - (1) new client - create the region (2) existing client - update the region if the region does not match with the array
		IF @isMultiTenantSite = 1 AND @clientId > 0
		BEGIN
IF NOT EXISTS (SELECT 1 FROM App_AdvanceSettings where entityId = @clientId AND entityType = 3 /*CLIENT_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1)
			BEGIN
				INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@clientId, 'Region Id', N'INTEGER', N'CommServDB.Client', @regionId, 1, 0, 3/*CLIENT_ENTITY*/, 0, 0)
			END
IF EXISTS (SELECT 1 FROM App_AdvanceSettings where entityId = @clientId AND value <> @regionId AND entityType = 3 /*CLIENT_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1 )
			BEGIN
				UPDATE APP_AdvanceSettings SET value = @regionId
WHERE entityId = @clientId AND entityType = 3 /*CLIENT_ENTITY*/ AND keyName = 'Region Id' AND deleted = 0 AND enabled = 1
			END
		END*/
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT	ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	RETURN
END CATCH
SELECT	0 AS '@errorCode',
		'' AS '@errorMessage'
FOR XML PATH ( 'CVGui_GenericResp' )
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLSetArrayDetails')
	delete from GxQscripts where name = 'MM_SMXMLSetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLSetArrayDetails')
	delete from GXDBVersions where aliasname = 'MM_SMXMLSetArrayDetails'
GO

insert into GXDBVersions values(2, 'MM_SMXMLSetArrayDetails',  'v1.33.2.23.4.1', 'MM_SMXMLSetArrayDetails', 'v1.33.2.23.4.1')
GO

