

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLSetArrayController.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLSetArrayController.sp,v $ $Id: MM_SMXMLSetArrayController.sp,v 1.4.12.4 2018/03/19 23:59:41 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMXMLSetArrayController <<<'

IF EXISTS (select * from sysobjects where name='MM_SMXMLSetArrayController')
	drop procedure MM_SMXMLSetArrayController
IF EXISTS (select * from GxQscripts where name='MM_SMXMLSetArrayController')
	delete from GxQscripts where name = 'MM_SMXMLSetArrayController'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLSetArrayController')
	delete from GXDBVersions where aliasname = 'MM_SMXMLSetArrayController'
GO
print '... Creating Procedure: MM_SMXMLSetArrayController'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLSetArrayController
  @i_xmlTextInput XML,
  @i_arrayId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- MMSMSetArrayDetailsReq
DECLARE @copyId					INTEGER = 0
DECLARE @appId					INTEGER = 0
DECLARE @assocType				INTEGER = 0
DECLARE @add					INTEGER = 0
	-- MMSMSetArrayDetailsReq.MMSMArrayInfo
	DECLARE @vendorId				INTEGER = 0
	DECLARE @vendorName				NVARCHAR(128) = N''
	DECLARE @arrayId				INTEGER = 0
	DECLARE @clientId				INTEGER = 0
	DECLARE @arrayName				NVARCHAR(1024) = N''
	DECLARE @ctrlHostName			NVARCHAR(1024) = N''
	DECLARE @arrayFlags				INTEGER = 0
DECLARE @flags				INTEGER = 0
DECLARE @xmlResp			XML
-- Constants for Array Type
DECLARE @MMSM_ART_ARRAY			INTEGER = 0
DECLARE @MMSM_ART_DFM			INTEGER = 1
DECLARE @MMSM_ART_PRIMARY		INTEGER = 2
-- Constants for Vendor name
DECLARE @SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME NVARCHAR(64) = 'NetApp'
-- Constants for Assoc Type
DECLARE @MMSM_AT_NONE			INTEGER = 0
DECLARE @MMSM_AT_TEMPL			INTEGER = 1
DECLARE @MMSM_AT_VENDOR			INTEGER = 2
DECLARE @MMSM_AT_ARRAY			INTEGER = 3
DECLARE @MMSM_AT_CTRL_HOST		INTEGER = 4
DECLARE @MMSM_AT_SUBCLT_POLICY	INTEGER = 5
DECLARE @MMSM_AT_COPY			INTEGER = 6
DECLARE @MMSM_AT_CLIENT_GROUP	INTEGER = 7
DECLARE @MMSM_AT_CLIENT			INTEGER = 8
DECLARE @MMSM_AT_SUBCLIENT		INTEGER = 9
DECLARE @arrCtrlCountForPruning	INTEGER = 0
DECLARE @errorCode				INTEGER = 0
DECLARE	@userId INT
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMSetArrayDetailsReq/processinginstructioninfo/user') R ( ref )), 0)
-- Get the input parameters from the XML input str
SET @copyId = ISNULL ( ( SELECT R.ref.value('@copyId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @appId = ISNULL ( ( SELECT R.ref.value('@appId', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @assocType = ISNULL ( ( SELECT R.ref.value('@assocType', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), @MMSM_AT_ARRAY )
SET @add = ISNULL ( ( SELECT R.ref.value('@add', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq' ) R ( ref ) ), 1 )
SET @vendorId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/vendor' ) R ( ref ) ), 0 )
SET @vendorName = ISNULL ( ( SELECT R.ref.value('@name', 'NVARCHAR(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/vendor' ) R ( ref ) ), N'' )
SET @arrayId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/arrayName' ) R ( ref ) ), 0 )
SET @clientId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/client' ) R ( ref ) ), 0 )
SET @arrayName = ISNULL ( ( SELECT R.ref.value('@name', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info/arrayName' ) R ( ref ) ), N'' )
SET @ctrlHostName = ISNULL ( ( SELECT R.ref.value('@ctrlHostName', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
SET @arrayFlags = ISNULL ( ( SELECT R.ref.value('@flags', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/info' ) R ( ref ) ), N'' )
DECLARE @tblArrayControllers TABLE (
	arrayControllerId		INTEGER,
	mediaAgentId			INTEGER,
	assocId					INTEGER,
	assocType				INTEGER,
	arrOptions				INTEGER
)
DECLARE	@tblArrCtrlOpts TABLE(
	mediaAgentId			INTEGER,
	arrCtrlOptionId			INTEGER,
	arrCtrlOptionName		NVARCHAR(256),
	arrCtrlOptionEnabled	INTEGER
)
INSERT	INTO @tblArrayControllers
SELECT
		ISNULL ( ( R.ref.value('@arrayControllerId', 'INTEGER') ), 0 ),
		ISNULL ( (R.ref.value('(mediaAgent/@id)[1]','INTEGER') ),0),
		@arrayId,
		@MMSM_AT_ARRAY,
		0
FROM	@i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/selectedMAs' ) R ( ref )
INSERT	INTO @tblArrCtrlOpts
SELECT
		ISNULL ( (R.ref.value('(mediaAgent/@id)[1]','INTEGER') ),0),
		ISNULL ( ( R4.ref4.value('@id', 'INTEGER') ), 0 ),
		ISNULL ( ( R4.ref4.value('@name', 'NVARCHAR(510)') ), 0 ),
		ISNULL ( (R4.ref4.value('(../@isEnabled)[1]','INTEGER') ),0)
FROM	@i_xmlTextInput.nodes ( '/EVGui_MMSMSetArrayDetailsReq/selectedMAs' ) R ( ref )
		CROSS APPLY ref.nodes('./arrCtrlOptions/arrCtrlOption') R4 (ref4)
UPDATE	a
SET		arrOptions  = c.arrOpt
FROM	@tblArrayControllers a inner join
		(
		SELECT	b.mediaAgentId, SUM(DISTINCT b.arrCtrlOptionId) arrOpt
		FROM	@tblArrCtrlOpts b
		WHERE	b.arrCtrlOptionEnabled = 1
		GROUP BY b.mediaAgentId) c
		ON a.mediaAgentId = c.mediaAgentId
IF @add = 1
BEGIN
	INSERT INTO SMArrayController
	SELECT	@i_arrayId, mediaAgentId, @arrayId, @assocType,arrOptions,0
	FROM	@tblArrayControllers
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SELECT	@errorCode AS '@errorCode', 'Failed to add Array Controller info to DB' AS '@errorMessage'
		RETURN @errorCode
	END
END
ELSE -- Edit the existing array controller
BEGIN
	IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null DROP TABLE #tblMMS2GetMediaAgentsForUserResult
	CREATE TABLE #tblMMS2GetMediaAgentsForUserResult (clientId integer)
	DECLARE @retVal INTEGER = 0
	EXEC MMS2GetMediaAgentsForUser @userId
	-- Delete the array controllers only if the MA is visible to the user
	DELETE	AC
	FROM	SMArrayController AC
			INNER JOIN #tblMMS2GetMediaAgentsForUserResult MA ON AC.MMHostId = MA.clientId
	WHERE	AC.ArrayNum = @arrayId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SELECT	@errorCode AS '@errorCode', 'Failed to remove Array Controller info from DB' AS '@errorMessage'
		RETURN @errorCode
	END
	IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null DROP TABLE #tblMMS2GetMediaAgentsForUserResult
	INSERT INTO SMArrayController
	SELECT	@i_arrayId, mediaAgentId, @arrayId, @assocType,arrOptions,0
	FROM	@tblArrayControllers TMPAC
			LEFT JOIN SMArrayController AC ON AC.ArrayNum = @i_arrayId AND AC.MMHostId = TMPAC.mediaAgentId
	WHERE	AC.MMHostId IS NULL
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SELECT	@errorCode AS '@errorCode', 'Failed to insert Array Controller info to DB' AS '@errorMessage'
		RETURN @errorCode
	END
END
RETURN @errorCode
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLSetArrayController')
	delete from GxQscripts where name = 'MM_SMXMLSetArrayController'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLSetArrayController')
	delete from GXDBVersions where aliasname = 'MM_SMXMLSetArrayController'
GO

insert into GXDBVersions values(2, 'MM_SMXMLSetArrayController',  '00010004001200040000', 'MM_SMXMLSetArrayController', '00010004001200040000')
GO

