

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLGetVendorConfigs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLGetVendorConfigs.sp,v $ $Id: MM_SMXMLGetVendorConfigs.sp,v 1.11.12.6 2020/09/23 03:24:21 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMXMLGetVendorConfigs')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLGetVendorConfigs <<<'
	drop procedure MM_SMXMLGetVendorConfigs
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLGetVendorConfigs')
	delete from GxQscripts where name = 'MM_SMXMLGetVendorConfigs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetVendorConfigs')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetVendorConfigs'
GO
print '... Creating Procedure: MM_SMXMLGetVendorConfigs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLGetVendorConfigs
  @i_xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @vendorId				INTEGER = 0
DECLARE @vendorName				NVARCHAR(128) = N''
DECLARE @assocType				INTEGER = 0
DECLARE @arrCfgListEmpty NVARCHAR(1024) = N'##CV_SM_EMPTY_LIST##'
-- Get the input parameters from the XML input str
SET @vendorId = ISNULL ( ( SELECT R.ref.value('@id', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetVendorConfigListReq/vendor' ) R ( ref ) ), 0 )
SET @vendorName = ISNULL ( ( SELECT R.ref.value('@name', 'nvarchar(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetVendorConfigListReq/vendor' ) R ( ref ) ), N'' )
SET @assocType = ISNULL ( ( SELECT R.ref.value('@assocType', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetVendorConfigListReq' ) R ( ref ) ), 0 )
-- Constants for Config Value Type
DECLARE @MMSM_CT_NONE			INTEGER = 0
DECLARE @MMSM_CT_BOOL			INTEGER = 1
DECLARE @MMSM_CT_INT			INTEGER = 2
DECLARE @MMSM_CT_UINT			INTEGER = 3
DECLARE @MMSM_CT_LONG			INTEGER = 4
DECLARE @MMSM_CT_ULONG			INTEGER = 5
DECLARE @MMSM_CT_LONGLONG		INTEGER = 6
DECLARE @MMSM_CT_ULONGLONG		INTEGER = 7
DECLARE @MMSM_CT_STRING			INTEGER = 8
DECLARE @MMSM_CT_IP_ADDR		INTEGER = 9
DECLARE @MMSM_CT_LIST			INTEGER = 10
DECLARE @MMSM_CT_COMBO			INTEGER = 11
DECLARE @MMSM_CT_PSWD			INTEGER = 12
DECLARE @MMSM_CT_ENC_STRING		INTEGER = 13
-- Constants for Assoc Type
DECLARE @MMSM_AT_NONE			INTEGER = 0
DECLARE @MMSM_AT_TEMPL			INTEGER = 1
DECLARE @MMSM_AT_VENDOR			INTEGER = 2
DECLARE @MMSM_AT_ARRAY			INTEGER = 3
DECLARE @MMSM_AT_CTRL_HOST		INTEGER = 4
DECLARE @MMSM_AT_SUBCLT_POLICY	INTEGER = 5
DECLARE @MMSM_AT_COPY			INTEGER = 6
DECLARE @MMSM_AT_CLIENT_GROUP	INTEGER = 7
DECLARE @MMSM_AT_CLIENT			INTEGER = 8
DECLARE @MMSM_AT_SUBCLIENT		INTEGER = 9
-- Constants for SMMasterConfigs - ShowInGui column
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI				INTEGER = 0
DECLARE @SM_MASTERCONFIGS_SHOW_IN_GUI				INTEGER = 1
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_ARRAY		INTEGER = 2
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_COPY		INTEGER = 4
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_CLIENT		INTEGER = 8
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_SUBCLIENT	INTEGER = 16
DECLARE @ARRAY_CONFIGS_DEFAULT_VALUE_DELIM VARCHAR(10)= '#:SMCFG:#'
DECLARE @SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTES INT = 2 -- SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTES
IF @vendorId = @MMSM_AT_NONE
BEGIN
	SELECT @vendorId = Id FROM SMVendor (READUNCOMMITTED) WHERE Name = @vendorName
END
ELSE IF @vendorName = N''
BEGIN
	SELECT @vendorName = name FROM SMVendor (READUNCOMMITTED) WHERE Id = @vendorId
END
IF @assocType = @MMSM_AT_NONE
BEGIN
	SET @assocType = @MMSM_AT_ARRAY
END
-- Local Variables
DECLARE @tblVendorConfig TABLE (
							configId				INTEGER,
							configName				NVARCHAR(256),
							configType				INTEGER,
							value					NVARCHAR(MAX),
							isEnabled				INTEGER,
							orderId					INTEGER,
							flags					INTEGER )
DECLARE @assocTypeMCFlag INT = 0
SET @assocTypeMCFlag =	 CASE @assocType
						WHEN @MMSM_AT_ARRAY THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_ARRAY
						WHEN @MMSM_AT_COPY THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_COPY
						WHEN @MMSM_AT_CLIENT THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_CLIENT
						WHEN @MMSM_AT_SUBCLIENT THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_SUBCLIENT
						ELSE 0 END
INSERT	INTO @tblVendorConfig
SELECT	DISTINCT MC.Id, MC.Name, MC.Type,
		( CASE
			WHEN MC.Type = @MMSM_CT_BOOL THEN
				( CASE WHEN MC.DefaultInt = 0 THEN N'false' ELSE N'true' END )
			WHEN MC.Type = @MMSM_CT_INT THEN CONVERT ( NVARCHAR(1024), MC.DefaultInt )
			WHEN MC.Type = @MMSM_CT_UINT THEN CONVERT ( NVARCHAR(1024), MC.DefaultInt )
			WHEN MC.Type = @MMSM_CT_LONG THEN CONVERT ( NVARCHAR(1024), MC.DefaultLL )
			WHEN MC.Type = @MMSM_CT_ULONG THEN CONVERT ( NVARCHAR(1024), MC.DefaultLL )
			WHEN MC.Type = @MMSM_CT_LONGLONG THEN CONVERT ( NVARCHAR(1024), MC.DefaultLL )
			WHEN MC.Type = @MMSM_CT_ULONGLONG THEN CONVERT ( NVARCHAR(1024), MC.DefaultLL )
			WHEN MC.Type = @MMSM_CT_STRING THEN MC.DefaultStr
			WHEN MC.Type = @MMSM_CT_IP_ADDR THEN MC.DefaultStr
			WHEN MC.Type = @MMSM_CT_PSWD THEN MC.DefaultStr
			WHEN MC.Type = @MMSM_CT_ENC_STRING THEN MC.DefaultStr
			WHEN MC.Type = @MMSM_CT_LIST THEN (	SELECT	0 as '@id', VAL.Data as '@name'
												FROM dbo.SplitStringMaxLen( MC.DefaultStr,@ARRAY_CONFIGS_DEFAULT_VALUE_DELIM) VAL
												WHERE MC.DefaultStr <> @arrCfgListEmpty
												FOR XML PATH ('values'))
		END ),
		MC.IsValid, MC.OrderNum, MC.Flags
FROM	SMVendor VEN WITH (NOLOCK) INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON VEN.Id = MC.VendorId
WHERE	VEN.Name = @vendorName
		AND ( MC.ShowInGUI & @SM_MASTERCONFIGS_SHOW_IN_GUI = 1 )
		AND ( MC.ShowInGUI & @assocTypeMCFlag = 0 )
DECLARE @xmlConfigList				XML
SET	@xmlConfigList = (
	SELECT	configId AS '@masterConfigId',
			configType AS '@type',
			(CASE WHEN configType <> @MMSM_CT_LIST THEN value END) AS '@value',
			isEnabled AS '@isEnabled',
			ISNULL(SMP.ValueStr,'') as '@notes',
			flags AS '@flags',
			0 AS 'name/@id',
			configName AS 'name/@name',
			(CASE WHEN configType = @MMSM_CT_LIST THEN CONVERT(XML,value) END)
	FROM	@tblVendorConfig
			LEFT JOIN SMParam SMP ON SMP.KeyEntity = @SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTES AND configId = CAST(SMP.KeyName AS INTEGER)
	ORDER BY orderId
	FOR XML PATH ( 'configList' )
)
DECLARE @xmlConfigs				XML
SET	@xmlConfigs = (
	SELECT	@MMSM_AT_VENDOR AS '@assocType', @xmlConfigList
	FOR XML PATH ( 'configs' )
)
DECLARE @outXML XML
SET @outXML = (
					SELECT	@vendorId AS 'vendor/@id',
							@vendorName AS 'vendor/@name',
							@xmlConfigs
					FOR XML PATH ( 'EVGui_MMSMGetVendorConfigListResp' )
				)
SELECT @outXML
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLGetVendorConfigs')
	delete from GxQscripts where name = 'MM_SMXMLGetVendorConfigs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetVendorConfigs')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetVendorConfigs'
GO

insert into GXDBVersions values(2, 'MM_SMXMLGetVendorConfigs',  '00010011001200060000', 'MM_SMXMLGetVendorConfigs', '00010011001200060000')
GO

