

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLGetSnapEngines.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMXMLGetSnapEngines')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLGetSnapEngines <<<'
	drop procedure MM_SMXMLGetSnapEngines
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLGetSnapEngines')
	delete from GxQscripts where name = 'MM_SMXMLGetSnapEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetSnapEngines')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetSnapEngines'
GO
print '... Creating Procedure: MM_SMXMLGetSnapEngines'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLGetSnapEngines
  @i_xmlTextInput XML,
  @i_enableNativeSnapEngine INT
AS
  DECLARE @engineId INT
  DECLARE @engineName NVARCHAR(256)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @NativeSnapVendorName VARCHAR(64) = 'Native' /*SM_SNAPSHOT_ENGINE_NATIVE_NAME*/
DECLARE @tblSnapShotEngine TABLE
(
	SnapShotEngineId	INT,
	SnapEngineName		NVARCHAR(256),
	SnapVendorName		NVARCHAR(256)
)
DECLARE @i_AppTypeId INT = 0
DECLARE @i_AppId INT = 0
DECLARE @i_InstanceId INT = 0
DECLARE @i_VendorId INT = 0
DECLARE @virtualServerInstanceType INT = 0
DECLARE @multiStorageEnabled INT = 0
DECLARE @snapVendorName NVARCHAR(128) = N''
DECLARE @bIsNasClient INT = 0
SET @i_AppTypeId = ISNULL(( SELECT R.ref.value('@applicationId', 'int') FROM @i_xmlTextInput.nodes('/EVGui_GetSnapShotEngineReq/subClientInfo') R(ref)), 0)
SET @i_InstanceId = ISNULL(( SELECT R.ref.value('@instanceId', 'int') FROM @i_xmlTextInput.nodes('/EVGui_GetSnapShotEngineReq/subClientInfo') R(ref)), 0)
SET @i_AppId = ISNULL(( SELECT R.ref.value('@subclientId', 'int') FROM @i_xmlTextInput.nodes('/EVGui_GetSnapShotEngineReq/subClientInfo') R(ref)), 0)
SET @i_VendorId = ISNULL(( SELECT R.ref.value('@id', 'int') FROM @i_xmlTextInput.nodes('/EVGui_GetSnapShotEngineReq/vendor') R(ref)), 0)
-- Admin Console will send subclientId only
If @i_AppId > 0
BEGIN
	IF @i_AppTypeId = 0
		SET @i_AppTypeId = ISNULL( (SELECT appTypeId FROM APP_Application WITH(NOLOCK) WHERE id = @i_AppId), 0)
	IF @i_InstanceId = 0
		SET @i_InstanceId = ISNULL( (SELECT instance FROM APP_Application WITH(NOLOCK) WHERE id = @i_AppId), 0)
END
-- For NAS clients see if we can limit the list to only the one vendor that applies.
-- A NAS client can have the NDMP, Windows FS, or Linux FS agent inder it
IF (@i_VendorId = 0) AND (@i_AppTypeId IN (13, 33, 29))
BEGIN
	DECLARE @i_ClientId INT = 0
	SET @i_ClientId = ISNULL(( SELECT R.ref.value('@clientId', 'int') FROM @i_xmlTextInput.nodes('/EVGui_GetSnapShotEngineReq/subClientInfo') R(ref)), 0)
	IF (@i_ClientId = 0) AND (@i_AppId > 0)
		SET @i_ClientId = ISNULL( (SELECT clientId FROM APP_Application WITH(NOLOCK) WHERE id = @i_AppId), 0)
IF (@i_AppTypeId = 13)
		SET @bIsNasClient = 1
	IF @i_ClientId > 0
	BEGIN
		DECLARE @i_NasOS INT = 0
		SET @i_NasOS = (SELECT ISNULL(CONVERT(INT, attrVal), 0)
		                FROM APP_ClientProp WITH(NOLOCK)
		                WHERE componentNameid = @i_ClientId AND attrName = N'NAS OS Type' AND modified = 0)
		-- Set bIsNasClient. Could also check the APP_Client simOperatingSystemId in (SIM_ID_NAS_OS, SIM_ID_EMC_CELERRA_OS, SIM_ID_GENERIC_FILER_OS, SIM_ID_BLUEARC_FILER_OS, SIM_ID_HITACHI_ENAS_OS) - 16,17,19,29,45
		-- If we already know it is a NAS client do not do this query since we don't want to go to the APP_Client table if not needed
		IF (@bIsNasClient = 0) AND
		    EXISTS (SELECT 1 FROM APP_Client WITH(NOLOCK)
WHERE (id = @i_ClientId) AND (status & (CAST(0x0080 AS BIGINT) | CAST(0x8000000 AS BIGINT)) <> 0))
			SET @bIsNasClient = 1
		SET @i_VendorId =
			CASE
WHEN (@i_NasOS = 2)  THEN 3
WHEN (@i_NasOS = 18)  THEN 11
WHEN (@i_NasOS = 33)   THEN 31
WHEN (@i_NasOS = 9) THEN 33
WHEN (@i_NasOS = 32)  THEN 21
				-- No need to do Nutanix
				-- * Code below removes the Nutanix engine from the returned list for all agents other than VMware and Hyper-V
				-- * The Nutanix client and subclients do not have an IntelliSnap option - so will not be displaying an engine list
-- WHEN (@i_NasOS = 34) THEN 26
				ELSE 0
			END;
	END
END
IF( @i_VendorId > 0)
BEGIN
	SELECT @snapVendorName = Name FROM SMVendor (READUNCOMMITTED) WHERE Id = @i_VendorId
END
-- If the instance is VSA, then get the virtual server instance type
IF @i_AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/
BEGIN
	SET @virtualServerInstanceType = ISNULL( (select attrVal FROM APP_InstanceProp WITH(NOLOCK) WHERE attrName ='Virtual Server Instance Type' AND modified =0 and componentNameId = @i_InstanceId), 0)
END
/*101 - 'VMWare'
  102 - 'Hyper V'
  301 - 'Amazon'
  401 - 'Azure'
  601 - 'Nutanix'*/
--Fetch all the engines that are visible
INSERT INTO @tblSnapShotEngine
SELECT	SnapShotEngineId, SnapEngineName, SnapVendorName
FROM	SMSnapShotEngine (NOLOCK)
WHERE	(SnapShotEngineFlags & 1 /*SM_SNAPSHOT_ENGINE_FLAGS_HIDDEN*/ ) = 0
		AND ( LEN(@snapVendorName) = 0 OR (SnapVendorName = @snapVendorName) )
-- If the flag @i_enableNativeSnapEngine is set to 0, then remove the native snap engines.
IF @i_enableNativeSnapEngine = 0
BEGIN
	DELETE FROM @tblSnapShotEngine
	WHERE SnapVendorName = @NativeSnapVendorName
END
/*App-Aware Snap engine (Virtual Server Application Snap):
-	Should be shown only for non-VSA subclients like SQL, Exchange, Oracle, Share-Point, FS, etc
-	Shouldn’t be shown for any VSA subclients – instance type doesn’t matter – all VSA instances (VMware / Nutanix / HyperV / AWS / Azure) shouldn’t have this engine
*/
-- Check the AppTypeId for the VSA SubClient, And do not show VSA-AppAware Snap engine for VSA SubClient
IF @i_AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/
BEGIN
DELETE FROM @tblSnapShotEngine WHERE SnapShotEngineId = 48 /*SM_SNAPSHOT_ENGINE_VSA*/
END
/*
VVOL engine (Virtual Server Agent Snap):
-	Should be shown currently for VMware, Hyper-V, Nutanix and Azure instances
-	Shouldn’t be shown for any non-VSA subclients
*/
-- Check the instance property for the HyperVisor type, For non-VMWare / Nutanix, do not show VVOL engines
-- Should be shown currently for VMware, Hyper-V, Nutanix and Azure instances
IF (@i_AppTypeId <> 0) AND @virtualServerInstanceType NOT IN (101 /*VMWare*/, 102 /*Hyper-V*/,601 /*Nutanix*/, 401 /*Azure*/, 402 /*Azure RM*/, 403 /*Azure Stack*/)
	BEGIN
DELETE FROM @tblSnapShotEngine WHERE SnapShotEngineId IN (58, 59) /*SM_SNAPSHOT_ENGINE_VSA_VVOL_SNAP,SM_SNAPSHOT_ENGINE_VSA_VVOL_CLONE*/
	END
--Show the Nutanix snap engine only for VMware and Hyper-V
IF @virtualServerInstanceType <> 101 /*APP_VIRTSERV_VIRTUAL_CENTER*/ AND @virtualServerInstanceType <> 102 /*APP_VIRTSERV_MS_VIRTUAL_SERVER*/
BEGIN
DELETE FROM @tblSnapShotEngine WHERE SnapShotEngineId IN (55, 56) /*SM_SNAPSHOT_ENGINE_NUTANIX_SNAP,SM_SNAPSHOT_ENGINE_NUTANIX_CLONE*/
END
/*
Make Auto Discover Engines Visible only if MMConfig: MMCONFIG_SHOW_MULTI_STORAGE is set
*/
SET @multiStorageEnabled = ISNULL( (SELECT  value FROM MMConfigs WITH(NOLOCK) WHERE name='MMCONFIG_SHOW_MULTI_STORAGE'), 1)
IF @multiStorageEnabled = 0
BEGIN
	DELETE FROM @tblSnapShotEngine
WHERE SnapShotEngineId IN (23,24)/*SM_SNAPSHOT_ENGINE_AUTO_SNAP,SM_SNAPSHOT_ENGINE_AUTO_CLONE*/
END
-- NDMP, CIFS, and NFS do not support Huawei Clone - it is only applicable to block storage which would be for the client mounting the block storage
-- So for NAS clients we never want to have the Huawei clone engine for any agent
-- For non-NAS clients it is possible to put CIFS or NFS mounts in the content, but at this time in this SP we are not going to try to determine if the content is block storage
IF @bIsNasClient = 1
BEGIN
DELETE FROM @tblSnapShotEngine WHERE SnapShotEngineId = 40
END
--Return the list of the snap engines
SELECT SnapShotEngineId, SnapEngineName FROM @tblSnapShotEngine ORDER BY SnapEngineName
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLGetSnapEngines')
	delete from GxQscripts where name = 'MM_SMXMLGetSnapEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetSnapEngines')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetSnapEngines'
GO

insert into GXDBVersions values(2, 'MM_SMXMLGetSnapEngines',  '00000000000000000000', 'MM_SMXMLGetSnapEngines', '00000000000000000000')
GO

