

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLGetArrays.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLGetArrays.sp,v $ $Id: MM_SMXMLGetArrays.sp,v 1.11.2.9 2020/09/23 03:09:35 duncan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMXMLGetArrays')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLGetArrays <<<'
	drop procedure MM_SMXMLGetArrays
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLGetArrays')
	delete from GxQscripts where name = 'MM_SMXMLGetArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrays')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrays'
GO
print '... Creating Procedure: MM_SMXMLGetArrays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLGetArrays
  @i_xmlTextInput XML OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- XML Input Parameters
DECLARE @i_vendorId				INTEGER = 0
DECLARE @i_vendorName			NVARCHAR(128) = N''
DECLARE @i_arrayId				INTEGER = 0
DECLARE @i_arrayName			NVARCHAR(1024) = N''
DECLARE @i_copyId				INTEGER = 0
DECLARE @i_appId				INTEGER = 0
DECLARE @i_flags				INTEGER = 0
DECLARE @i_userId				INTEGER = 0
DECLARE @i_clientId				INTEGER = 0
DECLARE @i_isNestedCall			INTEGER = 0
-- Get the input parameters from the XML input str
SET @i_vendorId = ISNULL ( ( SELECT R.ref.value('@id', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq/vendor' ) R ( ref ) ), 0 )
SET @i_vendorName = ISNULL ( ( SELECT R.ref.value('@name', 'nvarchar(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq/vendor' ) R ( ref ) ), N'' )
SET @i_arrayId = ISNULL ( ( SELECT R.ref.value('@id', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq/array' ) R ( ref ) ), 0 )
SET @i_arrayName = ISNULL ( ( SELECT R.ref.value('@name', 'nvarchar(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq/array' ) R ( ref ) ), N'' )
SET @i_copyId = ISNULL ( ( SELECT R.ref.value('@copyId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq' ) R ( ref ) ), 0 )
SET @i_appId = ISNULL ( ( SELECT R.ref.value('@appId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq' ) R ( ref ) ), 0 )
SET @i_flags = ISNULL ( ( SELECT R.ref.value('@flags', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq' ) R ( ref ) ), 0 )
SET @i_userId = ISNULL ( ( SELECT R.ref.value('@userId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq' ) R ( ref ) ), 0 )
SET @i_clientId = ISNULL ( ( SELECT R.ref.value('@clientId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayListReq' ) R ( ref ) ), 0 )
SET @i_isNestedCall = ISNULL ( ( SELECT R.ref.value('@isNestedCall', 'integer') FROM @i_xmlTextInput.nodes ( '//EVGui_MMSMGetArrayListReq/processinginstructioninfo' ) R ( ref ) ), 0 )
-- Constants for Associated Array
DECLARE	@MMSM_AIT_AVAILABLE INTEGER = 0
DECLARE	@MMSM_AIT_ASSOCIATED INTEGER = 1
DECLARE @tblArrays TABLE (
					vendorId					INTEGER,
					vendorName					NVARCHAR(128),
					arrayId						INTEGER,
					arrayName					NVARCHAR(1024),
					ctrlHostName				NVARCHAR(1024),
					userName					NVARCHAR(1024),
					isEnabled					INTEGER,
					offlineReason				NVARCHAR(1024),
					arrayType					INTEGER,
					description					NVARCHAR(1024),
					arrayInfoType				INTEGER,
					flags						INTEGER,
					credentialId				INTEGER,
					clientId					INTEGER)
DECLARE	@filteredMode INTEGER = 1
IF @i_copyId > 0
BEGIN
	SELECT	@i_copyId = defaultSnapCopy FROM archGroup WHERE id = @i_copyId
END
IF @i_vendorName = N'' AND @i_arrayId = 0 AND @i_arrayName = N'' AND @i_copyId = 0 AND @i_appId = 0 AND @i_clientId = 0
BEGIN
	SET		@filteredMode = 0
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId > 0
END
ELSE IF @i_appId > 0
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, CH.SnapVendorName, CH.ControlHostId, CH.SMArrayId, CH.SMHostName, CH.SMHostUserName, CH.SMHostStatus, CH.SMHostIP, CH.SMHostFlags, CH.SMHostDescription, @MMSM_AIT_ASSOCIATED, 0, CH.CredentialId, CH.ClientId
	FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMControlHost CH WITH (NOLOCK) ON SNAP.ControlHostId = CH.ControlHostId
	WHERE	VOL.AppId = @i_appId AND SNAP.ControlHostId > 0
END
ELSE IF @i_copyId > 0
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, CH.SnapVendorName, CH.ControlHostId, CH.SMArrayId, CH.SMHostName, CH.SMHostUserName, CH.SMHostStatus, CH.SMHostIP, CH.SMHostFlags, CH.SMHostDescription, @MMSM_AIT_ASSOCIATED, 0, CH.CredentialId, CH.ClientId
	FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMControlHost CH WITH (NOLOCK) ON SNAP.ControlHostId = CH.ControlHostId
	WHERE	VOL.CopyId = @i_copyId AND SNAP.ControlHostId > 0
END
ELSE IF @i_clientId > 0
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_ASSOCIATED, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId > 0 AND ClientId = @i_clientId
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, CH.SnapVendorName, CH.ControlHostId, CH.SMArrayId, CH.SMHostName, CH.SMHostUserName, CH.SMHostStatus, CH.SMHostIP, CH.SMHostFlags, CH.SMHostDescription, @MMSM_AIT_ASSOCIATED, 0, CH.CredentialId, CH.ClientId
	FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMControlHost CH WITH (NOLOCK) ON SNAP.ControlHostId = CH.ControlHostId
			INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = VOL.AppId
	WHERE	SNAP.ControlHostId > 0 AND APP.clientId = @i_clientId
END
ELSE IF @i_arrayName <> N''
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	SMArrayId = @i_arrayName
END
ELSE IF @i_arrayId > 0
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId = @i_arrayId
END
ELSE IF @i_vendorName <> N''
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId > 0
			AND SnapVendorName = @i_vendorName
END
-- For the new subclient creation
ELSE IF @i_appId = -1
BEGIN
	INSERT	INTO @tblArrays
	SELECT	0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CredentialId, ClientId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId > 0
END
IF (@i_copyId > 0 OR @i_appId > 0  OR @i_clientId > 0) AND (@i_vendorName = N'' AND @i_arrayId = 0)
BEGIN
	INSERT	INTO @tblArrays
	SELECT	DISTINCT 0, CH.SnapVendorName, CH.ControlHostId, CH.SMArrayId, CH.SMHostName, CH.SMHostUserName, CH.SMHostStatus, CH.SMHostIP, CH.SMHostFlags, CH.SMHostDescription, @MMSM_AIT_AVAILABLE, 0, CH.CredentialId, CH.ClientId
	FROM	SMControlHost CH WITH (NOLOCK) LEFT OUTER JOIN @tblArrays ARR ON CH.ControlHostId = ARR.arrayId
	WHERE	CH.ControlHostId > 0
			AND ARR.arrayId IS NULL
END
DECLARE @tblUserCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
DECLARE @capRight INTEGER = 1 -- EV_SCHEDULE_ADMIN
DECLARE @commCellId INTEGER = 2 -- DEFAULT_COMM_CELL_ID
DECLARE @arrayItem INTEGER = 9615 -- ARRAY_ITEM
DECLARE @array_Id INTEGER
IF OBJECT_ID('tempdb.dbo.#tblArrayWithRight') IS NOT NULL
	DROP TABLE #tblArrayWithRight
CREATE TABLE #tblArrayWithRight (arrayId INT)
IF OBJECT_ID('tempdb.dbo.#associatedMMArrayEntitiesWithCapability') IS NOT null
   DROP TABLE #associatedMMArrayEntitiesWithCapability
EXEC sec_updateUserCredentials @i_userId
create table  #associatedMMArrayEntitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, @arrayItem, 0, '#associatedMMArrayEntitiesWithCapability'
IF  NOT EXISTS (SELECT * FROM sys.objects
	WHERE object_id = OBJECT_ID(N'tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') AND type in (N'U'))
	BEGIN
		CREATE TABLE #getNonIdaObjects_InputPermissionsTbl (permissionId    INT)
	END
INSERT INTO #getNonIdaObjects_InputPermissionsTbl VALUES(244)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl VALUES(245)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 153, -1, '#tblArrayWithRight'
INSERT INTO #tblArrayWithRight
SELECT Tbl.arrayId FROM @tblArrays Tbl
inner join #associatedMMArrayEntitiesWithCapability sec
on ( sec.arrayId = Tbl.arrayId OR
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
and (sec.capabilities & CAST(POWER(2.0, @capRight - 1) AS bigint))<>0
-- Delete arrays the user cannot access
DELETE FROM @tblArrays WHERE arrayId NOT IN (SELECT arrayId FROM #tblArrayWithRight)
-- If the flag is set to send only NetApp SVM Arrays, then remove all non-netapp arrays.
IF (@i_flags & 1 > 0)
BEGIN
DELETE FROM @tblArrays WHERE vendorName <> 'NetApp' OR (arrayType & 8 = 0)
	-- If the name is set in the hidden Snap config, then read the name from there.
	UPDATE	A
	SET		arrayName = CFG.ValueStr
	FROM	@tblArrays A
INNER JOIN SMConfigs CFG (NOLOCK) ON A.arrayId = CFG.ArrayId AND CFG.AssocType = 3
WHERE	CFG.MasterConfigId = 200
			AND LEN(CFG.ValueStr) > 0
END
-- Get arrays only for deconfigured clients. This flag is used when adding a NAS client from Command Center.
-- The array is added first, then the client is added for the array - and it provides a list of arrays that can have a client added.
IF (@i_flags & 2 = 2)
BEGIN
	DELETE TblA FROM  @tblArrays TblA
	INNER JOIN APP_Client AC (NOLOCK) ON TblA.clientId = AC.id
WHERE TblA.clientId <= 2 OR (AC.status & 0x00002 = 0)
END
--set userName as credential name if credentials are stored in credential manager
UPDATE	A
SET		userName = Creds.credentialName
FROM 	@tblArrays A
		INNER JOIN APP_CredentialAssoc Assoc WITH (NOLOCK) ON A.credentialId = Assoc.assocId
		INNER JOIN APP_Credentials Creds WITH (NOLOCK) ON Assoc.credentialId = Creds.credentialId
DECLARE @xmlArrayList XML
SET @xmlArrayList = (
		SELECT	DISTINCT
				ctrlHostName			AS '@ctrlHostName',
				description				AS '@description',
				-- (CASE WHEN isEnabled = 1 THEN N'true' ELSE N'false' END) AS '@isEnabled',
				isEnabled				AS '@isEnabled',
				offlineReason			AS '@offlineReason',
				(arrayType & 3)			AS '@arrayType',
				arrayInfoType			AS '@arrayInfoType',
				flags					AS '@flags',
				vendorId				AS 'vendor/@id',
				vendorName				AS 'vendor/@name',
				arrayId					AS 'arrayName/@id',
				arrayName				AS 'arrayName/@name',
				userName				AS 'userPswd/@userName'
		FROM	@tblArrays
		FOR XML PATH ( 'arrayList' )
)
declare @outputXml xml
set @outputXml = (SELECT
		@i_copyId AS '@copyId',
		@i_appId AS '@appId',
		@i_vendorId  AS 'vendor/@id',
		@i_vendorName  AS 'vendor/@name',
		@i_arrayId  AS 'array/@id',
		@i_arrayName  AS 'array/@name',
		@xmlArrayList
FOR XML PATH ( 'EVGui_MMSMGetArrayListResp' ))
IF OBJECT_ID('tempdb.dbo.#tblArrayWithRight') IS NOT NULL
	DROP TABLE #tblArrayWithRight
if @i_isNestedCall=0
begin
	select @outputXml
	return
end
set @i_xmlTextInput = @outputXml
return
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLGetArrays')
	delete from GxQscripts where name = 'MM_SMXMLGetArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrays')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrays'
GO

insert into GXDBVersions values(2, 'MM_SMXMLGetArrays',  '00010011000200090000', 'MM_SMXMLGetArrays', '00010011000200090000')
GO

