

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLGetArrayVendors.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLGetArrayVendors.sp,v $ $Id: MM_SMXMLGetArrayVendors.sp,v 1.7.12.10 2020/10/27 17:29:10 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMXMLGetArrayVendors')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLGetArrayVendors <<<'
	drop procedure MM_SMXMLGetArrayVendors
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLGetArrayVendors')
	delete from GxQscripts where name = 'MM_SMXMLGetArrayVendors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrayVendors')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrayVendors'
GO
print '... Creating Procedure: MM_SMXMLGetArrayVendors'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLGetArrayVendors
  @i_xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblVendors TABLE (
					Id						INTEGER,
					name					NVARCHAR(128),
					capabilityFlag			bigint,
					enableName				INTEGER,
					enableControlHost		INTEGER,
					enableArrayType			INTEGER,
					enableArrayDG			INTEGER,
					enableHostDG			INTEGER,
					enableArrayNameChange	INTEGER,
					guiDefault				INTEGER)
DECLARE @tblArrCtrlOps TABLE (
					vendorName				NVARCHAR(128),
					arrCtrlOptionId			INTEGER,
					arrCtrlOptionName		NVARCHAR(128),
					isEnabled				INTEGER)
DECLARE @tblLabelNames TABLE (
    vendorId  INT DEFAULT 0,
arrayNameLabel NVARCHAR(255) DEFAULT N'',
arrayControlHostLabel NVARCHAR(255) DEFAULT N'',
arrayUserNameLabel NVARCHAR(255) DEFAULT N'',
arrayPasswordLabel NVARCHAR(255) DEFAULT N''
)
DECLARE	@userId INT
DECLARE @localeId INT = 0
DECLARE @availableMAs			XML
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMGetArrayVendorListReq/processinginstructioninfo/user') R ( ref )), 0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMGetArrayVendorListReq/processinginstructioninfo/locale') R ( ref )), 0)
INSERT	INTO @tblVendors
SELECT	MAX(VEN.Id), VEN.Name, (MAX(capabilities)|MIN(capabilities)),
		-- enableName
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 16 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_ARRAYID*/) > 0 THEN 1 ELSE 0 END),
		-- enableControlHost
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 32 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_CTRL_HOST*/) > 0 THEN 1 ELSE 0 END),
		-- enableArrayType
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 256 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_ARRAYTYPE*/) > 0 THEN 1 ELSE 0 END),
		-- enableArrayDG
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 64 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_DEVICE_GRP*/) > 0 THEN 1 ELSE 0 END),
		-- enableHostDG
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 512 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_HOST_DEVICE_GRP*/) > 0 THEN 1 ELSE 0 END),
		-- enableArrayNameChange
( CASE WHEN ((MAX(capabilities)|MIN(capabilities)) & 1024 /*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_ALLOW_ARRAY_NAME_CHANGE*/) > 0 THEN 1 ELSE 0 END),
		MAX(GUIDefault)
FROM	SMSnapShotEngine ENG WITH (NOLOCK)
INNER JOIN SMVendor VEN WITH (NOLOCK) on VEN.Name = ENG.SnapVendorName
WHERE	ENG.SnapShotEngineId > 0
AND VEN.ShowInGUI = 1 /*SM_VENDOR_SHOW_IN_GUI*/
GROUP BY	VEN.Name
INSERT INTO @tblArrCtrlOps
SELECT		VEN.name, CAST(SMP.keyName AS INT) , SMP.valueStr,
			CASE WHEN ( VEN.guiDefault & CAST( SMP.KeyName AS INTEGER) > 0) THEN 1 ELSE 0 END
FROM		@tblVendors VEN, SMParam (NOLOCK) SMP
WHERE		SMP.KeyEntity = 1 AND SMP.KeyName in ('262144'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/,
														'524288'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_ARRAY_REPORTING*/,
														'1048576'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_REMOTE_SNAP_MA*/,
														'2097152'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_RECON_SNAP*/)
			AND VEN.capabilityFlag & CAST( SMP.KeyName as integer) > 0
-- Call the SP MMS2GetMediaAgentsForUser for getting MA's that are visible to current user
IF @userId > 0
BEGIN
	IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') IS NOT NULL DROP TABLE #tblMMS2GetMediaAgentsForUserResult
	CREATE TABLE #tblMMS2GetMediaAgentsForUserResult (clientId integer)
	DECLARE @retVal INTEGER = 0
	EXEC MMS2GetMediaAgentsForUser @userId
	SET @availableMAs = (
		SELECT		0 as '@arrayControllerId',
					CLNT.id AS 'mediaAgent/@id', CLNT.name AS 'mediaAgent/@name'
		FROM		#tblMMS2GetMediaAgentsForUserResult MA
					INNER JOIN	APP_Client CLNT (NOLOCK) ON MA.clientId = CLNT.id
		WHERE		CLNT.id > 1
		ORDER BY CLNT.name
		FOR	XML PATH ('availableMAs') )
	IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null DROP TABLE #tblMMS2GetMediaAgentsForUserResult
END
INSERT INTO @tblLabelNames
SELECT  VEN.Id, ISNULL(LM1.Message, N''), ISNULL(LM2.Message, N''), ISNULL(LM3.Message, N''), ISNULL(LM4.Message, N'')
FROM    SMVendor VEN WITH (READUNCOMMITTED)
        LEFT JOIN EvLocaleMsgs LM1 WITH (READUNCOMMITTED) ON VEN.ArrayNameLabelMsgId = LM1.MessageID AND LM1.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM2 WITH (READUNCOMMITTED) ON VEN.ArrayControlHostLabelMsgId = LM2.MessageID AND LM2.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM3 WITH (READUNCOMMITTED) ON VEN.ArrayUserNameLabelMsgId = LM3.MessageID AND LM3.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM4 WITH (READUNCOMMITTED) ON VEN.ArrayPasswordLabelMsgId = LM4.MessageID AND LM4.LocaleID = @localeId
WHERE   VEN.ShowInGUI = 1
DECLARE @vendorList				XML
SET @vendorList = (
					SELECT
							VEN.capabilityFlag  AS '@capabilityFlag',
							TLN.arrayNameLabel AS '@arrayNameLabel',
							TLN.arrayControlHostLabel AS '@arrayControlHostLabel',
							TLN.arrayUserNameLabel AS '@arrayUserNameLabel',
							TLN.arrayPasswordLabel AS '@arrayPasswordLabel',
							VEN.Id AS 'vendor/@id',
							VEN.name AS 'vendor/@name',
							VEN.enableName AS 'capabilities/@enableName',
							VEN.enableControlHost AS 'capabilities/@enableControlHost',
							1 AS 'capabilities/@enableUserName',
							1 AS 'capabilities/@enablePassword',
							VEN.enableArrayType AS 'capabilities/@enableArrayType',
							VEN.enableArrayDG AS 'capabilities/@enableArrayDG',
							VEN.enableHostDG AS 'capabilities/@enableHostDG',
							VEN.enableArrayNameChange AS 'capabilities/@enableArrayNameChange',
							(	SELECT 	isEnabled AS '@isEnabled',
										arrCtrlOptionId AS 'arrCtrlOption/@id', arrCtrlOptionName AS 'arrCtrlOption/@name'
								FROM	@tblArrCtrlOps
								WHERE	vendorName = name
								ORDER BY arrCtrlOptionId
								FOR XML PATH('arrCtrlopts'), TYPE
							)
					FROM	@tblVendors VEN
					INNER JOIN @tblLabelNames TLN ON VEN.Id = TLN.vendorId
					FOR XML PATH ( 'vendorList' ) )
DECLARE @outXML XML
SET @outXML = (
				SELECT	@vendorList,
						@availableMAs
				FOR XML PATH ( 'EVGui_MMSMGetArrayVendorListResp' )
				)
SELECT @outXML
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLGetArrayVendors')
	delete from GxQscripts where name = 'MM_SMXMLGetArrayVendors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrayVendors')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrayVendors'
GO

insert into GXDBVersions values(2, 'MM_SMXMLGetArrayVendors',  '00010007001200100000', 'MM_SMXMLGetArrayVendors', '00010007001200100000')
GO

