

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLGetArrayDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLGetArrayDetails.sp,v $ $Id: MM_SMXMLGetArrayDetails.sp,v 1.21.2.19 2020/10/30 18:27:19 mmani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMXMLGetArrayDetails')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLGetArrayDetails <<<'
	drop procedure MM_SMXMLGetArrayDetails
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLGetArrayDetails')
	delete from GxQscripts where name = 'MM_SMXMLGetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrayDetails')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrayDetails'
GO
print '... Creating Procedure: MM_SMXMLGetArrayDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMXMLGetArrayDetails
  @i_xmlTextInput XML,
  @i_userId INT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- XML Input Parameters
DECLARE @vendorId				INTEGER = 0
DECLARE @vendorName			NVARCHAR(128) = N''
DECLARE @arrayId				INTEGER = 0
DECLARE @arrayName			NVARCHAR(1024) = N''
DECLARE @copyId					INTEGER = 0
DECLARE @appId					INTEGER = 0
DECLARE @assocType			INTEGER = 0
DECLARE @flags				INTEGER = 0
DECLARE @clientId			INTEGER = 0
DECLARE @mountHostId		INTEGER = 0
-- Constants for Associated Array
DECLARE	@MMSM_AIT_AVAILABLE INTEGER = 0
DECLARE	@MMSM_AIT_ASSOCIATED INTEGER = 1
-- Constants for Config Value Type
DECLARE @MMSM_CT_NONE			INTEGER = 0
DECLARE @MMSM_CT_BOOL			INTEGER = 1
DECLARE @MMSM_CT_INT			INTEGER = 2
DECLARE @MMSM_CT_UINT			INTEGER = 3
DECLARE @MMSM_CT_LONG			INTEGER = 4
DECLARE @MMSM_CT_ULONG			INTEGER = 5
DECLARE @MMSM_CT_LONGLONG		INTEGER = 6
DECLARE @MMSM_CT_ULONGLONG		INTEGER = 7
DECLARE @MMSM_CT_STRING			INTEGER = 8
DECLARE @MMSM_CT_IP_ADDR		INTEGER = 9
DECLARE @MMSM_CT_LIST			INTEGER = 10
DECLARE @MMSM_CT_COMBO			INTEGER = 11
DECLARE @MMSM_CT_PSWD			INTEGER = 12
DECLARE @MMSM_CT_ENC_STRING		INTEGER = 13
-- Constants for Assoc Type
DECLARE @MMSM_AT_NONE			INTEGER = 0
DECLARE @MMSM_AT_TEMPL			INTEGER = 1
DECLARE @MMSM_AT_VENDOR			INTEGER = 2
DECLARE @MMSM_AT_ARRAY			INTEGER = 3
DECLARE @MMSM_AT_CTRL_HOST		INTEGER = 4
DECLARE @MMSM_AT_SUBCLT_POLICY	INTEGER = 5
DECLARE @MMSM_AT_COPY			INTEGER = 6
DECLARE @MMSM_AT_CLIENT_GROUP	INTEGER = 7
DECLARE @MMSM_AT_CLIENT			INTEGER = 8
DECLARE @MMSM_AT_SUBCLIENT		INTEGER = 9
-- Constants for SMMasterConfigs - ShowInGui column
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI				INTEGER = 0
DECLARE @SM_MASTERCONFIGS_SHOW_IN_GUI				INTEGER = 1
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_ARRAY		INTEGER = 2
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_COPY		INTEGER = 4
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_CLIENT		INTEGER = 8
DECLARE @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_SUBCLIENT	INTEGER = 16
DECLARE @arrCfgListEmpty NVARCHAR(1024) = N'##CV_SM_EMPTY_LIST##'
DECLARE @SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTES INT = 2 -- SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTESs
DECLARE @l_VsaVolumeFlag		BIGINT = 4294967296   /* CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB  */
DECLARE @l_VsaChildMasterJobId	INT	= 0
DECLARE @l_VsaParentAppId		INT = 0
DECLARE @l_VsaParentClientId	INT = 0
-- Get the input parameters from the XML input str
SET @vendorId = ISNULL ( ( SELECT R.ref.value('@id', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq/vendor' ) R ( ref ) ), 0 )
SET @vendorName = ISNULL ( ( SELECT R.ref.value('@name', 'nvarchar(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq/vendor' ) R ( ref ) ), N'' )
SET @arrayId = ISNULL ( ( SELECT R.ref.value('@id', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq/array' ) R ( ref ) ), 0 )
SET @arrayName = ISNULL ( ( SELECT R.ref.value('@name', 'nvarchar(128)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq/array' ) R ( ref ) ), N'' )
SET @copyId = ISNULL ( ( SELECT R.ref.value('@copyId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @appId = ISNULL ( ( SELECT R.ref.value('@appId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @assocType = ISNULL ( ( SELECT R.ref.value('@assocType', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq' ) R ( ref ) ), @MMSM_AT_ARRAY )
SET @flags = ISNULL ( ( SELECT R.ref.value('@flags', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @clientId = ISNULL( ( SELECT R.ref.value('@clientId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMGetArrayDetailsReq' ) R ( ref ) ), 0 )
SET @mountHostId = @clientId
IF @copyId > 0
BEGIN
	SELECT	@copyId = defaultSnapCopy FROM archGroup WHERE id = @copyId
END
DECLARE @tblArrays TABLE (
					vendorId					INTEGER,
					vendorName					NVARCHAR(128),
					arrayId						INTEGER,
					arrayName					NVARCHAR(1024),
					ctrlHostName				NVARCHAR(1024),
					userName					NVARCHAR(1024),
					isEnabled					INTEGER,
					offlineReason				NVARCHAR(1024),
					arrayType					INTEGER,
					description					NVARCHAR(1024),
					arrayInfoType				INTEGER,
					flags						INTEGER,
					uniqueIdentifier			NVARCHAR(1024),
					credentialId				INTEGER,
					regionId					NVARCHAR(MAX) DEFAULT N'',
					regionName					NVARCHAR(254) DEFAULT N'')
DECLARE	@tblArrayConfigs TABLE (
							configId				INTEGER,
							configName				NVARCHAR(256),
							masterConfigId			INTEGER,
							configType				INTEGER,
							assocType				INTEGER,
							value					NVARCHAR(MAX),
							isEnabled				INTEGER,
							isOverridden			INTEGER,
							flags					INTEGER,
							orderId					INTEGER )
DECLARE @tblArrayDG TABLE (name NVARCHAR(1024), masterConfigId INTEGER, type INTEGER, value NVARCHAR(2048), isOverridden INTEGER)
DECLARE @arrayDGName NVARCHAR(2048) = N''
DECLARE @useDevicesFromThisDG NVARCHAR(2048) = N''
DECLARE @disableDG NVARCHAR(2048) = N''
DECLARE @isADGOverridden NVARCHAR(2048) = N''
DECLARE @tblHostDG TABLE (name NVARCHAR(1024), masterConfigId INTEGER, type INTEGER, value NVARCHAR(2048), isOverridden INTEGER)
DECLARE @deviceGroupOption INTEGER = 0
DECLARE @hostDGName NVARCHAR(2048) = N''
DECLARE @useOnlySpouseDevices INTEGER = 0
DECLARE @doNotMoveDevices INTEGER = 0
DECLARE @isHDGOverridden INTEGER = 0
DECLARE	@filteredMode INTEGER = 1
DECLARE @xmlUserGroups		XML = N''
DECLARE @xmlSecurity		XML = N''
DECLARE @xmlArrayInfo		XML = N''
DECLARE @xmlConfigList		XML = N''
DECLARE @xmlArrayDG			XML = N''
DECLARE @xmlHostDG			XML = N''
DECLARE @selectedMAs		XML = N''
DECLARE @availableMAs		XML	= N''
IF @arrayId > 0
BEGIN
	INSERT	INTO @tblArrays (vendorId, vendorName,arrayId,arrayName,ctrlHostName,userName,isEnabled, offlineReason, arrayType, description, arrayInfoType, flags, uniqueIdentifier, credentialId)
	SELECT	0, SnapVendorName, ControlHostId, SMArrayId, SMHostName, SMHostUserName, SMHostStatus, SMHostIP, SMHostFlags, SMHostDescription, @MMSM_AIT_AVAILABLE, Flags, uniqueIdentifier, CredentialId
	FROM	SMControlHost WITH (NOLOCK)
	WHERE	ControlHostId = @arrayId
	IF @vendorId = 0
	BEGIN
		SELECT @vendorId = VEN.id FROM SMVendor VEN WITH (READUNCOMMITTED)
		INNER JOIN @tblArrays ARRAYS ON ARRAYS.vendorName = VEN.Name
		WHERE ARRAYS.arrayId = @arrayId
	END
	IF @vendorName = ''
	BEGIN
		SELECT @vendorName = vendorName FROM @tblArrays WHERE arrayId = @arrayId
	END
	IF @arrayName = ''
	BEGIN
		SELECT @arrayName = arrayName FROM @tblArrays WHERE arrayId = @arrayId
	END
	IF @assocType = @MMSM_AT_NONE
	BEGIN
		SET @assocType = @MMSM_AT_ARRAY
	END
END
DECLARE @tblArrayUserGroup TABLE (groupId integer, groupName nvarchar(1024))
-- Get default user groups
insert into @tblArrayUserGroup select id, name
from UMGroups
where name = 'View All' or id = dbo.GetMasterGroupID()
-- Get user groups saved for array
insert into @tblArrayUserGroup select b.groupId, c.name
from @tblArrays a, UMGroupAssociation b, UMGroups c
where b.type1 = 9615 and a.arrayId = b.id1 and b.groupId = c.id
-- Construct return xml string for array security
SET @xmlUserGroups = (
	SELECT	groupId		AS	'@userGroupId',
			groupName	AS	'@userGroupName'
	FROM	@tblArrayUserGroup
	FOR XML PATH ('associatedUserGroups'))
set @xmlSecurity = (select @xmlUserGroups for xml path ('arraySecurity'))
DECLARE @entitySecurityAssociation XML
IF @flags <> 1 -- Request is from GUI
BEGIN
EXEC [dbo].[sec_getSecurityForEntity]
@i_userId, @entitySecurityAssociation OUTPUT, 153, @arrayId
END
UPDATE	@tblArrays
SET		regionId	= APPADV.value,
		regionName	= REGION.displayName
FROM	@tblArrays TMP1 INNER JOIN  APP_AdvanceSettings APPADV (NOLOCK) ON TMP1.arrayId = APPADV.entityId
						INNER JOIN	App_Region REGION (NOLOCK) ON APPADV.value = CAST(REGION.id AS nvarchar(MAX))
WHERE  APPADV.keyName = 'Region Id' AND APPADV.entityType = 153/*ARRAY_ENTITY*/ AND APPADV.deleted = 0 AND APPADV.enabled = 1
-- Get the Array Info
-- IF @assocType = @MMSM_AT_ARRAY
SET @xmlArrayInfo = (
	SELECT	ctrlHostName					AS '@ctrlHostName',
			description						AS '@description',
			-- (CASE WHEN isEnabled = 1 THEN N'true' ELSE N'false' END) AS '@isEnabled',
			isEnabled						AS '@isEnabled',
			offlineReason					AS '@offlineReason',
			(arrayType & (POWER(2, 2) - 1))	AS '@arrayType',
			arrayInfoType					AS '@arrayInfoType',
			flags							AS '@flags',
			uniqueIdentifier				AS '@uniqueIdentifier',
			vendorId						AS 'vendor/@id',
			vendorName						AS 'vendor/@name',
			arrayId							AS 'arrayName/@id',
			arrayName						AS 'arrayName/@name',
			userName						AS 'userPswd/@userName',
			CredentialId					AS 'savedCredential/@credentialId',
			@entitySecurityAssociation		AS 'securityAssociations',
			@xmlSecurity,
			regionId						AS 'region/@regionId',
			regionName						AS 'region/@regionName'
	FROM	@tblArrays
		FOR XML PATH ( 'info' )	)
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------
---- The following levels have been decided for overriding snap configs(after discussion on MR 266746)
-------------------------------------------------------------------------------------------------------
----	+ ARRAY
----	++	 COPY
----	######## IF VSA V2 ###########
----	++++	CLIENT PARENT
----	++++++++	SUBCLIENT PARENT
----	##############################
----	++++	CLIENT							( IF VSA V2 THEN CHILD )
----	++++++++	SUBCLIENT					( IF VSA V2 THEN CHILD )
----	++++++++++++	CLIENT MOUNT HOST		( IF MOUNT OR UNMOUNT OPERATION )
-------------------------------------------------------------------------------------------
-- Get the Snap Configurations
-- From Array Level
INSERT	INTO @tblArrayConfigs
SELECT	CFG.ConfigId, MC.Name, MC.Id, MC.Type, @MMSM_AT_ARRAY,
		( CASE
			WHEN MC.Type = @MMSM_CT_BOOL THEN
				( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
			WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
			WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
			WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
		END ),
		CFG.IsValid, 0, MC.Flags, MC.OrderNum
FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON CFG.MasterConfigId = MC.Id
WHERE	CFG.ArrayId = @arrayId
		AND CFG.AssocId = @arrayId
		AND CFG.AssocType = @MMSM_AT_ARRAY
		AND MC.Type <> @MMSM_CT_LIST
UNION
SELECT	MC.Id, MC.Name, MC.Id, MC.Type, @MMSM_AT_ARRAY,
		ISNULL( (	SELECT	CASE WHEN @assocType <> @MMSM_AT_ARRAY THEN 0 ELSE CFGL.ConfigId END AS '@id',
							CFGL.ValueStr AS '@name'
					FROM	SMConfigsList CFGL (NOLOCK)
					WHERE	CFGL.MasterConfigId = MC.Id
							AND CFGL.ArrayId = @arrayId
							AND CFGL.AssocId = @arrayId
							AND CFGL.AssocType = @MMSM_AT_ARRAY
							AND CFGL.ValueStr <> @arrCfgListEmpty
					ORDER BY CFGL.ElementOrder
					FOR XML PATH ('values')), ''),
		1, 0, 0, MC.OrderNum
FROM 	SMVendor VEN (NOLOCK) INNER JOIN SMMasterConfigs MC (NOLOCK) ON VEN.Id = MC.VendorId
WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
		AND MC.Type = @MMSM_CT_LIST
ORDER BY OrderNum
IF @assocType = @MMSM_AT_SUBCLIENT AND @appId > 0
	SELECT	@copyId = AG.defaultSnapCopy
	FROM	APP_Application APP WITH (NOLOCK) INNER JOIN archGroup AG WITH (NOLOCK) ON APP.dataArchGrpID = AG.id
	WHERE	APP.id = @appId
-- Get the Snap Configurations
-- From Copy Level
IF (@assocType = @MMSM_AT_COPY OR @assocType = @MMSM_AT_SUBCLIENT) AND @copyId > 0
BEGIN
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value = ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON CFG.MasterConfigId = MC.Id
			INNER JOIN @tblArrayConfigs tAC ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @copyId
			AND CFG.AssocType = @MMSM_AT_COPY
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
							CFGL.ValueStr AS '@name'
					FROM	SMConfigsList CFGL (NOLOCK)
					WHERE	CFGL.MasterConfigId = MC.Id
							AND CFGL.ArrayId = @arrayId
							AND CFGL.AssocId = @copyId
							AND CFGL.AssocType = @MMSM_AT_COPY
							AND CFGL.ValueStr <> @arrCfgListEmpty
					ORDER BY CFGL.ElementOrder
					FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN (NOLOCK) INNER JOIN SMMasterConfigs MC (NOLOCK) ON VEN.Id = MC.VendorId
			INNER JOIN @tblArrayConfigs tAC ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN ( SELECT masterConfigId FROM SMConfigsList (NOLOCK) WHERE ArrayId = @arrayId AND AssocId = @copyId AND AssocType = @MMSM_AT_COPY )
END
------------------------------------------------------------------------------------------------------------------------------------------------------------
------ Check if the input subclient is VSA V2 child entry or not. If so, fetch the VSA V2 parent client & subclient snap configs.
------------------------------------------------------------------------------------------------------------------------------------------------------------
SELECT	TOP 1 @l_VsaChildMasterJobId = VOL.MasterJobId
FROM	SMVolume VOL (READUNCOMMITTED)
WHERE	VOL.AppId = @appId
			AND VOL.MasterJobId > 0
			AND VOL.MasterJobId <> VOL.JobId
			AND VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag
AND VOL.AppTypeId = 106 /* CV_APPTYPE_VIRTUAL_SERVER */
---- Confirmed that it is VA V2 subclient.. Fetch parent details.
IF @l_VsaChildMasterJobId > 0
BEGIN
	---- First check if the link exists in JMJobDataLink table or not.
	SELECT	TOP 1 @l_VsaParentAppId = APP.id, @l_VsaParentClientId = APP.clientId
	FROM	JMJobDataLink JDL WITH (READUNCOMMITTED)
				INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
					ON JDL.childAppid = @appId
						AND JDL.parentAppid = APP.id
WHERE	JDL.linkType = 7	 /* LINK_TYPE_FOR_VSA_V2_PARENT_CHILD */
	ORDER BY JDL.childJobId DESC		--- Try to get the latest info
	---- Try to get VSA Parent subclient Id & Parent client Id from SMVolume entries for any existing job.
	IF @l_VsaParentAppId = 0
	BEGIN
		SELECT	TOP 1 @l_VsaParentAppId = VOL.AppId, @l_VsaParentClientId = APP.clientId
		FROM	SMVolume VOL WITH (READUNCOMMITTED)
					INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
						ON VOL.AppId = APP.id
		WHERE	VOL.MasterJobId = @l_VsaChildMasterJobId
					AND VOL.JobId = VOL.MasterJobId
AND VOL.AppTypeId = 106 /* CV_APPTYPE_VIRTUAL_SERVER */
					AND VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag
	END
	---- If not found, Finally look in child client property. (It is already established that given appId is child VSA V2)
	IF @l_VsaParentAppId = 0
	BEGIN
		---- Parent Subclient Id
		SELECT	@l_VsaParentAppId = (	CASE
											WHEN ISNUMERIC(CP.attrVal) = 1
												THEN CP.attrVal
											ELSE 0
										END
									)
		FROM	APP_ClientProp CP WITH (READUNCOMMITTED)
		WHERE	CP.componentNameId IN (	SELECT	APP.clientId
										FROM	APP_Application APP WITH (READUNCOMMITTED)
										WHERE	APP.id = @appId
									  )
					AND CP.attrName = 'VSA Discover Subclient ID'
					AND CP.modified = 0
		---- Parent Client Id
		IF @l_VsaParentAppId > 0
		BEGIN
			SELECT	@l_VsaParentClientId = APP.clientId
			FROM	APP_Application APP WITH (READUNCOMMITTED)
			WHERE	APP.id = @l_VsaParentAppId
		END
	END
END
------ If VSA Parent Client Id exists, then get the client level snap configs
------ *NOTE* - If the snap configs are edited at VSA V2 Child Client level, then it will be picked up later as part of regular client level check.
IF (@assocType = @MMSM_AT_CLIENT OR @assocType = @MMSM_AT_SUBCLIENT) AND (@l_VsaParentClientId > 0)
BEGIN
	UPDATE	@tblArrayConfigs
	SET		isOverridden = 0
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value	= ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK)
				INNER JOIN SMMasterConfigs MC WITH (NOLOCK)
					ON CFG.MasterConfigId = MC.Id
				INNER JOIN @tblArrayConfigs tAC
					ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
				AND CFG.AssocId		= @l_VsaParentClientId
				AND CFG.AssocType	= @MMSM_AT_CLIENT
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
										CFGL.ValueStr AS '@name'
								FROM	SMConfigsList CFGL (NOLOCK)
								WHERE	CFGL.MasterConfigId		= MC.Id
											AND CFGL.ArrayId	= @arrayId
											AND CFGL.AssocId	= @l_VsaParentClientId
											AND CFGL.AssocType	= @MMSM_AT_CLIENT
											AND CFGL.ValueStr <> @arrCfgListEmpty
								ORDER BY CFGL.ElementOrder
								FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN (NOLOCK)
				INNER JOIN SMMasterConfigs MC (NOLOCK)
					ON VEN.Id = MC.VendorId
				INNER JOIN @tblArrayConfigs tAC
					ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN ( SELECT masterConfigId FROM SMConfigsList (NOLOCK) WHERE ArrayId = @arrayId AND AssocId = @l_VsaParentClientId AND AssocType = @MMSM_AT_CLIENT)
END
------ If VSA Parent subclient Id exists, then get the snap configs
IF (@l_VsaParentAppId > 0) AND (@assocType = @MMSM_AT_SUBCLIENT)
BEGIN
	UPDATE	@tblArrayConfigs
	SET		isOverridden = 0
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value = ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK)
				INNER JOIN SMMasterConfigs MC WITH (NOLOCK)
					ON CFG.MasterConfigId = MC.Id
				INNER JOIN @tblArrayConfigs tAC
					ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
				AND CFG.AssocId = @l_VsaParentAppId
				AND CFG.AssocType = @MMSM_AT_SUBCLIENT
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
										CFGL.ValueStr AS '@name'
								FROM	SMConfigsList CFGL (NOLOCK)
								WHERE	CFGL.MasterConfigId		= MC.Id
											AND CFGL.ArrayId	= @arrayId
											AND CFGL.AssocId	= @l_VsaParentAppId
											AND CFGL.AssocType	= @MMSM_AT_SUBCLIENT
											AND CFGL.ValueStr <> @arrCfgListEmpty
								ORDER BY CFGL.ElementOrder
								FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN (NOLOCK)
				INNER JOIN SMMasterConfigs MC (NOLOCK)
					ON VEN.Id = MC.VendorId
				INNER JOIN @tblArrayConfigs tAC
					ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN ( SELECT masterConfigId FROM SMConfigsList (NOLOCK) WHERE ArrayId = @arrayId AND AssocId = @l_VsaParentAppId AND AssocType = @MMSM_AT_SUBCLIENT )
END
------------------------------------------------------------------------------------------------------------------------------------------------------------
------ Get the regular client level snap configs
------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Get the client ID from subclient ID
IF @assocType = @MMSM_AT_SUBCLIENT AND @appId > 0
	SELECT	@clientId = APP.clientId
	FROM	APP_Application APP (NOLOCK) WHERE	APP.id = @appId
-- During Mount/Unmount the MountHostId will be passed in as client Id (which is stored in @mountHostId)
-- Only if mount host is not same as client, we need to fetch the mount host details (during mount/unmount operations)
IF @mountHostId = @clientId
BEGIN
	SET @mountHostId = 0
END
-- Get the Snap Configurations
-- From Client Level
IF (@assocType = @MMSM_AT_CLIENT OR @assocType = @MMSM_AT_SUBCLIENT )AND @clientId > 0
BEGIN
	UPDATE @tblArrayConfigs
	SET		isOverridden = 0
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value = ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON CFG.MasterConfigId = MC.Id
			INNER JOIN @tblArrayConfigs tAC ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @clientId
			AND CFG.AssocType = @MMSM_AT_CLIENT
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
							CFGL.ValueStr AS '@name'
					FROM	SMConfigsList CFGL (NOLOCK)
					WHERE	CFGL.MasterConfigId = MC.Id
							AND CFGL.ArrayId = @arrayId
							AND CFGL.AssocId = @clientId
							AND CFGL.AssocType = @MMSM_AT_CLIENT
							AND CFGL.ValueStr <> @arrCfgListEmpty
					ORDER BY CFGL.ElementOrder
					FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN (NOLOCK) INNER JOIN SMMasterConfigs MC (NOLOCK) ON VEN.Id = MC.VendorId
			INNER JOIN @tblArrayConfigs tAC ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN ( SELECT masterConfigId FROM SMConfigsList (NOLOCK) WHERE ArrayId = @arrayId AND AssocId = @clientId AND AssocType = @MMSM_AT_CLIENT)
END
-- Get the Snap Configurations
-- From Subclient Level
IF @assocType = @MMSM_AT_SUBCLIENT AND @appId > 0
BEGIN
	UPDATE	@tblArrayConfigs
	SET		isOverridden = 0
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value = ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON CFG.MasterConfigId = MC.Id
			INNER JOIN @tblArrayConfigs tAC ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @appId
			AND CFG.AssocType = @MMSM_AT_SUBCLIENT
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
							CFGL.ValueStr AS '@name'
					FROM	SMConfigsList CFGL (NOLOCK)
					WHERE	CFGL.MasterConfigId = MC.Id
							AND CFGL.ArrayId = @arrayId
							AND CFGL.AssocId = @appId
							AND CFGL.AssocType = @MMSM_AT_SUBCLIENT
							AND CFGL.ValueStr <> @arrCfgListEmpty
					ORDER BY CFGL.ElementOrder
					FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN (NOLOCK) INNER JOIN SMMasterConfigs MC (NOLOCK) ON VEN.Id = MC.VendorId
			INNER JOIN @tblArrayConfigs tAC ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN ( SELECT masterConfigId FROM SMConfigsList (NOLOCK) WHERE ArrayId = @arrayId AND AssocId = @appId AND AssocType = @MMSM_AT_SUBCLIENT )
END
----------------------------------------------------------------------------------------------------------------
---- Fetch the snap configs from mount host (in case of Mount/Unmount operations). Giving it highest priority.
----------------------------------------------------------------------------------------------------------------
IF (@assocType = @MMSM_AT_CLIENT OR @assocType = @MMSM_AT_SUBCLIENT ) AND @mountHostId > 0
BEGIN
	UPDATE	@tblArrayConfigs
	SET		isOverridden = 0
	UPDATE	@tblArrayConfigs
	SET		configId = CFG.ConfigId,
			value = ( CASE
						WHEN MC.Type = @MMSM_CT_BOOL THEN
							( CASE WHEN CFG.ValueInt = 0 THEN N'false' ELSE N'true' END )
						WHEN MC.Type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueInt )
						WHEN MC.Type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT ( NVARCHAR(1024), CFG.ValueLL )
						WHEN MC.Type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END ),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK)
				INNER JOIN SMMasterConfigs MC WITH (NOLOCK)
					ON CFG.MasterConfigId = MC.Id
				INNER JOIN @tblArrayConfigs tAC
					ON CFG.MasterConfigId = tAC.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
				AND CFG.AssocId	= @mountHostId
				AND CFG.AssocType = @MMSM_AT_CLIENT
	UPDATE	@tblArrayConfigs
	SET		configId = MC.Id,
			value = ISNULL( (	SELECT	CFGL.ElementOrder AS '@id',
										CFGL.ValueStr AS '@name'
								FROM	SMConfigsList CFGL WITH (NOLOCK)
								WHERE	CFGL.MasterConfigId = MC.Id
											AND CFGL.ArrayId = @arrayId
											AND CFGL.AssocId = @mountHostId
											AND CFGL.AssocType = @MMSM_AT_CLIENT
											AND CFGL.ValueStr <> @arrCfgListEmpty
								ORDER BY CFGL.ElementOrder
								FOR XML PATH ('values')), ''),
			isOverridden = 1
	FROM 	SMVendor VEN WITH (NOLOCK)
				INNER JOIN SMMasterConfigs MC WITH (NOLOCK)
					ON VEN.Id = MC.VendorId
				INNER JOIN @tblArrayConfigs tAC
					ON mc.id = tAC.masterConfigId
	WHERE	VEN.Name IN ( SELECT vendorName FROM @tblArrays )
			AND MC.Type = @MMSM_CT_LIST
			AND MC.Id IN (	SELECT	masterConfigId
							FROM	SMConfigsList WITH (NOLOCK)
							WHERE	ArrayId = @arrayId
										AND AssocId = @mountHostId
										AND AssocType = @MMSM_AT_CLIENT	)
END
-- We will return the hidden array configs to the snap engines
IF @flags <> 1 -- If the request is not from the engine, then delete the hidden array configs
BEGIN
	DECLARE @flagToHideConfig INTEGER = 0
	SELECT @flagToHideConfig = ( CASE WHEN @assocType = @MMSM_AT_ARRAY THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_ARRAY
									  WHEN @assocType = @MMSM_AT_COPY THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_COPY
									  WHEN @assocType = @MMSM_AT_CLIENT THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_CLIENT
									  WHEN @assocType = @MMSM_AT_SUBCLIENT THEN @SM_MASTERCONFIGS_HIDE_IN_GUI_AT_SUBCLIENT
							 ELSE 0 END )
	DELETE tAC FROM @tblArrayConfigs tAC INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON tAC.masterConfigId = MC.Id
	WHERE  MC.ShowInGui & @flagToHideConfig = @flagToHideConfig
	DELETE tAC FROM @tblArrayConfigs tAC INNER JOIN SMMasterConfigs MC WITH (NOLOCK) ON tAC.masterConfigId = MC.Id
	WHERE  MC.ShowInGUI & @SM_MASTERCONFIGS_SHOW_IN_GUI = 0
END
IF @flags = 1	-- Request is from MM (for engine)
BEGIN
	DECLARE @ARRAY_CONFIGS_CONFIG_DELIM	NVARCHAR(8) = N'|::|'
	DECLARE @ARRAY_CONFIGS_VALUE_DELIM NVARCHAR(8) = N'|'
	DECLARE @ARRAY_CONFIGS_LIST_VVALUE_DELIM NVARCHAR(8) = N'|:|'
	DECLARE @configs NVARCHAR(MAX) = N''
	/*
	SELECT	@configs = @configs + MC.KeyName + @ARRAY_CONFIGS_VALUE_DELIM + CAST ( AC.configType AS NVARCHAR (4) ) + @ARRAY_CONFIGS_VALUE_DELIM +
						( CASE WHEN AC.configType = @MMSM_CT_BOOL THEN ( CASE WHEN AC.value = N'false' THEN N'0' ELSE N'1' END ) ELSE AC.value END) +
						@ARRAY_CONFIGS_CONFIG_DELIM
	FROM	SMMasterConfigs MC WITH (NOLOCK) INNER JOIN @tblArrayConfigs AC ON MC.Id = AC.masterConfigId
	*/
	SELECT @configs = @configs	+ MC.KeyName + @ARRAY_CONFIGS_VALUE_DELIM + CAST ( AC.configType AS NVARCHAR (4) ) + @ARRAY_CONFIGS_VALUE_DELIM +
						( CASE WHEN AC.configType = @MMSM_CT_BOOL THEN ( CASE WHEN AC.value = N'false' THEN N'0' ELSE N'1' END )
							WHEN AC.configType = @MMSM_CT_LIST THEN (
											ISNULL( (SELECT
												STUFF((SELECT
														  @ARRAY_CONFIGS_LIST_VVALUE_DELIM + T.c.value('(./@name)[1]','VARCHAR(MAX)')
													   FROM
														  (SELECT CAST( AC.value AS XML) as val)v
													   CROSS APPLY
														  v.val.nodes('/values') T(c)
													   FOR XML PATH('')
													  ), 1, 3, '')
											),''))
							ELSE AC.value END) +
						@ARRAY_CONFIGS_CONFIG_DELIM
	FROM	SMMasterConfigs MC WITH (NOLOCK) INNER JOIN @tblArrayConfigs AC ON MC.Id = AC.masterConfigId
	SELECT	0, 0, 0, 0, 0, 0, @configs, 0, 0
	RETURN
END
ELSE	-- Request is from GUI
BEGIN
	SET	@xmlConfigList = (
		SELECT	masterConfigId AS '@masterConfigId',
				configType AS '@type',
				(CASE WHEN configType <> @MMSM_CT_LIST THEN value END) AS '@value',
				isEnabled AS '@isEnabled',
				isOverridden AS '@isOverridden',
				ISNULL(SMP.ValueStr,'') as '@notes',
				flags AS '@flags',
				configId AS 'name/@id',
				configName AS 'name/@name',
				(CASE WHEN configType = @MMSM_CT_LIST THEN CONVERT(XML,value) END)
		FROM	@tblArrayConfigs
				LEFT JOIN SMParam SMP ON SMP.KeyEntity = @SM_PARAM_KEY_ENTITY_ARRAY_CONFIGS_NOTES AND masterConfigId = CAST(SMP.KeyName AS INTEGER)
		FOR XML PATH ( 'configList' )
	)
END
-- If the request is from the GUI, then set the array controller details
IF @flags <> 1
BEGIN
		DECLARE @arrayCapab bigint = 0
		SELECT @arrayCapab = @arrayCapab | Capabilities from SMSnapShotEngine (NOLOCK) where SnapVendorName = (SELECT SnapVendorName FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayId)
		IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null DROP TABLE #tblMMS2GetMediaAgentsForUserResult
		CREATE TABLE #tblMMS2GetMediaAgentsForUserResult (clientId integer)
		-- Call the SP MMS2GetMediaAgentsForUser for getting MA's that are visible to current user
		IF @i_userId > 0
		BEGIN
			DECLARE @retVal INTEGER = 0
			EXEC MMS2GetMediaAgentsForUser @i_userId
		END
		SET @selectedMAs =
			(	SELECT	AC.ArrayControllerId AS '@arrayControllerId',
						AC.MMHostId AS 'mediaAgent/@id',
						CLNT.name AS 'mediaAgent/@name',
						(
							SELECT	(CASE WHEN AC.Options & CAST( SMP.KeyName as integer) > 0 THEN 1 ELSE 0 END) AS '@isEnabled',
									SMP.KeyName AS 'arrCtrlOption/@id',
									SMP.ValueStr AS 'arrCtrlOption/@name'
							FROM	SMParam SMP (NOLOCK)
							WHERE	SMP.KeyEntity = 1 AND SMP.KeyName in
														('262144'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/,
														'524288'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_ARRAY_REPORTING*/,
														'1048576'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_REMOTE_SNAP_MA*/,
														'2097152'/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_RECON_SNAP*/)
									AND CAST( SMP.KeyName as bigint) & @arrayCapab  > 0
							ORDER BY CAST (smp.KeyName AS INT)
							FOR XML PATH ('arrCtrlOptions'), TYPE
						)
				FROM	#tblMMS2GetMediaAgentsForUserResult MA
						INNER JOIN SMArrayController (NOLOCK) AC ON AC.MMHostId = MA.clientId
						INNER JOIN APP_Client (NOLOCK) CLNT ON AC.MMHostId = CLNT.id
				WHERE	AC.ArrayNum = @arrayId
				ORDER BY CLNT.name
				FOR XML PATH ('selectedMAs') )
		SET @availableMAs = (
		SELECT		0 as '@arrayControllerId',
					CLNT.id AS 'mediaAgent/@id', CLNT.name AS 'mediaAgent/@name'
		FROM		#tblMMS2GetMediaAgentsForUserResult MA
					INNER JOIN	APP_Client CLNT (NOLOCK) ON MA.ClientId = CLNT.id
		WHERE		CLNT.id NOT IN ( SELECT MMHostId FROM SMArrayController (NOLOCK) WHERE ArrayNum = @arrayId )
					AND CLNT.id > 1
		ORDER BY CLNT.name
		FOR	XML PATH ('availableMAs') )
		IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null DROP TABLE #tblMMS2GetMediaAgentsForUserResult
END
--------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM SMSnapShotEngine WHERE Capabilities & 64 > 0 AND SnapVendorName = @vendorName)
	INSERT	INTO @tblArrayDG
	SELECT	MC.Name, MC.Id, MC.Type, N'', 0
	FROM	SMMasterConfigs MC WITH (NOLOCK) INNER JOIN SMVendor VEN WITH (NOLOCK) ON MC.VendorId = VEN.Id
	WHERE	VEN.name = @vendorName
			AND MC.ShowInGUI = 2
IF EXISTS (SELECT * FROM @tblArrayDG)
BEGIN
	UPDATE	@tblArrayDG
	SET		value = (CASE WHEN ADG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN ADG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN ADG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN ADG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END)
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblArrayDG ADG ON CFG.MasterConfigId = ADG.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @arrayId
			AND CFG.AssocType = @MMSM_AT_ARRAY
	UPDATE	@tblArrayDG
	SET		value = (CASE WHEN ADG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN ADG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN ADG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN ADG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblArrayDG ADG ON CFG.MasterConfigId = ADG.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @copyId
			AND CFG.AssocType = @MMSM_AT_COPY
	UPDATE	@tblArrayDG
	SET		value = (CASE WHEN ADG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN ADG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN ADG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN ADG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblArrayDG ADG ON CFG.MasterConfigId = ADG.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @appId
			AND CFG.AssocType = @MMSM_AT_SUBCLIENT
	SELECT	@arrayDGName = value FROM @tblArrayDG WHERE name = N'Storage Device Group'
	SELECT	@useDevicesFromThisDG = value FROM @tblArrayDG WHERE name = N'Use Devices only from this Group'
	SELECT	@disableDG = value FROM @tblArrayDG WHERE name = N'Disable Device Group'
	IF EXISTS (SELECT * FROM @tblArrayDG WHERE isOverridden = 1)
		SET @isADGOverridden = N'1'
	SET	@xmlArrayDG = (
		SELECT	@arrayDGName AS '@arrayDGName',
				@useDevicesFromThisDG AS '@useDevicesFromThisDG',
				@disableDG AS '@disableDG',
				@isADGOverridden AS '@isOverridden'
		FOR XML PATH ( 'arrayDG' )
	)
END
--------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM SMSnapShotEngine WHERE Capabilities & 512 > 0 AND SnapVendorName = @vendorName)
	INSERT	INTO @tblHostDG
	SELECT	MC.Name, MC.Id, MC.Type, N'', 0
	FROM	SMMasterConfigs MC WITH (NOLOCK) INNER JOIN SMVendor VEN WITH (NOLOCK) ON MC.VendorId = VEN.Id
	WHERE	VEN.name = @vendorName
			AND MC.ShowInGUI = 3
IF EXISTS (SELECT * FROM @tblHostDG)
BEGIN
	UPDATE	@tblHostDG
	SET		value = (CASE WHEN HDG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN HDG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN HDG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN HDG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END)
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblHostDG HDG ON CFG.MasterConfigId = HDG.masterConfigId AND CFG.ArrayId = @arrayId
			AND CFG.AssocId = @arrayId
			AND CFG.AssocType = @MMSM_AT_ARRAY
	UPDATE	@tblHostDG
	SET		value = (CASE WHEN HDG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN HDG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN HDG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN HDG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblHostDG HDG ON CFG.MasterConfigId = HDG.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @copyId
			AND CFG.AssocType = @MMSM_AT_COPY
	UPDATE	@tblHostDG
	SET		value = (CASE WHEN HDG.type IN (@MMSM_CT_BOOL) THEN ( CASE WHEN CFG.ValueInt = 1 THEN N'true' ELSE N'false' END )
							WHEN HDG.type IN (@MMSM_CT_INT, @MMSM_CT_UINT, @MMSM_CT_LONG, @MMSM_CT_ULONG) THEN CONVERT(NVARCHAR(128), CFG.ValueInt)
							WHEN HDG.type IN (@MMSM_CT_LONGLONG, @MMSM_CT_ULONGLONG) THEN CONVERT(NVARCHAR(128), CFG.ValueLL)
							WHEN HDG.type IN (@MMSM_CT_STRING, @MMSM_CT_IP_ADDR, @MMSM_CT_PSWD, @MMSM_CT_ENC_STRING) THEN CFG.ValueStr
					END),
			isOverridden = 1
	FROM	SMConfigs CFG WITH (NOLOCK) INNER JOIN @tblHostDG HDG ON CFG.MasterConfigId = HDG.masterConfigId
	WHERE	CFG.ArrayId = @arrayId
			AND CFG.AssocId = @appId
			AND CFG.AssocType = @MMSM_AT_SUBCLIENT
	SELECT	@deviceGroupOption = value FROM @tblHostDG WHERE name = N'Host Device Group Options'
	SELECT	@hostDGName = value FROM @tblHostDG WHERE name = N'Host Device Group'
	SELECT	@useOnlySpouseDevices = value FROM @tblHostDG WHERE name = N'Use only Spouse Devices'
	SELECT	@doNotMoveDevices = value FROM @tblHostDG WHERE name = N'Do not move Source and Target Device across Group'
	IF EXISTS (SELECT * FROM @tblHostDG WHERE isOverridden = 1)
		SET @isHDGOverridden = N'1'
	SET	@xmlHostDG = (
		SELECT	@deviceGroupOption AS '@deviceGroupOption',
				@hostDGName AS '@hostDGName',
				@useOnlySpouseDevices AS '@useOnlySpouseDevices',
				@doNotMoveDevices AS '@doNotMoveDevices',
				@isHDGOverridden AS '@isOverridden'
		FOR XML PATH ( 'hostDG' )
	)
END
DECLARE @localeId INT = 0
DECLARE @arrayNameLabel NVARCHAR(255) = N''
DECLARE @arrayControlHostLabel NVARCHAR(255) = N''
DECLARE @arrayUserNameLabel NVARCHAR(255) = N''
DECLARE @arrayPasswordLabel NVARCHAR(255) = N''
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMGetArrayDetailsReq/processinginstructioninfo/locale') R ( ref )), 0)
SELECT  @arrayNameLabel = ISNULL(LM1.Message, N''), @arrayControlHostLabel = ISNULL(LM2.Message, N''), @arrayUserNameLabel = ISNULL(LM3.Message, N''), @arrayPasswordLabel = ISNULL(LM4.Message, N'')
FROM    SMVendor VEN WITH (READUNCOMMITTED)
        LEFT JOIN EvLocaleMsgs LM1 WITH (READUNCOMMITTED) ON VEN.ArrayNameLabelMsgId = LM1.MessageID AND LM1.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM2 WITH (READUNCOMMITTED) ON VEN.ArrayControlHostLabelMsgId = LM2.MessageID AND LM2.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM3 WITH (READUNCOMMITTED) ON VEN.ArrayUserNameLabelMsgId = LM3.MessageID AND LM3.LocaleID = @localeId
        LEFT JOIN EvLocaleMsgs LM4 WITH (READUNCOMMITTED) ON VEN.ArrayPasswordLabelMsgId = LM4.MessageID AND LM4.LocaleID = @localeId
WHERE   VEN.Id = @vendorId
SELECT
		@copyId AS '@copyId',
		@appId AS '@appId',
		@assocType AS '@assocType',
		@arrayNameLabel AS '@arrayNameLabel',
		@arrayControlHostLabel AS '@arrayControlHostLabel',
		@arrayUserNameLabel AS '@arrayUserNameLabel',
		@arrayPasswordLabel AS '@arrayPasswordLabel',
		@vendorId  AS 'vendor/@id',
		@vendorName  AS 'vendor/@name',
		@arrayId  AS 'array/@id',
		@arrayName  AS 'array/@name',
		@xmlArrayInfo,
		@xmlConfigList AS 'configList',
		@xmlArrayDG,
		@xmlHostDG,
		@selectedMAs,
		@availableMAs
FOR XML PATH ( 'EVGui_MMSMGetArrayDetailsResp' )
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLGetArrayDetails')
	delete from GxQscripts where name = 'MM_SMXMLGetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLGetArrayDetails')
	delete from GXDBVersions where aliasname = 'MM_SMXMLGetArrayDetails'
GO

insert into GXDBVersions values(2, 'MM_SMXMLGetArrayDetails',  '00010021000200190000', 'MM_SMXMLGetArrayDetails', '00010021000200190000')
GO

