

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLDeleteArray.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLDeleteArray.sp,v $ $Id: MM_SMXMLDeleteArray.sp,v 1.6.58.10 2020/10/30 18:27:10 mmani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMXMLDeleteArray')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLDeleteArray <<<'
	drop procedure MM_SMXMLDeleteArray
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLDeleteArray')
	delete from GxQscripts where name = 'MM_SMXMLDeleteArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLDeleteArray')
	delete from GXDBVersions where aliasname = 'MM_SMXMLDeleteArray'
GO
print '... Creating Procedure: MM_SMXMLDeleteArray'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMXMLDeleteArray
  @i_xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @vendorId				INTEGER = 0
DECLARE @vendorName				NVARCHAR(128) = N''
DECLARE @arrayId				INTEGER = 0
DECLARE @arrayName				NVARCHAR(1024) = N''
DECLARE	@archGroupName			NVARCHAR(288) = N''
DECLARE @VIRT_ENGINE INTEGER = 32768 -- SM_SNAPSHOT_ENGINE_CAPABILITY_VIRTUALIZED
DECLARE @errorCode INTEGER = 0
DECLARE	@archGroupNames			NVARCHAR(MAX) = N''
DECLARE @errorMsg				NVARCHAR(MAX) = N''
DECLARE @count					INTEGER = 0
DECLARE @localeId 				INTEGER = 0
DECLARE @outputXML				XML
SET @arrayId = ISNULL ( ( SELECT R.ref.value('@id', 'INTEGER') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMDeleteArrayReq/array' ) R ( ref ) ), 0 )
SET @arrayName = ISNULL ( ( SELECT R.ref.value('@name', 'NVARCHAR(1024)') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMDeleteArrayReq/array' ) R ( ref ) ), N'' )
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                       FROM    @i_xmlTextInput.nodes('EVGui_MMSMDeleteArrayReq/processinginstructioninfo/locale') R ( ref )), 0)
IF @arrayId = 0
BEGIN
	SET @outputXML = (SELECT(
	SELECT	1 AS '@errorCode', 'Given array id is not a valid one. Please select the appropriate array and try delete.' AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	))
	SELECT @outputXML
	RETURN
END
-- Check whether the DFM Server is used by any Storage Policy
DECLARE @tblTmp TABLE
	(
		archGroupName		nVARCHAR(256),
		archGroupId			INTEGER,
		arrayId				INTEGER,
		defaultSnapCopy		INTEGER,
		secondaryCopyExists INTEGER,
		sourceSnapExists	INTEGER
	)
INSERT INTO @tblTmp
SELECT	ISNULL(AG.name, N'') , AGCH.ArchGroupId, ARRAY.ControlHostId, defaultSnapCopy, 0, 0
FROM	ArchGroupControlHost AGCH WITH (NOLOCK)
		INNER JOIN SMControlHost ARRAY WITH (NOLOCK) ON AGCH.ControlHostId = ARRAY.ControlHostId
		INNER JOIN ArchGroup AG WITH (NOLOCK) ON AGCH.ArchGroupId = AG.Id
WHERE	ARRAY.ControlHostId = @arrayId
--Check if the archgroup is associated with any secondary copies- bothactive and in _DELETED state, If any such SP is found, then do not delete the array
UPDATE @tblTmp
	SET	secondaryCopyExists = 1
	FROM archGroupCopy AGC (NOLOCK)
	INNER JOIN @tblTmp TMP ON AGC.archGroupId = TMP.archGroupId
	AND AGC.isSnapCopy = 1 AND AGC.id <> TMP.defaultSnapCopy
--if the @tblTmp has rows with secondaryCopyExists=1 indicates that there exists an OCUM SP that has secondary copies associated
IF EXISTS(SELECT 1 FROM @tblTmp where secondaryCopyExists = 1)
BEGIN
	SELECT @archGroupNames = @archGroupNames + ',' + T1.SPName from (select distinct archGroupName as SPName FROM @tblTmp where secondaryCopyExists = 1) T1
	SELECT @archGroupNames = (select SUBSTRING(@archGroupNames,2,LEN(@archGroupNames)-1))
	SET @count = (SELECT count(distinct archGroupName) FROM @tblTmp where secondaryCopyExists = 1)
	IF @count = 1
		SET	@errorMsg = 'The OCUM server is still used by a storage policy [' + @archGroupNames + '] and has secondary snap copies associated. Please delete the associated storage policy and then delete the OCUM server.'
	ELSE IF @count > 1
		SET	@errorMsg = 'The OCUM server is still used by multiple storage policies [' + @archGroupNames + '] and has secondary snap copies associated. Please delete the associated storage policies and then delete the OCUM server.'
	SET @outputXML = (SELECT(
	SELECT	1 AS '@errorCode', @errorMsg AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	))
	SELECT @outputXML
	RETURN
END
--None of the SPs have secondary copies associated, hence check if the primary snap copy has snapshots associated. If yes, then do not delete the OCUM array
ELSE
BEGIN
	UPDATE @tblTmp
	SET	sourceSnapExists = 1
	FROM SMVolume VOL (NOLOCK)
	INNER JOIN @tblTmp TMP ON VOL.CopyId = TMP.defaultSnapCopy
	INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
	INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	--If any of the Primary snap copies have snaps associated, then do not delete the array
	IF EXISTS(SELECT 1 FROM @tblTmp where sourceSnapExists = 1 )
	BEGIN
		SELECT @archGroupNames = @archGroupNames + ',' + T1.SPName from (select distinct archGroupName as SPName FROM @tblTmp where sourceSnapExists = 1) T1
		SELECT @archGroupNames = (select SUBSTRING(@archGroupNames,2,LEN(@archGroupNames)-1))
		SET @count = (SELECT count(distinct archGroupName) FROM @tblTmp where sourceSnapExists = 1)
		IF @count = 1
			SET	@errorMsg = 'The OCUM server is still used by a storage policy [' + @archGroupNames + '] and the primary snap copies still has snaps associated with it. Please delete the associated storage policy and then delete the OCUM server.'
		ELSE IF @count > 1
			SET	@errorMsg = 'The OCUM server is still used by multiple storage policies [' + @archGroupNames + '] and the primary snap copies still has snaps associated with it. Please delete the associated storage policies and then delete the OCUM server.'
		SET @outputXML = (SELECT(
		SELECT	1 AS '@errorCode', @errorMsg AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		RETURN
	END
END
IF EXISTS (	SELECT 	1
			FROM 	SMSnap WITH (READUNCOMMITTED)
			WHERE 	ControlHostId = @arrayId)
BEGIN
	SET @errorCode = 1
	SET @errorMsg = (SELECT 	Message
					FROM 		EvLocaleMsgs WITH (READUNCOMMITTED)
WHERE 		MessageID = (4582 | (CAST(POWER(2, 24) AS BIGINT) * 35))
								AND LocaleID = @localeId)
    SET @outputXML = (SELECT(
    SELECT  @errorCode AS '@errorCode',
			@errorMsg AS '@errorMessage'
    FOR XML PATH ( 'CVGui_GenericResp' )
    ))
    SELECT @outputXML
    RETURN
END
-- Check for Snaps of Virtualized Engine (like VPLEX)
IF EXISTS   (SELECT     SNAP.*
            FROM        SMSnap SNAP (NOLOCK)
                        LEFT OUTER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.OriginalSnapEngineId
                        LEFT OUTER JOIN SMControlHost ARRAY (NOLOCK) ON ARRAY.ControlHostId = SNAP.ReserveField2
            WHERE       ENG.Capabilities & @VIRT_ENGINE = @VIRT_ENGINE
                        AND ARRAY.ControlHostId = @arrayId)
BEGIN
    SET @outputXML = (SELECT(
    SELECT  1 AS '@errorCode', 'There are still snaps associated with the virtualized array. Please delete all the snaps associated with this array and then delete this array.' AS '@errorMessage'
    FOR XML PATH ( 'CVGui_GenericResp' )
    ))
    SELECT @outputXML
    RETURN
END
IF @arrayName = N''
BEGIN
	SET @arrayName = (SELECT SMArrayId from SMControlHost SCH WITH (NOLOCK) WHERE SCH.ControlHostId = @arrayId)
END
-- Check for Snaps of Virtualized Array (like HDS) only when Physical Array is being deleted.
IF EXISTS	(SELECT *	FROM SMConfigs WITH (NOLOCK)
WHERE ArrayId = @arrayId AND AssocType = 3
AND MasterConfigId = 164 AND ValueStr = N'')
BEGIN
	IF EXISTS	(SELECT		SNAP.*
				FROM		SMSnap SNAP WITH (NOLOCK)
				JOIN		SMConfigs SMC WITH (NOLOCK) ON SMC.ArrayId = SNAP.ControlHostId
				JOIN		SMMasterConfigs SMMC WITH (NOLOCK) ON SMMC.Id = SMC.MasterConfigId
WHERE		SMMC.Id = 164		-- Physical Array Serial # snap config for VSM array
AND	SMMC.VendorId = 2 	-- HDS
							AND	SMC.ValueStr = @arrayName)
	BEGIN
		SET @outputXML = (SELECT(
		SELECT  1 AS '@errorCode', 'There are still snaps associated with the virtualized array. Please delete all the snaps associated with this array and then delete this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		RETURN
	END
END
IF EXISTS (SELECT VHOST.ControlHostId FROM APP_VMToPMMap MAP WITH(NOLOCK)
			INNER JOIN SMControlHost VHOST WITH(NOLOCK) ON MAP.VMClientId = VHOST.ClientId
			INNER JOIN SMControlHost PHOST WITH(NOLOCK) ON MAP.PMClientId = PHOST.ClientId
			WHERE PHOST.ControlHostId = @arrayId)
BEGIN
	SET @outputXML = (SELECT(
	SELECT	1 AS '@errorCode', 'There are still vServers associated with this array. Please delete all the vServers associated with this array and then delete this array.' AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	))
	SELECT @outputXML
	RETURN
END
IF EXISTS (SELECT 1 FROM SMRelationNode (NOLOCK) WHERE vFilerId = @arrayId)
BEGIN
	SET @outputXML = (SELECT(
	SELECT	1 AS '@errorCode', 'There are still NetApp NOSB Storage Policies associated with this vServer. Please delete all the copies associated with this vServer and then delete this array.' AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	))
	SELECT @outputXML
	RETURN
END
-- Cleanup the tables for Offline Replication
IF OBJECT_ID('tempdb.dbo.#replGroupToDel') IS NOT NULL
    DROP TABLE #replGroupToDel
IF OBJECT_ID('tempdb.dbo.#replEntitiesToDel') IS NOT NULL
    DROP TABLE #replEntitiesToDel
CREATE TABLE #replGroupToDel (
		ReplicaGroupId int
	)
CREATE TABLE #replEntitiesToDel (
		ReplicaEntityId	int
	)
create clustered index replGroupToDel_ReplicaGroupId_Idx ON #replGroupToDel(ReplicaGroupId)
create clustered index replEntitiesToDel_ReplicaEntityId_Idx ON #replEntitiesToDel(ReplicaEntityId)
INSERT INTO #replEntitiesToDel
SELECT	ReplicaEntityId FROM SMReplicaEntities (NOLOCK) WHERE ArrayNum = @arrayId
INSERT INTO #replGroupToDel
SELECT	RG.ReplicaGroupId
FROM	SMReplicaGroup RG (NOLOCK) INNER JOIN SMReplicaEntities SRC (NOLOCK) ON RG.SrcEntityId = SRC.ReplicaEntityId
		INNER JOIN SMReplicaEntities TGT (NOLOCK) ON RG.TgtEntityId = TGT.ReplicaEntityId
WHERE	SRC.ArrayNum = @arrayId OR TGT.ArrayNum = @arrayId
IF EXISTS	(SELECT 1 FROM #replGroupToDel RG INNER JOIN SMSnapToReplicaGroupMap MAP (NOLOCK) ON RG.ReplicaGroupId = MAP.ReplicaGroupId)
BEGIN
	SET @outputXML = (SELECT(
	SELECT  1 AS '@errorCode', 'There are still jobs having Replica Groups associated with the array. Please delete all the jobs using Replica Groups from this array and then delete this array.' AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	))
	SELECT @outputXML
	RETURN
END
BEGIN TRANSACTION DeleteArrayTran
BEGIN
	-- Cleanup the tables for Offline Replication
	DELETE MAP FROM SMReplicaGroupMap MAP INNER JOIN #replGroupToDel RG_DEL ON MAP.ReplicaGroupId = RG_DEL.ReplicaGroupId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete replica group mappings for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	DELETE RG FROM	SMReplicaGroup RG INNER JOIN #replGroupToDel RG_DEL ON RG.ReplicaGroupId = RG_DEL.ReplicaGroupId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete replica groups for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	DELETE RE FROM SMReplicaEntities RE INNER JOIN #replEntitiesToDel RE_DEL ON RE.ReplicaEntityId = RE_DEL.ReplicaEntityId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete replica entities for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	DELETE REPL_PAIR FROM SMArrayReplicaPairs REPL_PAIR WHERE SrcArrayNum = @arrayId OR TgtArrayNum = @arrayId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete array replica pairs for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	IF OBJECT_ID('tempdb.dbo.#replGroupToDel') IS NOT NULL
        DROP TABLE #replGroupToDel
	IF OBJECT_ID('tempdb.dbo.#replEntitiesToDel') IS NOT NULL
        DROP TABLE #replEntitiesToDel
	DELETE	SMConfigs
	FROM	SMConfigs
	WHERE	ArrayId = @arrayId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete snap configurations for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
				))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	DELETE	SMConfigsList
	FROM	SMConfigsList
	WHERE	ArrayId = @arrayId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete snap configurations list for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
				))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	DELETE SMHostAlias
	WHERE RefId = @arrayId
AND RefType = 5
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete aliases for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	-- Delete single array-client associations
	DELETE	App_ClientProp
	FROM 	App_ClientProp
	WHERE	attrName = 'Arrays'
			AND attrval = CONVERT(NVARCHAR(20), @arrayId)
			AND modified = 0
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete array-client associations for this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
	-- Remove multi array-client associations
	IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE attrName = 'Arrays'
				AND @arrayId in (SELECT _ID FROM dbo.SplitIDs(attrVal))
				AND	modified = 0)
	BEGIN
		UPDATE	App_ClientProp
		SET 	attrVal =	(
								SELECT 	LEFT(Tbl.List, LEN(Tbl.List) - 1) AS attrVal
								FROM	(SELECT (
													SELECT	CONVERT(NVARCHAR(20), _ID) + ','
													FROM 	dbo.SplitIDs(attrVal)
													WHERE 	_ID <> @arrayId
													FOR 	XML PATH('')
												) AS List
										) Tbl
							)
		WHERE 	attrName = 'Arrays'
				AND @arrayId in (SELECT _ID FROM dbo.SplitIDs(attrVal))
				AND modified = 0
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SET @outputXML = (SELECT(
			SELECT	@errorCode AS '@errorCode', 'Failed to remove array-client associations for this array.' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			))
			SELECT @outputXML
			ROLLBACK TRANSACTION DeleteArrayTran
			RETURN
		END
	END
	--Before deleting from SMControlHost, verify if the OCUM array is associated to any storage policy - If yes, then delete the association
	IF EXISTS(SELECT 1 FROM @tblTmp where arrayId = @arrayId)
	BEGIN
		DELETE ArchGroupControlHost
		FROM   ArchGroupControlHost
		WHERE  ControlHostId = @arrayId
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SET @outputXML = (SELECT(
			SELECT	@errorCode AS '@errorCode', 'Failed to remove array-storage policy asssociation for the OCUM array.' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			))
			SELECT @outputXML
			ROLLBACK TRANSACTION DeleteArrayTran
			RETURN
		END
	END
	--Delete the region association, if exists
IF EXISTS (SELECT 1 FROM APP_AdvanceSettings (NOLOCK) WHERE entityType = 153/*ARRAY_ENTITY*/ AND entityId = @arrayId AND keyName = 'Region Id')
	BEGIN
		DELETE	APP_AdvanceSettings
		FROM	APP_AdvanceSettings
WHERE	entityType = 153/*ARRAY_ENTITY*/ AND entityId = @arrayId AND keyName = 'Region Id'
		SET @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SET @outputXML = (SELECT(
			SELECT	@errorCode AS '@errorCode', 'Failed to remove array-region asssociation for the array [' + @arrayName + ']' AS '@errorMessage'
			FOR XML PATH ( 'CVGui_GenericResp' )
			))
			SELECT @outputXML
			ROLLBACK TRANSACTION DeleteArrayTran
			RETURN
		END
	END
	DELETE	SMControlHost
	FROM	SMControlHost
	WHERE	ControlHostId = @arrayId
	SET @errorCode = @@ERROR
	IF @errorCode > 0
	BEGIN
		SET @outputXML = (SELECT(
		SELECT	@errorCode AS '@errorCode', 'Failed to delete this array.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		))
		SELECT @outputXML
		ROLLBACK TRANSACTION DeleteArrayTran
		RETURN
	END
END
COMMIT TRANSACTION DeleteArrayTran
SET @outputXML = (SELECT(
SELECT	0 AS '@errorCode', 'Array has been successfully deleted' AS '@errorMessage'
FOR XML PATH ( 'CVGui_GenericResp' )
))
SELECT @outputXML
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLDeleteArray')
	delete from GxQscripts where name = 'MM_SMXMLDeleteArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLDeleteArray')
	delete from GXDBVersions where aliasname = 'MM_SMXMLDeleteArray'
GO

insert into GXDBVersions values(2, 'MM_SMXMLDeleteArray',  '00010006005800100000', 'MM_SMXMLDeleteArray', '00010006005800100000')
GO

