

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMXMLArrayReplPairOp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMXMLArrayReplPairOp.sp,v $ $Id: MM_SMXMLArrayReplPairOp.sp,v 1.1.2.6 2020/03/12 21:59:44 mtayal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMXMLArrayReplPairOp')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMXMLArrayReplPairOp <<<'
	drop procedure MM_SMXMLArrayReplPairOp
END
IF EXISTS (select * from GxQscripts where name='MM_SMXMLArrayReplPairOp')
	delete from GxQscripts where name = 'MM_SMXMLArrayReplPairOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLArrayReplPairOp')
	delete from GXDBVersions where aliasname = 'MM_SMXMLArrayReplPairOp'
GO
print '... Creating Procedure: MM_SMXMLArrayReplPairOp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMXMLArrayReplPairOp
  @i_xmlTextInput XML OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ARRAY_REPL_PAIR_OPERATION_GET INT = 1
DECLARE @ARRAY_REPL_PAIR_OPERATION_UPDATE INT = 2
-- XML Input Parameters
DECLARE @i_copyId				INTEGER = 0
DECLARE @i_operationId			INTEGER = 0
DECLARE @i_flags				INTEGER = 0
DECLARE @i_userId				INTEGER = 0
-- Get the input parameters from the XML input str
SET @i_copyId = ISNULL ( ( SELECT R.ref.value('@copyId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMArrayReplicaPairReq' ) R ( ref ) ), 0 )
SET @i_operationId = ISNULL ( ( SELECT R.ref.value('@operation', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMArrayReplicaPairReq' ) R ( ref ) ), 0 )
SET @i_flags = ISNULL ( ( SELECT R.ref.value('@flags', 'bigint') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMArrayReplicaPairReq' ) R ( ref ) ), 0 )
SET @i_userId = ISNULL ( ( SELECT R.ref.value('@userId', 'integer') FROM @i_xmlTextInput.nodes ( '/EVGui_MMSMArrayReplicaPairReq' ) R ( ref ) ), 0 )
IF @i_operationId NOT IN(@ARRAY_REPL_PAIR_OPERATION_GET, @ARRAY_REPL_PAIR_OPERATION_UPDATE )
BEGIN
	SELECT  1 AS '@errorCode', 'Operation Type is invalid for array replica pair operation.' AS '@errorMessage'
	FOR XML PATH ( 'CVGui_GenericResp' )
	RETURN
END
DECLARE @replicaPairsTbl TABLE(
	replicaPairId	INT,
	srcArrayId		INT,
	srcArrayName	NVARCHAR(MAX),
	tgtArrayId		INT,
	tgtArrayName	NVARCHAR(MAX),
	copyId			INT,
	flags			INT
)
INSERT INTO @replicaPairsTbl
SELECT	ref.value('@replicaPairId', 'int'),
		ref.value('./srcArray[1]/@id','int'),
		ref.value('./srcArray[1]/@name','nvarchar(max)'),
		ref.value('./tgtArray[1]/@id','int'),
		ref.value('./tgtArray[1]/@name','nvarchar(max)'),
		ref.value('@copyId', 'int'),
		ISNULL(ref.value('@flags', 'bigint'),0)
FROM	@i_xmlTextInput.nodes('/EVGui_MMSMArrayReplicaPairReq/replPairList') R(ref)
IF @i_operationId = @ARRAY_REPL_PAIR_OPERATION_GET
BEGIN
	-- Fetch the replica pair information for a given copyId
	DECLARE @xmlReplicaPairs XML
	SET @xmlReplicaPairs = (	SELECT	R.ReplicaPairId AS '@replicaPairId',
						R.ArchGroupCopyId AS '@copyId',
						R.Flags AS '@flags',
						SRC.ControlHostId AS 'srcArray/@id',
						CASE WHEN LEN(ISNULL(CFG_SRC.ValueStr,'')) > 0 THEN CFG_SRC.ValueStr ELSE SRC.SMArrayId END AS 'srcArray/@name',
						TGT.ControlHostId AS 'tgtArray/@id',
						CASE WHEN LEN(ISNULL(CFG_TGT.ValueStr,'')) > 0 THEN CFG_TGT.ValueStr ELSE TGT.SMArrayId END AS 'tgtArray/@name',
3 AS 'vendor/@id', -- Currently this table supports NetApp vendor only.
'NetApp' AS 'vendor/@name'
				FROM	SMArrayReplicaPairs R (NOLOCK)
						INNER JOIN SMControlHost SRC (NOLOCK) ON R.SrcArrayNum = SRC.ControlHostId
						INNER JOIN SMControlHost TGT (NOLOCK) ON R.TgtArrayNum = TGT.ControlHostId
LEFT JOIN SMConfigs CFG_SRC (NOLOCK) ON SRC.ControlHostId = CFG_SRC.ArrayId AND CFG_SRC.AssocType = 3
LEFT JOIN SMConfigs CFG_TGT (NOLOCK) ON TGT.ControlHostId = CFG_TGT.ArrayId AND CFG_TGT.AssocType = 3
WHERE	ArchGroupCopyId = @i_copyId AND CFG_SRC.MasterConfigId = 200 AND CFG_TGT.MasterConfigId = 200
				FOR XML PATH ('replPairList'))
	-- Fetch the replica pair information for a given copyId
	SELECT @i_copyId AS '@copyId', @xmlReplicaPairs
	FOR XML PATH ('EVGui_MMSMArrayReplicaPairResp')
END
ELSE
BEGIN
	-- Update the replica pair information for the given copy in the DB
	-- Add sanity checks to for copyId
	IF NOT EXISTS (SELECT 1 FROM archGroupCopy (NOLOCK) WHERE id = @i_copyId)
	BEGIN
		SELECT  1 AS '@errorCode', 'Array replica pair operation: Input copy Id does not exist.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
	-- Add sanity check for Arrays
	IF EXISTS (SELECT 1 FROM @replicaPairsTbl A LEFT JOIN SMControlHost CTRL ON A.srcArrayId = CTRL.ControlHostId WHERE CTRL.ControlHostId IS NULL )
	BEGIN
		SELECT  1 AS '@errorCode', 'Array replica pair operation: Input source array number does not exist.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
	IF EXISTS (SELECT 1 FROM @replicaPairsTbl A LEFT JOIN SMControlHost CTRL ON A.tgtArrayId = CTRL.ControlHostId WHERE CTRL.ControlHostId IS NULL )
	BEGIN
		SELECT  1 AS '@errorCode', 'Array replica pair operation: Input target array number does not exist.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END
	-- Add the replica pairs if not exists and return success
	BEGIN TRY
		BEGIN TRAN ArrayReplicaPairOpTran
		INSERT INTO SMArrayReplicaPairs (ArchGroupCopyId, SrcArrayNum, TgtArrayNum, Flags)
		SELECT	@i_copyId, A.srcArrayId, A.tgtArrayId, A.flags
		FROM	@replicaPairsTbl A
				LEFT JOIN SMArrayReplicaPairs PAIR (NOLOCK) ON PAIR.ArchGroupCopyId = @i_copyId AND A.srcArrayId = PAIR.SrcArrayNum AND PAIR.TgtArrayNum = A.tgtArrayId
		WHERE	PAIR.ArchGroupCopyId IS NULL
		-- Delete the pairs that are not present in the input
		DELETE PAIR
		FROM	SMArrayReplicaPairs PAIR
				LEFT JOIN @replicaPairsTbl A ON PAIR.ArchGroupCopyId = @i_copyId AND A.srcArrayId = PAIR.SrcArrayNum AND PAIR.TgtArrayNum = A.tgtArrayId
		WHERE	A.srcArrayId IS NULL AND PAIR.ArchGroupCopyId = @i_copyId
		COMMIT TRAN ArrayReplicaPairOpTran
		SELECT  0 AS '@errorCode', 'Array Replica pairs updated successfully.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
		RETURN
	END TRY
	BEGIN CATCH
		IF XACT_STATE() <> 0
		ROLLBACK TRANSACTION ArrayReplicaPairOpTran
		SELECT  1 AS '@errorCode', 'Failed to update Array Replica pairs.' AS '@errorMessage'
		FOR XML PATH ( 'CVGui_GenericResp' )
	END CATCH
END
GO


IF EXISTS (select * from GxQscripts where name = 'MM_SMXMLArrayReplPairOp')
	delete from GxQscripts where name = 'MM_SMXMLArrayReplPairOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMXMLArrayReplPairOp')
	delete from GXDBVersions where aliasname = 'MM_SMXMLArrayReplPairOp'
GO

insert into GXDBVersions values(2, 'MM_SMXMLArrayReplPairOp',  '00010001000200060000', 'MM_SMXMLArrayReplPairOp', '00010001000200060000')
GO

