

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountVM.sp,v $ $Id: MM_SMVolSnapsToUnmountVM.sp,v 1.1.4.2 2018/11/15 17:57:31 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToUnmountVM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToUnmountVM <<<'
	drop procedure MM_SMVolSnapsToUnmountVM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToUnmountVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountVM'
GO
print '... Creating Procedure: MM_SMVolSnapsToUnmountVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToUnmountVM
  @i_xmlInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MountVMVolId INTEGER
  DECLARE @o_MountVMSnapId INTEGER
  DECLARE @o_UnmountMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-----------------------------------------------------------------------------
-- XML Structure for MM_SMVolSnapsToUnmountVM
-----------------------------------------------------------------------------
/*
	<MM_SMVolSnapsToUnmountVM>
		<JobId>xxxx</JobId>
		<HostId>xxxx</HostId>
		<MountFlags>xxxx</MountFlags>
		<MountMode>xxxx</MountMode>
		<OpSource>xxxx</OpSource>
		<SMVolumes>
			<VolumeId>xxxx</VolumeId>
			<VolumeId>xxxx</VolumeId>
			...
			<VolumeId>xxxx</VolumeId>
		</SMVolumes>
	</MM_SMVolSnapsToUnmountVM>
*/
----------------------------------------------------- ERROR VARIABLES -----------------------------------------------------
SET @o_ErrorCode    = 0
SET @o_ErrorStr     = ''
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT                INTEGER = 60200	/*	E_MM_SM_SB_ERROR	*/
----------------------------------------------------- INPUT VALIDATION ----------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
    SET @o_ErrorCode    = @ERROR_INVALID_XML_INPUT
    SET @o_ErrorStr     = 'Input XML Parameter cannot be empty.'
    GOTO PROC_FAILURE
END
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE @x_JobId								INTEGER			= 0
DECLARE @x_HostId								INTEGER			= 0
DECLARE @x_OpSource								INTEGER			= 0
DECLARE @x_MountFlags							BIGINT			= 0
DECLARE @x_MountMode							BIGINT			= 0
DECLARE	@l_RetVal								INTEGER			= 0
DECLARE	@l_VolId								INTEGER			= 0
DECLARE	@l_VsaVolumeFlag						BIGINT			= 4294967296		/*	CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB	*/
----------------------------------------------------- LOCAL TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtVM_Ret'		) IS NOT NULL
	DROP TABLE #SMVSToUmtVM_Ret
---- Return table
CREATE TABLE #SMVSToUmtVM_Ret					(	UnmountVolumeId	INT,
													UnmountSnapId	INT,
													UnmountMode		INT,
													ErrorCode		INT,
													ErrorStr		VARCHAR(1024)	)
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_JobId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/JobId'		)	R(ref)), 0)
SET @x_HostId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/HostId'		)	R(ref)), 0)
SET @x_MountFlags	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/MountFlags'	)	R(ref)), 0)
SET @x_MountMode	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/MountMode'	)	R(ref)), 0)
SET @x_OpSource		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/OpSource'	)	R(ref)), 0)
---- If the flag for Proxyless is set, call the corresponding SP
IF(		((@x_MountMode	& 4				/*	SM_VSA_MOUNT_MODE_NO_ESX_DS	*/				) = 4				/*	SM_VSA_MOUNT_MODE_NO_ESX_DS	*/				)
		OR
((@x_MountFlags & 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	) = 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	)
	)
BEGIN
	INSERT INTO		#SMVSToUmtVM_Ret
	EXEC @l_RetVal	= MM_SMVolSnapsToUnmountPVM @i_xmlInput, 0, ''
	IF(@l_RetVal <> 0)
	BEGIN
IF (@l_RetVal <> 60340	/*	E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT	*/)
		BEGIN
SET @o_ErrorCode	=	ISNULL( (SELECT ErrorCode	FROM #SMVSToUmtVM_Ret),	60200	/*	E_MM_SM_SB_ERROR	*/	)
			SET @o_ErrorStr		=	ISNULL( (SELECT ErrorStr	FROM #SMVSToUmtVM_Ret),	'Validation for proxyless mode failed'				)
			GOTO PROC_FAILURE
		END
		---- Else, continue with single-node unmount validation..
	END
	ELSE IF (@l_RetVal = 0)
	BEGIN
		GOTO PROC_SUCCESS
	END
END
----------------------------------------------------- TEMP TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtVM_InVols'		) IS NOT NULL
	DROP TABLE #SMVSToUmtVM_InVols
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtVM_LinkVols'		) IS NOT NULL
	DROP TABLE #SMVSToUmtVM_LinkVols
---- Volume table
CREATE TABLE #SMVSToUmtVM_InVols													(	SMVolumeId		INT,
																						MasterJobId		INT,
																						VolFlags		BIGINT		)
CREATE INDEX SMVSToUmtVM_InVols_SMVols_Idx		ON	#SMVSToUmtVM_InVols				(	SMVolumeId					)
---- Volumes linked to Linking-Snaps table
CREATE TABLE #SMVSToUmtVM_LinkVols													(	SMVolumeId		INT,
																						MountStatus		INT,
																						MasterJobId		INT,
																						MountHostId		INT			)
CREATE INDEX SMVSToUmtVM_LinkVols_SMVolumeId_Idx	ON	#SMVSToUmtVM_LinkVols		(	SMVolumeId					)
----------------------------------------------------- INPUT FETCHING -------------------------------------------------------
---- Get all the volume Ids
INSERT	INTO	#SMVSToUmtVM_InVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MasterJobId, VOL.VolumeFlags
FROM			(	SELECT	R.ref.value('.', 'INT') AS SMVolumeId
					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/SMVolumes/VolumeId') R(ref)
				) AS
				TV	INNER JOIN	SMVolume VOL (READUNCOMMITTED)	ON TV.SMVolumeId = VOL.SMVolumeId
----------------------------------------------------- INPUT VALIDATION 2 ----------------------------------------------------
IF EXISTS	(	SELECT	TOP 1 TV.SMVolumeId
				FROM	#SMVSToUmtVM_InVols	TV
				WHERE	TV.VolFlags & @l_VsaVolumeFlag <> @l_VsaVolumeFlag
			)
BEGIN
		SET		@o_ErrorStr		= 'The list contains mix of VSA Indexing-V2 and other snaps. Please select either VSA Indexing-V2 snap volumes alone or the other ones alone.'
SET		@o_ErrorCode	= 60200		/*	E_MM_SM_SB_ERROR	*/
		GOTO	PROC_FAILURE
END
----------------------------------------------------- MAIN LOGIC ----------------------------------------------------------
---- Get all the Vols associated with the Snaps which were fetched previously.
INSERT	INTO	#SMVSToUmtVM_LinkVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MountStatus, VOL.MasterJobId, VOL.MountHostId
FROM			#SMVSToUmtVM_InVols	TV	INNER JOIN	SMVolSnapMap	MAP  (READUNCOMMITTED)	ON TV.SMVolumeId	= MAP.SMVolumeId
										INNER JOIN	SMVolSnapMap	RMAP (READUNCOMMITTED)	ON MAP.SMSnapId		= RMAP.SMSnapId
										INNER JOIN	SMVolume		VOL  (READUNCOMMITTED)	ON RMAP.SMVolumeId	= VOL.SMVolumeId
WHERE			(	VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag				)
				AND
				(	VOL.SMVolumeId	NOT IN (SELECT SMVolumeId FROM #SMVSToUmtVM_InVols)	)
---- Fail the Unmount Validation if any one of the linked volumes is in Mounting / Unmounting state.
---- Refer to VSA V2 - Mount Unmount Validation excel sheet to get more insights
SET		@l_VolId =	(	SELECT TOP 1	TLV.SMVolumeId
						FROM			#SMVSToUmtVM_LinkVols	TLV
WHERE			(	TLV.MountStatus >=	40	/*	SM_VS_MNT_STARTED	*/	AND		TLV.MountStatus <	58	/*	SM_VS_MNT_FAILED	*/	)
										OR
(	TLV.MountStatus >=	60	/*	SM_VS_UMT_STARTED	*/	AND		TLV.MountStatus <	78	/*	SM_VS_UMT_FAILED	*/	)
					)
IF		@l_VolId IS NOT NULL
BEGIN
		SET		@o_ErrorStr		= 'One or more linked volumes [' + CONVERT(VARCHAR(10), @l_VolId) + '] is being used by Jobs]'
SET		@o_ErrorCode	= 60207		/*	E_MM_SM_SB_VOL_OP_IN_PROCESS	*/
		GOTO	PROC_FAILURE
END
---- Check if any of the shared vols is mounted, if so do only DB op for the current volume
--INSERT	INTO	#SMVSToUmtVM_Ret
--SELECT			DISTINCT TV.SMVolumeId, 0, 32	/*	SM_UMT_MOD_NO_OP	*/, 0, ''
--FROM			#SMVSToUmtVM_LinkVols TLV	INNER JOIN SMVolSnapMap			MAP	 (READUNCOMMITTED)	ON TLV.SMVolumeId	= MAP.SMVolumeId
--											INNER JOIN SMVolSnapMap			RMAP (READUNCOMMITTED)	ON MAP.SMSnapId		= RMAP.SMSnapId
--											INNER JOIN #SMVSToUmtVM_InVols	TV						ON RMAP.SMVolumeId	= TV.SMVolumeId
--											INNER JOIN SMSnapResource		RSRV (READUNCOMMITTED)	ON TLV.SMVolumeId	= RSRV.SMVolumeId		---- What about Proxyless entries??
--WHERE				TLV.MountStatus = 59		/*	SM_VS_MNT_MOUNTED	*/
--				AND	TLV.MountHostId = @x_HostId
---- Return all the shared snaps that should not get unmounted.
INSERT	INTO	#SMVSToUmtVM_Ret
SELECT			DISTINCT 0, MAP.SMSnapId, 1	/*	SM_UMP_MOD_RETAIN	*/, 0 , N''
FROM			#SMVSToUmtVM_LinkVols TLV	INNER JOIN SMVolSnapMap	MAP	(READUNCOMMITTED)	ON TLV.SMVolumeId = MAP.SMVolumeId
WHERE			TLV.MountStatus =	59	/*	SM_VS_MNT_MOUNTED	*/		AND
				TLV.MountHostId =	@x_HostId
---- Set the Output values
INSERT	INTO	#SMVSToUmtVM_Ret
SELECT			TV.SMVolumeId, 0, 0	/*	SM_UMT_MOD_NONE	*/, 0, ''
FROM			#SMVSToUmtVM_InVols TV
WHERE			TV.SMVolumeId NOT IN (	SELECT RET.UnmountVolumeId FROM #SMVSToUmtVM_Ret RET	)
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
PROC_SUCCESS:
	-- Get the return values
	SELECT	TR.UnmountVolumeId, TR.UnmountSnapId, TR.UnmountMode, @o_ErrorCode, @o_ErrorStr
	FROM	#SMVSToUmtVM_Ret TR
	GOTO PROC_END
PROC_FAILURE:
	-- Get the return values.
	SELECT 0, 0, 0, @o_ErrorCode, @o_ErrorStr
PROC_END:
	-- Cleanup the temp tables
	IF OBJECT_ID('temp.dbo.#SMVSToUmtVM_InVols'			)	IS NOT NULL
		DROP TABLE #SMVSToUmtVM_InVols
	IF OBJECT_ID('temp.dbo.#SMVSToUmtVM_LinkVols'		)	IS NOT NULL
		DROP TABLE #SMVSToUmtVM_LinkVols
	IF OBJECT_ID('temp.dbo.#SMVSToUmtVM_Ret'			)	IS NOT NULL
		DROP TABLE #SMVSToUmtVM_Ret
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToUnmountVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountVM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToUnmountVM',  '00010001000400020000', 'MM_SMVolSnapsToUnmountVM', '00010001000400020000')
GO

