

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountPVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountPVM.sp,v $ $Id: MM_SMVolSnapsToUnmountPVM.sp,v 1.1.4.2 2018/11/15 17:57:22 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToUnmountPVM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToUnmountPVM <<<'
	drop procedure MM_SMVolSnapsToUnmountPVM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToUnmountPVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountPVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountPVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountPVM'
GO
print '... Creating Procedure: MM_SMVolSnapsToUnmountPVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToUnmountPVM
  @i_xmlInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MountVMVolId INTEGER
  DECLARE @o_MountVMSnapId INTEGER
  DECLARE @o_UnmountMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-----------------------------------------------------------------------------
-- XML Structure for MM_SMVolSnapsToUnmountPVM
-----------------------------------------------------------------------------
/*
	<MM_SMVolSnapsToUnmountVM>
		<JobId>xxxx</JobId>
		<HostId>xxxx</HostId>
		<MountFlags>xxxx</MountFlags>
		<MountMode>xxxx</MountMode>
		<OpSource>xxxx</OpSource>
		<SMVolumes>
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
			...
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
		</SMVolumes>
	</MM_SMVolSnapsToUnmountVM>
*/
----------------------------------------------------- ERROR VARIABLES -----------------------------------------------------
SET @o_ErrorCode    = 0
SET @o_ErrorStr     = ''
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT                INTEGER = 60200	/*	E_MM_SM_SB_ERROR	*/
----------------------------------------------------- INPUT VALIDATION ----------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
    SET @o_ErrorCode    = @ERROR_INVALID_XML_INPUT
    SET @o_ErrorStr     = 'Input XML Parameter cannot be empty.'
    GOTO PROC_FAILURE
END
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE @x_JobId								INTEGER			= 0
DECLARE @x_HostId								INTEGER			= 0
DECLARE @x_OpSource								INTEGER			= 0
DECLARE @x_MountFlags							BIGINT			= 0
DECLARE @x_MountMode							BIGINT			= 0
DECLARE	@l_MountVolId							INTEGER			= 0
DECLARE	@l_RetVal								INTEGER			= 0
DECLARE	@l_VsaVolumeFlag						BIGINT			= 4294967296		/*	CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB	*/
----------------------------------------------------- LOCAL TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_InVols'		) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_InVols
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_InMVols'		) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_InMVols
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkSnaps'	) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_LinkSnaps
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkVols'	) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_LinkVols
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkMVols'	) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_LinkMVols
IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_Ret'			) IS NOT NULL
	DROP TABLE #SMVSToUmtPVM_Ret
---- Volume table
CREATE TABLE #SMVSToUmtPVM_InVols													(	SMVolumeId		INT,
																						MasterJobId		INT,
																						VolFlags		BIGINT			)
CREATE INDEX SMVSToUmtPVM_InVols_SMVols_Idx			ON	#SMVSToUmtPVM_InVols		(	SMVolumeId						)
---- MountVolume table
CREATE	TABLE #SMVSToUmtPVM_InMVols													(	MountVolumeId	INT,
																						SMVolumeId		INT,
																						MountJobId		INT				)
CREATE INDEX SMVSToUmtPVM_InMVols_MVols_Idx			ON	#SMVSToUmtPVM_InMVols		(	MountVolumeId					)
---- Linked Snap table
CREATE TABLE #SMVSToUmtPVM_LinkSnaps												(	SMSnapId		INT,
																						EngineId		INT				)
CREATE INDEX SMVSToUmtPVM_LS_SMSnapId_Idx			ON	#SMVSToUmtPVM_LinkSnaps		(	SMSnapId						)
---- Volumes Linked to Linked-Snaps
CREATE TABLE #SMVSToUmtPVM_LinkVols													(	SMVolumeId		INT,
																						MountStatus		INT,
																						MasterJobId		INT,
																						MountHostId		INT,			)
CREATE INDEX SMVSToUmtPVM_LV_SMVols_Idx				ON	#SMVSToUmtPVM_LinkVols		(	SMVolumeId						)
---- MountVolumes linked to Linked-Vols
CREATE TABLE #SMVSToUmtPVM_LinkMVols												(	SMMountVolId	INT,
																						SMVolumeId		INT,
																						MountJobId		INT,
																						MountHostId		INT,
																						MountStatus		INT,
																						MountOptions	NVARCHAR(2048)	)
CREATE INDEX SMVSToUmtPVM_LinkMVols_MVols_Idx		ON	#SMVSToUmtPVM_LinkMVols		(	SMMountVolId					)
---- Return table
CREATE TABLE #SMVSToUmtPVM_Ret														(	BaseVolumeId	INT,
																						BaseSnapId		INT,
																						UnmountMode		INT,
																						ErrorCode		INT,
																						ErrorStr		VARCHAR(1024)	)
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_JobId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/JobId'		)	R(ref)), 0)
SET @x_HostId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/HostId'		)	R(ref)), 0)
SET @x_MountFlags	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/MountFlags'	)	R(ref)), 0)
SET @x_MountMode	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/MountMode'	)	R(ref)), 0)
SET @x_OpSource		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/OpSource'	)	R(ref)), 0)
-- Get all the volume Ids
INSERT	INTO	#SMVSToUmtPVM_InVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MasterJobId, VOL.VolumeFlags
FROM			(	SELECT	R.ref.value('.', 'INT') AS SMVolumeId
					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/SMVolumes/VolumeId') R(ref)
				) AS
				TV	INNER JOIN	SMVolume VOL (READUNCOMMITTED)	ON	TV.SMVolumeId = VOL.SMVolumeId
-- Get all the MountVolumeIds
INSERT	INTO	#SMVSToUmtPVM_InMVols
SELECT			DISTINCT MVOL.Id, MVOL.SMVolumeId, MVOL.MountJobId
FROM			(	SELECT	R.ref.value('.', 'INT') as MountVolumeId
					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToUnmountVM/SMVolumes/MountVolumeId') R(ref)
				) AS
				TBMV	LEFT OUTER JOIN	SMMountVolume MVOL (READUNCOMMITTED)	ON TBMV.MountVolumeId = MVOL.Id
----------------------------------------------------- INPUT VALIDATION 2 ----------------------------------------------------
IF EXISTS	(	SELECT	TOP 1 TV.SMVolumeId
				FROM	#SMVSToUmtPVM_InVols	TV
				WHERE	TV.VolFlags & @l_VsaVolumeFlag <> @l_VsaVolumeFlag
			)
BEGIN
		SET		@o_ErrorStr		= 'The list contains mix of VSA Indexing-V2 and other snaps. Please select either VSA Indexing-V2 snap volumes alone or the other ones alone.'
SET		@o_ErrorCode	= 60200		/*	E_MM_SM_SB_ERROR	*/
		GOTO	PROC_FAILURE
END
----------------------------------------------------- MAIN LOGIC ----------------------------------------------------------
---- Get all the Snaps behind the datatsore being used by current Vols
INSERT	INTO	#SMVSToUmtPVM_LinkSnaps
SELECT			DISTINCT SNAP.SMSnapId, SNAP.SnapShotEngineId
FROM			#SMVSToUmtPVM_InVols TV	INNER JOIN	SMVolSnapMap	MAP	 (READUNCOMMITTED)	ON	TV.SMVolumeId	= MAP.SMVolumeId
										INNER JOIN	SMSnap			SNAP (READUNCOMMITTED)	ON	MAP.SMSnapId	= SNAP.SMSnapId
---- First check if the Engine is multi-node capable or not
IF(	(@x_MountFlags & 268435456 /*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/) = 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	)
BEGIN
	IF EXISTS	(	SELECT		TOP 1 TLS.SMSnapId
					FROM		#SMVSToUmtPVM_LinkSnaps	TLS	INNER JOIN	SMSnapshotEngine ENG (READUNCOMMITTED)	ON TLS.EngineId = ENG.SnapShotEngineId
WHERE		(ENG.Capabilities & 67108864	/*	SM_SNAPSHOT_ENGINE_CAPABILITY_ALLOW_MULTI_NODE_MOUNT_VMWARE	*/ = 0)
				)
	BEGIN
		SET		@o_ErrorStr		= 'The current engine is not Multi-Node Mount capable. Skipping to single-node unmount validation.'
SET		@o_ErrorCode	= 60340	/*	E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT	*/
		GOTO	PROC_FAILURE
	END
END
---- Get all the Vols associated with the Snaps which were fetched previously.
INSERT	INTO	#SMVSToUmtPVM_LinkVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MountStatus, VOL.MasterJobId, VOL.MountHostId
FROM			#SMVSToUmtPVM_LinkSnaps	TLS	INNER JOIN	SMVolSnapMap	MAP (READUNCOMMITTED)	ON	TLS.SMSnapId	= MAP.SMSnapId
											INNER JOIN	SMVolume		VOL (READUNCOMMITTED)	ON	MAP.SMVolumeId	= VOL.SMVolumeId
WHERE			(	VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag					)
				AND
				(	VOL.SMVolumeId	NOT IN (SELECT SMVolumeId FROM #SMVSToUmtPVM_InVols)	)
---- Get all the MountVolume entries for the Vols sharing the Snaps which is to be unmapped.
INSERT	INTO	#SMVSToUmtPVM_LinkMVols
SELECT			MVOL.Id,
				MVOL.SMVolumeId,
				ISNULL(MVOL.MountJobId,		0	),
				ISNULL(MVOL.MountHostId,	0	),
				ISNULL(MVOL.MountStatus,	0	),
				ISNULL(MVOL.MountOptions,	N''	)
FROM			#SMVSToUmtPVM_LinkVols TLV	LEFT OUTER JOIN SMMountVolume MVOL (READUNCOMMITTED)	ON TLV.SMVolumeId = MVOL.SMVolumeId
---- Fail the Unmount Validation if any one of the linked MountVolumes is in Mounting / Unmounting state.
---- Refer to VSA V2 - Mount Unmount Validation excel sheet to get more insights
SET		@l_MountVolId =	(	SELECT TOP 1	TLMV.SMVolumeId
							FROM			#SMVSToUmtPVM_LinkMVols	TLMV
WHERE			(	TLMV.MountStatus >=	40	/*	SM_VS_MNT_STARTED	*/	AND		TLMV.MountStatus <	58	/*	SM_VS_MNT_FAILED	*/	)
											OR
(	TLMV.MountStatus >=	60	/*	SM_VS_UMT_STARTED	*/	AND		TLMV.MountStatus <	78	/*	SM_VS_UMT_FAILED	*/	)
						)
IF		@l_MountVolId IS NOT NULL
BEGIN
		SET		@o_ErrorStr		= 'One or more linked volumes [' + CONVERT(VARCHAR(10), @l_MountVolId) + '] is being used by Jobs'
SET		@o_ErrorCode	= 60207	/*	E_MM_SM_SB_VOL_OP_IN_PROCESS	*/
		GOTO	PROC_FAILURE
END
---- Check if any of the shared vols is mounted, if so do only DB op for the current volume
--INSERT	INTO	#SMVSToUmtPVM_Ret
--SELECT			DISTINCT TMV.SMVolumeId, 0, 32	/*	SM_UMT_MOD_NO_OP	*/, 0, ''
--FROM			#SMVSToUmtPVM_LinkMVols TLMV	INNER JOIN SMMountMap				MMAP  (READUNCOMMITTED)	ON TLMV.SMMountVolId		= MMAP.SMMountVolumeId
--												INNER JOIN SMMountMap				RMMAP (READUNCOMMITTED)	ON MMAP.SMSnapId			= RMMAP.SMSnapId
--												INNER JOIN #SMVSToUmtPVM_InMVols	TMV						ON RMMAP.SMMountVolumeId	= TMV.MountVolumeId
--												INNER JOIN SMSnapResource			RSRV  (READUNCOMMITTED)	ON TLMV.SMVolumeId			= RSRV.SMVolumeId
--																											AND	TLMV.SMMountVolId		= RSRV.SnapShotId
--WHERE				TLMV.MountStatus = 59		/*	SM_VS_MNT_MOUNTED	*/
--				AND	TLMV.MountHostId = @x_HostId
------ If there are any Mounted entries, collect the corresponding Snap Id
INSERT	INTO	#SMVSToUmtPVM_Ret
SELECT			DISTINCT 0, MMAP.SMSnapId, 1	/*	SM_UMP_MOD_RETAIN	*/, 0, N''
FROM			#SMVSToUmtPVM_LinkMVols	TLMV INNER JOIN SMMountMap MMAP	ON TLMV.SMMountVolId = MMAP.SMMountVolumeId
WHERE			TLMV.MountHostId	= @x_HostId
AND	TLMV.MountStatus	= 59		/*	SM_VS_MNT_MOUNTED	*/
---- Set the Output values
INSERT	INTO	#SMVSToUmtPVM_Ret
SELECT			TV.SMVolumeId, 0, 0	/*	SM_UMT_MOD_NONE	*/, 0, ''
FROM			#SMVSToUmtPVM_InVols TV
WHERE			TV.SMVolumeId NOT IN (	SELECT RET.BaseVolumeId FROM #SMVSToUmtPVM_Ret RET	)
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
PROC_SUCCESS:
	-- Get the return values
	SELECT	TR.BaseVolumeId, TR.BaseSnapId, TR.UnmountMode, @o_ErrorCode, @o_ErrorStr
	FROM	#SMVSToUmtPVM_Ret TR
	GOTO PROC_END
PROC_FAILURE:
	-- Get the return values.
	SELECT 0, 0, 0, @o_ErrorCode, @o_ErrorStr
PROC_END:
	-- Cleanup the temp tables
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_InVols'		) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_InVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_InMVols'		) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_InMVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkSnaps'	) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_LinkSnaps
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkVols'	) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_LinkVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_LinkMVols'	) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_LinkMVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToUmtPVM_Ret'			) IS NOT NULL
		DROP TABLE #SMVSToUmtPVM_Ret
	RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToUnmountPVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountPVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountPVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountPVM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToUnmountPVM',  '00010001000400020000', 'MM_SMVolSnapsToUnmountPVM', '00010001000400020000')
GO

