

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountMNM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmountMNM.sp,v $ $Id: MM_SMVolSnapsToUnmountMNM.sp,v 1.1.2.11 2020/06/13 04:38:17 mtayal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToUnmountMNM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToUnmountMNM <<<'
	drop procedure MM_SMVolSnapsToUnmountMNM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToUnmountMNM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountMNM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountMNM'
GO
print '... Creating Procedure: MM_SMVolSnapsToUnmountMNM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToUnmountMNM
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_SMMetaDataId INTEGER
  DECLARE @o_UnmountMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
    DECLARE @ErrorCode          INTEGER
    DECLARE @ErrorStr           VARCHAR(1024)
	DECLARE @defaultCCId INT = 2
    -----------------------------------------------------------------------------
    -- Process Input XML
    -----------------------------------------------------------------------------
    -- XML Structure for MM_SMVolSnapsToUnmount
    /*
        <MM_SMVolSnapsToUnmount>
			<JobId></JobId>
			<HostId></HostId>
			<OpSource></OpSource>
			<VolumeId></VolumeId>
			<MountFlags></MountFlags>
        </MM_SMVolSnapsToUnmount>
    */
	DECLARE @tblReturn  TABLE (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer,
			UnmountMode integer,
			ErrorCode integer
		)
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_OpSource INTEGER
	DECLARE @x_MountFlags BIGINT
	DECLARE @x_MountMode INTEGER
	-- Job State - Running (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_RUNNING INTEGER;
	SET @JOB_STATE_RUNNING = 1
	-- Job State - Suspended (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPENDED INTEGER;
	SET @JOB_STATE_SUSPENDED = 5
	-- Job State - Suspend Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPEND_PENDING INTEGER;
	SET @JOB_STATE_SUSPEND_PENDING = 7
	-- Job State - Suspended (2) (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPENDED_2 INTEGER;
	SET @JOB_STATE_SUSPENDED_2 = 14
	-- Live Browse Job, GUI job will have a valid job id
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/HostId') R(ref)), 0)
	SET @x_OpSource = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/OpSource') R(ref)), 0)
	SET @x_MountFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/MountFlags') R(ref)), 0)
	SET @x_MountMode = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/MountMode') R(ref)), 0)
	DECLARE @tblSMVolume TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		CopyId integer,
		AppId integer,
		SourceClientId integer,
		AppTypeId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		VolumeFlags bigint
	)
	DECLARE @tblSMMntVolume TABLE (
		SMMntVolumeId integer,
		SMVolumeId integer,
		CommCellId integer,
		MntJobId integer,
		MountHostId integer,
		MountStatus integer,
		MountOptions nvarchar(2048),
		MountFlags	bigint
	)
	DECLARE @isForceUnmountOperation INTEGER = 0
SET @isForceUnmountOperation = CASE WHEN ((@x_MountFlags & 16/*VOLSNAP_ACTIONFLAGS_FORCE_UNMOUNT*/) > 0) THEN 1 ELSE 0 END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK)
					where JobId = @x_JobId and commCellId = @defaultCCId)
	BEGIN
SELECT 0, 0, 0, 0, 0, 60203, 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']', 0, 0
		RETURN 0
	END
	-----------------------------------------------------------------------------
	INSERT INTO @tblSMVolume
	SELECT	TVOL.SMVolumeId,
			ISNULL(VOL.ArchFileId, 0),
			ISNULL(VOL.CommCellId, 0),
			ISNULL(VOL.JobId, 0),
			ISNULL(VOL.CopyId, 0),
			ISNULL(VOL.AppId, 0),
			ISNULL(VOL.SourceClientId, 0),
			ISNULL(VOL.AppTypeId, 0),
			ISNULL(VOL.RecoveryPointId, 0),
			ISNULL(VOL.PruneFlags, 0),
			ISNULL(VOL.MountHostId, 0),
			ISNULL(VOL.MountStatus, 0),
			ISNULL(VOL.VolumeFlags, 0)
	FROM	(SELECT	R.ref.value('.', 'int') AS SMVolumeId
			FROM	@i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/VolumeId') R(ref)) TVOL
			LEFT OUTER JOIN SMVolume VOL (READUNCOMMITTED) ON TVOL.SMVolumeID = VOL.SMVolumeID
	/* Fetch details of input volume id in @tblSMMntVolume table from SMMountVolume */
	INSERT	INTO @tblSMMntVolume
	SELECT	MVOL.Id,
			MVOL.SMVolumeId,
			ISNULL(MVOL.CommCellId, 0),
			ISNULL(MVOL.MountJobId, 0),
			ISNULL(MVOL.MountHostId, 0),
			ISNULL(MVOL.MountStatus, 0),
			ISNULL(MVOL.MountOptions, N''),
			ISNULL(MVOL.MountFlags, 0)
	FROM	(SELECT	R.ref.value('.', 'int') AS SMMountVolumeId
			FROM	@i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/MountVolumeId') R(ref)) TVOL
			LEFT OUTER JOIN SMMountVolume MVOL (READUNCOMMITTED) ON TVOL.SMMountVolumeId = MVOL.Id
	------------------------------------------
	-- Get correct mount host for Dev snap ---
	------------------------------------------
	DECLARE @bIsSnapCenterSC INT = 0
	SELECT  @bIsSnapCenterSC = attrVal
	FROM    APP_SubclientProp PROP (READUNCOMMITTED)
	WHERE   attrName = 'Snap Center Subclient' AND modified = 0
			AND componentNameId = (SELECT TOP 1 AppId FROM @tblSMVolume)
	IF (@bIsSnapCenterSC = 1)
	BEGIN
		SET @x_HostId = (SELECT TOP 1 SourceClientId FROM @tblSMVolume)
	END
	-- Below validations are applicable if the unmount request needs to be sent to the Media Agent.
	-- For Force Unmount, the request is not sent to the Media Agent. So, these are skipped.
	IF @isForceUnmountOperation = 0
	BEGIN
		-----------------------------------------------------------------------------
		-- Unknown mount host
		-----------------------------------------------------------------------------
		DECLARE @HostName NVARCHAR(1024) = N''
		SET @HostName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @x_HostId)
		IF @HostName IS NULL OR @HostName = N''
		BEGIN
SELECT 0, 0, 0, 0, 0, 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].', 0, 0
	   		RETURN 0
		END
		DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT)
		INSERT	INTO @tblMMHost
		SELECT	MmHostEnabled, MMHostSoftState
		FROM	MMHost WITH (NOLOCK)
		WHERE 	ClientId = @x_HostId
		-----------------------------------------------------------------------------
		-- MediaAgent not installed
		-----------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM @tblMMHost)
		BEGIN
SELECT 0, 0, 0, 0, 0, 60912, 'MediaAgent not installed on host [' + @HostName + '].', 0, 0
	   		RETURN 0
		END
		-----------------------------------------------------------------------------
		-- Media Agent not enabled
		-----------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
		BEGIN
SELECT 0, 0, 0, 0, 0, 383, 'MediaAgent on host [' + @HostName + '] is not enabled.', 0, 0
	   		RETURN 0
		END
		-----------------------------------------------------------------------------
		-- Media Agent Offline
		-----------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
		BEGIN
SELECT 0, 0, 0, 0, 0, 357, 'MediaAgent on host [' + @HostName + '] is offline.', 0, 0
	   		RETURN 0
		END
	END
	-----------------------------------------------------------------------------
	-- Check whether the mount job is still running or not
	-----------------------------------------------------------------------------
IF @x_OpSource = 2/*SM_OS_GUI*/
		AND EXISTS (SELECT 1 FROM @tblSMMntVolume TVOL INNER JOIN SMMountVolume MVOL ON TVOL.SMVolumeId = MVOL.SMVolumeId
								INNER JOIN JMJobInfo (NOLOCK) JOB ON MVOL.MountJobId = JOB.JobId AND JOB.commCellId = @defaultCCId)
	BEGIN
SELECT 0, 0, 0, 0, 0, 60278, 'Mount Job is still running.', 0, 0
		RETURN 0
	END
	-- If this is a test clone job or a force unmount request, then go to exit. The rest of the validations are applicable for Multi-node mount.
IF @isForceUnmountOperation = 1 OR EXISTS (SELECT 1 FROM @tblSMMntVolume WHERE MountFlags & 2048 > 0)
	BEGIN
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Check whether there are any other Multi-Host reservations for the same backup copy job (which is still running)
	-----------------------------------------------------------------------------
	/*
	INSERT	INTO @tblReturn
SELECT	0, TMVOL.SMVolumeId, 0, 0, 32, 60214
	FROM	@tblSMMntVolume TMVOL INNER JOIN SMMountVolume MVOL (NOLOCK) ON TMVOL.SMVolumeId = MVOL.SMVolumeId
	WHERE	TMVOL.MntJobId = MVOL.MountJobId
			AND TMVOL.MountHostId <> MVOL.MountHostId
			AND MVOL.MountJobId IN (SELECT JobId FROM JMJobInfo (NOLOCK)
									WHERE STATE IN (@JOB_STATE_RUNNING, @JOB_STATE_SUSPENDED, @JOB_STATE_SUSPEND_PENDING, @JOB_STATE_SUSPENDED_2) )
	*/
	-----------------------------------------------------------------------------
	-- Check whether there are any other reservations by other jobs
	-----------------------------------------------------------------------------
	INSERT	INTO @tblReturn
SELECT	0, TMVOL.SMVolumeId, 0, 0, 32, 60214
	FROM	@tblSMMntVolume TMVOL INNER JOIN SMSnapResource RSRV (NOLOCK) ON TMVOL.SMVolumeId = RSRV.SMVolumeId
	WHERE	RSRV.JobId <> @x_JobId
AND ((RSRV.JobId = @JOBID_NA AND RSRV.Flags & 32 = 32)
					OR RSRV.JobId IN (SELECT JobId FROM JMJobInfo (NOLOCK)
							where STATE IN (@JOB_STATE_RUNNING, @JOB_STATE_SUSPENDED, @JOB_STATE_SUSPEND_PENDING, @JOB_STATE_SUSPENDED_2)))
	-----------------------------------------------------------------------------
	-- Check whether there are any other regular reservations (non-controller) by other jobs on the same host
	-----------------------------------------------------------------------------
	INSERT	INTO @tblReturn
SELECT	0, TMVOL.SMVolumeId, 0, 0, 32, 60214
	FROM	@tblSMMntVolume TMVOL INNER JOIN SMVolume VOL (NOLOCK) ON TMVOL.SMVolumeId = VOL.SMVolumeId
	WHERE	VOL.MountHostId > 0 AND VOL.MountHostId = TMVOL.MountHostId AND TMVOL.MountOptions <> '2' /*SM_VSA_MOUNT_MODE_CONTROLLER*/
	-----------------------------------------------------------------------------
	-- Volumes are being processed by other operation
	-----------------------------------------------------------------------------
	-- Volumes can not be unmounted if they are in the middle of being reverted or deleted.
	-- They can be unmounted if they are in the middle of being mounted or unmounted
	INSERT	INTO @tblReturn
SELECT	0, SMVolumeId, 0, 0, 0, 60013
	FROM	@tblSMVolume
WHERE	MountStatus > 79 AND MountStatus <> 89
AND PruneFlags = 1
	DELETE FROM @tblSMVolume
WHERE MountStatus > 79 AND MountStatus <> 89
AND PruneFlags = 1
	-----------------------------------------------------------------------------
	-- Check whether there are any controller mounts going on
	-----------------------------------------------------------------------------
IF(	(@x_OpSource = 1	/*SM_OS_IDA*/ )
		AND
( (@x_MountFlags & 268435456 /* VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB */ ) = 268435456 /* VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB */ )
		AND
( (@x_MountMode & 1 /* SM_VSA_MOUNT_MODE_COORDINATOR */ ) = 1 /* SM_VSA_MOUNT_MODE_COORDINATOR */
OR (@x_MountMode & 2 /* SM_VSA_MOUNT_MODE_CONTROLLER */) = 2 /* SM_VSA_MOUNT_MODE_CONTROLLER */)
	  )
	BEGIN
		DECLARE @l_MountJobIdToPrint	INTEGER = 0
		DECLARE @l_HostIdToPrint		INTEGER = 0
		DECLARE @l_HostNameToPrint		NVARCHAR(1024) = N''
		---- If there are any controller nodes which is still mounting,
		SELECT	TOP 1  @l_MountJobIdToPrint = MVOL.MountJobId, @l_HostIdToPrint = MVOL.MountHostId
		FROM	@tblSMMntVolume TMV INNER JOIN SMMountVolume	MVOL (READUNCOMMITTED) ON TMV.MntJobId		= MVOL.MountJobId
									INNER JOIN JMJobInfo		JOB  (READUNCOMMITTED) ON MVOL.MountJobId	= JOB.JobId	AND JOB.commCellId = @defaultCCId
WHERE	( MVOL.MountStatus >= 40   /* SM_VS_MNT_STARTED */  AND  MVOL.MountStatus < 58    /* SM_VS_MNT_FAILED */  )
AND ( (CAST(MVOL.MountOptions AS INTEGER) & 2 /* SM_VSA_MOUNT_MODE_CONTROLLER */) = 2	/* SM_VSA_MOUNT_MODE_CONTROLLER */)
		IF @l_MountJobIdToPrint <> 0
		BEGIN
			SET @l_HostNameToPrint = (SELECT name FROM APP_Client (READUNCOMMITTED) WHERE id = @l_HostIdToPrint)
SELECT 0, 0, 0, 0, 0, 60278, 'Mount job-['+ CAST(@l_MountJobIdToPrint AS NVARCHAR(128)) + '] is still running on host-['+ @l_HostNameToPrint + ']', 0, 0
			RETURN 0
		END
	END
	-- SnapTODOMNM: Need to revisit the unmount validation for the combination of Multi-Node Mount & VSA-AppAware
CX_EXIT:
	-- SELECT *, @ErrorCode, @ErrorStr
	SELECT	*, '', 0, 0
	FROM	@tblReturn
	ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId
	RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToUnmountMNM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmountMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmountMNM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmountMNM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToUnmountMNM',  '00010001000200110000', 'MM_SMVolSnapsToUnmountMNM', '00010001000200110000')
GO

