

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToUnmount.sp,v $ $Id: MM_SMVolSnapsToUnmount.sp,v 1.23.12.17 2020/09/17 18:20:07 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToUnmount')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToUnmount <<<'
	drop procedure MM_SMVolSnapsToUnmount
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToUnmount')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmount')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmount'
GO
print '... Creating Procedure: MM_SMVolSnapsToUnmount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToUnmount
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_SMMetaDataId INTEGER
  DECLARE @o_UnmountMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @defaultCCId INT = 2
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToUnmount
	/*
		<MM_SMVolSnapsToUnmount>
			<JobId></JobId>
			<HostId></HostId>
			<OpSource></OpSource>
			<VolumeId></VolumeId>
			<MountFlags></MountFlags>
		</MM_SMVolSnapsToUnmount>
	*/
	/**************************/
	/* Vimal: The Clean-up thread will group the volumes by HostId, JobId and send it to this Unmount Validation SP */
	/* Yanhui: The Clean-up thread will group the volumes by SnapShotEngineId, ControlHostId and MountHostId (no jobId), and send it to this Unmount Validation SP */
	/*         Because one volume may be associated with multiple jobs and we want only one unmount request sent to MA.
               Reservations for volume will be removed for all jobs at once during clean up. */
	/**************************/
	if object_id('tempdb.dbo.#tblReturnSnapToUnmt') is not null
		drop table #tblReturnSnapToUnmt
	CREATE TABLE #tblReturnSnapToUnmt (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer,
			UnmountMode integer,
			ErrorCode integer,
			ErrorString varchar(1024) DEFAULT ''
		)
	DECLARE @tblVolIDs TABLE (SMVolumeId int)
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_Cleanup INTEGER
	DECLARE @x_MountFlags BIGINT
	DECLARE @x_MountMode INTEGER
	-- Job State - Running (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_RUNNING INTEGER;
	SET @JOB_STATE_RUNNING = 1
	-- Job State - Suspended (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPENDED INTEGER;
	SET @JOB_STATE_SUSPENDED = 5
	-- Job State - Suspend Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPEND_PENDING INTEGER;
	SET @JOB_STATE_SUSPEND_PENDING = 7
	-- Job State - Suspended (2) (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_SUSPENDED_2 INTEGER;
	SET @JOB_STATE_SUSPENDED_2 = 14
	-- GUI Job
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	INSERT	INTO @tblVolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/VolumeId') R(ref)
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/HostId') R(ref)), 0)
	SET @x_Cleanup = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/OpSource') R(ref)), 0)
	SET @x_MountFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/MountFlags') R(ref)), 0)
	SET @x_MountMode = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToUnmount/MountMode') R(ref)), 0)
	DECLARE @isForceUnmountOperation INTEGER = 0
SET @isForceUnmountOperation = CASE WHEN ((@x_MountFlags & 16/*VOLSNAP_ACTIONFLAGS_FORCE_UNMOUNT*/) > 0) THEN 1 ELSE 0 END
	IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
	IF OBJECT_ID('tempdb.dbo.#tblSCGVols') IS NOT NULL
		DROP TABLE #tblSCGVols
	IF OBJECT_ID('tempdb.dbo.#tblSCGVolSnaps') IS NOT NULL
		DROP TABLE #tblSCGVolSnaps
	DECLARE @tblRtnSP TABLE (SMVolSnapMapId INTEGER, SMVolumeId INTEGER, SMSnapId INTEGER, SMMetaDataId INTEGER, UnmountMode INTEGER, ErrorCode INTEGER, ErrorStr VARCHAR(1024), ReserveParam1 INTEGER, ReserveParam2 INTEGER)
    DECLARE @retVal INT = 0
    ---------------------------------------------------------------------------------
	-- If the flag is set for Multi Node Mount, call the SP for Multi Node Unmount validations  -
	---------------------------------------------------------------------------------
IF	((@x_MountFlags & 268435456) = 268435456 /*VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB*/)
OR ((@x_MountFlags & 1073741824) = 1073741824 /*VOLSNAP_ACTIONFLAGS_SCSI_SERVER_OP_DB*/)
		-- Route no ESX DS mount also to the multi-node unmount validation
OR ((@x_MountMode & 4) = 4)
OR ((@x_MountFlags & 2048) = 2048 /*VOLSNAP_ACTIONFLAGS_TEST_CLONE_ENV*/)
	BEGIN
		INSERT INTO @tblRtnSP
		EXEC @retVal = MM_SMVolSnapsToUnmountMNM @i_xmlTextInput,0 ,''
		INSERT	INTO #tblReturnSnapToUnmt
		SELECT	SMVolSnapMapId, SMVolumeId, SMSnapId, SMMetaDataId, UnmountMode, ErrorCode, ErrorStr FROM @tblRtnSP
		GOTO CX_EXIT
	END
	CREATE TABLE #tblSMVolume (
		SMVolumeId integer primary key,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		CopyId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		VolumeFlags bigint
	)
	CREATE TABLE  #tblSCGVols (
		SMVolumeId integer PRIMARY KEY,
		JobId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	CREATE TABLE  #tblSCGVolsnaps (
		SMSnapId integer,
		SMVolumeId integer,
		JobId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	INSERT INTO #tblSMVolume
	SELECT	a.SMVolumeId,
			isnull(b.ArchFileId, 0),
			isnull(b.CommCellId, 0),
			isnull(b.JobId, 0),
			isnull(b.CopyId, 0),
			isnull(b.RecoveryPointId, 0),
			isnull(b.PruneFlags, 0),
			isnull(b.MountHostId, 0),
			isnull(b.MountStatus, 0),
			isnull(b.VolumeFlags, 0)
	FROM @tblVolIDs as a left outer join SMVolume as b WITH (NOLOCK)
	ON a.SMVolumeID = b.SMVolumeID
	-----------------------------------------------------------------------------
	-- Get all the volumes within SCG -- Use RecoveryPointId as SCG id
	-----------------------------------------------------------------------------
	INSERT	INTO #tblSCGVols
	SELECT	A.SMVolumeId, A.JobId, A.RecoveryPointId, A.PruneFlags, A.MountHostId, A.MountStatus, A.SourcePath, A.SourceGUID
	FROM	SMVolume A WITH (NOLOCK)
	WHERE	A.RecoveryPointId in (SELECT DISTINCT RecoveryPointId FROM #tblSMVolume WHERE RecoveryPointId > 0)
AND A.AppTypeId = 22
AND (A.VolumeFlags & 8192 = 8192)
	INSERT INTO #tblSCGVolsnaps
	SELECT A.SMSnapId, B.*
	FROM SMVolSnapMap A WITH (NOLOCK), #tblSCGVols B
	WHERE A.SMVolumeId = B.SMVolumeId
	-----------------------------------------------------------------------------
	-- Unknown volume
	-----------------------------------------------------------------------------
	INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60221,''
	FROM	#tblSMVolume
	WHERE	ArchFileId = 0
	DELETE FROM #tblSMVolume
	WHERE ArchFileId = 0
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK)
					where JobId = @x_JobId and commCellId = @defaultCCId)
	BEGIN
SELECT 0, 0, 0, 0, 0, 60203, 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']', 0, 0
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volumes are being processed by other operation
	-----------------------------------------------------------------------------
	-- Volumes can not be unmounted if they are in the middle of being reverted or deleted.
	-- They can be unmounted if they are in the middle of being mounted or unmounted
	INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60013,''
	FROM	#tblSMVolume
WHERE	MountStatus > 79 AND MountStatus <> 89
AND PruneFlags = 1
	DELETE FROM #tblSMVolume
WHERE MountStatus > 79 AND MountStatus <> 89
AND PruneFlags = 1
	-----------------------------------------------------------------------------
	-- Volumes in SCG are being reverted or deleted
	-----------------------------------------------------------------------------
	IF EXISTS ( SELECT * FROM #tblSCGVols
WHERE PruneFlags = 1
AND MountStatus > 79
AND MountStatus <> 89 )
	BEGIN
		INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60013,''
		FROM #tblSMVolume
		GOTO CX_EXIT
	END
	-- For MM Clean-up
IF @x_Cleanup = 3
	BEGIN
		INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, a.SMVolumeId, 0, 0, 0, 60214,''
		FROM	#tblSMVolume a, SMSnapResource b WITH (NOLOCK)
		WHERE	a.SMVolumeId = b.SMVolumeId
				AND b.JobId IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK)
								where STATE IN (@JOB_STATE_RUNNING, @JOB_STATE_SUSPENDED, @JOB_STATE_SUSPEND_PENDING, @JOB_STATE_SUSPENDED_2) )
		DELETE	FROM #tblSMVolume
		FROM	#tblSMVolume a, SMSnapResource b WITH (NOLOCK)
		WHERE	a.SMVolumeId = b.SMVolumeId
				AND b.JobId IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK)
								where STATE IN (@JOB_STATE_RUNNING, @JOB_STATE_SUSPENDED, @JOB_STATE_SUSPEND_PENDING, @JOB_STATE_SUSPENDED_2))
	END
	IF @isForceUnmountOperation = 1
	BEGIN
		IF EXISTS ( SELECT	* FROM	#tblSMVolume a, SMSnapResource b WITH (NOLOCK)
					WHERE	a.SMVolumeId = b.SMVolumeId AND b.JobId IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK)
							where STATE IN (@JOB_STATE_RUNNING, @JOB_STATE_SUSPENDED, @JOB_STATE_SUSPEND_PENDING, @JOB_STATE_SUSPENDED_2) ) )
		BEGIN
SELECT 0, 0, 0, 0, 0, 60214, 'Volume is reserved.', 0, 0
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS ( SELECT * FROM	#tblSMVolume A INNER JOIN SMVolAction VOL (NOLOCK) ON A.SMVolumeId = VOL.SMVolumeId WHERE SnapOpType = 3)
		BEGIN
SELECT 0, 0, 0, 0, 0, 60208, 'Unmount operation in progress.', 0, 0
			GOTO CX_ERROR_EXIT
		END
		DELETE	FROM SMSnapResource
		FROM	#tblSMVolume a INNER JOIN SMSnapResource b (NOLOCK) ON	a.SMVolumeId = b.SMVolumeId
		WHERE	a.MountHostId = @x_HostId
	END
IF @x_MountFlags & 128 <> 128
	BEGIN
		-- Below checks should be skipped for force unmount operation
		IF @isForceUnmountOperation = 0
		BEGIN
			-----------------------------------------------------------------------------
			-- Remove volumes unmounted
			-----------------------------------------------------------------------------
			INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60126,''
			FROM	#tblSMVolume
			WHERE	MountHostId = 0
			DELETE	FROM #tblSMVolume
			WHERE	MountHostId = 0
			-----------------------------------------------------------------------------
			-- Unknown mount host
			-----------------------------------------------------------------------------
			DECLARE @HostName NVARCHAR(1024) = N''
			SET @HostName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @x_HostId)
			IF @HostName IS NULL OR @HostName = N''
			BEGIN
SELECT 0, 0, 0, 0, 0, 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].', 0, 0
				GOTO CX_ERROR_EXIT
			END
			DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT)
			INSERT	INTO @tblMMHost
			SELECT	MmHostEnabled, MMHostSoftState
			FROM	MMHost WITH (NOLOCK)
			WHERE 	ClientId = @x_HostId
			-----------------------------------------------------------------------------
			-- MediaAgent not installed
			-----------------------------------------------------------------------------
			IF NOT EXISTS (SELECT * FROM @tblMMHost)
			BEGIN
SELECT 0, 0, 0, 0, 0, 60912, 'MediaAgent not installed on host [' + @HostName + '].', 0, 0
				GOTO CX_ERROR_EXIT
			END
			-----------------------------------------------------------------------------
			-- Media Agent not enabled
			-----------------------------------------------------------------------------
			IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
			BEGIN
SELECT 0, 0, 0, 0, 0, 383, 'MediaAgent on host [' + @HostName + '] is not enabled.', 0, 0
				GOTO CX_ERROR_EXIT
			END
			-----------------------------------------------------------------------------
			-- Media Agent Offline
			-----------------------------------------------------------------------------
			IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
			BEGIN
SELECT 0, 0, 0, 0, 0, 357, 'MediaAgent on host [' + @HostName + '] is offline.', 0, 0
				GOTO CX_ERROR_EXIT
			END
			-----------------------------------------------------------------------------
			-- Volumes are being mounted to a different host
			-----------------------------------------------------------------------------
			INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60205,''
			FROM	#tblSMVolume
			WHERE	MountHostId > 0
					AND MountHostId <> @x_HostId
			DELETE FROM #tblSMVolume
			WHERE MountHostId > 0
			AND MountHostId <> @x_HostId
			IF EXISTS ( SELECT * FROM #tblSCGVols
						WHERE MountHostId > 0
						AND MountHostId <> @x_HostId )
			BEGIN
				INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60205,''
				FROM #tblSMVolume
				GOTO CX_EXIT
			END
		END -- Force unmount skip checks ends here.
		-----------------------------------------------------------------------------
		-- Volumes are reseved by other jobs
		-----------------------------------------------------------------------------
IF @x_Cleanup <> 3/*SM_OS_MM*/
		BEGIN -- Non MM request block
    		DECLARE @RESTAB TABLE(VOL_ID INT,RES_ID INT);
			INSERT INTO @RESTAB
			SELECT SMVolumeId,0
			FROM #tblSMVolume
IF @x_Cleanup = 2/*SM_OS_GUI*/
			BEGIN -- Checks for GUI request
				-- Get the snap resource id for the GUI mount
				UPDATE	@RESTAB
				SET		RES_ID=SmResourceId
				FROM	@RESTAB c INNER JOIN #tblSMVolume a	ON c.VOL_ID = a.SMVolumeId
						INNER JOIN SMSnapResource b WITH (NOLOCK) ON a.SMVolumeId = b.SMVolumeId
WHERE b.Flags & 2 = 2
				-- Get the snap resource Id for Live Browse mount
				UPDATE	@RESTAB
				SET		RES_ID=SmResourceId
				FROM	@RESTAB c INNER JOIN #tblSMVolume a	ON c.VOL_ID = a.SMVolumeId
						INNER JOIN SMSnapResource b WITH (NOLOCK) ON a.SMVolumeId = b.SMVolumeId
WHERE	( ( b.Flags & 32 = 32 )
OR ( b.Flags & 256 = 256) )
					AND RES_ID = 0
			END -- Checks for GUI request
			ELSE
			BEGIN -- Normal Job Mounts
				UPDATE	@RESTAB
				SET		RES_ID=SmResourceId
				FROM	@RESTAB c INNER JOIN #tblSMVolume a	ON c.VOL_ID = a.SMVolumeId
						INNER JOIN SMSnapResource b WITH (NOLOCK) ON a.SMVolumeId = b.SMVolumeId
				WHERE	b.JobId = @x_JobId
			END -- Normal Job Mounts
			-- Volume is reserved by some other operation
			INSERT  INTO #tblReturnSnapToUnmt
SELECT  0, a.SMVolumeId, 0, 0, 0, 60214,''
			FROM    #tblSMVolume a INNER JOIN SMSnapResource b WITH (NOLOCK) ON a.SMVolumeId = b.SMVolumeId
					INNER JOIN @RESTAB c ON a.SMVolumeID= c.VOL_ID
			WHERE   b.SmResourceId <> c.RES_ID
AND b.Flags & 128 <> 128
IF @x_MountFlags <> 64 AND @x_Cleanup <> 2
				DELETE	FROM SMSnapResource
				FROM	#tblReturnSnapToUnmt a, SMSnapResource b WITH (NOLOCK)
				WHERE	a.SMVolumeId = b.SMVolumeId
						AND b.JobId = @x_JobId
IF @x_Cleanup = 2
				DELETE	FROM SMSnapResource
				FROM	#tblReturnSnapToUnmt a, SMSnapResource b WITH (NOLOCK) ,@RESTAB c
				WHERE	a.SMVolumeId = b.SMVolumeId
						AND a.SMVolumeID= c.VOL_ID
						AND b.SmResourceId=c.RES_ID
						AND (
b.Flags & 2 <> 2
OR b.Flags & 32 <> 32
							)
			--  VSA AppAware
			--  Following query is cuasing unmounts to go ahead
			--	if the job Id in Snap resource does not match
			--	Causing issue with parent GUI unmount, appaware validation is skipped
			--  The GUI mount job will not be the same as snap job, causing the volumes entries to be removed. So added the OpSource check.
			DELETE	FROM #tblSMVolume
			FROM	#tblSMVolume a, SMSnapResource b WITH (NOLOCK)
			WHERE	a.SMVolumeId = b.SMVolumeId
					AND b.JobId <> @x_JobId
AND a.VolumeFlags & 262144 <> 262144
AND a.VolumeFlags & 131072 <> 131072
AND @x_Cleanup <> 2
			UPDATE	SMSnapResource
SET		Flags = 32
			FROM	#tblReturnSnapToUnmt a, SMSnapResource b WITH (NOLOCK) ,@RESTAB c
			WHERE	a.SMVolumeId = b.SMVolumeId
					AND a.SMVolumeID= c.VOL_ID
AND b.Flags & 2 = 2
AND b.Flags & 32 = 32
					AND b.SmResourceId=c.RES_ID
			DELETE	FROM #tblSMVolume
			FROM	#tblSMVolume a, SMSnapResource b WITH (NOLOCK)
			WHERE	a.SMVolumeId = b.SMVolumeId
					AND @x_JobId = @JOBID_NA
AND b.Flags & 2 = 2
AND b.Flags & 32 = 32
		END -- Non MM request block
		-----------------------------------------------------------------------------
		-- Volumes are being held by other operation
		-- SnapOpType MM_SM_OPTYPE_UNMOUNT_SNAP = 3
		-----------------------------------------------------------------------------
		INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60208,''
		FROM	#tblSMVolume
		WHERE	SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
					WHERE JobId != @x_JobId AND SnapOpType != 3)
		DELETE FROM #tblSMVolume
		WHERE	SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
					WHERE JobId != @x_JobId AND SnapOpType != 3)
		-- Do not unmount if linked volumes in SCG are being processed by a different operation.
		IF EXISTS ( SELECT * FROM #tblSCGVols
					WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    					WHERE JobId != @x_JobId AND SnapOpType != 3))
		BEGIN
			INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, SMVolumeId, 0, 0, 0, 60208,''
			FROM #tblSMVolume
			GOTO CX_EXIT
		END
    	-----------------------------------------------------------------------------
		-- Unmount from DB only if its snaps are mounted by multiple volumes in SCG not picked
    	-----------------------------------------------------------------------------
    	INSERT	INTO #tblReturnSnapToUnmt
SELECT	DISTINCT 0, A.SMVolumeId, 0, 0, 32, 0,''
		FROM #tblSCGVolsnaps A, #tblSCGVolsnaps B
		WHERE A.SMSnapId = B.SMSnapId AND A.SourcePath = B.SourcePath AND A.SourceGUID = B.SourceGUID
		AND A.SMVolumeId IN (SELECT SMVolumeId FROM #tblSMVolume)
		AND B.SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblSMVolume)
AND A.MountStatus > 39
AND A.MountStatus <= 59
AND B.MountStatus > 39
AND B.MountStatus <= 59
		DELETE FROM #tblSMVolume
		WHERE SMVolumeId IN (SELECT SMVolumeId FROM #tblReturnSnapToUnmt)
		DECLARE @tblJobIds TABLE (JobId INT)
		INSERT	INTO @tblJobIds SELECT DISTINCT VOL.JobId FROM #tblSMVolume TV INNER JOIN SMVolume VOL WITH(NOLOCK) ON TV.SMVolumeId = VOL.SMVolumeId
		DECLARE @tblMapMetaDataIds TABLE ( MetaDataId INTEGER )
		INSERT	INTO @tblMapMetaDataIds
		SELECT	DISTINCT MAP.MetaDataId
		FROM	#tblSMVolume VOL INNER JOIN SMVolSnapMap MAP WITH(NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
				AND MetaDataId > 0
		-- ExxonMobil - Volume(775) and Snap(776) on a HPUX LVM resulted in 42K Map entries and locked this SQL SP for hours together
		IF OBJECT_ID('tempdb.dbo.#tblLinkVolSnap') IS NOT NULL
			DROP TABLE #tblLinkVolSnap
		IF OBJECT_ID('tempdb.dbo.#tmpSMVolume') IS NOT NULL
			DROP TABLE #tmpSMVolume
		CREATE TABLE #tblLinkVolSnap (SMVolumeId int, SMSnapId INT, MetaDataId INT, JobId INT, SCGId INT, MountHostId INT, MountStatus INT, SourceGUID NVARCHAR(1024))
		CREATE INDEX tblLinkVolSnap_SMVolumeId_SCGId_MetaDataId ON #tblLinkVolSnap (SMVolumeId, SCGId, MetaDataId)
		INSERT	INTO #tblLinkVolSnap
		SELECT	DISTINCT MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, VOL.JobId, VOL.RecoveryPointId, VOL.MountHostId, VOL.MountStatus, VOL.SourceGUID
		FROM	@tblMapMetaDataIds MM INNER JOIN SMVolSnapMap MAP WITH(NOLOCK) ON MM.MetaDataId = MAP.MetaDataId
				INNER JOIN SMVolume VOL WITH(NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
		WHERE	VOL.MountHostId > 0
		CREATE TABLE #tmpSMVolume (SMVolumeId INT, MetaDataId INT, SnapJobId INT, JobId INT, SCGId INT, MountHostId INT, MountStatus INT, UnmountMode INT, SourceGUID NVARCHAR(1024))
		CREATE INDEX tmpSMVolumeidx_SMVolumeId_MetaDataId ON #tmpSMVolume (SMVolumeId, MetaDataId)
		INSERT	INTO #tmpSMVolume
		SELECT	DISTINCT TV.SMVolumeId, MAP.MetaDataId, VOL.JobId, TV.JobId, VOL.RecoveryPointId, TV.MountHostId, TV.MountStatus, 0, VOL.SourceGUID
		FROM	#tblSMVolume TV INNER JOIN SMVolume VOL WITH(NOLOCK) ON TV.SMVolumeId = VOL.SMVolumeId
				INNER JOIN SMVolSnapMap MAP WITH(NOLOCK) ON TV.SMVolumeId = MAP.SMVolumeId
		-- Check whehter DB only operation is needed or whehter FS Unmount only operation is needed
		UPDATE	#tmpSMVolume
SET		UnmountMode =  ( CASE when TV.SnapJobId <> LV1.JobId AND TV.SourceGUID = LV1.SourceGUID then 32
when TV.SnapJobId = LV1.JobId and TV.MetaDataId = LV1.MetaDataId then 1 else 0 end )
		FROM	#tmpSMVolume TV inner join #tblLinkVolSnap LV1 on
				TV.SCGId = LV1.SCGId
				AND TV.MountHostId = LV1.MountHostId
		where LV1.SMVolumeId NOT IN ( SELECT SMVolumeId FROM #tblSMVolume )
    	INSERT	INTO #tblReturnSnapToUnmt
SELECT	DISTINCT 0, SMVolumeId, 0, 0, 1, 0,''
    	FROM	#tmpSMVolume
WHERE	UnmountMode > 0
		DELETE	FROM #tblSMVolume WHERE SMVolumeId IN (SELECT SMVolumeId FROM #tblReturnSnapToUnmt)
		DELETE	FROM #tmpSMVolume WHERE SMVolumeId IN (SELECT SMVolumeId FROM #tblReturnSnapToUnmt)
		-----------------------------------------------------------------------------
		-- VSA AppAware Validation
		-----------------------------------------------------------------------------
		--- Parent Unmount Validation
		-- Check whether any reservation exist for other children of this parent
		-- If so, fail the unmount validation with Volume Reserved error
		--Check whether any child of this parent is in mounted or mounting or unmounting state
		--If so, fail the unmount validation with Volume Reserved error
		--Always use VolAction in conjunction with SnapResource or SMVolume
		DECLARE @tblAppAwareLinkedVols TABLE (
				ParentVolumeId integer,
				ChildVolumeId integer,
				ChildMountHostId integer,
				ChildMountStatus integer
			)
		-- Find Child Volumes ( except current Child which is mounting this parentVol)
		INSERT	INTO @tblAppAwareLinkedVols
		SELECT  V.SMVolumeId,
				B.SMVolumeId,
				B.MountHostId,
				B.MountStatus
		FROM	#tblSMVolume V INNER JOIN JMVSAAppJobLink JOBLINK (NOLOCK) ON JOBLINK.parentJobId = V.JobId
				INNER JOIN SMVOLUME B (NOLOCK) ON B.JobId = JOBLINK.childJobId AND V.CopyId = B.CopyId
WHERE	V.VolumeFlags & 262144 = 262144
AND B.VolumeFlags & 131072 = 131072
				AND B.SMVolumeId NOT IN ( SELECT DISTINCT SMVolumeId FROM  SMVolAction (NOLOCK)
									      WHERE JobId = @x_JobId AND SnapOpType = 3)
		-- Any Child Volume Reserved
		INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, A.SMVolumeId, 0, 0, 0, 60214,''
		FROM  #tblSMVolume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId
		WHERE B.ChildVolumeId IN ( SELECT DISTINCT SMVolumeId FROM SMSnapResource)
		DELETE	FROM #tblSMVolume WHERE SMVolumeId IN (SELECT SMVolumeId FROM #tblReturnSnapToUnmt)
		-- Any Child Volume in mounting,mounted,unmounting state
		INSERT	INTO #tblReturnSnapToUnmt
SELECT	0, A.SMVolumeId, 0, 0, 0, 60214,''
		FROM  #tblSMVOlume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId
		INNER JOIN	SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = B.ChildVolumeId
WHERE (VOL.MountStatus >= 40 AND VOL.MountStatus <= 78)
		DELETE	FROM #tblSMVolume WHERE SMVolumeId IN (SELECT SMVolumeId FROM #tblReturnSnapToUnmt)
	END
	-- Get volumes without snap to unmount
	INSERT INTO #tblReturnSnapToUnmt
SELECT 0, SMVolumeId, 0, 0, 16, 0,''
	FROM #tblSMVolume
	WHERE SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM #tblReturnSnapToUnmt)
	-- Update unmount mode if any of the volume has snapresource flag as mount src_vol
	UPDATE tumt
SET		tumt.UnmountMode = (tumt.UnmountMode | 128) /*SM_UMT_MOD_UMT_SRC_DEVICE*/
	FROM #tblReturnSnapToUnmt tumt, SMSnapResource smres
	WHERE  tumt.SMVolumeId = smres.SMVolumeId
AND smres.Flags = 512 /*SNAPRES_FLAGS_SOURCE_DEVICE_MOUNT*/
CX_EXIT:
	-- SELECT *, @ErrorCode, @ErrorStr
	SELECT *, 0, 0
	FROM #tblReturnSnapToUnmt
	ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId
CX_ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tblLinkVolSnap') IS NOT NULL
		DROP TABLE #tblLinkVolSnap
	IF OBJECT_ID('tempdb.dbo.#tmpSMVolume') IS NOT NULL
		DROP TABLE #tmpSMVolume
	IF OBJECT_ID('tempdb.dbo.#tblReturnSnapToUnmt') IS NOT NULL
		DROP TABLE #tblReturnSnapToUnmt
	IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
	IF OBJECT_ID('tempdb.dbo.#tblSCGVols') IS NOT NULL
		DROP TABLE #tblSCGVols
	IF OBJECT_ID('tempdb.dbo.#tblSCGVolSnaps') IS NOT NULL
		DROP TABLE #tblSCGVolSnaps
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToUnmount')
	delete from GxQscripts where name = 'MM_SMVolSnapsToUnmount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToUnmount')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToUnmount'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToUnmount',  '00010023001200170000', 'MM_SMVolSnapsToUnmount', '00010023001200170000')
GO

