

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToRevert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToRevert.sp,v $ $Id: MM_SMVolSnapsToRevert.sp,v 1.19.2.14 2020/03/11 01:01:00 dsaraf Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToRevert')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToRevert <<<'
	drop procedure MM_SMVolSnapsToRevert
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToRevert')
	delete from GxQscripts where name = 'MM_SMVolSnapsToRevert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToRevert')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToRevert'
GO
print '... Creating Procedure: MM_SMVolSnapsToRevert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToRevert
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_SMMetaDataId INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToRevert
	/*
		<MM_SMVolSnapsToRevert>
			<VolumeId></VolumeId>
			<JobId></JobId>
			<HostId></HostId>
			<ActionFlags></ActionFlags>
		</MM_SMVolSnapsToRevert>
	*/
	DECLARE @tblReturn  TABLE (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer
		)
	DECLARE @tblVolIDs TABLE (SMVolumeId int)
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_ActionFlags BIGINT
	-- GUI Job
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	DECLARE @defaultCCId INT = 2
	INSERT	INTO @tblVolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToRevert/VolumeId') R(ref)
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToRevert/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToRevert/HostId') R(ref)), 0)
	SET @x_ActionFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToRevert/ActionFlags') R(ref)), 0)
	DECLARE @DataVolumeOnly INTEGER
	SET @DataVolumeOnly = 0
IF @x_ActionFlags & 1048576 > 0
		SET @DataVolumeOnly = 1
	DECLARE @tblSMVolume TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		RecoveryPointId integer,
		CopyId integer,
		AppId integer,
		AppTypeId integer,
		SourceClientId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		VolumeFlags bigint
	)
	DECLARE @tblSCGVols  TABLE (
		SMVolumeId integer,
		JobId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	INSERT INTO @tblSMVolume
	SELECT	a.SMVolumeId,
			isnull(b.ArchFileId, 0),
			isnull(b.CommCellId, 0),
			isnull(b.JobId, 0),
			isnull(b.RecoveryPointId, 0),
			isnull(b.CopyId, 0),
			isnull(b.AppId, 0),
			isnull(b.AppTypeId, 0),
			isnull(b.SourceClientId, 0),
			isnull(b.PruneFlags, 0),
			isnull(b.MountHostId, 0),
			isnull(b.MountStatus, 0),
			isnull(b.VolumeFlags, 0)
	FROM @tblVolIDs as a left outer join SMVolume as b WITH (NOLOCK)
	ON a.SMVolumeID = b.SMVolumeID
	-----------------------------------------------------------------------------
	-- Get all the volumes within SCG -- Use RecoveryPointId as SCG id
	-----------------------------------------------------------------------------
	INSERT	INTO @tblSCGVols
	SELECT	A.SMVolumeId, A.JobId, A.RecoveryPointId, A.PruneFlags, A.MountHostId, A.MountStatus, A.SourcePath, A.SourceGUID
	FROM	SMVolume A WITH (NOLOCK), ArchFile B WITH (NOLOCK)
	WHERE	A.ArchFileId = B.id AND A.CommCellId = B.CommCellId AND B.isValid = 1
	AND		(@DataVolumeOnly = 0 OR @DataVolumeOnly > 0 AND B.fileType = 1)
	AND		A.RecoveryPointId in (SELECT DISTINCT RecoveryPointId FROM @tblSMVolume WHERE RecoveryPointId > 0)
AND A.AppTypeId = 22
AND (A.VolumeFlags & 8192 = 8192)
	-----------------------------------------------------------------------------
	-- Unknown volume
	-----------------------------------------------------------------------------
	-- Volume not exists in DB
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume WHERE ArchFileId = 0)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60210
		SET @ErrorStr = 'One or more volumes are missing from database. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Invalid source client host
	-----------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM @tblSMVolume WHERE SourceClientId <> @x_HostId)
	BEGIN
SET @ErrorCode = 60149
		SET @ErrorStr = 'Given client host [' + Convert(varchar(10), @x_HostId) + '] is different than the source client host.'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
  	-----------------------------------------------------------------------------
    -- Unknown mount host
    -----------------------------------------------------------------------------
   	DECLARE @HostName NVARCHAR(1024) = N''
   	SET @HostName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @x_HostId)
   	IF @HostName IS NULL OR @HostName = N''
   	BEGIN
SELECT 0, 0, 0, 0, 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].', 0, 0
   		RETURN
   	END
	DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT)
	INSERT	INTO @tblMMHost
	SELECT	MmHostEnabled, MMHostSoftState
	FROM	MMHost WITH (NOLOCK)
	WHERE 	ClientId = @x_HostId
   	-----------------------------------------------------------------------------
   	-- MediaAgent not installed
   	-----------------------------------------------------------------------------
   	IF NOT EXISTS (SELECT * FROM @tblMMHost)
   	BEGIN
SELECT 0, 0, 0, 0, 60912, 'MediaAgent not installed on host [' + @HostName + '].', 0, 0
   		RETURN
   	END
   	-----------------------------------------------------------------------------
   	-- Media Agent not enabled
   	-----------------------------------------------------------------------------
   	IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
	BEGIN
SELECT 0, 0, 0, 0, 383, 'MediaAgent on host [' + @HostName + '] is not enabled.', 0, 0
   		RETURN
   	END
   	-----------------------------------------------------------------------------
   	-- Media Agent Offline
   	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
	BEGIN
SELECT 0, 0, 0, 0, 357, 'MediaAgent on host [' + @HostName + '] is offline.', 0, 0
   		RETURN
   	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (select * from JMJobInfo where JobId = @x_JobId and commCellId = @defaultCCId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volume is not active
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE PruneFlags <> 1)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60202
		SET @ErrorStr = 'One or more snapshots required for the job no longer exist on the array, and appear to have been manually deleted or automatically removed as part of array cleanup thresholds. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Invalid ArchFile Id
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId FROM @tblSMVolume a
						WHERE NOT EXISTS (
								SELECT * FROM ArchFileCopy b WITH (NOLOCK)
								WHERE a.ArchFileId = b.ArchFileId
								AND a.CommCellId = b.CommCellId
								AND b.ArchCopyId = a.CopyId))
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60216
		SET @ErrorStr = 'One or more volumes have no archive file. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Vault/Mirror Snaps
	-----------------------------------------------------------------------------
    /*
	SET @ErrorVolId = (SELECT	TOP 1 a.SMVolumeId
								FROM @tblSMVolume a
								INNER JOIN archGroupCopy b ON a.CopyId = b.id
								LEFT OUTER JOIN archGroup c ON b.id = c.defaultSnapCopy
								WHERE c.id IS NULL)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60152
		SET @ErrorStr = 'Revert Operation not supported for Vault/Mirror snaps. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
    */
	-----------------------------------------------------------------------------
	-- LREP Snaps
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT	TOP 1 a.SMVolumeId
								FROM @tblSMVolume a, SMVolume b
								WHERE a.SMVolumeId = b.SMVolumeId
AND (b.VolumeFlags & 4096) = 4096)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60152
		SET @ErrorStr = 'Revert Operation not supported for LREP snaps. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are reserved
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
				WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMSnapResource WITH (NOLOCK)))
	IF @ErrorVolId IS null
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSCGVols
				WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMSnapResource WITH (NOLOCK)))
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60214
		SET @ErrorStr = 'Revert operation not possible now as volume(s) reserved by other jobs or user - may be already mounted. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are being processed by other operation
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE MountStatus NOT IN (39, 79, 89)
				OR MountHostId > 0)
	IF @ErrorVolId IS null
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSCGVols
WHERE MountStatus NOT IN (39, 79, 89)
				OR MountHostId > 0)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Revert operation not possible now as other snap operations like mount, unmount using the volume(s) currently. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are being prepared for the same subclient
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 VOL.JobId FROM SMVolume VOL WITH (READUNCOMMITTED), JMJobInfo JOB WITH (NOLOCK), @tblSMVolume RVTVOL
WHERE VOL.AppId = RVTVOL.AppId AND VOL.MountStatus < 39 AND VOL.JobId = JOB.JobId)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Snap-protect Job [' + Convert(varchar(10), @ErrorVolId) + '] running for the same subclient.'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are being held by other operation
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (	SELECT TOP 1 a.SMVolumeId FROM SMVolAction a WITH (NOLOCK), @tblVolIDs b
				WHERE a.SMVolumeId = b.SMVolumeId )
	IF @ErrorVolId IS null
		SET @ErrorVolId = (	SELECT TOP 1 a.SMVolumeId FROM SMVolAction a WITH (NOLOCK), @tblSCGVols b
				WHERE a.SMVolumeId = b.SMVolumeId )
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60212
		SET @ErrorStr = 'One or more volumes are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- GUI revert
	-----------------------------------------------------------------------------
	IF	@x_JobId = @JOBID_NA
	BEGIN
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSCGVols
							WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume) )
		IF @ErrorVolId IS NOT null
		BEGIN
SET @ErrorCode = 60150
			SET @ErrorStr = 'One or more dependent volumes are not selected for revert. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
			SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
			RETURN
		END
	END
	-----------------------------------------------------------------------------
	-- Get volumes in the same job copy
	-----------------------------------------------------------------------------
	DECLARE @tblJobCopyVols  TABLE ( SMVolumeId integer )
	-- Get all the volumes of the job
	INSERT	INTO @tblJobCopyVols
	SELECT	DISTINCT VOL.SMVolumeId
	FROM	SMVolume VOL WITH (NOLOCK), @tblSMVolume TVOL, archFile AF WITH (NOLOCK), archFileCopy AFC  WITH (NOLOCK)
	WHERE	VOL.JobId = TVOL.JobId AND VOL.CopyId = TVOL.CopyId
			AND VOL.SMVolumeId <> TVOL.SMVolumeId
			AND VOL.PruneFlags = 1
			AND TVOL.PruneFlags = 1
			AND VOL.RecoveryPointId > 0
			AND VOL.ArchFileId = AF.id
			AND VOL.CommCellId = AF.commCellId
			AND VOL.ArchFileId = AFC.ArchFileId
			AND VOL.CommCellId = AFC.commCellId
			AND AF.isValid = 1 AND AFC.isValid = 1
			AND	(@DataVolumeOnly = 0 OR @DataVolumeOnly > 0 AND AF.fileType = 1)
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblJobCopyVols
						WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume) )
	IF @ErrorVolId IS NOT NULL
	BEGIN
		--Need to define new error code
SET @ErrorCode = 60150
		SET @ErrorStr = 'Not all volumes for the same job on the same copy are selected. VolumeId [' + Convert(varchar(10), @ErrorVolId) + '].'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Get linked snaps and volumes
	-----------------------------------------------------------------------------
	DECLARE @tblLinkedSnaps TABLE ( SMSnapId integer, SnapShotEngineId integer, AppTypeId integer )
	DECLARE @tblLinkedVols  TABLE ( SMVolumeId integer )
	-- Get all the snaps of given volumes
	INSERT INTO @tblLinkedSnaps
	SELECT	DISTINCT SNAP.SMSnapId, SNAP.SnapShotEngineId, TVOL.AppTypeId
	FROM	@tblSMVolume TVOL INNER JOIN SMVolSnapMap MAP WITH(NOLOCK) ON TVOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH(NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
	WHERE	TVOL.RecoveryPointId = 0
	-- Get all the volumes share snaps with given volumes
	INSERT INTO @tblLinkedVols
	SELECT DISTINCT a.SMVolumeId
	FROM SMVolSnapMap a WITH (NOLOCK), @tblLinkedSnaps b
	WHERE a.SMSnapId = b.SMSnapId AND a.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
	-- Relax the shared snap check for VSA V2 file level revert in case of NFS Datastore.
DECLARE @l_NFSInfo			NVARCHAR(64)	= N'%' + '#' + CAST(101 as NVARCHAR(8)) + '|::|' + CAST(2 AS NVARCHAR(8)) 	+ '|::|' + N'%'
DECLARE @l_NFS41Info		NVARCHAR(64)	= N'%' + '#' + CAST(101 as NVARCHAR(8)) + '|::|' + CAST(3 AS NVARCHAR(8)) 	+ '|::|' + N'%'
DECLARE @l_VSAV2VolFlag		BIGINT			= 4294967296
	DELETE	FROM @tblLinkedVols
	FROM	@tblLinkedVols TLV	INNER JOIN SMVolume			VOL	(READUNCOMMITTED) ON TLV.SMVolumeId			= VOL.SMVolumeId		AND (VOL.VolumeFlags & @l_VSAV2VolFlag = @l_VSAV2VolFlag)
								INNER JOIN SMVolSnapMap		MAP	(READUNCOMMITTED) ON VOL.SMVolumeId			= MAP.SMVolumeId
								INNER JOIN SMSnap			SNP	(READUNCOMMITTED) ON MAP.SMSnapId			= SNP.SMSnapId
								INNER JOIN SMSnapShotEngine ENG	(READUNCOMMITTED) ON SNP.SnapShotEngineId	= ENG.SnapShotEngineId
INNER JOIN SMMetadata		MDT	(READUNCOMMITTED) ON VOL.SMVolumeId			= MDT.RefId				AND (MDT.RefType = 1)
WHERE	(ENG.Capabilities & 8192 /* SM_SNAPSHOT_ENGINE_CAPABILITY_REVERT_VMWARE */	= 8192	/* SM_SNAPSHOT_ENGINE_CAPABILITY_REVERT_VMWARE */)
			AND
			( (MDT.MetaData like @l_NFSInfo) OR (MDT.MetaData like @l_NFS41Info) )
	-----------------------------------------------------------------------------
	-- Linked volumes are not selected for revert
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
						WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume) )
	IF @ErrorVolId IS NOT NULL
	BEGIN
		--Need to define new error code
SET @ErrorCode = 60150
		SET @ErrorStr = 'One or more dependent volumes are not selected for revert. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Check Engine Capability for Revert
	-----------------------------------------------------------------------------
	/* Get Revert Capability of SnapshotEngine for each snap */
DECLARE	@EngineName NVARCHAR(128) = N''
	SET @EngineName = ( SELECT	TOP 1 ENGINE.SnapEngineName
						FROM	@tblLinkedSnaps TSNAP INNER JOIN SMSnapShotEngine ENGINE WITH(NOLOCK) ON TSNAP.SnapShotEngineId = ENGINE.SnapShotEngineId
WHERE	128 & ENGINE.Capabilities = 0 )
	IF @EngineName IS NOT NULL
	BEGIN
SET @ErrorCode = 60152
		SET @ErrorStr = 'Revert for Snap Engine [' + @EngineName + '] is not supported.'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Check Revert support for VMWare, XEN, HyperV
	-----------------------------------------------------------------------------
	/* Get VSA Revert Capability of SnapshotEngine for each snap */
	SET @EngineName = ( SELECT	TOP 1  ENGINE.SnapEngineName
						FROM	@tblLinkedSnaps TSNAP INNER JOIN SMSnapShotEngine ENGINE WITH(NOLOCK) ON TSNAP.SnapShotEngineId = ENGINE.SnapShotEngineId
WHERE	TSNAP.AppTypeId = 106
AND 8192 & ENGINE.Capabilities = 0 )
	IF @EngineName IS NOT NULL
	BEGIN
SET @ErrorCode = 60152
		SET @ErrorStr = 'Revert for VSA using Snap Engine [' + @EngineName + '] is not supported.'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Check External Backup Engine
	-----------------------------------------------------------------------------
	/*Revert is not supported for External Backup Engine */
	SET @EngineName = ( SELECT	TOP 1  ENGINE.SnapEngineName
						FROM	@tblLinkedSnaps TSNAP INNER JOIN SMSnapShotEngine ENGINE WITH(NOLOCK) ON TSNAP.SnapShotEngineId = ENGINE.SnapShotEngineId
WHERE	TSNAP.SnapShotEngineId = 51 )
	IF @EngineName IS NOT NULL
	BEGIN
SET @ErrorCode = 60152
		SET @ErrorStr = 'Revert for Snap Engine [' + @EngineName + '] is not supported.'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- VSA AppAware- Child Volume Revert Validation
	-----------------------------------------------------------------------------
	-- For child revert, parent snap should be mounted to the same host
	DECLARE @tblAppAwareLinkedVols TABLE (
		ChildVolumeId integer,
		ParentVolumeId integer,
		ParentVolMountHostId integer,
		ParentVolMountStatus integer
	)
	INSERT	INTO @tblAppAwareLinkedVols
	SELECT  V.SMVolumeId,
			B.SMVolumeId,
			B.MountHostId,
			B.MountStatus
	FROM	@tblSMVolume V INNER JOIN JMVSAAppJobLink JOBLINK (NOLOCK) ON JOBLINK.childJobId = V.JobId
			INNER JOIN SMVOLUME B (NOLOCK) ON B.JobId = JOBLINK.parentJobId
WHERE	V.VolumeFlags & 131072 = 131072
AND B.VolumeFlags & 262144 = 262144 -- Optional safe check
	SET @ErrorVolId = (SELECT	TOP 1 A.SMVolumeId
						FROM	@tblSMVolume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ChildVolumeId
WHERE B.ParentVolMountHostId <> @x_HostId OR B.ParentVolMountStatus <> 59)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60328
		SET @ErrorStr = 'VSA-AppAware.Parent Volume is either not mounted or mounted to a different host. Child VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr,0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Prevent revert from replica copy
	-----------------------------------------------------------------------------
	SET @ErrorVolId =	(SELECT	TOP 1 VOL.SMVolumeId
						FROM	@tblSMVolume VOL INNER JOIN archGroupCopy AGC on AGC.id = VOL.CopyId
WHERE	AGC.extendedFlags & 256 = 256) -- CVA_ARRAY_REPLICA_COPY_FLAG
	IF @ErrorVolId IS NOT NULL
	BEGIN
SET @ErrorCode = 60152 -- E_MM_SM_SB_REVERT_NOT_SUPPORTED
		SET @ErrorStr = 'Revert from replica copy is not supported'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr,0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Prevent revert for metro cluster snaps
	-----------------------------------------------------------------------------
	DECLARE @ClusterSnapCount int  = 0
	SELECT @ClusterSnapCount =	(SELECT	COUNT(DISTINCT SNP.SMSnapId)
						FROM	@tblLinkedSnaps SNP INNER JOIN SMSnap SSP (NOLOCK) ON SNP.SMSnapId = SSP.SMSnapId
						WHERE	SSP.SnapFlags & cast(17179869184 as bigint) = cast(17179869184 as bigint) /*CVSM_SNAPSHOTFLAGS_METRO_CLUSTER*/)
	IF @ClusterSnapCount > 0
	BEGIN
SET @ErrorCode = 60152 -- E_MM_SM_SB_REVERT_NOT_SUPPORTED
		SET @ErrorStr = 'Revert for Metro Cluster snaps is not supported'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr,0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
    -- Prevent revert for VPLEX with 3PAR backend array snaps
    -----------------------------------------------------------------------------
    IF EXISTS (SELECT 1 FROM @tblLinkedSnaps SNP INNER JOIN SMSnap SSP (NOLOCK) ON SNP.SMSnapId = SSP.SMSnapId
WHERE    SSP.OriginalSnapEngineId IN( 45 /*SM_SNAPSHOT_ENGINE_VPLEX_SNAP*/, 46 /*SM_SNAPSHOT_ENGINE_VPLEX_CLONE*/)
AND SSP.SnapShotEngineId IN(25 /*SM_SNAPSHOT_ENGINE_3PAR_SNAP*/, 26 /*SM_SNAPSHOT_ENGINE_3PAR_CLONE*/))
    BEGIN
SET @ErrorCode = 60152 /*E_MM_SM_SB_REVERT_NOT_SUPPORTED*/
            SET @ErrorStr = 'Revert for VPLEX with 3PAR backend array snaps is not supported'
            SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr,0, 0
            RETURN
    END
	-----------------------------------------------------------------------------
	--	Prevent revert for INFINIDAT, 3PAR volumes with replica snaps
	-----------------------------------------------------------------------------
	IF EXISTS (SELECT 1 FROM @tblSMVolume TVOL
					INNER JOIN SMVolume VOL WITH(NOLOCK) 		ON TVOL.ArchFileId = VOL.ArchFileId
					INNER JOIN SMVolSnapMap MAP WITH(NOLOCK)	ON VOL.SMVolumeId = MAP.SMVolumeId
					INNER JOIN SMSnap SNAP WITH(NOLOCK) 		ON MAP.SMSnapId = SNAP.SMSnapId
WHERE SNAP.SnapShotEngineId IN (42 /*SM_SNAPSHOT_ENGINE_INFINIDAT_SNAP */, 25 /*SM_SNAPSHOT_ENGINE_3PAR_SNAP*/, 26 /*SM_SNAPSHOT_ENGINE_3PAR_CLONE*/)
AND (VOL.VolumeFlags & 1048576) = 1048576 /*CVSM_VOLUMEFLAGS_REPLICA_SNAP_VOL_DB*/)
    BEGIN
SET @ErrorCode = 60152 /*E_MM_SM_SB_REVERT_NOT_SUPPORTED*/
            SET @ErrorStr = 'Restore using hardware snap revert is not supported for a primary volume which has replica snaps - either managed through Commvault or externally. For other appropriate methods applicable for the source volume restore, please check the corresponding application agent documentation for further details and also IntelliSnap support documentation for storage array.'
            SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr,0, 0
            RETURN
    END
	-----------------------------------------------------------------------------
	--	Prevent revert for replication target snaps
	-----------------------------------------------------------------------------
DECLARE @SNAPFLAGS_REPLICATION_SITE_SNAP	BIGINT	= 70368744177664		/* CVSM_SNAPSHOTFLAGS_PRIMARY_SNAP_AT_REPLICA_SITE_DB */
	DECLARE @l_ErrorSnapId						INT		= 0
	SET @l_ErrorSnapId = (SELECT TOP 1 SNAP.SMSnapId
						  FROM @tblSMVolume TVOL
							INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED)
								ON TVOL.SMVolumeId = MAP.SMVolumeId
							INNER JOIN SMSnap SNAP WITH (READUNCOMMITTED)
								ON MAP.SMSnapId = SNAP.SMSnapId
						  WHERE SNAP.SnapFlags & @SNAPFLAGS_REPLICATION_SITE_SNAP = @SNAPFLAGS_REPLICATION_SITE_SNAP )
    IF  @l_ErrorSnapId > 0
	BEGIN
SET @ErrorCode	= 60158		/* E_MM_SM_SB_REPL_TGT_SNAP_REVERT_NOT_SUPPORTED */
		SET @ErrorStr	= 'The revert operation cannot be done on primary snapshots that are created at the replication target array. SnapshotId-[' + Convert(varchar(64), @l_ErrorSnapId) + ']'
		SELECT 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
        RETURN
	END
	-----------------------------------------------------------------------------
	-- Return for mount operation
	-----------------------------------------------------------------------------
	INSERT INTO @tblReturn
	SELECT	DISTINCT b.SMVolSnapMapId, b.SMVolumeId, b.SMSnapId, b.MetaDataId
	FROM	@tblSMVolume a, SMVolSnapMap b WITH (NOLOCK)
	WHERE	a.SMVolumeId = b.SMVolumeId
	-----------------------------------------------------------------------------
	-- Get metadata referenced to volume and snap
	-----------------------------------------------------------------------------
	INSERT INTO @tblReturn
	SELECT	DISTINCT 0, a.SMVolumeId, 0, b.MetaDataId
	FROM	@tblSMVolume a, SMMetaData b WITH (NOLOCK)
WHERE	b.RefType = 1
	AND		a.SMVolumeId = b.RefId
	INSERT INTO @tblReturn
	SELECT	DISTINCT 0, 0, a.SMSnapId, b.MetaDataId
	FROM	@tblReturn a, SMMetaData b WITH (NOLOCK)
WHERE	b.RefType = 2
	AND		a.SMSnapId = b.RefId
CX_EXIT:
	SELECT *, @ErrorCode, @ErrorStr, 0, 0
	FROM @tblReturn
	ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToRevert')
	delete from GxQscripts where name = 'MM_SMVolSnapsToRevert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToRevert')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToRevert'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToRevert',  '00010019000200140000', 'MM_SMVolSnapsToRevert', '00010019000200140000')
GO

