

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToPrune.sp,v $ $Id: MM_SMVolSnapsToPrune.sp,v 1.2.276.2 2018/03/20 00:11:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMVolSnapsToPrune <<<'

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToPrune')
	drop procedure MM_SMVolSnapsToPrune
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToPrune')
	delete from GxQscripts where name = 'MM_SMVolSnapsToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToPrune')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToPrune'
GO
print '... Creating Procedure: MM_SMVolSnapsToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToPrune
  @i_HostId integer,
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_GroupIndex integer
  DECLARE @o_SnapShotEngineId integer
  DECLARE @o_ControlHostId integer
  DECLARE @o_SourceClientId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
  DECLARE @o_IsSnapLinked integer
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE	@tblVolToDel TABLE (
			SMVolumeId			integer,
			SourceClientId		integer
		)
	DECLARE	@tblReturn TABLE (
			GroupIndex			integer,
			SnapShotEngineId	integer,
			ControlHostId		integer,
			SourceClientId		integer,
			SMVolSnapMapId		integer,
			SMVolumeId			integer,
			SMSnapId			integer,
			MetaDataId			integer,
			IsSnapLinked		integer
		)
	DECLARE @tblReturnGroup TABLE (
			GroupIndex			integer IDENTITY(1, 1),
			SnapShotEngineId	integer,
			ControlHostId		integer,
			SourceClientId		integer
		)
	DECLARE @RetryParam integer
	SET @RetryParam = ISNULL((select Value from MMConfigs where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 5)
	-----------------------------------
	-- Get volume
	-----------------------------------
	INSERT INTO @tblVolToDel
	SELECT SMVolumeId, SourceClientId
	FROM SMVolume WITH (NOLOCK)
WHERE PruneFlags NOT IN (0, 1, 2, 6)
AND MountStatus < 40 AND MountStatus > 79
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource)
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMVolAction)
AND MountStatus <> 99
	AND (@i_HostId > 0 AND SourceClientId = @i_HostId OR @i_HostId = 0)
	AND RetryCount < @RetryParam
	AND SnapSource = 0
	IF @@ROWCOUNT = 0
	BEGIN
		GOTO CX_EXIT
	END
	------------------------------------------------------------
	------------------------------------------------------------
	INSERT INTO @tblReturn
	SELECT DISTINCT 0, C.SnapShotEngineId, C.ControlHostId, A.SourceClientId, B.SMVolSnapMapId, B.SMVolumeId, B.SMSnapId, B.MetaDataId, 0
	FROM @tblVolToDel A, SMVolSnapMap B WITH (NOLOCK), SMSnap C WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.SMSnapId = C.SMSnapId
	insert into @tblReturnGroup
	select distinct SnapShotEngineId, ControlHostId, SourceClientId
	from @tblReturn
	order by SnapShotEngineId, ControlHostId, SourceClientId
	update @tblReturn
	set GroupIndex = B.GroupIndex
	from @tblReturn A, @tblReturnGroup B
	where A.SnapShotEngineId = B.SnapShotEngineId
	and A.ControlHostId = B.ControlHostId
	and A.SourceClientId = B.SourceClientId
	------------------------------------------------------------------
	-- Snap linked to active volumes
	------------------------------------------------------------------
	UPDATE @tblReturn SET IsSnapLinked = 1
	FROM @tblReturn A, SMVolSnapMap B WITH (NOLOCK), SMVolume C WITH (NOLOCK)
	WHERE A.SMSnapId = B.SMSnapId
	AND B.SMVolumeId = C.SMVolumeId
	AND B.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolToDel)
AND C.MountStatus <> 99
	------------------------------------------------------------------
	-- Get all metadata for volumes
	------------------------------------------------------------------
	INSERT	INTO @tblReturn
	SELECT	A.GroupIndex, A.SnapShotEngineId, A.ControlHostId, A.SourceClientId, 0, RefId, 0, B.MetaDataId, 0
	FROM	@tblReturn A, SMMetaData B WITH (NOLOCK)
	WHERE	A.SMVolumeId = B.RefId
AND		B.RefType = 1
	------------------------------------------------------------------
	-- Get all metadata for snaps
	------------------------------------------------------------------
	INSERT	INTO @tblReturn
	SELECT	A.GroupIndex, A.SnapShotEngineId, A.ControlHostId, A.SourceClientId, 0, 0, RefId, B.MetaDataId, 0
	FROM	@tblReturn A, SMMetaData B WITH (NOLOCK)
	WHERE	A.SMSnapId = B.RefId
AND		B.RefType = 2
CX_EXIT:
CX_ERROR_EXIT:
	SELECT GroupIndex, SnapShotEngineId, ControlHostId, SourceClientId, SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, IsSnapLinked
	FROM @tblReturn
	ORDER BY GroupIndex, SnapShotEngineId, ControlHostId, SourceClientId, SMVolumeId, SMSnapId, MetaDataId
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToPrune')
	delete from GxQscripts where name = 'MM_SMVolSnapsToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToPrune')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToPrune'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToPrune',  '00010002027600020000', 'MM_SMVolSnapsToPrune', '00010002027600020000')
GO

