

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToPrepare.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToPrepare.sp,v $ $Id: MM_SMVolSnapsToPrepare.sp,v 1.2.86.4 2018/03/20 00:03:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMVolSnapsToPrepare <<<'

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToPrepare')
	drop procedure MM_SMVolSnapsToPrepare
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToPrepare')
	delete from GxQscripts where name = 'MM_SMVolSnapsToPrepare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToPrepare')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToPrepare'
GO
print '... Creating Procedure: MM_SMVolSnapsToPrepare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToPrepare
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
  DECLARE @o_LogMesg VARCHAR(4096)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @LogMesg			VARCHAR(4096) = ''
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToPrepare
	/*
		<MM_SMVolSnapsToPrepare>
			<JobId></JobId>
		</MM_SMVolSnapsToPrepare>
	*/
	DECLARE @tblReturn  TABLE (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer
		)
	DECLARE @MM_SM_OPTYPE_REVERT_SNAP INTEGER = 4
	DECLARE @x_JobId INTEGER
	DECLARE @tblVolIds TABLE (
				SMVolumeId	int,
				AppId		int)
	DECLARE @tblRevertVolIds TABLE (SMVolumeId int)
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToPrepare/JobId') R(ref)), 0)
	INSERT	INTO @tblVolIds
	SELECT	SMVolumeId, AppId
	FROM	SMVolume VOL WITH (READUNCOMMITTED)
	WHERE	VOL.JobId = @x_JobId
	INSERT	INTO @tblRevertVolIds
	SELECT	VOLRVT.SMVolumeId
	FROM	SMVolAction VOLACT WITH (READUNCOMMITTED) INNER JOIN SMVolume VOLRVT WITH (NOLOCK)
			ON VOLACT.SnapOpType = @MM_SM_OPTYPE_REVERT_SNAP
				AND VOLACT.SMVolumeId = VOLRVT.SMVolumeId
			INNER JOIN @tblVolIds VOL
			ON VOLRVT.AppId = VOL.AppId
	IF EXISTS (SELECT * FROM @tblRevertVolIds)
	BEGIN
SELECT	SMVolumeId, 60300, 'Currently Source Volume(s) of same subclient undergiong revert operation', 0, 0, @LogMesg
		FROM	@tblRevertVolIds
		RETURN	-- Return the failure messages
	END
	-- For ExxonMobil Oracle / VMAX jobs which are using Spouse Clone (eng-28) devs, the previous job has to be aged and pruned before starting the
	-- new job. This is due to the availability of one set of spouse clone devs for that subclient's source devs
	-- Check whether MMConfig - Pre-Snap Backup Pruning is enabled
	IF EXISTS(SELECT 1 FROM MMConfigs(NOLOCK) WHERE name = 'MMS2_SNAP_PREBACKUP_PRUNING' AND value = 1)
	BEGIN
		DECLARE @appId INTEGER = 0
		DECLARE @appTypeId INTEGER = 0
		DECLARE @copyId INTEGER = 0
		DECLARE @dataType INTEGER = 0
		DECLARE @isSpouseDevs INTEGER = 0
		DECLARE @tblVolumes TABLE(SMVolumeId int, AppId int, AppTypeId int, CopyId int, DataType int)
		IF NOT EXISTS (SELECT 1 FROM @tblVolIds)
			GOTO PROC_EXIT_SUCCESS
		SELECT	@appId = VOL.AppId, @appTypeId = VOL.AppTypeId, @copyId = VOL.CopyId, @dataType = AF.fileType
		FROM	SMVolume VOL(NOLOCK) INNER JOIN ArchFile AF(NOLOCK) ON VOL.SMVolumeId = (SELECT MAX(SMVolumeId) FROM @tblVolIds)
					AND VOL.ArchFileId = AF.id AND VOL.AppId = AF.appId and VOL.CommCellId = AF.commCellId
		IF 22 /*CV_APPTYPE_ORACLE8*/ != @appTypeId
			GOTO PROC_EXIT_SUCCESS
		SELECT	@isSpouseDevs = 1
		FROM	SMVolume VOL(NOLOCK) INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
					AND VOL.AppId = @appId AND VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolIds)
				INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId AND SNAP.SnapShotEngineId IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/)
					-- 4 /*SM_SNAPSHOT_ENGINE_SYMMETRIX*/, 5 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_SNAP*/, 47 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/
				INNER JOIN SMConfigs CFG(NOLOCK) ON CFG.MasterConfigId = 44 	/*SMCONFIG_EMC_SYMMETRIX_NAME_DISABLE_CONFIG_CHANGE_MAP_UNMAP*/
					AND CFG.IsValid = 1
					AND SNAP.ControlHostId = CFG.ArrayId
					AND (	(CFG.AssocType = 9 /*MMSM_AT_SUBCLIENT*/ AND CFG.AssocId = @appId)
							OR (CFG.AssocType = 6 /*MMSM_AT_COPY*/ AND CFG.AssocId = @copyId)
							OR (CFG.AssocType = 3 /*MMSM_AT_ARRAY*/ AND CFG.AssocId = SNAP.ControlHostId)	)
					AND CFG.ValueInt = 1
				INNER JOIN SMConfigs CFG1(NOLOCK) ON CFG1.MasterConfigId = 180 /*SMCONFIG_VMAX_PREBACKUP_SNAP_PRUNING*/
					AND CFG1.IsValid = 1 AND SNAP.ControlHostId = CFG1.ArrayId AND CFG1.AssocType = 9 /*MMSM_AT_SUBCLIENT*/ AND CFG1.AssocId = @appId AND CFG1.ValueInt = 1
		IF @isSpouseDevs != 1
			GOTO PROC_EXIT_SUCCESS
		-- Call Data-Aging's SP to age the oldest available and possible job
		IF EXISTS (SELECT 1 FROM SMVolume (NOLOCK) WHERE AppId = @appId AND JobId < @x_JobId AND PruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/)
		BEGIN
			IF object_id('tempdb.dbo.#tmpArchDeleteOldestJobOnAppCopyResult') IS NOT null DROP TABLE #tmpArchDeleteOldestJobOnAppCopyResult
			CREATE TABLE #tmpArchDeleteOldestJobOnAppCopyResult (retVal int, errorString varchar(1024), skippedCode int, prunedJobIdList varchar(max))
			-- INSERT	INTO #tmparchDeleteOldestJobOnAppCopyResult -- Nested INSERT INTO..EXEC not allowed
			EXEC	archDeleteOldestJobOnAppCopy @appId, @copyId, @dataType, 0/*Flags - honor all retention rules*/, 0/*reserve*/
			IF EXISTS(SELECT 1 FROM #tmpArchDeleteOldestJobOnAppCopyResult (NOLOCK))
			BEGIN
				SELECT TOP 1 @LogMesg = ('RetVal-[' + CONVERT(VARCHAR(8), retVal) + '] Err-[' + SUBSTRING(errorString, 0, 1024) + '] SkipCode-[' + CONVERT(VARCHAR(8), skippedCode) + '] PruneJobIds-[' + SUBSTRING(prunedJobIdList, 0, 2816) + ']') FROM #tmpArchDeleteOldestJobOnAppCopyResult (NOLOCK)
			END
			IF object_id('tempdb.dbo.#tmpArchDeleteOldestJobOnAppCopyResult') IS NOT null DROP TABLE #tmpArchDeleteOldestJobOnAppCopyResult
		END
		IF EXISTS (SELECT 1 FROM SMVolume (NOLOCK) WHERE AppId = @appId AND JobId < @x_JobId AND PruneFlags > 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/)
		BEGIN
			IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
			CREATE TABLE #ToBeDeletedVols (
					SMVolumeId integer,
					ArchFileId integer,
					CommCellId integer,
					CopyId integer,
					primary key (SMVolumeId, ArchFileId, CommCellId, CopyId)
				)
			IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
			CREATE TABLE #tblSMVolumeMountStatus  (
			            MountStatus integer,
						primary key (MountStatus)
			)
INSERT INTO #tblSMVolumeMountStatus SELECT 0                   /*SM_VS_NONE*/
INSERT INTO #tblSMVolumeMountStatus SELECT 10            /*SM_VS_PRP_STARTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 11          /*SM_VS_PRP_DV_DSCVRD*/
INSERT INTO #tblSMVolumeMountStatus SELECT 12    /*SM_VS_PRP_DV_DSCVR_FAILED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 18             /*SM_VS_PRP_FAILED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 19           /*SM_VS_PRP_PREPARED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 20           /*SM_VS_UPRP_STARTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 28            /*SM_VS_UPRP_FAILED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 29          /*SM_VS_UPRP_FINISHED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 30            /*SM_VS_CRT_STARTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 38             /*SM_VS_CRT_FAILED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 39            /*SM_VS_CRT_CREATED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 79          /*SM_VS_UMT_UNMOUNTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 89           /*SM_VS_RVT_REVERTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 90            /*SM_VS_DEL_STARTED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 97        /*SM_VS_DEL_EXT_DELETED*/
INSERT INTO #tblSMVolumeMountStatus SELECT 98             /*SM_VS_DEL_FAILED*/
			INSERT	INTO #ToBeDeletedVols
			SELECT	DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
			FROM	SMVolume VOL(NOLOCK) INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
						AND VOL.AppId = @appId AND VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolIds)
						AND VOL.PruneFlags > 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/
					INNER JOIN #tblSMVolumeMountStatus TMP_MS ON VOL.MountStatus = TMP_MS.MountStatus
					INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId AND SNAP.SnapShotEngineId IN (28 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE*/)
						-- 4 /*SM_SNAPSHOT_ENGINE_SYMMETRIX*/, 5 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_SNAP*/, 47 /*SM_SNAPSHOT_ENGINE_SYMMETRIX_VP_SNAP*/
			UPDATE	SMVolume
			SET		MountStatus = 99  /*SM_VS_DEL_DELETED*/
			WHERE	SMVolumeId IN (SELECT DISTINCT SMVolumeId FROM #ToBeDeletedVols(NOLOCK))
			IF object_id('tempdb.dbo.#tmpMM_SMDeleteVolSnapsResult') IS NOT null DROP TABLE #tmpMM_SMDeleteVolSnapsResult
			CREATE TABLE #tmpMM_SMDeleteVolSnapsResult (RetVal int)
			IF EXISTS (SELECT * FROM #ToBeDeletedVols)
				INSERT	INTO #tmpMM_SMDeleteVolSnapsResult
				EXEC	MM_SMDeleteVolSnaps 0, 0
			END
			IF object_id('tempdb.dbo.#tmpMM_SMDeleteVolSnapsResult') IS NOT null DROP TABLE #tmpMM_SMDeleteVolSnapsResult
			IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
			IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
	END
PROC_EXIT_SUCCESS:
	SELECT	0, 0, '', 0, 0, @LogMesg
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToPrepare')
	delete from GxQscripts where name = 'MM_SMVolSnapsToPrepare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToPrepare')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToPrepare'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToPrepare',  '00010002008600040000', 'MM_SMVolSnapsToPrepare', '00010002008600040000')
GO

