

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToMountVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToMountVM.sp,v $ $Id: MM_SMVolSnapsToMountVM.sp,v 1.1.4.4 2019/03/08 17:03:05 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToMountVM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToMountVM <<<'
	drop procedure MM_SMVolSnapsToMountVM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToMountVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountVM'
GO
print '... Creating Procedure: MM_SMVolSnapsToMountVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToMountVM
  @i_xmlInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MountVMVolId INTEGER
  DECLARE @o_Flag BIGINT
  DECLARE @o_SiblingVMVolId INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-----------------------------------------------------------------------------
-- XML Structure for MM_SMVolSnapsToMountVM
-----------------------------------------------------------------------------
/*
	<MM_SMVolSnapsToMountVM>
		<JobId>xxxx</JobId>
		<HostId>xxxx</HostId>
		<MountFlags>xxxx</MountFlags>
		<MountMode>xxxx</MountMode>
		<SMVolumes>
			<VolumeId>xxxx</VolumeId>
			<VolumeId>xxxx</VolumeId>
			...
			<VolumeId>xxxx</VolumeId>
		</SMVolumes>
	</MM_SMVolSnapsToMountVM>
*/
----------------------------------------------------- ERROR VARIABLES -----------------------------------------------------
SET @o_ErrorCode    = 0
SET @o_ErrorStr     = ''
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT                INTEGER = 60200	/*	E_MM_SM_SB_ERROR	*/
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE @x_JobId								INTEGER			= 0
DECLARE @x_HostId								INTEGER			= 0
DECLARE @x_MountFlags							BIGINT			= 0
DECLARE @x_MountMode							BIGINT			= 0
DECLARE	@l_RetVal								INTEGER			= 0
DECLARE @l_VolId								INTEGER			= 0
DECLARE	@l_VsaVolumeFlag						BIGINT			= 4294967296	/* CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB	*/
----------------------------------------------------- INPUT VALIDATION ----------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
    SET @o_ErrorCode    = @ERROR_INVALID_XML_INPUT
    SET @o_ErrorStr     = 'Input XML Parameter cannot be empty.'
    GOTO PROC_FAILURE
END
----------------------------------------------------- LOCAL TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_Ret'				) IS NOT NULL
	DROP TABLE #SMVSToMntVM_Ret
CREATE TABLE #SMVSToMntVM_Ret							(	MountVolumeId	INT,
															Flag			INT,
															SibVolumeId		INT,
															ErrorCode		INT,
															ErrorStr		VARCHAR(1024)	)
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_JobId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/JobId'		)	R(ref)), 0)
SET @x_HostId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/HostId'		)	R(ref)), 0)
SET @x_MountFlags	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/MountFlags'	)	R(ref)), 0)
SET @x_MountMode	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/MountMode'	)	R(ref)), 0)
---- If the request is not Traditional, Go to End.
------ In case proxyless validation is to be added, then call the new SP as required.
IF(	((@x_MountMode	& 4				/*	SM_VSA_MOUNT_MODE_NO_ESX_DS	*/				) = 4				/* SM_VSA_MOUNT_MODE_NO_ESX_DS	*/				)
	OR
((@x_MountFlags & 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	) = 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB*/	)		)
BEGIN
	INSERT INTO		#SMVSToMntVM_Ret
	EXEC @l_RetVal	= MM_SMVolSnapsToMountPVM @i_xmlInput, 0, ''
	IF(@l_RetVal <> 0)
	BEGIN
IF (@l_RetVal <> 60340	/*	E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT	*/	)
		BEGIN
SET @o_ErrorCode	=	ISNULL( (SELECT ErrorCode	FROM #SMVSToMntVM_Ret),	60200	/*	E_MM_SM_SB_ERROR	*/	)
			SET @o_ErrorStr		=	ISNULL( (SELECT ErrorStr	FROM #SMVSToMntVM_Ret),	'Validation for proxyless mode failed'				)
			GOTO PROC_FAILURE
		END
		---- Otherwise, continue with single-node unmount validation..
	END
	ELSE IF (@l_RetVal = 0)
	BEGIN
		GOTO PROC_SUCCESS
	END
END
----------------------------------------------------- TEMP TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_InVols'			) IS NOT NULL
	DROP TABLE #SMVSToMntVM_InVols
IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_LinkVols'			) IS NOT NULL
	DROP TABLE #SMVSToMntVM_LinkVols
---- Current Volume table
CREATE TABLE #SMVSToMntVM_InVols											(	SMVolumeId		INT,
																				MasterJobId		INT,
																				VolFlags		BIGINT,
																				SibVolumeId		INT				)
CREATE INDEX SMVSToMntVM_InVols_SMVolId_Idx	ON #SMVSToMntVM_InVols			(	SMVolumeId						)
---- Volumes linking to the Linking-Snaps
CREATE TABLE #SMVSToMntVM_LinkVols											(	SMVolumeId		INT,
																				MountStatus		INT,
																				MasterJobId		INT,
																				MountHostId		INT				)
CREATE INDEX SMVSToMntVM_LV_SMVolumeId_Idx	ON #SMVSToMntVM_LinkVols		(	SMVolumeId						)
----------------------------------------------------- INPUT PARSING 2 -------------------------------------------------------
---- Get all the volume Ids
INSERT	INTO	#SMVSToMntVM_InVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MasterJobId, VOL.VolumeFlags, 0
FROM			(
					SELECT	R.ref.value('.', 'INT') AS SMVolumeId
					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/SMVolumes/VolumeId') R(ref)
				)	AS
				TV	INNER JOIN	SMVolume VOL (READUNCOMMITTED)	ON TV.SMVolumeId = VOL.SMVolumeId
----------------------------------------------------- INPUT VALIDATION 2 ----------------------------------------------------
IF EXISTS	(	SELECT	TOP 1 TV.SMVolumeId
				FROM	#SMVSToMntVM_InVols	TV
				WHERE	TV.VolFlags & @l_VsaVolumeFlag <> @l_VsaVolumeFlag
			)
BEGIN
		SET		@o_ErrorStr		= 'The list contains mix of VSA Indexing-V2 and other snaps. Please select either VSA Indexing-V2 snap volumes alone or the other ones alone.'
SET		@o_ErrorCode	= 60200		/*	E_MM_SM_SB_ERROR	*/
		GOTO	PROC_FAILURE
END
----------------------------------------------------- MAIN LOGIC ----------------------------------------------------------
---- Get all the link Vols associated with the input vols.
INSERT	INTO	#SMVSToMntVM_LinkVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MountStatus, VOL.MasterJobId, VOL.MountHostId
FROM			#SMVSToMntVM_InVols	TV	INNER JOIN	SMVolSnapMap	MAP  (READUNCOMMITTED)	ON TV.SMVolumeId	= MAP.SMVolumeId
										INNER JOIN	SMVolSnapMap	RMAP (READUNCOMMITTED)	ON MAP.SMSnapId		= RMAP.SMSnapId
										INNER JOIN	SMVolume		VOL  (READUNCOMMITTED)	ON RMAP.SMVolumeId	= VOL.SMVolumeId
WHERE				(	VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag				)
				AND	(	VOL.SMVolumeId	NOT IN (SELECT SMVolumeId FROM #SMVSToMntVM_InVols)	)
---- Fail the Mount Validation if any one of the linking volumes is in Mounting / Unmounting state.
---- Refer to VSA V2 - Mount Unmount Validation excel sheet to get more insights
SET		@l_VolId =	(	SELECT TOP 1	TLV.SMVolumeId
						FROM			#SMVSToMntVM_LinkVols	TLV
WHERE			(	TLV.MountStatus >=	40	/*	SM_VS_MNT_STARTED	*/	AND		TLV.MountStatus <	58	/*	SM_VS_MNT_FAILED	*/	)
										OR
(	TLV.MountStatus >=	60	/*	SM_VS_UMT_STARTED	*/	AND		TLV.MountStatus <	78	/*	SM_VS_UMT_FAILED	*/	)
					)
IF		@l_VolId IS NOT NULL
BEGIN
		SET		@o_ErrorStr		= 'One or more linked volumes [' + CONVERT(VARCHAR(10), @l_VolId) + '] is being used by Jobs]'
SET		@o_ErrorCode	= 60207		/*	E_MM_SM_SB_VOL_OP_IN_PROCESS	*/
		GOTO	PROC_FAILURE
END
---- Check and get the linking volume which is already mounted.
UPDATE	TV
SET		TV.SibVolumeId = LV.SMVolumeId
FROM	#SMVSToMntVM_InVols TV	INNER JOIN	SMVolSnapMap MAP	(READUNCOMMITTED)	ON	(	TV.SMVolumeId	= MAP.SMVolumeId			)
								INNER JOIN	SMVolSnapMap RMAP	(READUNCOMMITTED)	ON	(	MAP.SMSnapId	= RMAP.SMSnapId				)
								INNER JOIN	#SMVSToMntVM_LinkVols LV				ON	(	RMAP.SMVolumeId	= LV.SMVolumeId				)
																						AND
(	LV.MountStatus	= 59		)
																						AND
																						(	LV.MountHostId	= @x_HostId					)
---- Set the Output values
INSERT	INTO	#SMVSToMntVM_Ret
SELECT			TV.SMVolumeId, (CASE WHEN TV.SibVolumeId = 0 THEN 0 ELSE 1 END), TV.SibVolumeId, 0, ''
FROM			#SMVSToMntVM_InVols TV
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
PROC_SUCCESS:
	SELECT	TR.MountVolumeId, TR.Flag, TR.SibVolumeId, @o_ErrorCode, @o_ErrorStr
	FROM	#SMVSToMntVM_Ret	TR
	GOTO PROC_END
PROC_FAILURE:
	SELECT 0, 0, 0, @o_ErrorCode, @o_ErrorStr
PROC_END:
	-- Cleanup the temp tables
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_InVols'		) IS NOT NULL
		DROP TABLE #SMVSToMntVM_InVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_LinkVols'		) IS NOT NULL
		DROP TABLE #SMVSToMntVM_LinkVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntVM_Ret'			) IS NOT NULL
		DROP TABLE #SMVSToMntVM_Ret
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToMountVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountVM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToMountVM',  '00010001000400040000', 'MM_SMVolSnapsToMountVM', '00010001000400040000')
GO

