

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToMountTestEnv.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToMountTestEnv.sp,v $ $Id: MM_SMVolSnapsToMountTestEnv.sp,v 1.3.2.8 2020/08/12 19:15:18 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToMountTestEnv')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToMountTestEnv <<<'
	drop procedure MM_SMVolSnapsToMountTestEnv
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToMountTestEnv')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountTestEnv'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountTestEnv')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountTestEnv'
GO
print '... Creating Procedure: MM_SMVolSnapsToMountTestEnv'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToMountTestEnv
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Tag - SM_MNT_TE
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @defaultCCId INT = 2
	DECLARE @EngineName NVARCHAR(128) = N''
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToMount
	/*
		<MM_SMVolSnapsToMount>
			<VolumeId></VolumeId>
			<JobId></JobId>
			<HostId></HostId>
			<MountFlags></MountFlags>
		</MM_SMVolSnapsToMount>
	*/
	IF OBJECT_ID('tempdb.dbo.#SM_MNT_TE_VolIDs') IS NOT NULL
	DROP TABLE #SM_MNT_TE_VolIDs
	CREATE TABLE #SM_MNT_TE_VolIDs
	(
		SMVolumeId INT
	)
	CREATE UNIQUE CLUSTERED INDEX ix_SM_MNT_TE_VolIDs ON #SM_MNT_TE_VolIDs (SMVolumeId);
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_MountFlags BIGINT
	DECLARE @ErrorVolId INTEGER = 0
	SET @ErrorCode = 0
	SELECT	@x_JobId =ISNULL(R.ref.value('(./JobId/text())[1]', 'int'), 0),
			@x_HostId =ISNULL(R.ref.value('(./HostId/text())[1]', 'int'), 0),
			@x_MountFlags =ISNULL(R.ref.value('(./MountFlags/text())[1]', 'bigint'), 0)
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount') R(ref)
	INSERT	INTO #SM_MNT_TE_VolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/VolumeId') R(ref)
	-----------------------------------------------------------------------------
	-- Engine doesn't support Test Environment creation.
	-----------------------------------------------------------------------------
	DECLARE @l_IsEngCapabilityCheckDisabled INTEGER = 0
	SELECT	@l_IsEngCapabilityCheckDisabled = value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_SNAP_SKIP_TEST_ENV_ENGINE_CAPABILITY_CHECK'
IF ( (@x_MountFlags & 1073741824 = 0) AND
		 (@l_IsEngCapabilityCheckDisabled = 0) )
	BEGIN
		SELECT @EngineName = (	SELECT	TOP 1 ENG.SnapEngineName
								FROM	#SM_MNT_TE_VolIDs TMP
											INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED)
												ON MAP.SMVolumeId = TMP.SMVolumeId
											INNER JOIN SMSnap SNAP WITH (READUNCOMMITTED)
												ON MAP.SMSnapId = SNAP.SMSnapId
											INNER JOIN SMSnapShotEngine ENG WITH (READUNCOMMITTED)
												ON SNAP.SnapShotEngineId = ENG.SnapShotEngineId
WHERE	ENG.Capabilities & 16777216 /*SM_SNAPSHOT_ENGINE_CAPABILITY_TESTENV_CREATE*/ = 0
							)
		IF @EngineName IS NOT NULL
		BEGIN
SET @ErrorCode = 60370
			SELECT @ErrorCode, 'The snapshot engine[' + @EngineName + '] does not support instant clone creation.'
			GOTO CX_EXIT
		END
	END
	-----------------------------------------------------------------------------
	-- JobId already exists. Retry attempt.
	-----------------------------------------------------------------------------
	-- Job Id exists in DB
IF (@x_MountFlags & 1073741824) = 0
	BEGIN
	SET @ErrorVolId = (	SELECT TOP 1 MVOL.Id
						FROM #SM_MNT_TE_VolIDs TMP
							JOIN SMMountVolume (READUNCOMMITTED) MVOL  ON MVOL.SMVolumeId=TMP.SMVolumeId
						WHERE MVOL.MountJobId = @x_JobId)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 60332, 'One or more volume(s) have been already created by a previous attempt for this job. MountVolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60332
		GOTO CX_EXIT
	END
	END
	ELSE
	BEGIN
SET @ErrorVolId = (SELECT TOP 1 MVOL.Id FROM SMMountVolume (READUNCOMMITTED) MVOL WHERE MVOL.MountJobId = @x_JobId AND MountFlags & 64 = 64)
		IF @ErrorVolId IS NOT NULL
		BEGIN
SELECT 60332, 'One or more volume(s) have been already created by a previous attempt for this job. MountVolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60332
			GOTO CX_EXIT
		END
	END
	---------------------------------------------------------------------------------------
    -- Engine doesn't support dedicated clone for mount (VSA applications)
    ---------------------------------------------------------------------------------------
	SELECT @EngineName = (SELECT TOP 1 ENG.SnapEngineName FROM #SM_MNT_TE_VolIDs TMP
					INNER JOIN SMVolume VOL (READUNCOMMITTED) ON TMP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
					INNER JOIN SMSnapshotEngine ENG (READUNCOMMITTED) ON SNAP.SnapShotEngineId = ENG.SnapShotEngineId
WHERE VOL.AppTypeId = 106
AND ENG.Capabilities & 134217728 /*SM_SNAPSHOT_ENGINE_CAPABILITY_DEDICATED_CLONE_FOR_MOUNT*/ = 0)
	IF @EngineName IS NOT NULL
	BEGIN
SELECT 60349, 'The snap engine[' + @EngineName + '] does not support dedicated clone creation for mount operation.'
SET @ErrorCode = 60349
		GOTO CX_EXIT
	END
	---------------------------------------------------------------------------------------
    -- For HDS TI, Test Clone creation is not supported for snaps created without cascade mode.
    ---------------------------------------------------------------------------------------
	DECLARE	@l_SnapIdWithoutCascadeMode			INTEGER = 0
DECLARE @l_SnapFlagSplSnapForInstClone		BIGINT	= 562949953421312 /* CVSM_SNAPSHOTFLAGS_SPL_SNAP_FOR_INSTANT_CLONE_DB */
	SELECT	TOP 1 @l_SnapIdWithoutCascadeMode = SNAP.SMSnapId
	FROM	#SM_MNT_TE_VolIDs TVOL
				INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED)
					ON TVOL.SMVolumeId = MAP.SMVolumeId
				INNER JOIN SMSnap SNAP WITH (READUNCOMMITTED)
					ON MAP.SMSnapId = SNAP.SMSnapId
WHERE	SNAP.SnapShotEngineId =	34		/* SM_SNAPSHOT_ENGINE_HDS_CCI_SNAP */
				AND (SNAP.SnapFlags & @l_SnapFlagSplSnapForInstClone <> @l_SnapFlagSplSnapForInstClone)
	IF @l_SnapIdWithoutCascadeMode  > 0
	BEGIN
SET @ErrorCode = 60371
		SELECT @ErrorCode, 'Instant clone creation is not possible for snap-[' + CONVERT(VARCHAR(64), @l_SnapIdWithoutCascadeMode) + '] as it is created without compatible mode.'
		GOTO CX_EXIT
	END
CX_EXIT:
	IF OBJECT_ID('tempdb..#SM_MNT_TE_VolIDs') IS NOT NULL
		DROP TABLE #SM_MNT_TE_VolIDs
	RETURN @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToMountTestEnv')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountTestEnv'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountTestEnv')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountTestEnv'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToMountTestEnv',  '00010003000200080000', 'MM_SMVolSnapsToMountTestEnv', '00010003000200080000')
GO

