

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToMountPVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToMountPVM.sp,v $ $Id: MM_SMVolSnapsToMountPVM.sp,v 1.1.4.3 2019/03/20 21:17:21 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToMountPVM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToMountPVM <<<'
	drop procedure MM_SMVolSnapsToMountPVM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToMountPVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountPVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountPVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountPVM'
GO
print '... Creating Procedure: MM_SMVolSnapsToMountPVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToMountPVM
  @i_xmlInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_MountVMVolId INTEGER
  DECLARE @o_Flag BIGINT
  DECLARE @o_SiblingVMVolId INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-----------------------------------------------------------------------------
-- XML Structure for MM_SMVolSnapsToMountVM
-----------------------------------------------------------------------------
/*
	<MM_SMVolSnapsToMountVM>
		<JobId>xxxx</JobId>
		<HostId>xxxx</HostId>
		<MountFlags>xxxx</MountFlags>
		<MountMode>xxxx</MountMode>
		<SMVolumes>
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
			...
			<VolumeId>xxxx</VolumeId><MountVolumeId>xxxx</MountVolumeId>
		</SMVolumes>
	</MM_SMVolSnapsToMountVM>
*/
----------------------------------------------------- ERROR VARIABLES -----------------------------------------------------
SET @o_ErrorCode    = 0
SET @o_ErrorStr     = ''
----------------------------------------------------- CONSTANTS FOR ERROR VALUES ------------------------------------------
DECLARE @ERROR_INVALID_XML_INPUT                INTEGER = 60200	/*	E_MM_SM_SB_ERROR	*/
----------------------------------------------------- INPUT VALIDATION ----------------------------------------------------
IF @i_xmlInput IS NULL
BEGIN
    SET @o_ErrorCode    = @ERROR_INVALID_XML_INPUT
    SET @o_ErrorStr     = 'Input XML Parameter cannot be empty.'
    GOTO PROC_FAILURE
END
----------------------------------------------------- LOCAL VARIABLES -----------------------------------------------------
DECLARE @x_JobId								INTEGER			= 0
DECLARE @x_HostId								INTEGER			= 0
DECLARE @x_MountFlags							BIGINT			= 0
DECLARE @x_MountMode							BIGINT			= 0
DECLARE	@l_MountVolId							INTEGER			= 0
DECLARE	@l_RetVal								INTEGER			= 0
DECLARE	@l_VsaVolumeFlag						BIGINT			= 4294967296		/*	CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB	*/
DECLARE @l_GenVolId								INTEGER			= 0
----------------------------------------------------- LOCAL TABLES --------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_InVols'		) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_InVols
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_InMVols'		) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_InMVols
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkSnaps'	) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_LinkSnaps
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkVols'	) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_LinkVols
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkMVols'	) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_LinkMVols
IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_Ret'			) IS NOT NULL
	DROP TABLE #SMVSToMntPVM_Ret
---- Volume table
CREATE TABLE #SMVSToMntPVM_InVols													(	SMVolumeId		INT,
																						MasterJobId		INT,
																						VolFlags		BIGINT			)
CREATE INDEX SMVSToMntPVM_InVols_SMVols_Idx			ON	#SMVSToMntPVM_InVols		(	SMVolumeId						)
---- MountVolume table
CREATE	TABLE #SMVSToMntPVM_InMVols													(	MountVolumeId	INT,
																						SMVolumeId		INT,
																						MountJobId		INT				)
CREATE INDEX SMVSToMntPVM_InMVols_MVols_Idx			ON	#SMVSToMntPVM_InMVols		(	MountVolumeId					)
---- Linked Snap table
CREATE TABLE #SMVSToMntPVM_LinkSnaps												(	SMSnapId		INT,
																						EngineId		INT				)
CREATE INDEX SMVSToMntPVM_LinkSnaps_SMSnapId_Idx	ON	#SMVSToMntPVM_LinkSnaps		(	SMSnapId						)
---- Volumes Linked to Linked-Snaps
CREATE TABLE #SMVSToMntPVM_LinkVols													(	SMVolumeId		INT,
																						MountStatus		INT,
																						MasterJobId		INT,
																						MountHostId		INT				)
CREATE INDEX SMVSToMntPVM_LinkVols_SMVols_Idx		ON	#SMVSToMntPVM_LinkVols		(	SMVolumeId						)
---- MountVolumes linked to Linked-Vols
CREATE TABLE #SMVSToMntPVM_LinkMVols												(	SMMountVolId	INT,
																						SMVolumeId		INT,
																						MountJobId		INT,
																						MountHostId		INT,
																						MountStatus		INT,
																						MountOptions	NVARCHAR(2048)	)
CREATE INDEX SMVSToMntPVM_LinkMVols_MVols_Idx		ON	#SMVSToMntPVM_LinkMVols		(	SMMountVolId					)
---- Return table
CREATE TABLE #SMVSToMntPVM_Ret														(	MountVolumeId	INT,
																						Flag			INT,
																						SibVolumeId		INT,
																						ErrorCode		INT,
																						ErrorStr		VARCHAR(1024)	)
----------------------------------------------------- INPUT PARSING -------------------------------------------------------
SET @x_JobId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/JobId'		)	R(ref)), 0)
SET @x_HostId		= ISNULL(( SELECT R.ref.value('.', 'INT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/HostId'		)	R(ref)), 0)
SET @x_MountFlags	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/MountFlags'	)	R(ref)), 0)
SET @x_MountMode	= ISNULL(( SELECT R.ref.value('.', 'BIGINT'	) FROM @i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/MountMode'	)	R(ref)), 0)
-- Get all the volume Ids
INSERT	INTO	#SMVSToMntPVM_InVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MasterJobId, VOL.VolumeFlags
FROM			(	SELECT	R.ref.value('.', 'INT') AS SMVolumeId
					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/SMVolumes/VolumeId') R(ref)
				) AS
				TV	INNER JOIN	SMVolume VOL (READUNCOMMITTED)	ON	TV.SMVolumeId = VOL.SMVolumeId
-- Get all the MountVolumeIds	(Currently not used. In future, it may be used to work with MountVolumes)
--INSERT	INTO	#SMVSToMntPVM_InMVols
--SELECT			MVOL.Id, MVOL.SMVolumeId, MVOL.MountJobId
--FROM			(	SELECT	R.ref.value('.', 'INT') as MountVolumeId
--					FROM	@i_xmlInput.nodes('/MM_SMVolSnapsToMountVM/SMVolumes/MountVolumeId') R(ref)
--				) AS
--				TBMV LEFT OUTER JOIN SMMountVolume MVOL (READUNCOMMITTED)	ON TBMV.MountVolumeId = MVOL.Id
----------------------------------------------------- INPUT VALIDATION 2 ----------------------------------------------------
IF EXISTS	(	SELECT	TOP 1 TV.SMVolumeId
				FROM	#SMVSToMntPVM_InVols	TV
				WHERE	TV.VolFlags & @l_VsaVolumeFlag <> @l_VsaVolumeFlag
			)
BEGIN
		SET		@o_ErrorStr		= 'The list contains mix of VSA Indexing-V2 and other snaps. Please select either VSA Indexing-V2 snap volumes alone or the other ones alone.'
SET		@o_ErrorCode	= 60200		/*	E_MM_SM_SB_ERROR	*/
		GOTO	PROC_FAILURE
END
----------------------------------------------------- MAIN LOGIC ----------------------------------------------------------
---- Get all the Snaps behind the datatsore being used by current Vols
INSERT	INTO	#SMVSToMntPVM_LinkSnaps
SELECT			DISTINCT SNAP.SMSnapId,	SNAP.SnapShotEngineId
FROM			#SMVSToMntPVM_InVols TV	INNER JOIN	SMVolSnapMap	MAP		(READUNCOMMITTED)	ON	TV.SMVolumeId = MAP.SMVolumeId
										INNER JOIN	SMSnap			SNAP	(READUNCOMMITTED)	ON	SNAP.SMSnapId = MAP.SMSnapId
---- First check if the Engine is multi-node capable or not
IF(	(@x_MountFlags & 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/ ) = 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	)
BEGIN
	IF EXISTS	(	SELECT		TOP 1 TLS.SMSnapId
					FROM		#SMVSToMntPVM_LinkSnaps	TLS	INNER JOIN	SMSnapshotEngine ENG	(READUNCOMMITTED)	ON TLS.EngineId = ENG.SnapShotEngineId
WHERE		(ENG.Capabilities & 67108864	/*	SM_SNAPSHOT_ENGINE_CAPABILITY_ALLOW_MULTI_NODE_MOUNT_VMWARE	*/ = 0)
				)
	BEGIN
		SET		@o_ErrorStr		= 'The current engine is not Multi-Node Mount capable. Skipping to single-node mount validation.'
SET		@o_ErrorCode	= 60340	/*	E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT	*/
		GOTO	PROC_FAILURE
	END
END
---- Get all the Vols associated with the Snaps which were fetched previously.
INSERT	INTO	#SMVSToMntPVM_LinkVols
SELECT			DISTINCT VOL.SMVolumeId, VOL.MountStatus, VOL.MasterJobId, VOL.MountHostId
FROM			#SMVSToMntPVM_LinkSnaps	TLS	INNER JOIN	SMVolSnapMap	MAP (READUNCOMMITTED)	ON	TLS.SMSnapId	= MAP.SMSnapId
											INNER JOIN	SMVolume		VOL (READUNCOMMITTED)	ON	VOL.SMVolumeId	= MAP.SMVolumeId
WHERE			(	VOL.VolumeFlags & @l_VsaVolumeFlag = @l_VsaVolumeFlag					)
				AND
				(	VOL.SMVolumeId	NOT IN (SELECT SMVolumeId FROM #SMVSToMntPVM_InVols)	)
---- If the snaps are already mounted to ESX, fail the current proxyless mount request.
SELECT @l_GenVolId = SMVolumeId FROM #SMVSToMntPVM_LinkVols WHERE MountStatus = 59		/*	SM_VS_MNT_MOUNTED	*/
IF(	(	@x_JobId	> 0		)
	AND
	(	@l_GenVolId > 0		)
	AND		---- Adding below check so that MNM backup copy is not affected!
(	(@x_MountFlags & 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/ ) <> 268435456	/*	VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB	*/	)
  )
BEGIN
	SET		@o_ErrorStr		= 'Found volume-['+ CONVERT(VARCHAR(10), @l_GenVolId) +'] which has already mounted the snaps in traditional way.'
SET		@o_ErrorCode	= 60364	/*	E_MM_SM_SP_LINK_VOL_MOUNT_MODE_INCOMPATIBLE	*/
	GOTO	PROC_FAILURE
END
---- Get all the MountVolume entries for the Vols sharing the Snaps which is to be mapped.
INSERT	INTO	#SMVSToMntPVM_LinkMVols
SELECT			MVOL.Id,
				MVOL.SMVolumeId,
				ISNULL(MVOL.MountJobId,		0	),
				ISNULL(MVOL.MountHostId,	0	),
				ISNULL(MVOL.MountStatus,	0	),
				ISNULL(MVOL.MountOptions,	N''	)
FROM			#SMVSToMntPVM_LinkVols TLV	LEFT OUTER JOIN SMMountVolume MVOL	(READUNCOMMITTED)	ON TLV.SMVolumeId = MVOL.SMVolumeId
---- Fail the mount Validation if any one of the linked MountVolumes is in Mounting / Unmounting state.
---- Refer to VSA V2 - Mount Unmount Validation excel sheet to get more insights
SET		@l_MountVolId =	(	SELECT TOP 1	TLMV.SMVolumeId
							FROM			#SMVSToMntPVM_LinkMVols	TLMV
WHERE			(	TLMV.MountStatus >=	40	/*	SM_VS_MNT_STARTED	*/	AND		TLMV.MountStatus <	58	/*	SM_VS_MNT_FAILED	*/	)
											OR
(	TLMV.MountStatus >=	60	/*	SM_VS_UMT_STARTED	*/	AND		TLMV.MountStatus <	78	/*	SM_VS_UMT_FAILED	*/	)
						)
IF		@l_MountVolId IS NOT NULL
BEGIN
		SET		@o_ErrorStr		= 'One or more linked volumes [' + CONVERT(VARCHAR(10), @l_MountVolId) + '] is being used by Jobs]'
SET		@o_ErrorCode	= 60207	/*	E_MM_SM_SB_VOL_OP_IN_PROCESS	*/
		GOTO	PROC_FAILURE
END
---- Set the Output values
INSERT	INTO	#SMVSToMntPVM_Ret
SELECT			TV.SMVolumeId, 0, 0, 0, ''
FROM			#SMVSToMntPVM_InVols TV
----------------------------------------------------- RETURN VALUES -------------------------------------------------------
PROC_SUCCESS:
	-- Get the return values
	SELECT	TR.MountVolumeId, TR.Flag, TR.SibVolumeId, @o_ErrorCode, @o_ErrorStr
	FROM	#SMVSToMntPVM_Ret TR
	GOTO PROC_END
PROC_FAILURE:
	-- Get the return values.
	SELECT 0, 0, 0, @o_ErrorCode, @o_ErrorStr
PROC_END:
	-- Cleanup the temp tables
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_InVols'		) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_InVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_InMVols'		) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_InMVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkSnaps'	) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_LinkSnaps
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkVols'	) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_LinkVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_LinkMVols'	) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_LinkMVols
	IF OBJECT_ID('tempdb.dbo.#SMVSToMntPVM_Ret'			) IS NOT NULL
		DROP TABLE #SMVSToMntPVM_Ret
	RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToMountPVM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountPVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountPVM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountPVM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToMountPVM',  '00010001000400030000', 'MM_SMVolSnapsToMountPVM', '00010001000400030000')
GO

