

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToMountMNM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToMountMNM.sp,v $ $Id: MM_SMVolSnapsToMountMNM.sp,v 1.1.2.9 2018/11/29 23:01:05 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToMountMNM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToMountMNM <<<'
	drop procedure MM_SMVolSnapsToMountMNM
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToMountMNM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountMNM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountMNM'
GO
print '... Creating Procedure: MM_SMVolSnapsToMountMNM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToMountMNM
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToMount
	/*
		<MM_SMVolSnapsToMount>
			<VolumeId></VolumeId>
			<JobId></JobId>
			<HostId></HostId>
			<MountFlags></MountFlags>
		</MM_SMVolSnapsToMount>
	*/
    /*
    Mount Validation for Multi-Host Mount
	Check whether the job is running or not (JMJobInfo.State = Running[1])
		If the job is not running, fail the validation
	Check whether the mount host id is valid (MMHost.ClientId) and online (MMHost.SoftState) and enabled (MMHost.Enabled) and also MMHost.OfflineReason = 0
		If the above conditions are not met, fail the validation
	Check whether volume is active or not ( SMVolume.PruneFlags = 1 )
		If Volume is not active, fail the validation
	Check whether volume's AFId is present in ArchFileCopy table and also whether its valid or not ( AFC.isValid = 1)
		If its not present or not valid, fail the validation
	Check in SMVolAction table whether the combo is present or not (Combo - SMVolumeId, HostId)
		If not, proceed further
		if present,
			Check SnapOpType and it should be Mount Op
				If different than Mount, fail the validation
				If its same, proceed further
    */
	DECLARE @x_JobId INTEGER = 0
	DECLARE @x_HostId INTEGER = 0
	DECLARE @x_MountFlags BIGINT = 0
	DECLARE @ErrorVolId INTEGER = 0
    DECLARE @ErrorJobId INTEGER = 0
    DECLARE @defaultCCId INT = 2
	DECLARE @ErrorSameVolJobHost INTEGER = 0
    DECLARE @tblVolIDs TABLE (SMVolumeId int)
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
    SET @ErrorCode = 0
    INSERT	INTO @tblVolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/VolumeId') R(ref)
    SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/HostId') R(ref)), 0)
	SET @x_MountFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/MountFlags') R(ref)), 0)
    DECLARE @tblSMVolume TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		CopyId integer,
		AppId integer,
		SourceClientId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		VolumeFlags bigint,
		EngineId integer,
		EngineCapabilities bigint
	)
    -- Check whether the input volume ids are in SMVolume table or not
    SET @ErrorVolId = (
          SELECT TOP 1 TVOL.SMVolumeId FROM @tblVolIDs TVOL LEFT OUTER JOIN SMVolume VOL (NOLOCK) ON TVOL.SMVolumeId = VOL.SMVolumeId
          WHERE  VOL.SMVolumeId IS NULL)
    IF @ErrorVolId IS NOT NULL
    BEGIN
SELECT 60335, 'One of input volumes [' + CONVERT(VARCHAR(10), @ErrorVolId) + '] not found in SMVolume.'
SET @ErrorCode = 60335
    GOTO CX_EXIT
    END
    INSERT INTO @tblSMVolume
	SELECT	TVOL.SMVolumeId,
			isnull(VOL.ArchFileId, 0),
			isnull(VOL.CommCellId, 0),
			isnull(VOL.JobId, 0),
			isnull(VOL.CopyId, 0),
			isnull(VOL.AppId, 0),
			isnull(VOL.SourceClientId, 0),
			ISNULL(VOL.RecoveryPointId, 0),
			isnull(VOL.PruneFlags, 0),
			isnull(VOL.MountHostId, 0),
			isnull(VOL.MountStatus, 0),
			isnull(VOL.VolumeFlags, 0),
			isnull(SNAP.SnapShotEngineId, 0),
			isnull(ENGINE.Capabilities, 0)
	FROM	@tblVolIDs AS TVOL INNER JOIN SMVolume AS VOL (NOLOCK) ON TVOL.SMVolumeID = VOL.SMVolumeID
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TVOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMSnapShotEngine ENGINE (NOLOCK) ON SNAP.SnapShotEngineId = ENGINE.SnapShotEngineId
    -----------------------------------------------------------------------------
	-- First check whether the snap engine is VMware Multi-Node Mount Capable or not
	-----------------------------------------------------------------------------
IF	((@x_MountFlags & 268435456) = 268435456 /*VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB*/)
		AND EXISTS (SELECT * FROM @tblSMVolume WHERE
EngineCapabilities & 67108864 /*SM_SNAPSHOT_ENGINE_CAPABILITY_ALLOW_MULTI_NODE_MOUNT_VMWARE*/ = 0)
	BEGIN
		DECLARE @engineId INT = 0
DECLARE @engineName NVARCHAR(128) = N''
SELECT @engineId = EngineId FROM @tblSMVolume WHERE EngineCapabilities & 67108864 /*SM_SNAPSHOT_ENGINE_CAPABILITY_ALLOW_MULTI_NODE_MOUNT_VMWARE*/ = 0
		SELECT @engineName = SnapEngineName FROM SMSnapShotEngine (NOLOCK) WHERE SnapShotEngineId = @engineId
SELECT 60340 /*E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT*/, 'Engine[' + @engineName + '(' + Convert(varchar(10), @engineId) + ')] is not Multi-Node Mount capable. Skipping to single-node mount'
SET @ErrorCode = 60340 /*E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT*/
        GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Check whether the job is Valid or Not.
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (SELECT * FROM JMJobInfo WITH(NOLOCK) WHERE JobId = @x_JobId AND commCellId = @defaultCCId)
	BEGIN
SELECT 60336, 'Job is not valid. JobId [' + Convert(varchar(10), @x_JobId) + ']'
SET @ErrorCode = 60336
        GOTO CX_EXIT
	END
    -----------------------------------------------------------------------------
	--	If the job is not running, running or not (JMJobInfo.State = Running[1]/*CVJobState::RUNNING*/)
	-----------------------------------------------------------------------------
    IF @x_JobId > 0 AND NOT EXISTS ( SELECT * FROM JMJobInfo WITH(NOLOCK) WHERE JobId = @x_JobId AND commCellId = @defaultCCId AND JMJobInfo.State = 1 /*CVJobState::RUNNING*/)
	BEGIN
SELECT 60203, 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']'
SET @ErrorCode = 60203
        GOTO CX_EXIT
	END
IF  @x_JobId = @JOBID_NA AND @x_MountFlags & 32 <> 32
    BEGIN
SELECT 60336, 'Job is not valid. JobId [' + Convert(varchar(10), @x_JobId) + ']'
SET @ErrorCode = 60336
        GOTO CX_EXIT
	END
	------------------------------------------
	-- Get correct mount host for Dev snap ---
	------------------------------------------
	DECLARE @bIsSnapCenterSC INT = 0
	SELECT	@bIsSnapCenterSC = attrVal
	FROM	APP_SubclientProp PROP (READUNCOMMITTED)
	WHERE	attrName = 'Snap Center Subclient' AND modified = 0
			AND componentNameId = (SELECT TOP 1 AppId FROM @tblSMVolume)
	IF (@bIsSnapCenterSC = 1)
	BEGIN
		SET @x_HostId = (SELECT TOP 1 SourceClientId FROM @tblSMVolume)
	END
    -----------------------------------------------------------------------------
    -- Validate Mount Host
    -----------------------------------------------------------------------------
    DECLARE @HostName NVARCHAR(1024) = N''
    SET @HostName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @x_HostId)
    IF @HostName IS NULL OR @HostName = N''
    BEGIN
SELECT 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].'
SET @ErrorCode = 60204
        GOTO CX_EXIT
    END
    DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT, OfflineReason INT)
    INSERT	INTO @tblMMHost
    SELECT	MmHostEnabled, MMHostSoftState , OfflineReason
    FROM	MMHost WITH (NOLOCK)
    WHERE 	ClientId = @x_HostId
    -----------------------------------------------------------------------------
    -- MediaAgent not installed
    -----------------------------------------------------------------------------
    IF NOT EXISTS (SELECT * FROM @tblMMHost)
    BEGIN
SELECT 60912, 'MediaAgent not installed on host [' + @HostName + '].'
SET @ErrorCode = 60912
        GOTO CX_EXIT
    END
    -----------------------------------------------------------------------------
    -- Media Agent not enabled
    -----------------------------------------------------------------------------
    IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
    BEGIN
SELECT 383, 'MediaAgent on host [' + @HostName + '] is not enabled.'
SET @ErrorCode = 383
        GOTO CX_EXIT
    END
    -----------------------------------------------------------------------------
    -- Media Agent Not accessible
    -----------------------------------------------------------------------------
    IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
    BEGIN
SELECT 357, 'MediaAgent on host [' + @HostName + '] is not accessable.'
SET @ErrorCode = 357
        GOTO CX_EXIT
    END
    -----------------------------------------------------------------------------
    -- Media Agent Offline
    -----------------------------------------------------------------------------
    IF EXISTS (SELECT * FROM @tblMMHost WHERE OfflineReason != 0)
    BEGIN
SELECT 357, 'MediaAgent on host [' + @HostName + '] is offline for some reason.'
SET @ErrorCode = 357
        GOTO CX_EXIT
    END
    -----------------------------------------------------------------------------
	-- Check if volume is Active or Aged
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume WHERE PruneFlags != 1)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 60341, 'One or more volumes are not valid or aged. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60341
        GOTO CX_EXIT
	END
    -----------------------------------------------------------------------------
	-- Volume not exists in DB
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume WHERE ArchFileId = 0)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 60210, 'One or more volumes are missing from database. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60210
        GOTO CX_EXIT
	END
    -----------------------------------------------------------------------------
	-- ArchFileId is valid or not.
	-----------------------------------------------------------------------------
	SET @ErrorVolId = ( SELECT TOP 1 a.SMVolumeId FROM @tblSMVolume a
						WHERE NOT EXISTS (
										SELECT * FROM archFileCopy b (NOLOCK)
										WHERE	a.ArchFileId = b.archFileId
												AND a.CopyId = b.archCopyId
												AND a.CommCellId = b.commCellId
												AND b.isValid = 1))
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 60216, 'One or more volumes have invalid or no archive file. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60216
        GOTO CX_EXIT
	END
    -----------------------------------------------------------------------------
    -- Check For Same VolumeId  JobId and HostId present in SMVolAction
    --MM_SM_OPTYPE_MOUNT_SNAP =2
    -- ****IMPORTANT****
    -- Here the SnapOpType check is > Mount - the reason is - OPType 1 is delete and if the snap volume is aged, we are
    -- no expecting to come this far based on the above checks for validity of snap volume
    -----------------------------------------------------------------------------
    SET @ErrorJobId = (SELECT     TOP 1 VOLACT.JobId
                         FROM   @tblSMVolume TVOL INNER JOIN SMVolAction VOLACT (NOLOCK) ON TVOL.SMVolumeId = VOLACT.SMVolumeId AND VOLACT.HostId = @x_HostId
                         WHERE  VOLACT.SnapOpType > 2 /*MM_SM_OPTYPE_MOUNT_SNAP*/ )
    IF @ErrorJobId IS NOT NULL
        BEGIN
SELECT 60334, ' There is an already job [' + Convert(varchar(10), @ErrorJobId) + '] doing another operation(non-mount) on same host[' + @HostName + '].'
SET @ErrorCode = 60334
        GOTO CX_EXIT
    END
    -----------------------------------------------------------------------------
    -- For same SMVolumeId and Diff Job ID failed it if other job having in middle of mounting. let them go.
    -- For same Volume should NOT be allowed to be mounted by different jobs when the volume is being mounted
	-----------------------------------------------------------------------------
    SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId
						FROM SMSnapResource a WITH (NOLOCK), @tblSMVolume b
WHERE a.SMVolumeId = b.SMVolumeId and (b.MountStatus > 39 AND b.MountStatus < 59) and a.JobId <> @x_JobId)
	IF @ErrorVolId IS NOT null
	BEGIN
SELECT 60207, ' Same volume is alredy reserved by other job for mounting. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60207
        GOTO CX_EXIT
	END
    -----------------------------------------------------------------------------
	--  For same SMVolumeId , and same Job Id and Mount Status is More then Unmount (REVERT OR DELETE) then fail the job
	-----------------------------------------------------------------------------
    SET @ErrorVolId = (
                 SELECT TOP 1 SMVolumeId
                 FROM   @tblSMVolume
WHERE  MountStatus > 79		AND
MountStatus NOT IN (89)		)
    IF @ErrorVolId IS NOT null
    BEGIN
SELECT 60337, 'Operation in progress on one or more reserved volumes and cannot be mounted again. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
SET @ErrorCode = 60337
        GOTO CX_EXIT
    END
CX_EXIT:
	RETURN @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToMountMNM')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMountMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMountMNM')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMountMNM'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToMountMNM',  '00010001000200090000', 'MM_SMVolSnapsToMountMNM', '00010001000200090000')
GO

