

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToMount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToMount.sp,v $ $Id: MM_SMVolSnapsToMount.sp,v 1.21.2.15 2020/09/30 22:01:46 bbrindavan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToMount')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToMount <<<'
	drop procedure MM_SMVolSnapsToMount
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToMount')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMount')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMount'
GO
print '... Creating Procedure: MM_SMVolSnapsToMount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToMount
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_MountPath NVARCHAR(1024)
  DECLARE @o_MountMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @defaultCCId INT = 2
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToMount
	/*
		<MM_SMVolSnapsToMount>
			<VolumeId></VolumeId>
			<JobId></JobId>
			<HostId></HostId>
			<MountFlags></MountFlags>
		</MM_SMVolSnapsToMount>
	*/
	DECLARE @tblReturn  TABLE (
			SMVolumeId integer,
MountPath	NVARCHAR(1024),
			MountMode	integer DEFAULT 0
		)
	DECLARE @tblVolIDs TABLE (SMVolumeId int)
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_MountFlags BIGINT
	DECLARE @x_SnapResFlags INTEGER
	DECLARE @x_MountMode INTEGER
	-- GUI Job
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	INSERT	INTO @tblVolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/VolumeId') R(ref)
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/HostId') R(ref)), 0)
	SET @x_MountFlags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/MountFlags') R(ref)), 0)
	SET @x_SnapResFlags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/SnapReservationFlags') R(ref)), 0)
	SET @x_MountMode = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToMount/MountMode') R(ref)), 0)
    DECLARE @tblRtnSP TABLE (errorCode integer, errorStr varchar(max))
    DECLARE @retVal INT = 0
	---------------------------------------------------------------------------------
	-- If the flag is set for Test Clones, call the SP for Test Clones validations  -
	---------------------------------------------------------------------------------
IF	@x_MountFlags & 2048 = 2048 /*VOLSNAP_ACTIONFLAGS_TEST_CLONE_ENV*/
	BEGIN
		INSERT INTO @tblRtnSP
		EXEC @retVal = MM_SMVolSnapsToMountTestEnv @i_xmlTextInput,0 ,''
		IF @retVal <> 0
		BEGIN
SET @ErrorCode = ISNULL((SELECT errorCode FROM @tblRtnSP), 60331)
			SET @ErrorStr = ISNULL((SELECT errorStr FROM @tblRtnSP), 'Test Clone validation failed')
			SELECT 0, '', 0, @ErrorCode, @ErrorStr, 0, 0
			RETURN
		END
		INSERT INTO @tblReturn
		SELECT	0, '', 0
		GOTO CX_EXIT
	END
    ---------------------------------------------------------------------------------
	-- If the flag is set for Multi Node Mount, call the SP for Multi Node Mount validations  -
	---------------------------------------------------------------------------------
IF	((@x_MountFlags & 268435456) = 268435456 /*VOLSNAP_ACTIONFLAGS_MULTI_NODE_MOUNT_DB*/)
OR ((@x_MountFlags & 1073741824) = 1073741824 /*VOLSNAP_ACTIONFLAGS_SCSI_SERVER_OP_DB*/)
		-- Route no ESX DS mount also to the multi-node mount validation
OR ((@x_MountMode & 4) = 4)
	BEGIN
		INSERT INTO @tblRtnSP
		EXEC @retVal = MM_SMVolSnapsToMountMNM @i_xmlTextInput,0 ,''
		-- Successful return from MNM validation
		IF @retVal = 0
		BEGIN
			INSERT INTO @tblReturn
			SELECT	0, '', 0
			GOTO CX_EXIT
		END
ELSE IF @retVal <> 60340 /*E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT*/
		BEGIN
SET @ErrorCode = ISNULL((SELECT errorCode FROM @tblRtnSP), 60338)
			SET @ErrorStr = ISNULL((SELECT errorStr FROM @tblRtnSP), 'MultiNode Mount Validation failed')
			SELECT 0, '', 0, @ErrorCode, @ErrorStr, 0, 0
			RETURN
		END
		-- Continue for single-node validation on /*E_MM_SM_SP_MULTINODE_MNT_ENGINE_NOT_SUPPORT*/
		-- ELSE / DEFAULT case
	END
	DECLARE @tblSMVolume TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		CopyId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		VolumeFlags bigint,
		MasterJobId integer,
		AppTypeId integer
	)
	DECLARE @tblSCGVols  TABLE (
		SMVolumeId integer,
		JobId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		MountPath	NVARCHAR(1024),
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	DECLARE @tblSCGVolSnaps  TABLE (
		SMSnapId integer,
		SMVolumeId integer,
		JobId integer,
		RecoveryPointId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		MountPath	NVARCHAR(1024),
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	INSERT INTO @tblSMVolume
	SELECT	a.SMVolumeId,
			isnull(b.ArchFileId, 0),
			isnull(b.CommCellId, 0),
			isnull(b.JobId, 0),
			isnull(b.CopyId, 0),
			ISNULL(b.RecoveryPointId, 0),
			isnull(b.PruneFlags, 0),
			isnull(b.MountHostId, 0),
			isnull(b.MountStatus, 0),
			isnull(b.VolumeFlags, 0),
			isnull(b.MasterJobId,0),
			isnull(b.AppTypeId, 0)
	FROM @tblVolIDs as a left outer join SMVolume as b WITH (NOLOCK)
	ON a.SMVolumeID = b.SMVolumeID
	-----------------------------------------------------------------------------
	-- Get all the volumes within SCG -- Use RecoveryPointId as SCG id
	-----------------------------------------------------------------------------
	INSERT	INTO @tblSCGVols
	SELECT	A.SMVolumeId, A.JobId, A.RecoveryPointId, A.PruneFlags, A.MountHostId, A.MountStatus,A.MountPath, A.SourcePath, A.SourceGUID
	FROM	SMVolume A WITH (NOLOCK), ArchFile B WITH (NOLOCK)
	WHERE	A.ArchFileId = B.id AND A.CommCellId = B.CommCellId AND B.isValid = 1
	AND		A.RecoveryPointId in (SELECT DISTINCT RecoveryPointId FROM @tblSMVolume WHERE RecoveryPointId > 0)
AND A.AppTypeId = 22
AND (A.VolumeFlags & 8192 = 8192)
	INSERT INTO @tblSCGVolSnaps
	SELECT A.SMSnapId, B.*
	FROM SMVolSnapMap A WITH (NOLOCK), @tblSCGVols B
	WHERE A.SMVolumeId = B.SMVolumeId
	-----------------------------------------------------------------------------
	-- Unknown volume
	-----------------------------------------------------------------------------
	-- Volume not exists in DB
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume WHERE ArchFileId = 0)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 0, '', 0, 60210, 'One or more volumes are missing from database. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volume is not active
	-----------------------------------------------------------------------------
	DECLARE @appType INT = 0
	SET @appType = (SELECT TOP 1 VOL.AppTypeId FROM @tblSMVolume TEMP, SMVolume VOL (NOLOCK) WHERE TEMP.SMVolumeId = VOL.SMVolumeId)
IF NOT ( @appType = 13 AND EXISTS (SELECT jobid FROM JMAdminJobInfoTable WHERE jobid = @x_JobId AND opType = 13 /*AUXCOPY*/)  )
	BEGIN
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE PruneFlags <> 1)
		IF @ErrorVolId IS NOT NULL
		BEGIN
SELECT 0, '', 0, 60202, 'One or more snapshots required for the job no longer exist on the array, and appear to have been manually deleted or automatically removed as part of array cleanup thresholds. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
	END
	-----------------------------------------------------------------------------
	-- Invalid ArchFile Id
	-- AND ( Child VSA Job OR FS\DB\NAS app  OR VSA V1 )
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId FROM @tblSMVolume a
						WHERE 	NOT EXISTS
								(
									SELECT 1 FROM ArchFileCopy b WITH (NOLOCK)
									WHERE a.ArchFileId = b.ArchFileId
									AND a.CommCellId = b.CommCellId
									AND b.ArchCopyId = a.CopyId
									-- we dont want to have mounts going for invalid afiles
									AND b.isValid = 1
								)
								AND
								( 	a.JobId != a.MasterJobId 						/*Child JOB*/
OR a.AppTypeId !=  106 /*CV_APPTYPE_VIRTUAL_SERVER*/ 	/* NON VSA WHEN AWS comes we need to change this*/
OR A.VolumeFlags & CAST(4294967296 AS BIGINT) = 0  	/* NOT (VSA V2 CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB)  */
								)
						)
	IF @ErrorVolId IS NOT NULL
	BEGIN
SELECT 0, '', 0, 60216, 'One or more volumes have no archive file. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (SELECT * FROM JMJobInfo WITH(NOLOCK) WHERE JobId = @x_JobId AND commCellId = @defaultCCId)
	BEGIN
SELECT 0, '', 0, 60203, 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']', 0, 0
		RETURN
	END
    -----------------------------------------------------------------------------
    -- VSA app-aware exclusive mount of parent through live browse of child
    -----------------------------------------------------------------------------
/* When the current operation is a parent VSA snap mount through a child live browse (with snap resource flag - 256),
	if another reservation exists for the parent, the current operation should not be allowed */
IF EXISTS (SELECT 1 FROM @tblSMVolume WHERE VolumeFlags & 262144 = 262144)
	BEGIN
IF @x_SnapResFlags & 256 = 256
		BEGIN
    		SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId FROM @tblSMVolume a INNER JOIN SMSnapResource b (NOLOCK)
									ON	a.SMVolumeId = b.SMVolumeId
AND a.VolumeFlags & 262144 = 262144)
    		IF @ErrorVolId IS NOT null
    		BEGIN
SELECT 0, '', 0, 60207, 'One or more app aware VSA volumes have been reserved and cannot be exclusively used for this operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    			RETURN
    		END
		END
		ELSE
/* For a mount operation of the VSA parent snap, if another reservation exists for the parent with the 256 flag,
		the current operation should not be allowed */
		BEGIN
    		SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId FROM @tblSMVolume a INNER JOIN SMSnapResource b (NOLOCK)
									ON	a.SMVolumeId = b.SMVolumeId
AND a.VolumeFlags & 262144 = 262144
AND b.Flags & 256 = 256)
    		IF @ErrorVolId IS NOT null
    		BEGIN
SELECT 0, '', 0, 60207, 'One or more app aware VSA volumes have been exclusively reserved and cannot be mounted again. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    			RETURN
    		END
		END
	END
	-----------------------------------------------------------------------------
	-- Do not allow GUI mount if volumes are reserved
	-----------------------------------------------------------------------------
IF	@x_JobId = @JOBID_NA AND @x_MountFlags & 32 <> 32
	BEGIN
		SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId
							FROM SMSnapResource a WITH (NOLOCK), @tblSMVolume b
WHERE a.SMVolumeId = b.SMVolumeId AND a.Flags & 128 <> 128)
		IF @ErrorVolId IS NOT NULL
		BEGIN
SELECT 0, '', 0, 60214, 'One or more volumes are reserved already and cannot be mounted again by GUI. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
	END
	-----------------------------------------------------------------------------
	-- Do not allow mount for already reserved and not yet started to mount volumes
	-----------------------------------------------------------------------------
	-- Especially in case of Live-Browse Mount & Job Mount with Live-Browse reserved the volume
	-- and MountStatus still being SM_VS_UMT_UNMOUNTED and not updated
	-- For VMware
	IF EXISTS(SELECT	TV.* FROM @tblSMVolume TV INNER JOIN SMVolume VOL (NOLOCK) ON TV.SMVolumeId = VOL.SMVolumeId
WHERE	VOL.AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/)
		SET @ErrorVolId = (SELECT	TOP 1 a.SMVolumeId
							FROM	SMSnapResource a WITH (NOLOCK), @tblSMVolume b, SMVolume c (NOLOCK)
WHERE	a.SMVolumeId = b.SMVolumeId AND a.JobId <> @x_JobId AND b.MountStatus NOT IN (39 /*SM_VS_CRT_CREATED*/, 59 /*SM_VS_MNT_MOUNTED*/, 79 /*SM_VS_UMT_UNMOUNTED*/, 89 /*SM_VS_RVT_REVERTED*/)
AND b.SMVolumeId = c.SMVolumeId AND c.AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/)
	ELSE
	SET @ErrorVolId = (SELECT TOP 1 a.SMVolumeId
						FROM SMSnapResource a WITH (NOLOCK), @tblSMVolume b
WHERE a.SMVolumeId = b.SMVolumeId AND a.JobId <> @x_JobId AND b.MountStatus NOT IN (59 /*SM_VS_MNT_MOUNTED*/))
	IF @ErrorVolId IS NOT null
	BEGIN
SELECT 0, '', 0, 60207, 'Operation in progress on one or more reserved volumes and cannot be mounted again. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
		RETURN
	END
	-- Do not allow mount for volumes already reserved by the same job and in the process of mounting
	-- [ Bijai : Relaxing validation here for AWS hot-add mount when direct read mount is present
	--    Direct-Read : MNM + SNAP_IN_USE_LOCK
	--    Hot-Add : Normal mount ]
	-------------------------------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT	TOP 1 a.SMVolumeId
						FROM	SMSnapResource a WITH (NOLOCK), @tblSMVolume b, SMVolume c (NOLOCK),SMVolSnapMap map (NOLOCK), SMSnap snap (NOLOCK)
						WHERE	a.SMVolumeId = b.SMVolumeId
								AND a.SMVolumeId = c.SMVolumeId
								AND map.SMVolumeId=a.SMVolumeId
								and snap.SMSnapId=map.SMSnapId
AND b.MountStatus NOT IN (59 /*SM_VS_MNT_MOUNTED*/)
AND c.AppTypeId = 106
AND NOT ( (a.Flags & 128 = 128)/*SNAPRES_FLAGS_VOLSNAP_SNAP_IN_USE_LOCK */
AND snap.SnapShotEngineId = 60))/*SM_SNAPSHOT_ENGINE_AMAZON_AWS*/
	IF @ErrorVolId IS NOT null
	BEGIN
SELECT 0, '', 0, 60207, 'Snap Volume [' + Convert(varchar(10), @ErrorVolId) + '] is being either mounted or unmounted. Please wait until completion of the current operation.', 0, 0
		RETURN
	END
IF @x_MountFlags & 128 = 128
	BEGIN
		-----------------------------------------------------------------------------
		-- Volumes are in the middle of being reverted or deleted
		-----------------------------------------------------------------------------
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE MountStatus > 79
AND MountStatus <> 89)
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being processed by other operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
		-----------------------------------------------------------------------------
		-- Volumes are being held by other operation from different job
		-- Allow mount if mount request has been added to SMVolAction for the same job
		-- SnapOpType MM_SM_OPTYPE_MOUNT_SNAP = 2
		-----------------------------------------------------------------------------
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
							WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
								WHERE JobId != @x_JobId AND SnapOpType IN (1, 4)))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60212, 'One or more volumes are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
	END
	ELSE
	BEGIN
	  	-----------------------------------------------------------------------------
	    -- Unknown mount host
	    -----------------------------------------------------------------------------
	   	DECLARE @HostName NVARCHAR(1024) = N''
	   	SET @HostName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @x_HostId)
	   	IF @HostName IS NULL OR @HostName = N''
	   	BEGIN
SELECT 0, '', 0, 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].', 0, 0
	   		RETURN
	   	END
		DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT)
		INSERT	INTO @tblMMHost
		SELECT	MmHostEnabled, MMHostSoftState
		FROM	MMHost WITH (NOLOCK)
		WHERE 	ClientId = @x_HostId
	   	-----------------------------------------------------------------------------
	   	-- MediaAgent not installed
	   	-----------------------------------------------------------------------------
	   	IF NOT EXISTS (SELECT * FROM @tblMMHost)
	   	BEGIN
SELECT 0, '', 0, 60912, 'MediaAgent not installed on host [' + @HostName + '].', 0, 0
	   		RETURN
	   	END
	   	-----------------------------------------------------------------------------
	   	-- Media Agent not enabled
	   	-----------------------------------------------------------------------------
	   	IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
		BEGIN
SELECT 0, '', 0, 383, 'MediaAgent on host [' + @HostName + '] is not enabled.', 0, 0
	   		RETURN
	   	END
	   	-----------------------------------------------------------------------------
	   	-- Media Agent Offline
	   	-----------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
		BEGIN
SELECT 0, '', 0, 357, 'MediaAgent on host [' + @HostName + '] is offline.', 0, 0
	   		RETURN
	   	END
    	-----------------------------------------------------------------------------
    	-- Volumes are in mounting state for live browse
    	-----------------------------------------------------------------------------
IF @x_MountFlags & 32 = 32
    	BEGIN
    		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE MountStatus > 39 AND MountStatus < 58)
    		IF @ErrorVolId IS NOT null
    		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being mounted. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    			RETURN
    		END
    	END
    	-----------------------------------------------------------------------------
    	-- Volumes are in mounting state but not by the same job
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE MountStatus > 39 AND MountStatus < 59
    						AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource WITH (NOLOCK) WHERE JobId = @x_JobId))
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being mounted by other job. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
		SET @ErrorVolId =
			(SELECT TOP 1 SMVolumeId
			FROM @tblSCGVols
WHERE MountStatus > 39 AND MountStatus < 59
			AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource WITH (NOLOCK) WHERE JobId = @x_JobId))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes in SCG are being mounted by other job. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Volumes are in the middle of being unmounted, reverted or deleted
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
WHERE MountStatus > 59
AND MountStatus NOT IN (79, 89))
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being processed by other operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
		SET @ErrorVolId =
			(SELECT TOP 1 SMVolumeId
			FROM @tblSCGVols
WHERE MountStatus > 59 AND MountStatus NOT IN (79, 89))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes in SCG are being processed by other operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Volumes are being held by other operation from different job
    	-- Allow mount if mount request has been added to SMVolAction for the same job
    	-- SnapOpType MM_SM_OPTYPE_MOUNT_SNAP = 2
    	-----------------------------------------------------------------------------
    	-- SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
    	-- 					WHERE SMVolumeId IN
    	-- 							(SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK))
    	-- 					AND SMVolumeId NOT IN
    	-- 							(SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    	-- 							WHERE JobId = @x_JobId AND SnapOpType = 2))
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
    						WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    							WHERE JobId != @x_JobId AND SnapOpType != 2))
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60212, 'One or more volumes are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
		SET @ErrorVolId =
			(SELECT TOP 1 SMVolumeId
			FROM @tblSCGVols
			WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    							WHERE JobId != @x_JobId AND SnapOpType = 2))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes in SCG are being mounted simultaneously. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
		SET @ErrorVolId =
			(SELECT TOP 1 SMVolumeId
			FROM @tblSCGVols
			WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    							WHERE JobId != @x_JobId AND SnapOpType NOT IN (4, 7)))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60212, 'One or more volumes in SCG are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Volumes are being mounted to a different host
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume
    						WHERE MountHostId > 0 AND MountHostId <> @x_HostId)
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60205, 'One or more volumes are mounted to a different host. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
		SET @ErrorVolId =
			(SELECT TOP 1 SMVolumeId
			FROM @tblSCGVols
			WHERE MountHostId > 0 AND MountHostId <> @x_HostId)
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60205, 'One or more volumes in SCG are mounted to a different host. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Native Snaps being mounted on a different host
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 VOL.SMVolumeId FROM @tblSMVolume TVOL, SMVolume VOL WITH (NOLOCK), SMSnap SNAP WITH (NOLOCK), SMVolSnapMap MAP WITH (NOLOCK)
    						WHERE VOL.SMVolumeId = TVOL.SMVolumeId AND
    							MAP.SMVolumeId = VOL.SMVolumeId AND
    							SNAP.SMSnapId = MAP.SMSnapId AND
SNAP.SnapShotEngineId = 1 AND
    							@x_HostId <> VOL.SourceClientId)
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60205, 'Native Snaps being mounted on non-source hosts. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
	END
	-----------------------------------------------------------------------------
	-- Get linked snaps and volumes
	-----------------------------------------------------------------------------
	DECLARE @tblLinkedSnaps TABLE ( SMSnapId integer, SnapShotEngineId integer )
	DECLARE @tblLinkedVols  TABLE ( SMVolumeId integer, MountHostId integer, MountStatus integer)
	-- Get all the snaps of given volumes
	INSERT INTO @tblLinkedSnaps
	SELECT DISTINCT c.SMSnapId, c.SnapShotEngineId
	FROM @tblSMVolume a, SMVolSnapMap b WITH (NOLOCK), SMSnap c WITH (NOLOCK)
	WHERE a.SMVolumeId = b.SMVolumeId AND b.SMSnapId = c.SMSnapId
	-- Get all the volumes share snaps with given volumes
	INSERT INTO @tblLinkedVols
	SELECT DISTINCT a.SMVolumeId, 0, 0
	FROM SMVolSnapMap a WITH (NOLOCK), @tblLinkedSnaps b
	WHERE a.SMSnapId = b.SMSnapId
	AND a.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
	-- Update mount status for all linked volumes
	UPDATE @tblLinkedVols
	SET MountHostId = B.MountHostId, MountStatus = B.MountStatus
	FROM @tblLinkedVols A, SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	-----------------------------------------------------------------------------
	-- Linked CDR volumes are not fully selected
	-----------------------------------------------------------------------------
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
						WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
						AND EXISTS (SELECT * FROM @tblLinkedSnaps
WHERE SnapShotEngineId IN (11, 10)))
	IF @ErrorVolId IS NOT NULL
	BEGIN
		SELECT 0, '', 0, -1, 'One or more linked CDR volumes are not being selected for mount. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
		RETURN
	END
IF @x_MountFlags & 128 = 128
	BEGIN
		-----------------------------------------------------------------------------
		-- Question: Do we care linked volumes being mounted, unmounted or deleted?
		-----------------------------------------------------------------------------
		-----------------------------------------------------------------------------
		-- Linked Volumes are in the middle of being reverted or deleted
		-----------------------------------------------------------------------------
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
WHERE MountStatus > 79
AND MountStatus <> 89)
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being processed by other operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
	END
	ELSE
	BEGIN
    	-----------------------------------------------------------------------------
    	-- Linked volumes are being mounted to a different host
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
    				WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
    				-- The Above condition can be removed, as its already being used in getting linked volumes
    				AND MountHostId > 0 AND MountHostId <> @x_HostId )
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60206, 'One or more linked volumes are being mounted to a different host. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Question: Do we care linked volumes being mounted, unmounted or deleted?
    	-----------------------------------------------------------------------------
    	-----------------------------------------------------------------------------
    	-- Linked Volumes are in the middle of being unmounted, reverted or deleted
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
WHERE MountStatus > 59
AND MountStatus NOT IN (79, 89))
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60207, 'One or more volumes are being processed by other operation. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
    	END
    	-----------------------------------------------------------------------------
    	-- Linked Volumes are being held by other operation from different job
    	-- Allow mount if mount request has been added to SMVolAction for the same job
    	-- SnapOpType MM_SM_OPTYPE_MOUNT_SNAP = 2
    	-----------------------------------------------------------------------------
    	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblLinkedVols
    						WHERE SMVolumeId IN
    								(SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK))
    						AND SMVolumeId NOT IN
    								(SELECT SMVolumeId FROM SMVolAction WITH (NOLOCK)
    								WHERE SnapOpType = 2))
    	IF @ErrorVolId IS NOT NULL
    	BEGIN
SELECT 0, '', 0, 60212, 'One or more volumes are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
    		RETURN
		END
	END
	-----------------------------------------------------------------------------
	-- VSA AppAware -
	-----------------------------------------------------------------------------
	--	Child Mount Validation
	---------------------------
	-- Existing Mount Validation for child should be ok
	-- First check whether its VSA App-Aware Child or not
	-- If so, find the parent and check whether its already mounted (mounting, unmounting, etc.)
	-- If the parent is in mnt/umnt -ing state, fail the current child mount
	-- If the parent is in mounted state, check for the different mount host
	DECLARE @tblAppAwareLinkedVols TABLE (
			ChildVolumeId integer,
			ParentVolumeId integer,
			ParentVolMountHostId integer,
			ParentVolMountStatus integer
		)
	 	INSERT	INTO @tblAppAwareLinkedVols
		SELECT  V.SMVolumeId,
				B.SMVolumeId,
				B.MountHostId,
				B.MountStatus
		FROM	@tblSMVolume V INNER JOIN JMVSAAppJobLink JOBLINK (NOLOCK) ON JOBLINK.childJobId = V.JobId
				INNER JOIN SMVOLUME B (NOLOCK) ON B.JobId = JOBLINK.parentJobId	AND V.CopyId = B.CopyId
WHERE	V.VolumeFlags & 131072 = 131072
AND B.VolumeFlags & 262144 = 262144 -- Optional safe check
		SET @ErrorVolId = (SELECT	TOP 1 A.SMVolumeId
								FROM	@tblSMVolume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ChildVolumeId
WHERE B.ParentVolMountHostId = @x_HostId AND B.ParentVolMountStatus <> 59)
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60207, 'VSA-AppAware.Operation in progress for Parent volumes.Child VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
		SET @ErrorVolId = (SELECT	TOP 1 A.SMVolumeId
							FROM	@tblSMVolume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ChildVolumeId
							WHERE	(B.ParentVolMountHostId > 0 AND B.ParentVolMountHostId <> @x_HostId ))
		IF @ErrorVolId IS NOT null
		BEGIN
SELECT 0, '', 0, 60206, 'VSA-AppAware.Parent volume is mounted to a different host. Child VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
			RETURN
		END
		--RDBG - The following validation is a regular validation, it is redundant so remove it
		--- Parent Mount Validation
		-- Different Mount Host Check
		---------------------------
		--SET @ErrorVolId =   (SELECT A.SMVolumeId
		--					FROM	@tblSMVolume A INNER JOIN SMVOlume B ON A.SMVolumeId = B.SMVolumeId
		--					WHERE	A.VolumeFlags & CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB = CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB
		--					AND B.MountHostId > 0 AND B.MountHostId <> @x_HostId)
		--IF @ErrorVolId IS NOT null
		--BEGIN
		--	SELECT 0, '', 0, E_MM_SM_SB_SNAP_MNT_DIFF_HOST, 'VSA-AppAware.Volume is mounted to a different host. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']', 0, 0
		--	RETURN
		--END
	-----------------------------------------------------------------------------
	-- Return for mount operation
	-----------------------------------------------------------------------------
	INSERT INTO @tblReturn
SELECT	DISTINCT A.SMVolumeId, B.MountPath, 32
	FROM 	@tblSCGVolSnaps A, @tblSCGVolSnaps B
	WHERE 	A.SMSnapId = B.SMSnapId AND A.SourcePath = B.SourcePath AND A.SourceGUID = B.SourceGUID
			AND A.SMVolumeId IN (SELECT SMVolumeId FROM @tblSMVolume)
AND A.MountStatus <> 59
AND B.MountStatus = 59
	INSERT	INTO @tblReturn
	SELECT	DISTINCT a.SMVolumeId, b.MountPath, 0
	FROM	@tblSMVolume a, SMVolume b WITH (NOLOCK)
	WHERE	a.SMVolumeId = b.SMVolumeId
			AND a.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblReturn)
	-----------------------------------------------------------------------------
	-- Get metadata referenced to volume and snap
	-----------------------------------------------------------------------------
	-- INSERT INTO @tblReturn
	-- SELECT	DISTINCT 0, a.SMVolumeId, 0, b.MetaDataId
	-- FROM	@tblSMVolume a, SMMetaData b WITH (NOLOCK)
	-- WHERE	b.RefType = SM_MRT_VOLUME
	-- AND		a.SMVolumeId = b.RefId
	-- INSERT INTO @tblReturn
	-- SELECT	DISTINCT 0, 0, a.SMSnapId, b.MetaDataId
	-- FROM	@tblReturn a, SMMetaData b WITH (NOLOCK)
	-- WHERE	b.RefType = SM_MRT_SNAP
	-- AND		a.SMSnapId = b.RefId
CX_EXIT:
	SELECT *, @ErrorCode, @ErrorStr, 0, 0
	FROM @tblReturn
	ORDER BY SMVolumeId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToMount')
	delete from GxQscripts where name = 'MM_SMVolSnapsToMount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToMount')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToMount'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToMount',  '00010021000200150000', 'MM_SMVolSnapsToMount', '00010021000200150000')
GO

