

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsToDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsToDelete.sp,v $ $Id: MM_SMVolSnapsToDelete.sp,v 1.40.2.22 2020/10/08 07:30:00 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsToDelete')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMVolSnapsToDelete <<<'
	drop procedure MM_SMVolSnapsToDelete
END
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsToDelete')
	delete from GxQscripts where name = 'MM_SMVolSnapsToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToDelete')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToDelete'
GO
print '... Creating Procedure: MM_SMVolSnapsToDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsToDelete
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_SMVolSnapMapId INTEGER
  DECLARE @o_SMVolumeId INTEGER
  DECLARE @o_SMSnapId INTEGER
  DECLARE @o_SMMetaDataId INTEGER
  DECLARE @o_DeleteMode INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorVolId			INTEGER
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	-----------------------------------------------------------------------------
	-- Process Input XML
	-----------------------------------------------------------------------------
	-- XML Structure for MM_SMVolSnapsToDelete
	/*
		<MM_SMVolSnapsToDelete>
			<VolumeId></VolumeId>
			<JobId></JobId>
			<HostId></HostId>
		</MM_SMVolSnapsToDelete>
	*/
	/**************************/
	/* Yanhui: The MM deletion thread will group the volumes by HostId, SnapShotEngineId (no jobId), and send it to this delete Validation SP */
	/**************************/
	DECLARE @tblReturn  TABLE (
			SMVolSnapMapId integer,
			SMVolumeId integer,
			SMSnapId integer,
			MetaDataId integer,
			DeleteMode integer DEFAULT 0
		)
	DECLARE @tblVolIDs TABLE (SMVolumeId int)
	DECLARE @x_JobId INTEGER
	DECLARE @x_HostId INTEGER
	DECLARE @x_OpSource INTEGER
	DECLARE @x_Flags BIGINT
	DECLARE @x_ArrayCount int, @x_EngineCount int
DECLARE @vsaVolumeFlag BIGINT = 4294967296
	INSERT	INTO @tblVolIDs
	SELECT R.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/VolumeId') R(ref)
	SET @x_JobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/JobId') R(ref)), 0)
	SET @x_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/HostId') R(ref)), 0)
	SET @x_OpSource = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/OpSource') R(ref)), 0)
	SET @x_Flags = ISNULL(( SELECT R.ref.value('.', 'bigint') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/Flags') R(ref)), 0)
	SET @x_ArrayCount = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/ArrayCount') R(ref)), 0)
	SET @x_EngineCount = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMVolSnapsToDelete/EngineCount') R(ref)), 0)
	DECLARE @isForceDeleteOperation INTEGER = 0
SET @isForceDeleteOperation = CASE WHEN ((@x_Flags & 536870912/*VOLSNAP_ACTIONFLAGS_FORCE_DELETE_DB*/) > 0) THEN 1 ELSE 0 END
	DECLARE @tblSMVolume TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		RecoveryPointId integer,
		CopyId integer,
		AppId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SnapSource integer,
		VolumeFlags bigint,
		MasterJobId integer
	)
	DECLARE @tblSharedVols  TABLE (
		SMVolumeId integer,
		JobId integer,
		VolumeFlags bigint,
		RecoveryPointId integer,
		CopyId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	DECLARE @tblSharedVolSnaps  TABLE (
		SMSnapId integer,
		UniqueIdentifier nvarchar(2048),
		SMVolumeId integer,
		JobId integer,
		VolumeFlags bigint,
		RecoveryPointId integer,
		CopyId integer,
		PruneFlags integer,
		MountHostId integer,
		MountStatus integer,
		SourcePath	nvarchar(1024),
		SourceGUID	nvarchar(1024)
	)
	INSERT INTO @tblSMVolume
	SELECT	a.SMVolumeId,
			isnull(b.ArchFileId, 0),
			isnull(b.CommCellId, 0),
			isnull(b.JobId, 0),
			isnull(b.RecoveryPointId, 0),
			isnull(b.CopyId, 0),
			isnull(b.AppId, 0),
			isnull(b.PruneFlags, 0),
			isnull(b.MountHostId, 0),
			isnull(b.MountStatus, 0),
			isnull(b.SnapSource, 0),
			isnull(b.VolumeFlags, 0),
			isnull(b.MasterJobId, 0)
	FROM @tblVolIDs as a left outer join SMVolume as b (READUNCOMMITTED)
	ON a.SMVolumeID = b.SMVolumeID
	-- AMFAM - Shared Volumes using Snap Consistency Group
	-- Check whether the volume(s) belongs to Snap Consistency Group (SCG)
	-- LREP	 -	One (or sometimes more) physical snap(s) may be shared by volumes
	--			in a Workflow Job. Workflow Job Id is stored in SMVolume.RecoveryPointId.
	--			Physical Snap Name is stored in Snap.UniqueIdentifier.
	--			Logical deletion -	There are undeleted volumes part of the Workflow Job
	--								referencing the shared snap.
	--			Physical deletion - All volumes part of the Workflow Job referencing the
	--								shared snap are deleted.
	-----------------------------------------------------------------------------
	-- Get all volumes within SCG or LREP group -- Use RecoveryPointId as Group Id
	-----------------------------------------------------------------------------
	INSERT	INTO @tblSharedVols
	SELECT	A.SMVolumeId, A.JobId, A.VolumeFlags, A.RecoveryPointId, A.CopyId, A.PruneFlags, A.MountHostId, A.MountStatus, A.SourcePath, A.SourceGUID
	FROM	SMVolume A (READUNCOMMITTED)
	WHERE	(
				A.RecoveryPointId in (SELECT DISTINCT RecoveryPointId FROM @tblSMVolume WHERE RecoveryPointId > 0)
AND ((A.AppTypeId = 22 AND (A.VolumeFlags & 8192 = 8192))
OR (A.VolumeFlags & 4096 = 4096))
			)
			OR
			(
				---- For VSA VMware V2 and Hyper-V V2
				(
(A.AppTypeId = 106		)
					OR
(A.AppTypeId = 33	)
				)
				AND ( A.VolumeFlags & @vsaVolumeFlag = @vsaVolumeFlag														)
					---- With newer implementation - all related VSA V2 entries will have same MasterJobId
				AND ( A.MasterJobId IN (SELECT DISTINCT TV.MasterJobId FROM @tblSMVolume TV WHERE TV.MasterJobId > 0)		)
			)
	INSERT	INTO @tblSharedVolSnaps
	SELECT	SNAP.SMSnapId, SNAP.UniqueIdentifier, SV.*
	FROM	@tblSharedVols SV
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON SV.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
	-----------------------------------------------------------------------------
	-- Remove volumes deleted
	-----------------------------------------------------------------------------
	DELETE	FROM @tblSMVolume
WHERE	PruneFlags = 6
	-----------------------------------------------------------------------------
	-- Unknown volume
	-----------------------------------------------------------------------------
	DELETE FROM @tblSMVolume
	WHERE ArchFileId = 0
	-----------------------------------------------------------------------------
	-- Check if the archFileCopy table entry is valid. If it is valid, fail the delete request.
	-----------------------------------------------------------------------------
	IF EXISTS (SELECT 1 FROM @tblSMVolume VOL INNER JOIN archFileCopy AFC (READUNCOMMITTED) ON VOL.ArchFileId = AFC.archFileId AND VOL.CopyId = AFC.archCopyId AND VOL.CommCellId = AFC.commCellId
WHERE AFC.isValid = 1 AND AFC.flags & 256 /*CVA_AGED_DATA_FLAG*/ = 0 AND VOL.pruneFlags = 4 /*MM_SM_PRUNEFLAGS_DANGLING*/)
	BEGIN
SELECT 0, 0, 0, 0, 0, 60280 /*E_MM_SM_SB_VALIDATION_DELETE_FAILED*/, 'ArchfileCopy entry is still valid. Failing the delete request.', 0, 0
   		RETURN
	END
	IF @isForceDeleteOperation = 0
	BEGIN
  		-----------------------------------------------------------------------------
		-- Unknown mount host
		-----------------------------------------------------------------------------
   		DECLARE @HostName NVARCHAR(1024) = N''
   		SET @HostName = (SELECT name FROM APP_Client (READUNCOMMITTED) WHERE id = @x_HostId)
		-- If this is a force delete operation, then ignore this check
   		IF (@HostName IS NULL OR @HostName = N'')
   		BEGIN
SELECT 0, 0, 0, 0, 0, 60204, 'No Host found with HostId [' + Convert(varchar(10), @x_HostId) + '].', 0, 0
   			RETURN
   		END
		DECLARE	@tblMMHost TABLE (MmHostEnabled INT, MMHostSoftState INT)
		INSERT	INTO @tblMMHost
		SELECT	MmHostEnabled, MMHostSoftState
		FROM	MMHost (READUNCOMMITTED)
		WHERE 	ClientId = @x_HostId
   		-----------------------------------------------------------------------------
   		-- MediaAgent not installed
   		-----------------------------------------------------------------------------
   		IF NOT EXISTS (SELECT * FROM @tblMMHost)
   		BEGIN
SELECT 0, 0, 0, 0, 0, 60912, 'MediaAgent not installed on host [' + @HostName + '].', 0, 0
   			RETURN
   		END
   		-----------------------------------------------------------------------------
   		-- Media Agent not enabled
   		-----------------------------------------------------------------------------
   		IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MmHostEnabled = 1)
		BEGIN
SELECT 0, 0, 0, 0, 0, 383, 'MediaAgent on host [' + @HostName + '] is not enabled.', 0, 0
   			RETURN
   		END
   		-----------------------------------------------------------------------------
   		-- Media Agent Offline
   		-----------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM @tblMMHost WHERE MMHostSoftState = 1)
		BEGIN
SELECT 0, 0, 0, 0, 0, 357, 'MediaAgent on host [' + @HostName + '] is offline.', 0, 0
   			RETURN
   		END
	END
	-----------------------------------------------------------------------------
	-- Volumes are reserved
	-----------------------------------------------------------------------------
	/*
	DELETE FROM @tblSMVolume
	WHERE SMVolumeId IN (SELECT SMVolumeId FROM SMSnapResource (READUNCOMMITTED))
	*/
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM SMSnapResource (READUNCOMMITTED) WHERE SMVolumeId IN (SELECT SMVolumeId FROM @tblSMVolume))
	IF @ErrorVolId IS null
		SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM SMSnapResource (READUNCOMMITTED) WHERE SMVolumeId IN (SELECT SMVolumeId FROM @tblSharedVols))
	IF @ErrorVolId IS NOT null
	BEGIN
SET @ErrorCode = 60214
		SET @ErrorStr = 'Delete operation not possible now as volume(s) reserved by other jobs or user - may be already mounted. VolumeId[' + CONVERT(varchar(10), @ErrorVolId) + ']'
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF	@x_JobId > 0 AND
		NOT EXISTS (SELECT * FROM JMJobInfo WHERE JobId = @x_JobId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is not running. JobId [' + Convert(varchar(10), @x_JobId) + ']'
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Foreign snap source
	-----------------------------------------------------------------------------
	IF	EXISTS (SELECT * FROM @tblSMVolume WHERE SnapSource <> 0)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Foreign snap source.'
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volumes are being held by other operation
	-----------------------------------------------------------------------------
	IF @ErrorVolId IS null
		SET @ErrorVolId = (	SELECT TOP 1 a.SMVolumeId FROM SMVolAction a (READUNCOMMITTED), @tblSharedVols b WHERE a.SMVolumeId = b.SMVolumeId )
	IF @ErrorVolId IS NOT null
	BEGIN
		SET @ErrorCode = 60212
		SET @ErrorStr = 'One or more volumes are dangling in SMVolAction table. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes have mounted test clones
	-----------------------------------------------------------------------------
	IF @ErrorVolId IS null
		SET @ErrorVolId = (	SELECT TOP 1 a.MountJobId FROM SMMountVolume a (READUNCOMMITTED), @tblSMVolume b
WHERE a.SMVolumeId = b.SMVolumeId and (a.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/)and a.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/)
	IF @ErrorVolId IS NOT null
	BEGIN
SET @ErrorCode = 60314
		SET @ErrorStr = 'One or more volumes still have Test Clones. Test clone Job Id [' + Convert(varchar(10), @ErrorVolId) +
						']. Please wait for the reservation period to expire or delete the Clone Environment before deleting snapshots.'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes have multi node mounts
	-----------------------------------------------------------------------------
	IF @ErrorVolId IS null
		SET @ErrorVolId = (	SELECT TOP 1 a.MountJobId FROM SMMountVolume a (READUNCOMMITTED), @tblSMVolume b
WHERE a.SMVolumeId = b.SMVolumeId and (a.MountFlags & 2048 != 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/)and a.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/)
	IF @ErrorVolId IS NOT null
	BEGIN
SET @ErrorCode = 60360
		SET @ErrorStr = 'One or more volumes are still not unmounted successfully. Mount Job Id [' + Convert(varchar(10), @ErrorVolId) +
						'].'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are mounted, or being mounted or unmounted or reverted
	-----------------------------------------------------------------------------
	-- Volumes in the middle of mounting or unmounting state can still be unmounted
	-- DELETE FROM @tblSMVolume
	-- WHERE MountStatus > SM_VS_CRT_CREATED
	-- AND MountStatus < SM_VS_RVT_REVERTED
	-- AND MountStatus <> SM_VS_UMT_UNMOUNTED
	-- AND PruneFlags = MM_SM_PRUNEFLAGS_ACTIVE
	IF @ErrorVolId IS null
SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblSMVolume WHERE MountStatus > 39 /*SM_VS_CRT_CREATED*/ AND MountStatus < 89 /*SM_VS_RVT_REVERTED*/ AND MountStatus <> 79 /*SM_VS_UMT_UNMOUNTED*/ AND PruneFlags >= 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/)
	IF @ErrorVolId IS NOT null
	BEGIN
		SET @ErrorCode = 60214
		SET @ErrorStr = 'Delete operation not possible now as volume(s) are in the middle of Mount / Unmount / Revert operation. VolumeId[' + CONVERT(varchar(10), @ErrorVolId) + ']'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are being held by other operation
	-- SnapOpType MM_SM_OPTYPE_DELETE_SNAP = 1
	-----------------------------------------------------------------------------
	-- The query below removes the entries from the result set.
	-- This step needs to be skipped for force delete operation.
	-- For Force delete operation, the op mode for a logical delete is updated by the result set of this stored proc.
	IF @isForceDeleteOperation = 0
	BEGIN
		DELETE FROM @tblSMVolume
		WHERE SMVolumeId IN
				(SELECT SMVolumeId FROM SMVolAction (READUNCOMMITTED))
		AND SMVolumeId NOT IN
				(SELECT SMVolumeId FROM SMVolAction (READUNCOMMITTED)
				WHERE JobId = @x_JobId AND SnapOpType = 1)
	END
	-----------------------------------------------------------------------------
	-- Get volumes in the same job copy
	-----------------------------------------------------------------------------
	DECLARE @tblJobCopyVols  TABLE ( SMVolumeId integer )
	-- Get all the volumes of the job
	INSERT	INTO @tblJobCopyVols
	SELECT	DISTINCT VOL.SMVolumeId
	FROM	SMVolume VOL (READUNCOMMITTED), @tblSMVolume TVOL, archFile AF (READUNCOMMITTED), archFileCopy AFC  (READUNCOMMITTED)
WHERE	VOL.JobId = TVOL.JobId AND VOL.CopyId = TVOL.CopyId AND VOL.AppTypeId <> 13
AND VOL.VolumeFlags & 33554432 = 0
			AND VOL.SMVolumeId <> TVOL.SMVolumeId
			AND VOL.PruneFlags = 1
			AND TVOL.PruneFlags = 1
			AND VOL.ArchFileId = AF.id
			AND VOL.CommCellId = AF.commCellId
			AND VOL.ArchFileId = AFC.ArchFileId
			AND VOL.CommCellId = AFC.commCellId
			AND AF.isValid = 1 AND AFC.isValid = 1
			AND AFC.ArchCopyId = TVOL.CopyId
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblJobCopyVols
						WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume) )
	IF @ErrorVolId IS NOT null
	BEGIN
		--Need to define new error code
SET @ErrorCode = 60150
		SET @ErrorStr = 'One or more dependent volumes are not selected for delete. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']. Please select all volumes of the job for deletion.'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-------------------------------------------------------------------------------------------
	-- All SMvolume entries for a single snapshot (in case of qtrees) must be deleted together
	-------------------------------------------------------------------------------------------
	DECLARE @tblNASVolGroups  TABLE ( SMVolumeId integer, GroupId INTEGER )
	INSERT	INTO @tblNASVolGroups
	SELECT	DISTINCT TVOL.SMVolumeId, SNAP.GroupId
	FROM	@tblSMVolume TVOL
INNER JOIN SMVolume VOL (READUNCOMMITTED) ON VOL.SMVolumeId = TVOL.SMVolumeId AND VOL.AppTypeId = 13
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
	DECLARE @tblNASJobCopyVols  TABLE ( SMVolumeId integer )
	INSERT	INTO @tblNASJobCopyVols
	SELECT	DISTINCT VOL.SMVolumeId
	FROM	SMVolume VOL (READUNCOMMITTED), @tblSMVolume TVOL, @tblNASVolGroups TGROUP,
			SMVolSnapMap MAP (READUNCOMMITTED), SMSnap SNAP (READUNCOMMITTED),
			archFile AF (READUNCOMMITTED), archFileCopy AFC  (READUNCOMMITTED)
	WHERE	VOL.JobId = TVOL.JobId AND VOL.CopyId = TVOL.CopyId
			AND VOL.SMVolumeId = MAP.SMVolumeId AND MAP.SMSnapId = SNAP.SMSnapId
			AND TVOL.SMVolumeId = TGROUP.SMVolumeId
			AND TGROUP.GroupId = SNAP.GroupId AND SNAP.GroupId > 0
			AND VOL.SMVolumeId <> TVOL.SMVolumeId
			AND VOL.PruneFlags = 1
			AND TVOL.PruneFlags = 1
			AND VOL.ArchFileId = AF.id
			AND VOL.CommCellId = AF.commCellId
			AND VOL.ArchFileId = AFC.ArchFileId
			AND VOL.CommCellId = AFC.commCellId
			AND AF.isValid = 1 AND AFC.isValid = 1
			AND AFC.ArchCopyId = TVOL.CopyId
	SET @ErrorVolId = (SELECT TOP 1 SMVolumeId FROM @tblNASJobCopyVols
						WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume) )
	IF @ErrorVolId IS NOT null
	BEGIN
SET @ErrorCode = 60150
		SET @ErrorStr = 'One or more dependent volumes are not selected for delete. VolumeId [' + Convert(varchar(10), @ErrorVolId) + ']. Please select all snap volumes of a NAS filer volume for deletion.'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-------------------------------------------------------------------------------------------
	-- All SMvolume entries for a single snapshot (in case of qtrees) must be deleted together for VSA V2.1 parent DS snaps
	-------------------------------------------------------------------------------------------
	DECLARE @tblVSAVolGroups  TABLE ( SMVolumeId integer, GroupId INTEGER, SMSnapId INTEGER  )
	INSERT	INTO @tblVSAVolGroups
	SELECT	DISTINCT TVOL.SMVolumeId, SNAP.GroupId, SNAP.SMSnapId
	FROM	@tblSMVolume TVOL
			INNER JOIN SMVolume VOL (READUNCOMMITTED)
				ON 	VOL.SMVolumeId = TVOL.SMVolumeId
AND VOL.VolumeFlags & CAST( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
				ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED)
				ON MAP.SMSnapId = SNAP.SMSnapId
	--
	-- Get All SM snaps dependent volumes for above selected smvolume in tblVSAVolGroups
	--
	DECLARE @tblFUllMap  TABLE ( SMVolumeId integer, SMSnapId integer )
	INSERT	INTO @tblFUllMap
	SELECT	DISTINCT MAP.SMVolumeId, MAP.SMSnapId
	FROM	@tblVSAVolGroups TVOL
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
				ON MAP.SMSnapId = TVOL.SMSnapId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED)
				ON MAP.SMSnapId = SNAP.SMSnapId
    --
	-- Remove smvolume entries whose snaps is having more entries in volsnapmap , means they are not the last one
	--
    DELETE
	FROM  @tblVSAVolGroups
	WHERE  SMSnapId IN (
						-- Right outer join means full map of snap has some volumes which are not there
						-- in selected for deletion group and their respective entry is NULL.
 						SELECT  fullSnapMap.SMSnapId
							FROM @tblVSAVolGroups tgroup
								RIGHT OUTER JOIN @tblFUllMap fullSnapMap
									ON fullSnapMap.SMVolumeId = tgroup.SMVolumeId
						WHERE tgroup.SMSnapId IS  NULL
					)
	-- use above volumes of VSA v2 ( tblVSAVolGroups ) which are given for delete and they are the last for their snaps ( means hw delete will happen )
	-- As these are the last volume snap or all volumes of this snap are in the selected list , lets see if it has groupid which
	-- is matching to some other snap not part of delete request .
	DECLARE @tblVSAJobCopyVols  TABLE ( NeededSMVolumeId integer,
										NeededJobId integer,
										NeededSrcDevice nvarchar(MAX),
										SelectedJobId integer,
										SelectedSMVolumeId integer
									)
	INSERT	INTO @tblVSAJobCopyVols
	SELECT	DISTINCT	VOL.SMVolumeId,
						VOL.jobid ,
						VOL.SourceDevice,
						TVOL.JobId,
						TVOL.SMVolumeId
	FROM	SMVolume VOL (READUNCOMMITTED)
	INNER JOIN @tblSMVolume TVOL
			ON 	VOL.CopyId = TVOL.CopyId
				AND VOL.MasterJobId = TVOL.MasterJobId
				AND VOL.MasterJobId > 0
AND VOL.VolumeFlags & CAST( 4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0
AND VOL.VolumeFlags & CAST( 536870912 AS BIGINT) /*CVSM_VOLUMEFLAGS_VM_LEVEL_SNAP_DB*/ = 0
	INNER JOIN @tblVSAVolGroups TGROUP
			ON  TVOL.SMVolumeId = TGROUP.SMVolumeId
	INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED)
			ON VOL.SMVolumeId = MAP.SMVolumeId
	INNER JOIN SMSnap SNAP	(READUNCOMMITTED)
			ON MAP.SMSnapId = SNAP.SMSnapId
	WHERE  	-- Not to check for non-NetApp engine for group id , even any volume within same master job pending is good enough to block
		  	(
SNAP.SnapShotEngineId <> 3
				OR
				(
					TGROUP.GroupId = SNAP.GroupId
			AND SNAP.GroupId > 0
				)
			)
			AND VOL.SMVolumeId <> TVOL.SMVolumeId
			AND VOL.PruneFlags = 1
			AND VOL.CommCellId = TVOL.commCellId
    DECLARE @selVOl INT , @needVol INT , @selJob INT, @needJob INT
	DECLARE @selSrcDevice nvarchar(max) , @needSrcDevice nvarchar(max)
	SELECT	TOP 1	@selVOl = SelectedSMVolumeId,	@selJob = SelectedJobId,
					@needVOL = NeededSMVolumeId,	@needJob = NeededJobId,		@needSrcDevice = NeededSrcDevice
	FROM @tblVSAJobCopyVols
	WHERE NeededSMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
	IF @needVOL IS NOT null
	BEGIN
SET @ErrorCode = 60150 /*E_MM_SM_SB_DEPENDENT_VOLS_NOT_SELECTED*/
		SET @ErrorStr = 'One or more shared snap volumes are not selected for delete. Please select VolumeId [' + Convert(varchar(10), @needVol) + '], from Snap Job[' + Convert(varchar(10), @needJob) + '],[' + Convert(varchar(50), @needSrcDevice) + '] to delete selected VolumeId [' + Convert(varchar(10), @selVOl) + ']	, from Snap Job[' + Convert(varchar(10), @selJob) + '] . Please select all related snap volumes of a datastore for deletion.'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Volumes are being used in backupcopy
	-----------------------------------------------------------------------------
	DECLARE @JOB_OP_TYPE_SNAPTOTAPE INTEGER = 60 -- SNAPTOTAPE in cvconstdef.h
	DECLARE @tblVolJobInfo TABLE (SMVolumeId INTEGER, WFJobId INTEGER, ChildJobId INTEGER, SnapJobId INTEGER)
	DECLARE @ErrorWFJobId INTEGER = 0
	DECLARE @ErrorChildJobId INTEGER = 0
	DECLARE @ErrorSnapJobId INTEGER = 0
	DECLARE @tblMirrorVolInfo TABLE (
		SMVolumeId integer,
		ArchFileId integer,
		CommCellId integer,
		JobId integer,
		CopyId integer
	)
	INSERT	INTO @tblMirrorVolInfo
	SELECT	SMvolumeId, ArchfileId, CommCellId, JobId, CopyId
	FROM	@tblSMVolume
    WHILE EXISTS    (SELECT T.SMVolumeId
                    FROM @tblMirrorVolInfo T, SMVolume S (READUNCOMMITTED), ArchGroupCopy AGC  (READUNCOMMITTED)
                    WHERE T.SMVolumeId = S.ReserveField1
                        AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblMirrorVolInfo)
                        AND S.CopyID = AGC.id
                        AND AGC.IsSnapCopy = 1
                        AND AGC.IsMirrorCopy = 1)
    BEGIN
        INSERT INTO @tblMirrorVolInfo
        SELECT S.SMVolumeId, S.ArchFileId, S.CommCellId, S.JobId, S.CopyId
        FROM @tblMirrorVolInfo T, SMVolume S (READUNCOMMITTED), ArchGroupCopy AGC (READUNCOMMITTED)
        WHERE T.SMVolumeId = S.ReserveField1
            AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblMirrorVolInfo)
            AND S.CopyID = AGC.id
            AND AGC.IsSnapCopy = 1
            AND AGC.IsMirrorCopy = 1
    END
	INSERT INTO @tblVolJobInfo
	SELECT	TEMP.SMVolumeId, WF.jobId, WF.childJobId, VOL.JobId
	FROM	@tblMirrorVolInfo TEMP
			JOIN SMVolume VOL (READUNCOMMITTED) ON TEMP.SMVolumeId = VOL.SMVolumeId
            JOIN JMJobSnapshotStats JSS (READUNCOMMITTED) ON VOL.JobId = JSS.jobId AND VOL.CommCellId = JSS.CommCellId
			JOIN archGroup AG (READUNCOMMITTED) ON JSS.archGrpId = AG.id
			JOIN archMaterializeSnapshotProp PROP (READUNCOMMITTED) ON JSS.archGrpId = PROP.archGroupId
			JOIN JMJobWF WF (READUNCOMMITTED) ON WF.processedJobId = VOL.JobId AND WF.childOpType = @JOB_OP_TYPE_SNAPTOTAPE
				AND VOL.CommCellId = WF.processedCommCellId
            JOIN JMJobInfo JOB (READUNCOMMITTED) ON WF.childJobId = JOB.jobId AND JOB.CommCellId = WF.processedCommCellId
	WHERE	VOL.CopyId = (CASE WHEN PROP.sourceCopyId = 0 THEN AG.defaultSnapCopy ELSE PROP.sourceCopyId END)
	SELECT	TOP 1 @ErrorVolId = SMVolumeId, @ErrorWFJobId = WFJobId, @ErrorChildJobId = ChildJobId, @ErrorSnapJobId = SnapJobId FROM @tblVolJobInfo
	IF @ErrorVolId IS NOT null
	BEGIN
SET @ErrorCode = 60214 /*E_MM_SM_SB_VOL_RESERVED*/
		SET @ErrorStr = 'Deleting volume(s) not possible now as they are being Backup Copied. Backup Copy Job[' + CONVERT(varchar(10), @ErrorChildJobId) +
							']. Snap Job[' + CONVERT(varchar(10), @ErrorSnapJobId) + ']. Work Flow Job[' + CONVERT(varchar(10), @ErrorWFJobId) + '].'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------------
	-- Do not allow deletion of snaps in latest cycle while Synth full job running.
	-----------------------------------------------------------------------------------
	DECLARE @SynthFullJobId INT  = 0
	DECLARE @SnapJobId INT = 0
	DECLARE @BkpLevelSynthFull INT = 64
	DECLARE @jobStatusCompleted INT = 1
	DECLARE @jobStatusCompletedWError INT = 3
	DECLARE @jobStatusCompletedWWarning INT = 14
	SELECT TOP 1 @SynthFullJobId = BKPINFO.jobId, @SnapJobId = TMP.JobId
	FROM	@tblSMVolume TMP
			INNER JOIN archGroup AG (READUNCOMMITTED) on TMP.CopyId = AG.defaultSnapCopy
			INNER JOIN APP_SubClientProp PROP (READUNCOMMITTED) ON PROP.componentNameId = TMP.AppId AND PROP.attrName = 'sys:full cycle num' AND PROP.modified = 0
			INNER JOIN JMBkpStats BKP (READUNCOMMITTED) ON BKP.jobId = TMP.JobId AND BKP.commCellId = TMP.CommCellId AND BKP.fullCycleNum = PROP.attrVal
				AND BKP.status IN (@jobStatusCompleted, @jobStatusCompletedWError, @jobStatusCompletedWWarning)
			INNER JOIN JMBkpJobInfo BKPINFO (READUNCOMMITTED) ON BKPINFO.applicationId = TMP.AppId AND BKPINFO.commcellId = TMP.CommCellId AND BKPINFO.bkpLevel = @BkpLevelSynthFull
	IF @SynthFullJobId > 0
	BEGIN
		SET @ErrorCode = 60214 /*E_MM_SM_SB_VOL_RESERVED*/
		SET @ErrorStr = 'Snaps of jobs in the latest cycle cannot be deleted while Synthetic Full job is running. Synthetic Full Job[' + CONVERT(varchar(10), @SynthFullJobId) +
							']. Snap Job[' + CONVERT(varchar(10), @SnapJobId) + '].'
		SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
		RETURN
	END
	-----------------------------------------------------------------------------
	-- Fail if volumes belong to different Clients, Arrays or Engines
	-----------------------------------------------------------------------------
	DECLARE @tblGroupVolsFromClients TABLE (
			SourceClientId integer default 0,
			JobId integer default 0,
			VolumeFlags bigint default 0,
			ControlHostId integer default 0,
			SnapShotEngineId integer default 0,
			SnapFlags bigint default 0
		)
	INSERT	INTO @tblGroupVolsFromClients
	SELECT	VOL.SourceClientId, VOL.JobId, VOL.VolumeFlags, SNAP.ControlHostId, SNAP.SnapShotEngineId, SNAP.SnapFlags
	FROM	@tblVolIDs TV INNER JOIN SMVolume VOL (READUNCOMMITTED) ON TV.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
	DECLARE @ClientCount int, @JobCount int, @ReplicaCount int, @ClusterSnapCount bigint
	select @ClientCount = (select COUNT(DISTINCT SourceClientId) from @tblGroupVolsFromClients)
	select @JobCount = (select COUNT(DISTINCT JobId) from @tblGroupVolsFromClients)
	select @ReplicaCount = (select COUNT(DISTINCT VolumeFlags) from @tblGroupVolsFromClients
where VolumeFlags & 1048576 = 1048576 /*CVSM_VOLUMEFLAGS_REPLICA_SNAP_VOL_DB*/)
	select @ClusterSnapCount = ISNULL((select COUNT(DISTINCT SnapFlags) from @tblGroupVolsFromClients
where SnapFlags & cast(17179869184 as bigint) = cast(17179869184 as bigint) /*CVSM_SNAPSHOTFLAGS_METRO_CLUSTER*/),0)
	DECLARE @engineMultiArrayCapab INT = 0
	SELECT	@engineMultiArrayCapab = (
										SELECT		COUNT (DISTINCT VOL.SnapShotEngineId)
										FROM		@tblGroupVolsFromClients vol
										INNER JOIN	SMSnapShotEngine (READUNCOMMITTED) ENG ON VOL.SnapShotEngineId = ENG.SnapShotEngineId
WHERE		ENG.Capabilities & 131072/*SM_SNAPSHOT_ENGINE_CAPABILITY_MULTI_ARRAY_FOR_SNAP_JOB*/ > 0
										 )
	DECLARE @engineMultiEngineCapab INT = 0
	SELECT	@engineMultiEngineCapab = (
										SELECT		COUNT (DISTINCT VOL.SnapShotEngineId)
										FROM		@tblGroupVolsFromClients vol
										INNER JOIN	SMSnapShotEngine (READUNCOMMITTED) ENG ON VOL.SnapShotEngineId = ENG.SnapShotEngineId
WHERE		ENG.Capabilities & CAST(8589934592 AS BIGINT )/*SM_SNAPSHOT_ENGINE_CAPABILITY_MULTI_ARRAY_MULTI_ENGINE*/ > 0
										 )
	DECLARE @allowDelete INT = 0
	IF	( @ClientCount > 1 and @x_OpSource <> 3/*SM_OS_MM*/) or @x_EngineCount > 1 or @x_ArrayCount > 1
		SET @allowDelete = 0
	ELSE
		SET @allowDelete = 1
	/* Allow deletion if engine is multi-array capable */
	IF  @x_EngineCount = 1 AND @x_ArrayCount > 1 and @engineMultiArrayCapab > 0
		SET @allowDelete = 1
	/* Allow deletion if engine is multi-engine capable */
	IF  (@x_EngineCount > 1 OR @x_ArrayCount > 1) and @engineMultiEngineCapab = @x_EngineCount
		SET @allowDelete = 1
	/* Allow deletion if primary and replica snaps of a job are being deleted together */
	IF  @x_ArrayCount > 1 and @ReplicaCount > 0 and @JobCount = 1
		SET @allowDelete = 1
	/* Allow deletion if primary and secondary snaps of a job are being deleted together */
	IF  @x_EngineCount = 1 AND @x_ArrayCount > 1 AND @clusterSnapCount > 0
		SET @allowDelete = 1
	IF @allowDelete = 0 AND @isForceDeleteOperation = 0
	BEGIN
SET @ErrorCode = 60153 /* 60153 */
			SET @ErrorStr = 'Cannot delete volumes from different Clients, Arrays or Engines. Will mark volumes for aging. [ClientCount = ' +
				Convert (varchar(4), @ClientCount ) + ', ArrayCount = ' + Convert(varchar (4), @x_ArrayCount) +
				', EngineCount = ' + Convert(varchar (4), @x_EngineCount) + ']'
			SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
			RETURN
	END
	-----------------------------------------------------------------------------
	-- VSA AppAware
	-----------------------------------------------------------------------------
	-- Parent Snap - Fail if there is a valid child found on the same copy
	DECLARE @tblAppAwareLinkedVols TABLE (
			ParentVolumeId integer,
			ChildVolumeId integer
		)
		-- Valid Childs Volumes
		-- Either check for Volume PruneFlags or valid archieve file
		INSERT	INTO @tblAppAwareLinkedVols
		SELECT  V.SMVolumeId,
				B.SMVolumeId
		FROM	@tblSMVolume V INNER JOIN JMVSAAppJobLink JOBLINK (READUNCOMMITTED) ON JOBLINK.parentJobId = V.JobId
				INNER JOIN SMVOLUME B (READUNCOMMITTED) ON B.JobId = JOBLINK.childJobId AND V.CopyId = B.CopyId
WHERE	V.VolumeFlags & 262144 = 262144
AND B.VolumeFlags & 131072 = 131072 -- Optional safe check
AND V.PruneFlags = 1
		SET @ErrorVolId = (SELECT	TOP 1 A.SMVolumeId
						   FROM	@tblSMVolume A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId )
		IF @ErrorVolId IS NOT null
		BEGIN
SET @ErrorCode = 60214
			SET @ErrorStr = 'VSA AppAware.Cannot delete Parent volume as there are valid child volume(s) present. VolumeId[' + CONVERT(varchar(10), @ErrorVolId) + ']'
			GOTO CX_EXIT
		END
	-----------------------------------------------------------------------------
	-- Return for delete operation
	-----------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM @tblSharedVolSnaps)
	BEGIN
		DECLARE @tblVolLogDelSCG TABLE	(SMVolumeId int) -- SCG volumes to be logically deleted
		DECLARE @tblVolLogDelLREP TABLE	(SMVolumeId int) -- LREP volumes to be logically deleted
		-- LREP volumes to be physically deleted
		-- This will contain two sets of volumes:
		-- 		1. volumes to be physically deleted from filer
		--		2. volumes to be physically deleted from filer and backup instance to be deleted
		DECLARE @tblVolPhyDelLREP TABLE	(
			SMVolumeId int DEFAULT 0,
			RecoveryPointId int DEFAULT 0,
			CopyId int DEFAULT 0,
			DeleteMode int DEFAULT 0)
		-- LREP volumes from SMVolume table (not part of input)
		-- which are part of workflow job but are not being deleted
		DECLARE @tblVolNoDelLREP TABLE	(
			SMVolumeId int DEFAULT 0,
			RecoveryPointId int DEFAULT 0,
			CopyId int DEFAULT 0)
		-- If LREP volume in XML input has snap which is also referred by volume
		-- in SMVolume table in DB which is not part of XML input, then the
		-- volume needs to be logically deleted. CopyId is considered as we don't
		-- want to prevent deletion of primary if a mirror copy is present. They
		-- are physically separate snaps although the RecoveryPointId and UniqueIdentifier
		-- are the same.
		INSERT	INTO @tblVolLogDelLREP
		SELECT	DISTINCT A.SMVolumeId
		FROM	@tblSharedVolSnaps A, @tblSharedVolSnaps B
WHERE	A.VolumeFlags & 4096 = 4096
				AND A.RecoveryPointId = B.RecoveryPointId
				AND	A.UniqueIdentifier = B.UniqueIdentifier
				AND	A.CopyId = B.CopyId
				AND A.SMVolumeId IN (SELECT SMVolumeId FROM @tblSMVolume)
				AND B.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
				AND B.MountStatus <> 99
		-- Add logical delete LREP volumes to return table
		INSERT	INTO @tblReturn
SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, 1
		FROM	@tblVolLogDelLREP NOOP, SMVolSnapMap MAP (READUNCOMMITTED)
		WHERE	NOOP.SMVolumeId = MAP.SMVolumeId
		-- These LREP volumes will be physically deleted
		-- Start with setting flag to delete DFM Backup Instance for all volumes
		INSERT	INTO @tblVolPhyDelLREP
SELECT	DISTINCT VOL.SMVolumeId, VOL.RecoveryPointId, VOL.CopyId, 4
		FROM	@tblSMVolume VOL JOIN @tblSharedVolSnaps SVS ON SVS.SMVolumeId = VOL.SMVolumeId
WHERE	SVS.VolumeFlags & 4096 = 4096
				AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM @tblReturn)
		-- Don't delete DFM Backup Instance (only delete physical snap) if:
		-- Any volume that is part of the workflow job is being logically deleted
		UPDATE	@tblVolPhyDelLREP
SET		DeleteMode = 2
		FROM	@tblVolPhyDelLREP
		WHERE	RecoveryPointId IN (SELECT DISTINCT RecoveryPointId FROM @tblVolLogDelLREP)
		-- Don't delete DFM Backup Instance (only delete physical snap) if:
		-- Any volume that is part of the workflow job is not being deleted (logically or physically)
		INSERT	INTO @tblVolNoDelLREP
		SELECT	SMVolumeId, RecoveryPointId, CopyId
		FROM	@tblSharedVolSnaps SVS
		WHERE	SVS.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolPhyDelLREP)
				AND SVS.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolLogDelLREP)
AND SVS.VolumeFlags & 4096 = 4096
		-- Also consider CopyId so that we do delete backup instance even if
		-- secondary copy is not being deleted
		UPDATE	@tblVolPhyDelLREP
SET		DeleteMode = 2
		FROM	@tblVolPhyDelLREP PHY, @tblVolNoDelLREP NODEL
		WHERE	PHY.RecoveryPointId = NODEL.RecoveryPointId
				AND PHY.CopyId = NODEL.CopyId
		-- Add physical delete LREP volumes to return table
		INSERT	INTO @tblReturn
		SELECT	DISTINCT MAP.SMVolSnapMapId, MAP.SMVolumeId, MAP.SMSnapId, MAP.MetaDataId, DEL.DeleteMode
		FROM	@tblVolPhyDelLREP DEL, SMVolSnapMap MAP (READUNCOMMITTED)
		WHERE	DEL.SMVolumeId = MAP.SMVolumeId
		-- If SCG volume in XML input has snap which is also referred by volume
		-- in SMVolume table in DB which is not part of XML input, then the
		-- volume needs to be logically deleted.
		INSERT	INTO @tblVolLogDelSCG
		SELECT	DISTINCT A.SMVolumeId
		FROM	@tblSharedVolSnaps A, @tblSharedVolSnaps B
WHERE	(A.VolumeFlags & 8192 = 8192)
				AND A.SMSnapId = B.SMSnapId AND A.SourcePath = B.SourcePath AND A.SourceGUID = B.SourceGUID
				AND A.SMVolumeId IN (SELECT SMVolumeId FROM @tblSMVolume)
				AND B.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
AND B.MountStatus <> 99
		-- Add the volumes for VSA v2
		INSERT	INTO @tblVolLogDelSCG
		SELECT	DISTINCT A.SMVolumeId
		FROM	@tblSharedVolSnaps A, @tblSharedVolSnaps B
		WHERE	(A.VolumeFlags & CAST(4294967296 AS BIGINT) =  CAST(4294967296 AS BIGINT))
				AND A.SMSnapId = B.SMSnapId
				AND A.SMVolumeId IN (SELECT SMVolumeId FROM @tblSMVolume)
				AND B.SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblSMVolume)
AND B.MountStatus <> 99
		-- Set flag to logically delete these SCG volumes
		INSERT	INTO @tblReturn
SELECT	DISTINCT b.SMVolSnapMapId, b.SMVolumeId, b.SMSnapId, b.MetaDataId, 1
		FROM	@tblVolLogDelSCG a, SMVolSnapMap b (READUNCOMMITTED)
		WHERE	a.SMVolumeId = b.SMVolumeId
	END
	-- Physically delete remaining volumes
	INSERT	INTO @tblReturn
SELECT	DISTINCT b.SMVolSnapMapId, b.SMVolumeId, b.SMSnapId, b.MetaDataId, 2
	FROM	@tblSMVolume a, SMVolSnapMap b (READUNCOMMITTED)
	WHERE	a.SMVolumeId = b.SMVolumeId
			AND a.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM @tblReturn)
	-- Get volumes without snap to delete
	INSERT INTO @tblReturn
	SELECT 0, SMVolumeId, 0, 0, 0
	FROM @tblSMVolume
	WHERE SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM @tblReturn)
	-- EXTERNAL BACKUP ENGINE & CVBLOCK SNAP Engine
	-- Snap Deletion - DB Only Op
	UPDATE RET
SET RET.DeleteMode = 1
	FROM @tblReturn RET
	INNER JOIN SMSnap Snap (READUNCOMMITTED)
	ON RET.SMSnapId = Snap.SMSnapId
WHERE Snap.SnapshotEngineId IN ( 51, 53)
	-----------------------------------------------------------------------------
	-- Get metadata referenced to volume and snap
	-----------------------------------------------------------------------------
	INSERT INTO @tblReturn
SELECT	DISTINCT 0, a.SMVolumeId, 0, b.MetaDataId, 2
	FROM	@tblSMVolume a, SMMetaData b (READUNCOMMITTED)
WHERE	b.RefType = 1
	AND		a.SMVolumeId = b.RefId
	INSERT INTO @tblReturn
SELECT	DISTINCT 0, 0, a.SMSnapId, b.MetaDataId, 2
	FROM	@tblReturn a, SMMetaData b (READUNCOMMITTED)
WHERE	b.RefType = 2
	AND		a.SMSnapId = b.RefId
	---------------------------------------------------------------
	-- VSA AppAware Child Snap - Set flag to logically delete these volumes
	-------------------------------------------------------------
	UPDATE RET
SET RET.DeleteMode = 1
	FROM  @tblReturn RET
	INNER JOIN @tblSMVolume V
	ON RET.SMVolumeId = V.SMVolumeId
WHERE V.VolumeFlags & 131072 = 131072
	IF @isForceDeleteOperation = 1
	BEGIN
		UPDATE RET
SET RET.DeleteMode = 1
		FROM @tblReturn RET
	END
CX_EXIT:
    IF @ErrorCode > 0
        SELECT 0, 0, 0, 0, 0, @ErrorCode, @ErrorStr, 0, 0
    ELSE
    	SELECT *, @ErrorCode, @ErrorStr, 0, 0
    	FROM @tblReturn
    	ORDER BY SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsToDelete')
	delete from GxQscripts where name = 'MM_SMVolSnapsToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsToDelete')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsToDelete'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsToDelete',  '00010040000200220000', 'MM_SMVolSnapsToDelete', '00010040000200220000')
GO

