

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMVolSnapsCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMVolSnapsCleanup.sp,v $ $Id: MM_SMVolSnapsCleanup.sp,v 1.2.276.2 2018/03/20 00:10:15 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMVolSnapsCleanup <<<'

IF EXISTS (select * from sysobjects where name='MM_SMVolSnapsCleanup')
	drop procedure MM_SMVolSnapsCleanup
IF EXISTS (select * from GxQscripts where name='MM_SMVolSnapsCleanup')
	delete from GxQscripts where name = 'MM_SMVolSnapsCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsCleanup')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsCleanup'
GO
print '... Creating Procedure: MM_SMVolSnapsCleanup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMVolSnapsCleanup
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_GroupIndex integer
  DECLARE @o_SnapShotEngineId integer
  DECLARE @o_ControlHostId integer
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @RetryParam integer
	SET @RetryParam = ISNULL((select Value from MMConfigs where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 5)
	DECLARE @tblVolList TABLE (
		SMVolumeId		integer,
		ExpirationTime	integer,
		UpdateTime		integer
		)
	DECLARE @tblVolsInAction TABLE (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		UpdateTime		integer,
		RetryCount		integer
		)
	DECLARE @tblVolsToRevert TABLE (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		UpdateTime		integer,
		RetryCount		integer
		)
	DECLARE @tblVolsToDelete TABLE (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		UpdateTime		integer,
		RetryCount		integer
		)
	DECLARE @tblVolsToUnmount TABLE (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		UpdateTime		integer,
		RetryCount		integer
		)
	DECLARE @tblUnmount TABLE (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer
		)
	DECLARE @tblVolsInRunningJobs TABLE (
			SMVolumeId		integer
		)
	DECLARE @tblReturn TABLE (
			GroupIndex			integer,
			SnapShotEngineId	integer,
			ControlHostId		integer,
			MountHostId			integer,
			JobId				integer,
			SMVolSnapMapId		integer,
			SMVolumeId			integer,
			SMSnapId			integer,
			MetaDataId			integer
		)
	DECLARE @tblReturnGroup TABLE (
			GroupIndex			integer IDENTITY(1, 1),
			SnapShotEngineId	integer,
			ControlHostId		integer,
			MountHostId			integer
		)
	-- Get all volumes reserved by running, waiting and suspended jobs
	INSERT INTO @tblVolsInRunningJobs
	SELECT DISTINCT A.SMVolumeId
	FROM SMSnapResource A WITH (NOLOCK), JMJobInfo B WITH (NOLOCK)
	WHERE A.JobId = B.JobId
	AND B.state in (1, 3, 5)
	-- Job State - Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_PENDING INTEGER;
	SET @JOB_STATE_PENDING = 2
	-- Constant Definition as in EvDebug.h
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	DECLARE @CurrentTime INTEGER;
	SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
	------------------------------------------------------------------
	-- Reset MountStatus for volumes unmonted
	-- No rolling back
	-- VMLTODO: Need to check what should be done in case MountHostId = 0 but MountPath is not empty
	------------------------------------------------------------------
	UPDATE SMVolume
SET MountStatus = 79,
		MountStatusUpdateTime = @CurrentTime,
		RetryCount = 0
	WHERE MountHostId = 0 AND MountPath = N''
AND MountStatus >= 40 AND MountStatus < 79
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Release reservations for volumes unmonted
	-- No rolling back
	-- VMLTODO: Need to check what should be done in case MountHostId = 0 but MountPath is not empty
	------------------------------------------------------------------
	DELETE SMSnapResource
	FROM SMSnapResource A WITH (NOLOCK), SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.MountHostId = 0 AND B.MountPath = N''
	AND ( A.JobId = @JOBID_NA OR A.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK)))
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Cleanup dangling actions
	-- No rolling back
	------------------------------------------------------------------
	DELETE SMVolAction
	FROM SMVolAction A WITH (NOLOCK), SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND A.JobId > 0 AND A.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- BEGIN TRANSACTION
	------------------------------------------------------------------
	BEGIN TRANSACTION CleanupVolumeMountsTran
	------------------------------------------------------------------
	-- Get All Volumes in Actions (from SMVolAction)
	------------------------------------------------------------------
	INSERT INTO @tblVolsInAction
	SELECT A.SMVolumeId, A.MountHostId, A.MountStatus,
			(CASE WHEN A.MountStatusUpdateTime > B.StartTime
			 THEN A.MountStatusUpdateTime
			 ELSE B.StartTime
			 END), A.RetryCount
	FROM  SMVolume A WITH (NOLOCK), SMVolAction B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	INSERT INTO @tblVolList
	SELECT SMVolumeId, 0, UpdateTime
	FROM @tblVolsInAction
	------------------------------------------------------------------
	-- Get volumes are being reverted
	------------------------------------------------------------------
	INSERT INTO @tblVolsToRevert
	SELECT SMVolumeId, MountHostId, MountStatus, MountStatusUpdateTime, RetryCount
	FROM  SMVolume WITH (NOLOCK)
WHERE MountStatus >= 80 AND MountStatus < 89
AND PruneFlags = 1
	INSERT INTO @tblVolList
	SELECT SMVolumeId, 0, UpdateTime
	FROM @tblVolsToRevert
	------------------------------------------------------------------
	-- Get Volumes for Delete
	------------------------------------------------------------------
	INSERT INTO @tblVolsToDelete
	SELECT SMVolumeId, MountHostId, MountStatus, MountStatusUpdateTime, RetryCount
	FROM  SMVolume WITH (NOLOCK)
WHERE MountStatus >= 90 AND MountStatus < 99
AND PruneFlags <> 5
	INSERT INTO @tblVolList
	SELECT SMVolumeId, 0, UpdateTime
	FROM @tblVolsToDelete
	------------------------------------------------------------------
	-- Get Volumes for Unmount
	-- Volume mounted, partially mounted, or Failed to be unmounted
	------------------------------------------------------------------
	INSERT INTO @tblVolsToUnmount
	SELECT SMVolumeId, MountHostId, MountStatus, MountStatusUpdateTime, RetryCount
	FROM  SMVolume WITH (NOLOCK)
	WHERE MountHostId > 0
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblVolsInRunningJobs)
AND MountStatus >= 40 AND MountStatus < 79
	AND RetryCount < @RetryParam
	INSERT INTO @tblVolList
	SELECT SMVolumeId, 0, UpdateTime
	FROM @tblVolsToUnmount
	------------------------------------------------------------------
	-- Calculate ExpirationTime
	------------------------------------------------------------------
	UPDATE @tblVolList
	SET ExpirationTime = UpdateTime + D.MountStatusUpdateExpiryInterval * 60
	FROM  @tblVolList A, SMVolSnapMap B WITH (NOLOCK),
		  SMSnap C WITH (NOLOCK), SMSnapShotEngine D WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.SMSnapId = C.SMSnapId
	AND C.SnapShotEngineId = D.SnapShotEngineId
	------------------------------------------------------------------
	-- Delete Dangling Actions
	------------------------------------------------------------------
	DELETE SMVolAction
	FROM SMVolAction A, @tblVolsInAction B, @tblVolList C
	WHERE A.SMVolumeId = B.SMVolumeId AND B.SMVolumeId = C.SMVolumeId
	AND C.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Update volumes of expired revert
	------------------------------------------------------------------
	UPDATE SMVolume
SET MountStatus = 79,
		MountStatusUpdateTime = @CurrentTime
	FROM SMVolume A, @tblVolsToRevert B, @tblVolList C
	WHERE A.SMVolumeId = B.SMVolumeId AND B.SMVolumeId = C.SMVolumeId
	AND C.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Update volumes of expired delete
	------------------------------------------------------------------
	UPDATE SMVolume
SET PruneFlags = 5
	FROM SMVolume A, @tblVolsToDelete B, @tblVolList C
	WHERE A.SMVolumeId = B.SMVolumeId AND B.SMVolumeId = C.SMVolumeId
	AND C.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- COMMIT TRANSACTION
	------------------------------------------------------------------
	COMMIT TRANSACTION CleanupVolumeMountsTran
	------------------------------------------------------------------
	-- Get volumes of to be unmounted
	------------------------------------------------------------------
	INSERT INTO @tblUnmount
	SELECT SMVolumeId, MountHostId, 0
	FROM @tblVolsToUnmount
	WHERE SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource B WITH (NOLOCK))
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get volumes of reserved but partially mounted
	------------------------------------------------------------------
	INSERT INTO @tblUnmount
	SELECT A.SMVolumeId, A.MountHostId, B.JobId
	FROM @tblVolsToUnmount A, SMSnapResource B WITH (NOLOCK), @tblVolList C
	WHERE A.SMVolumeId = B.SMVolumeId AND B.SMVolumeId = C.SMVolumeId
	AND (
			(
				-- Expired mount or unmount
				C.ExpirationTime < @CurrentTime
			)
			OR
			(	-- Application Mounts for non-running job
				B.JobId != @JOBID_NA AND
				B.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
			)
			OR
			(	-- Application Mounts incomplete for pending job
				B.JobId != @JOBID_NA AND
				B.JobId IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK) WHERE STATE = @JOB_STATE_PENDING)
			)
		)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	DELETE FROM @tblUnmount
	FROM @tblUnmount A, @tblVolsToUnmount B
WHERE A.SMVolumeId = B.SMVolumeId AND A.JobId = @JOBID_NA AND B.MountStatus = 59
	-----------------------------------
	-- Get OUTPUT
	-----------------------------------
	INSERT INTO @tblReturn
	SELECT DISTINCT 0, C.SnapShotEngineId, C.ControlHostId, A.MountHostId, A.JobId, B.SMVolSnapMapId, B.SMVolumeId, B.SMSnapId, B.MetaDataId
	FROM @tblUnmount A, SMVolSnapMap B WITH (NOLOCK), SMSnap C WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.SMSnapId = C.SMSnapId
	AND C.SnapShotEngineId > 0 AND C.SnapShotEngineId IN (SELECT SnapShotEngineId FROM SMSnapShotEngine)
	AND C.ControlHostId > 0 AND C.ControlHostId IN (SELECT ControlHostId FROM SMControlHost)
	ORDER BY C.SnapShotEngineId, C.ControlHostId, A.MountHostId, A.JobId, B.SMVolumeId, B.SMSnapId, B.MetaDataId
	insert into @tblReturnGroup
	select distinct SnapShotEngineId, ControlHostId, MountHostId
	from @tblReturn
	order by SnapShotEngineId, ControlHostId, MountHostId
	update @tblReturn
	set GroupIndex = B.GroupIndex
	from @tblReturn A, @tblReturnGroup B
	where A.SnapShotEngineId = B.SnapShotEngineId
	and A.ControlHostId = B.ControlHostId
	and A.MountHostId = B.MountHostId
	insert into @tblReturn
	select A.GroupIndex, A.SnapShotEngineId, A.ControlHostId, A.MountHostId, A.JobId, 0, B.RefId, 0, B.MetaDataId
	from @tblReturn A, SMMetaData B WITH (NOLOCK)
where B.RefType = 1
	and B.RefId in (Select Distinct SMVolumeId from @tblReturn)
	insert into @tblReturn
	select A.GroupIndex, A.SnapShotEngineId, A.ControlHostId, A.MountHostId, A.JobId, 0, 0, B.RefId, B.MetaDataId
	from @tblReturn A, SMMetaData B WITH (NOLOCK)
where B.RefType = 2
	and B.RefId in (Select Distinct SMSnapId from @tblReturn)
	SELECT * FROM @tblReturn
	ORDER BY GroupIndex, SnapShotEngineId, ControlHostId, MountHostId, JobId, SMVolumeId, SMSnapId, MetaDataId
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION CleanupVolumeMountsTran
	delete from @tblReturn
	select * from @tblReturn
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMVolSnapsCleanup')
	delete from GxQscripts where name = 'MM_SMVolSnapsCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMVolSnapsCleanup')
	delete from GXDBVersions where aliasname = 'MM_SMVolSnapsCleanup'
GO

insert into GXDBVersions values(2, 'MM_SMVolSnapsCleanup',  '00010002027600020000', 'MM_SMVolSnapsCleanup', '00010002027600020000')
GO

