

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMValidationForUnmount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMValidationForUnmount.sp,v $ $Id: MM_SMValidationForUnmount.sp,v 1.6.210.2 2018/03/20 00:10:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMValidationForUnmount <<<'

IF EXISTS (select * from sysobjects where name='MM_SMValidationForUnmount')
	drop procedure MM_SMValidationForUnmount
IF EXISTS (select * from GxQscripts where name='MM_SMValidationForUnmount')
	delete from GxQscripts where name = 'MM_SMValidationForUnmount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForUnmount')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForUnmount'
GO
print '... Creating Procedure: MM_SMValidationForUnmount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMValidationForUnmount
  @i_SMVolumeId integer,
  @i_JobId integer,
  @i_HostId integer
AS
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorStr varchar(1024)
  DECLARE @o_MountHostId integer
  DECLARE @o_MountStatus integer
  DECLARE @o_PruneFlags integer
  DECLARE @o_MountPath NVARCHAR(1024)
  DECLARE @o_IsReserved integer
  DECLARE @o_OpCompleted integer
  DECLARE @o_UnmountMode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @SMVolumeId			INTEGER
	DECLARE @PruneFlags			INTEGER
	DECLARE @MountStatus		INTEGER
	DECLARE @MountHostId		INTEGER
DECLARE @MountPath			NVARCHAR(1024)
	DECLARE @IsReserved			INTEGER
	DECLARE @OpCompleted		INTEGER
	DECLARE @UnmountMode		INTEGER
	SET @ErrorCode = 0
	SET @ErrorStr = ''
	SET @SMVolumeId = 0
	SET @PruneFlags = 0
	SET @MountStatus = 0
	SET @MountHostId = 0
	SET @MountPath = ''
	SET @IsReserved = 0
	SET @OpCompleted = 0
	SET @UnmountMode = 0
	DECLARE	@tblMountStatus TABLE (
			MountStatus integer
		)
	DECLARE @defaultCCId INT = 2
INSERT INTO @tblMountStatus SELECT 39
INSERT INTO @tblMountStatus SELECT 59
INSERT INTO @tblMountStatus SELECT 79
INSERT INTO @tblMountStatus SELECT 89
	SELECT	@SMVolumeId = A.SMVolumeId,
			@PruneFlags = A.PruneFlags,
			@MountHostId = A.MountHostId,
			@MountStatus = A.MountStatus,
			@MountPath = A.MountPath
	FROM SMVolume A WITH (NOLOCK)
	WHERE A.SMVolumeId = @i_SMVolumeId
	IF @@ROWCOUNT = 0
	BEGIN
SET @ErrorCode = 60210
		SET @ErrorStr = 'Volume does not exist.'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId
				AND JobId = @i_JobId )
	BEGIN
		SET @IsReserved = 1
	END
	-----------------------------------------------------------------------------
	-- Invalid host
	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MMHost WHERE ClientId = @i_HostId)
	BEGIN
SET @ErrorCode = 60204
		SET @ErrorStr = 'Mount host does not exist. HostId: [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF @i_JobId > 0 AND NOT EXISTS (select * from JMJobInfo where JobId = @i_JobId and commCellId = @defaultCCId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is no longer running. JobId: [' + Convert(varchar(10), @i_JobId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not unmount if there is other operation running
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMVolAction WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
SET @ErrorCode = 60212
		SET @ErrorStr = 'Volume is in SMVolAction table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not unmount if volume is being mounted to different host
	-----------------------------------------------------------------------------
	IF @MountHostId <> 0 AND @MountHostId <> @i_HostId
	BEGIN
SET @ErrorCode = 60205
		SET @ErrorStr = 'Volume is mounted to host [' + Convert(varchar(10), @MountHostId) + ']. Cannot unmount it from host [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not unmount if volume is being processed by other operation
	-----------------------------------------------------------------------------
	-- IF @MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus)
IF @MountStatus < 40 AND @MountStatus > 79
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Volume is being processed by other operation. MountStatus: [' + Convert(varchar(10), @MountStatus) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume unmounted if volume is unreserved for the given job
	-----------------------------------------------------------------------------
	IF @IsReserved = 0 AND @MountHostId = 0
	BEGIN
		SET @OpCompleted = 1
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume unmounted but volume is still reserved for the given job
	-----------------------------------------------------------------------------
	IF @IsReserved = 1 AND @MountHostId = 0
	BEGIN
SET @UnmountMode = 0
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Need to check linked snap and volume status
	--
	-- YLUTODO: WHAT WE REALLY NEED IS THE VOLUME GROUP INFORMATION
	--          THAT INFORMATION IS CURRENTLY STORED IN METADATA TABLE IN XML
	--          IT IS IMPOSSIBLE TO DO JOIN AND SEARCH ON IT
	-----------------------------------------------------------------------------
	DECLARE @tblSnapForVol TABLE ( SMSnapId integer, MountStatus integer )
	DECLARE @tblVolLinked TABLE ( SMVolumeId integer, MountHostId integer, MountStatus integer )
	--Get all the snaps of given volume
	INSERT INTO @tblSnapForVol
	SELECT DISTINCT SMSnapId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMVolumeId = @i_SMVolumeId
	--Get all the volumes linked to snap of given volume
	INSERT INTO @tblVolLinked
	SELECT DISTINCT SMVolumeId, 0, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMSnapId in (SELECT SMSnapId FROM @tblSnapForVol) AND SMVolumeId = @i_SMVolumeId
	UPDATE @tblVolLinked
	SET MountHostId = B.MountHostId, MountStatus = B.MountStatus
	FROM @tblVolLinked A, SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	UPDATE @tblSnapForVol
	SET MountStatus = C.MountStatus
	FROM @tblSnapForVol A, SMVolSnapMap B WITH (NOLOCK), @tblVolLinked C
	WHERE A.SMSnapId = B.SMSnapId
	AND B.SMVolumeId = C.SMVolumeId
AND C.MountStatus = 59
	AND C.SMVolumeId <> @i_SMVolumeId
	-----------------------------------------------------------------------------
	-- Do not unmount if snap of volume is being processed by other operation
	-----------------------------------------------------------------------------
	/*
	IF EXISTS (	SELECT * FROM @tblVolLinked
				WHERE MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus) )
	*/
	IF EXISTS (	SELECT * FROM @tblVolLinked
WHERE MountStatus < 40 OR MountStatus > 79)
	BEGIN
SET @ErrorCode = 60208
		SET @ErrorStr = 'Snap of volume is currently being processed by other operation.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- SET UNMOUNT MODE:
	-- YLUTODO: This logic does not work for multiple volumes.
	--				We may endup not doing clean up for volumes needed.
	-----------------------------------------------------------------------------
IF	NOT EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus =  59)
	BEGIN
SET @UnmountMode = 16
	END
ELSE IF	EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus =  59)
	BEGIN
SET @UnmountMode = 1
	END
CX_EXIT:
CX_ERROR_EXIT:
	SELECT @ErrorCode, @ErrorStr, @MountHostId, @MountStatus, @PruneFlags, @MountPath, @IsReserved, @OpCompleted, @UnmountMode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMValidationForUnmount')
	delete from GxQscripts where name = 'MM_SMValidationForUnmount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForUnmount')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForUnmount'
GO

insert into GXDBVersions values(2, 'MM_SMValidationForUnmount',  '00010006021000020000', 'MM_SMValidationForUnmount', '00010006021000020000')
GO

