

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMValidationForRevert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMValidationForRevert.sp,v $ $Id: MM_SMValidationForRevert.sp,v 1.2.278.2 2018/03/20 00:04:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMValidationForRevert <<<'

IF EXISTS (select * from sysobjects where name='MM_SMValidationForRevert')
	drop procedure MM_SMValidationForRevert
IF EXISTS (select * from GxQscripts where name='MM_SMValidationForRevert')
	delete from GxQscripts where name = 'MM_SMValidationForRevert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForRevert')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForRevert'
GO
print '... Creating Procedure: MM_SMValidationForRevert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMValidationForRevert
  @i_SMVolumeId integer,
  @i_JobId integer,
  @i_HostId integer
AS
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorStr varchar(1024)
  DECLARE @o_MountHostId integer
  DECLARE @o_MountStatus integer
  DECLARE @o_PruneFlags integer
  DECLARE @o_MountPath NVARCHAR(1024)
  DECLARE @o_IsReserved integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @SMVolumeId			INTEGER
	DECLARE @ArchFileId			INTEGER
	DECLARE @CommCellId			INTEGER
	DECLARE @CopyId				INTEGER
	DECLARE @PruneFlags			INTEGER
	DECLARE @MountStatus		INTEGER
	DECLARE @MountHostId		INTEGER
	DECLARE @SourceClientId		INTEGER
DECLARE @MountPath			NVARCHAR(1024)
	DECLARE @IsReserved			INTEGER
	DECLARE @JobReserved		INTEGER
	SET @ErrorCode = 0
	SET @ErrorStr = ''
	SET @SMVolumeId = 0
	SET @ArchFileId = 0
	SET @CommCellId = 0
	SET @CopyId = 0
	SET @PruneFlags = 0
	SET @MountStatus = 0
	SET @MountHostId = 0
	SET @SourceClientId = 0
	SET @MountPath = ''
	SET @IsReserved = 0
	SET @JobReserved = 0
	DECLARE	@tblMountStatus TABLE (
			MountStatus integer
		)
INSERT INTO @tblMountStatus SELECT 39
INSERT INTO @tblMountStatus SELECT 79
INSERT INTO @tblMountStatus SELECT 89
	SELECT	@SMVolumeId = A.SMVolumeId,
			@ArchFileId = A.ArchFileId,
			@CommCellId = A.CommCellId,
			@CopyId = A.CopyId,
			@PruneFlags = A.PruneFlags,
			@MountHostId = A.MountHostId,
			@SourceClientId = A.SourceClientId,
			@MountStatus = A.MountStatus,
			@MountPath = A.MountPath
	FROM SMVolume A WITH (NOLOCK)
	WHERE A.SMVolumeId = @i_SMVolumeId
	IF @@ROWCOUNT = 0
	BEGIN
SET @ErrorCode = 60210
		SET @ErrorStr = 'Volume does not exist.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is reserved
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId
				AND JobId = @i_JobId )
	BEGIN
		SET @IsReserved = 1
	END
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
		SET @JobReserved = ISNULL((SELECT TOP 1 jobId FROM SMSnapResource WITH (NOLOCK)
									WHERE SMVolumeId = @i_SMVolumeId), 0)
		IF @JobReserved <> 0
		BEGIN
SET @ErrorCode = 60214
			SET @ErrorStr = 'Volume is reserved by Job ['  + Convert(varchar(10), @JobReserved) + ']'
			GOTO CX_ERROR_EXIT
		END
	END
	-----------------------------------------------------------------------------
	-- Invalid host
	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MMHost WHERE ClientId = @i_HostId)
	BEGIN
SET @ErrorCode = 60204
		SET @ErrorStr = 'Mount host does not exist. HostId: [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF @i_JobId > 0 AND NOT EXISTS (SELECT * FROM JMJobInfo WHERE JobId = @i_JobId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is no longer running. JobId: [' + Convert(varchar(10), @i_JobId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is aged
	-----------------------------------------------------------------------------
IF @PruneFlags <> 1
	BEGIN
SET @ErrorCode = 60202
		SET @ErrorStr = 'Volume is either inactive or pruned. PruneFlags: [' + Convert(varchar(10), @PruneFlags) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is aged
	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM ArchFileCopy WITH (NOLOCK)
					WHERE ArchFileId = @ArchFileId
					AND CommCellId = @CommCellId
					AND ArchCopyId = @CopyId)
	BEGIN
SET @ErrorCode = 60216
		SET @ErrorStr = 'Volume is not in ArchFileCopy table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not revert if there is other operation running
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMVolAction WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
SET @ErrorCode = 60212
		SET @ErrorStr = 'Volume is in SMVolAction table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Cannot revert volume from host other than SourceClientId
	-----------------------------------------------------------------------------
	IF @SourceClientId <> @i_HostId
	BEGIN
SET @ErrorCode = 60213
		SET @ErrorStr = 'Cannot revert volume from host [' + Convert(varchar(10), @i_HostId) + ']. SourceClientId: [' + Convert(varchar(10), @SourceClientId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not revert if volume is mounted or being processed by other operation
	-----------------------------------------------------------------------------
	IF @MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus)
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Volume is being processed by other operation. MountStatus: [' + Convert(varchar(10), @MountStatus) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Need to check linked snap and volume status
	--
	-- YLUTODO: WHAT WE REALLY NEED IS THE VOLUME GROUP INFORMATION
	--          THAT INFORMATION IS CURRENTLY STORED IN METADATA TABLE IN XML
	--          IT IS IMPOSSIBLE TO DO JOIN AND SEARCH ON IT
	-----------------------------------------------------------------------------
	DECLARE @tblSnapForVol TABLE ( SMSnapId integer, MountStatus integer )
	DECLARE @tblVolLinked TABLE ( SMVolumeId integer, MountStatus integer )
	--Get all the snaps of given volume
	INSERT INTO @tblSnapForVol
	SELECT DISTINCT SMSnapId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMVolumeId = @i_SMVolumeId
	--Get all the volumes linked to snap of given volume
	INSERT INTO @tblVolLinked
	SELECT DISTINCT SMVolumeId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMSnapId in (SELECT SMSnapId FROM @tblSnapForVol)
	UPDATE @tblVolLinked
	SET MountStatus = B.MountStatus
	FROM @tblVolLinked A, SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	-----------------------------------------------------------------------------
	-- Do not revert if snap of volume is mounted or being processed by other operation
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM @tblVolLinked
				WHERE MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus) )
	BEGIN
SET @ErrorCode = 60208
		SET @ErrorStr = 'Snap of volume is currently being processed by other operation.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- YLUTODO: Relationship of multiple snaps and volumes need to be verifed.
	--				This cannot be done with single volume validation.
	-----------------------------------------------------------------------------
CX_EXIT:
CX_ERROR_EXIT:
	SELECT @ErrorCode, @ErrorStr, @MountHostId, @MountStatus, @PruneFlags, @MountPath, @IsReserved
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMValidationForRevert')
	delete from GxQscripts where name = 'MM_SMValidationForRevert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForRevert')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForRevert'
GO

insert into GXDBVersions values(2, 'MM_SMValidationForRevert',  '00010002027800020000', 'MM_SMValidationForRevert', '00010002027800020000')
GO

