

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMValidationForMount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMValidationForMount.sp,v $ $Id: MM_SMValidationForMount.sp,v 1.7.210.2 2018/03/20 00:09:29 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMValidationForMount <<<'

IF EXISTS (select * from sysobjects where name='MM_SMValidationForMount')
	drop procedure MM_SMValidationForMount
IF EXISTS (select * from GxQscripts where name='MM_SMValidationForMount')
	delete from GxQscripts where name = 'MM_SMValidationForMount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForMount')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForMount'
GO
print '... Creating Procedure: MM_SMValidationForMount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMValidationForMount
  @i_SMVolumeId integer,
  @i_JobId integer,
  @i_HostId integer
AS
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorStr varchar(1024)
  DECLARE @o_MountHostId integer
  DECLARE @o_MountStatus integer
  DECLARE @o_PruneFlags integer
  DECLARE @o_MountPath NVARCHAR(1024)
  DECLARE @o_IsReserved integer
  DECLARE @o_OpCompleted integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @SMVolumeId			INTEGER
	DECLARE @ArchFileId			INTEGER
	DECLARE @CommCellId			INTEGER
	DECLARE @CopyId				INTEGER
	DECLARE @PruneFlags			INTEGER
	DECLARE @MountStatus		INTEGER
	DECLARE @MountHostId		INTEGER
DECLARE @MountPath			NVARCHAR(1024)
	DECLARE @IsReserved			INTEGER
	DECLARE @JobReserved		INTEGER
	DECLARE @OpCompleted		INTEGER
	DECLARE @defaultCCId INT = 2
	SET @ErrorCode = 0
	SET @ErrorStr = ''
	SET @SMVolumeId = 0
	SET @ArchFileId = 0
	SET @CommCellId = 0
	SET @CopyId = 0
	SET @PruneFlags = 0
	SET @MountStatus = 0
	SET @MountHostId = 0
	SET @MountPath = ''
	SET @IsReserved = 0
	SET @JobReserved = 0
	SET @OpCompleted = 0
	DECLARE	@tblMountStatus TABLE (
			MountStatus integer
		)
INSERT INTO @tblMountStatus SELECT 39
INSERT INTO @tblMountStatus SELECT 59
INSERT INTO @tblMountStatus SELECT 79
INSERT INTO @tblMountStatus SELECT 89
	SELECT	@SMVolumeId = A.SMVolumeId,
			@ArchFileId = A.ArchFileId,
			@CommCellId = A.CommCellId,
			@CopyId = A.CopyId,
			@PruneFlags = A.PruneFlags,
			@MountHostId = A.MountHostId,
			@MountStatus = A.MountStatus,
			@MountPath = A.MountPath
	FROM SMVolume A WITH (NOLOCK)
	WHERE A.SMVolumeId = @i_SMVolumeId
	IF @@ROWCOUNT = 0
	BEGIN
SET @ErrorCode = 60210
		SET @ErrorStr = 'Volume does not exist.'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId
				AND JobId = @i_JobId )
	BEGIN
		SET @IsReserved = 1
	END
	-----------------------------------------------------------------------------
	-- Do not allow GUI mount if it is already mounted (reserved)
	-----------------------------------------------------------------------------
	IF @i_JobId = -12345
	BEGIN
		SET @JobReserved = ISNULL((SELECT TOP 1 jobId FROM SMSnapResource WITH (NOLOCK)
									WHERE SMVolumeId = @i_SMVolumeId), 0)
		IF @JobReserved <> 0
		BEGIN
SET @ErrorCode = 60214
			SET @ErrorStr = 'Volume cannot be mounted by user because it is reserved by Job ['  + Convert(varchar(10), @JobReserved) + ']'
			GOTO CX_ERROR_EXIT
		END
	END
	-----------------------------------------------------------------------------
	-- Invalid host
	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MMHost WHERE ClientId = @i_HostId)
	BEGIN
SET @ErrorCode = 60204
		SET @ErrorStr = 'Mount host does not exist. HostId: [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF @i_JobId > 0 AND NOT EXISTS (select * from JMJobInfo where JobId = @i_JobId and commCellId = @defaultCCId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is no longer running. JobId: [' + Convert(varchar(10), @i_JobId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is aged
	-----------------------------------------------------------------------------
IF @PruneFlags <> 1
	BEGIN
SET @ErrorCode = 60202
		SET @ErrorStr = 'Volume is either inactive or pruned. PruneFlags: [' + Convert(varchar(10), @PruneFlags) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid ArchFile Id
	-----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM ArchFileCopy WITH (NOLOCK)
					WHERE ArchFileId = @ArchFileId
					AND CommCellId = @CommCellId
					AND ArchCopyId = @CopyId)
	BEGIN
SET @ErrorCode = 60216
		SET @ErrorStr = 'Volume is not in ArchFileCopy table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not mount if there is other operation running
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMVolAction WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
SET @ErrorCode = 60212
		SET @ErrorStr = 'Volume is in SMVolAction table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not mount if volume is being mounted to different host
	-----------------------------------------------------------------------------
	IF @MountHostId <> 0 AND @MountHostId <> @i_HostId
	BEGIN
SET @ErrorCode = 60205
		SET @ErrorStr = 'Volume is mounted to host [' + Convert(varchar(10), @MountHostId) + ']. Cannot mount it to host [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not mount if Mount Status is other than that in @tblMountStatus
	-----------------------------------------------------------------------------
	IF @MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus)
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Volume is being processed by other operation. MountStatus: [' + Convert(varchar(10), @MountStatus) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is mounted and reserved for the given job and mount host
	-----------------------------------------------------------------------------
IF @IsReserved = 1 AND @MountStatus =  59 AND @MountHostId = @i_HostId
	BEGIN
		SET @OpCompleted = 1
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Need to check linked snap and volume status
	-----------------------------------------------------------------------------
	DECLARE @tblSnapForVol TABLE ( SMSnapId integer, MountStatus integer )
	DECLARE @tblVolLinked TABLE ( SMVolumeId integer, MountHostId integer, MountStatus integer )
	--Get all the snaps of given volume
	INSERT INTO @tblSnapForVol
	SELECT DISTINCT SMSnapId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMVolumeId = @i_SMVolumeId
	--Get all the volumes linked to snap of given volume
	INSERT INTO @tblVolLinked
	SELECT DISTINCT SMVolumeId, 0, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMSnapId in (SELECT SMSnapId FROM @tblSnapForVol) AND SMVolumeId = @i_SMVolumeId
	UPDATE @tblVolLinked
	SET MountHostId = B.MountHostId, MountStatus = B.MountStatus
	FROM @tblVolLinked A, SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	UPDATE @tblSnapForVol
	SET MountStatus = C.MountStatus
	FROM @tblSnapForVol A, SMVolSnapMap B WITH (NOLOCK), @tblVolLinked C
	WHERE A.SMSnapId = B.SMSnapId
	AND B.SMVolumeId = C.SMVolumeId
AND C.MountStatus = 59
	AND C.SMVolumeId <> @i_SMVolumeId
	-----------------------------------------------------------------------------
	-- Do not mount if snap of volume is being processed by other operation
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM @tblVolLinked
				WHERE MountStatus NOT IN (SELECT MountStatus FROM @tblMountStatus) )
	BEGIN
SET @ErrorCode = 60208
		SET @ErrorStr = 'Snap of volume is currently being processed by other operation.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not mount if snap of volume is being mounted to a different host
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM @tblVolLinked
				WHERE MountHostId <> 0
				AND MountHostId <> @i_HostId )
	BEGIN
SET @ErrorCode = 60206
		SET @ErrorStr = 'Snap of volume is being mounted to different host.'
 		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not mount if some snaps of volume are mounted and some are not
	-----------------------------------------------------------------------------
IF	EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus =  59)
AND	EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus <> 59)
	BEGIN
SET @ErrorCode = 60209
		SET @ErrorStr = 'Snaps of volume are partically mounted.'
		GOTO CX_ERROR_EXIT
	END
CX_EXIT:
CX_ERROR_EXIT:
	SELECT @ErrorCode, @ErrorStr, @MountHostId, @MountStatus, @PruneFlags, @MountPath, @IsReserved, @OpCompleted
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMValidationForMount')
	delete from GxQscripts where name = 'MM_SMValidationForMount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForMount')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForMount'
GO

insert into GXDBVersions values(2, 'MM_SMValidationForMount',  '00010007021000020000', 'MM_SMValidationForMount', '00010007021000020000')
GO

