

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMValidationForDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMValidationForDelete.sp,v $ $Id: MM_SMValidationForDelete.sp,v 1.4.210.2 2018/03/20 00:09:35 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMValidationForDelete <<<'

IF EXISTS (select * from sysobjects where name='MM_SMValidationForDelete')
	drop procedure MM_SMValidationForDelete
IF EXISTS (select * from GxQscripts where name='MM_SMValidationForDelete')
	delete from GxQscripts where name = 'MM_SMValidationForDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForDelete')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForDelete'
GO
print '... Creating Procedure: MM_SMValidationForDelete'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMValidationForDelete
  @i_SMVolumeId integer,
  @i_JobId integer,
  @i_HostId integer
AS
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorStr varchar(1024)
  DECLARE @o_MountHostId integer
  DECLARE @o_MountStatus integer
  DECLARE @o_PruneFlags integer
  DECLARE @o_MountPath NVARCHAR(1024)
  DECLARE @o_IsReserved integer
  DECLARE @o_OpCompleted integer
  DECLARE @o_UnmountMode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode			INTEGER
	DECLARE @ErrorStr			VARCHAR(1024)
	DECLARE @SMVolumeId			INTEGER
	DECLARE @PruneFlags			INTEGER
	DECLARE @MountStatus		INTEGER
	DECLARE @MountHostId		INTEGER
	DECLARE @SourceClientId		INTEGER
DECLARE @MountPath			NVARCHAR(1024)
	DECLARE @IsReserved			INTEGER
	DECLARE @JobReserved		INTEGER
	DECLARE @OpCompleted		INTEGER
	DECLARE @UnmountMode		INTEGER
	DECLARE @defaultCCId INT = 2
	SET @ErrorCode = 0
	SET @ErrorStr = ''
	SET @SMVolumeId = 0
	SET @PruneFlags = 0
	SET @MountStatus = 0
	SET @MountHostId = 0
	SET @SourceClientId = 0
	SET @MountPath = ''
	SET @IsReserved = 0
	SET @JobReserved = 0
	SET @OpCompleted = 0
	SET @UnmountMode = 0
	IF OBJECT_ID (N'tempdb..#tblSMVolumeMountStatus') IS NULL
	BEGIN
		CREATE TABLE #tblSMVolumeMountStatus
		( MountStatus integer )
	END
	IF NOT EXISTS (SELECT * FROM #tblSMVolumeMountStatus)
	BEGIN
		INSERT INTO #tblSMVolumeMountStatus SELECT 0
		INSERT INTO #tblSMVolumeMountStatus SELECT 10
		INSERT INTO #tblSMVolumeMountStatus SELECT 11
		INSERT INTO #tblSMVolumeMountStatus SELECT 12
		INSERT INTO #tblSMVolumeMountStatus SELECT 18
		INSERT INTO #tblSMVolumeMountStatus SELECT 19
		INSERT INTO #tblSMVolumeMountStatus SELECT 20
		INSERT INTO #tblSMVolumeMountStatus SELECT 28
		INSERT INTO #tblSMVolumeMountStatus SELECT 29
		INSERT INTO #tblSMVolumeMountStatus SELECT 30
		INSERT INTO #tblSMVolumeMountStatus SELECT 38
		INSERT INTO #tblSMVolumeMountStatus SELECT 39
		INSERT INTO #tblSMVolumeMountStatus SELECT 79
		INSERT INTO #tblSMVolumeMountStatus SELECT 80
		INSERT INTO #tblSMVolumeMountStatus SELECT 88
		INSERT INTO #tblSMVolumeMountStatus SELECT 89
		INSERT INTO #tblSMVolumeMountStatus SELECT 90
		INSERT INTO #tblSMVolumeMountStatus SELECT 98
		INSERT INTO #tblSMVolumeMountStatus SELECT 99
	END
	SELECT	@SMVolumeId = A.SMVolumeId,
			@PruneFlags = A.PruneFlags,
			@MountHostId = A.MountHostId,
			@SourceClientId = A.SourceClientId,
			@MountStatus = A.MountStatus,
			@MountPath = A.MountPath
	FROM SMVolume A WITH (NOLOCK)
	WHERE A.SMVolumeId = @i_SMVolumeId
	IF @@ROWCOUNT = 0
	BEGIN
SET @ErrorCode = 60210
		SET @ErrorStr = 'Volume does not exist.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Volume is reserved
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId
				AND JobId = @i_JobId )
	BEGIN
		SET @IsReserved = 1
	END
	IF EXISTS (	SELECT * FROM SMSnapResource WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
		SET @JobReserved = ISNULL((SELECT TOP 1 jobId FROM SMSnapResource WITH (NOLOCK)
									WHERE SMVolumeId = @i_SMVolumeId), 0)
		IF @JobReserved <> 0
		BEGIN
SET @ErrorCode = 60214
			SET @ErrorStr = 'Volume is reserved by Job ['  + Convert(varchar(10), @JobReserved) + ']'
			GOTO CX_ERROR_EXIT
		END
	END
	-----------------------------------------------------------------------------
	-- Volume is deleted already
	-----------------------------------------------------------------------------
IF @PruneFlags = 6
	BEGIN
		SET @OpCompleted = 1
		GOTO CX_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid host
	-----------------------------------------------------------------------------
	-- VMLTODO: May be this condition needs to be removed as in the case of deconfigured clients
	IF NOT EXISTS (SELECT * FROM MMHost WHERE ClientId = @i_HostId)
	BEGIN
SET @ErrorCode = 60204
		SET @ErrorStr = 'Mount host does not exist. HostId: [' + Convert(varchar(10), @i_HostId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Invalid job
	-----------------------------------------------------------------------------
	IF @i_JobId > 0 AND NOT EXISTS (select * from JMJobInfo where JobId = @i_JobId and commCellId = @defaultCCId)
	BEGIN
SET @ErrorCode = 60203
		SET @ErrorStr = 'Job is no longer running. JobId: [' + Convert(varchar(10), @i_JobId) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Do not delete if there is other operation running
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM SMVolAction WITH (NOLOCK)
				WHERE SMVolumeId = @i_SMVolumeId )
	BEGIN
SET @ErrorCode = 60212
		SET @ErrorStr = 'Volume is in SMVolAction table.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Cannot delete volume from host other than SourceClientId
	-----------------------------------------------------------------------------
	-- VMLTODO: This check will have to be removed for Snap Reconciliation and in case of snap operation through Proxy
	/*
	IF @SourceClientId <> @i_HostId
	BEGIN
SET @ErrorCode = 60213
		SET @ErrorStr = 'Volume cannot be deleted from host [' + Convert(varchar(10), @i_HostId) + ']. SourceClientId: [' + Convert(varchar(10), @SourceClientId) + ']'
		GOTO CX_ERROR_EXIT
	END
	*/
	-----------------------------------------------------------------------------
	-- Do not delete if volume is in other Mount Status
	-----------------------------------------------------------------------------
	IF @MountStatus NOT IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
	BEGIN
SET @ErrorCode = 60207
		SET @ErrorStr = 'Volume is being processed by other operation. MountStatus: [' + Convert(varchar(10), @MountStatus) + ']'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- Need to check linked snap and volume status
	--
	-- YLUTODO: WHAT WE REALLY NEED IS THE VOLUME GROUP INFORMATION
	--          THAT INFORMATION IS CURRENTLY STORED IN METADATA TABLE IN XML
	--          IT IS IMPOSSIBLE TO DO JOIN AND SEARCH ON IT
	-----------------------------------------------------------------------------
	DECLARE @tblSnapForVol TABLE ( SMSnapId integer, MountStatus integer )
	DECLARE @tblVolLinked TABLE ( SMVolumeId integer, MountStatus integer )
	--Get all the snaps of given volume
	INSERT INTO @tblSnapForVol
	SELECT DISTINCT SMSnapId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMVolumeId = @i_SMVolumeId
	--Get all the volumes linked to snap of given volume
	INSERT INTO @tblVolLinked
	SELECT DISTINCT SMVolumeId, 0
	FROM SMVolSnapMap WITH (NOLOCK)
	WHERE SMSnapId in (SELECT SMSnapId FROM @tblSnapForVol)
	AND SMVolumeId != @i_SMVolumeId
	UPDATE @tblVolLinked
	SET MountStatus = B.MountStatus
	FROM @tblVolLinked A, SMVolume B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	UPDATE @tblSnapForVol
	SET MountStatus = C.MountStatus
	FROM @tblSnapForVol A, SMVolSnapMap B WITH (NOLOCK), @tblVolLinked C
	WHERE A.SMSnapId = B.SMSnapId
	AND B.SMVolumeId = C.SMVolumeId
	AND C.MountStatus NOT IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
	AND C.SMVolumeId <> @i_SMVolumeId
	-----------------------------------------------------------------------------
	-- Do not delete if snap of volume is being processed by other operation
	-----------------------------------------------------------------------------
	IF EXISTS (	SELECT * FROM @tblVolLinked
				WHERE MountStatus NOT IN (SELECT MountStatus FROM #tblSMVolumeMountStatus) )
	BEGIN
SET @ErrorCode = 60208
		SET @ErrorStr = 'Snap of volume is currently being processed by other operation.'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------------------
	-- SET UNMOUNT MODE
	-----------------------------------------------------------------------------
IF @MountStatus <> 59
	BEGIN
SET @UnmountMode = 0
	END
ELSE IF	NOT EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus =  59)
	BEGIN
SET @UnmountMode = 16
	END
ELSE IF	EXISTS	(SELECT * FROM @tblSnapForVol WHERE MountStatus =  59)
	BEGIN
SET @UnmountMode = 1
	END
CX_EXIT:
CX_ERROR_EXIT:
	SELECT @ErrorCode, @ErrorStr, @MountHostId, @MountStatus, @PruneFlags, @MountPath, @IsReserved, @OpCompleted, @UnmountMode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMValidationForDelete')
	delete from GxQscripts where name = 'MM_SMValidationForDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMValidationForDelete')
	delete from GXDBVersions where aliasname = 'MM_SMValidationForDelete'
GO

insert into GXDBVersions values(2, 'MM_SMValidationForDelete',  '00010004021000020000', 'MM_SMValidationForDelete', '00010004021000020000')
GO

