

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateVolumeProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMUpdateVolumeProgress.sp,v $ $Id: MM_SMUpdateVolumeProgress.sp,v 1.1.2.1 2019/06/16 03:03:21 bbrindavan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMUpdateVolumeProgress')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMUpdateVolumeProgress <<<'
	drop procedure MM_SMUpdateVolumeProgress
END
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateVolumeProgress')
	delete from GxQscripts where name = 'MM_SMUpdateVolumeProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateVolumeProgress')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateVolumeProgress'
GO
print '... Creating Procedure: MM_SMUpdateVolumeProgress'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateVolumeProgress
  @i_xmlInput XML,
  @i_reserveInt INT
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
SET XACT_ABORT ON
/*
<MM_SMUpdateVolumeProgress>
	<ISSnapOpStat ReqId="1" WorkerProcessId="1" WorkerThreadId="2" >
		<Volume SMVolumeId="1" MountVolumeId="2"  />
		<Volume SMVolumeId="2" MountVolumeId="4"  />
		<Volume SMVolumeId="3" MountVolumeId="5"  />
	</ISSnapOpStat>
</MM_SMUpdateVolumeProgress>
*/
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
--Validate  Input XML
IF @i_xmlInput IS NULL
BEGIN
SET @o_ErrorCode = 60366 /*E_MM_SM_SP_IS_UPDATE_VOL_MNT_STATUS_TIME_FAILED */
    SET @o_ErrorStr = 'Input xml parameter cannot be empty.'
    GOTO PROC_END
END
-- Create Table from XML Input
IF OBJECT_ID('tempdb.dbo.#tblSMUpdateVolProgress') IS NOT NULL DROP TABLE #tblSMUpdateVolProgress
CREATE TABLE #tblSMUpdateVolProgress (ReqId int, WorkerProcessId int, WorkerThreadId int, SMVolumeId int,MountVolumeId int)
INSERT INTO #tblSMUpdateVolProgress(ReqId, SMVolumeId ,MountVolumeId,WorkerProcessId,WorkerThreadId)
SELECT
	oref.value('@ReqId','int'),
	vref.value('@SMVolumeId', 'int'),
	vref.value('@MountVolumeId', 'int'),
    oref.value('@WorkerProcessId', 'int'),
    oref.value('@WorkerThreadId', 'int')
FROM
    @i_xmlInput.nodes('/MM_SMUpdateVolumeProgress/ISSnapOpStat') AS OpStat(oref) CROSS APPLY
	oref.nodes('./Volume') AS Vol(vref)
--Validate  Input XML
IF NOT EXISTS (SELECT 1 FROM #tblSMUpdateVolProgress)
BEGIN
SET @o_ErrorCode = 60366 /*E_MM_SM_SP_IS_UPDATE_VOL_MNT_STATUS_TIME_FAILED */
    SET @o_ErrorStr = 'No volume id or mount volume id found in input xml'
    GOTO PROC_END
END
--Validate VolumeID
IF EXISTS (
	SELECT  1
	FROM    #tblSMUpdateVolProgress TMPVOL
	LEFT JOIN
			SMVolume(READUNCOMMITTED) VOL
	ON      VOL.SMVolumeId = TMPVOL.SMVolumeId
	WHERE   VOL.SMVolumeId IS NULL
)
BEGIN
SET @o_ErrorCode = 60366 /*E_MM_SM_SP_IS_UPDATE_VOL_MNT_STATUS_TIME_FAILED */
	SET @o_ErrorStr ='Invalid volume id found'
	GOTO PROC_END
END
--Validate MountVolume ID
IF EXISTS (
	SELECT  1
	FROM    #tblSMUpdateVolProgress TMPVOL
	LEFT JOIN
			SMMountVolume(READUNCOMMITTED) MV
	ON      MV.id = TMPVOL.MountVolumeId
	WHERE   TMPVOL.MountVolumeId<>0 AND MV.id IS NULL
)
BEGIN
SET @o_ErrorCode = 60366 /*E_MM_SM_SP_IS_UPDATE_VOL_MNT_STATUS_TIME_FAILED */
	SET @o_ErrorStr ='Invalid mount volume id found'
	GOTO PROC_END
END
BEGIN TRY
	BEGIN TRANSACTION
	-- Update SMVolAction Table
	UPDATE VOLACT
	SET VOLACT.CVMAProcessId = TMPVOL.WorkerProcessId,
		VOLACT.CVMAThreadId = TMPVOL.WorkerThreadId
	FROM #tblSMUpdateVolProgress TMPVOL
		JOIN SMVolAction VOLACT
			ON VOLACT.RequestId=TMPVOL.ReqId
				AND VOLACT.SMVolumeId=TMPVOL.SMVolumeId
	DECLARE @x_currentTime  INT = dbo.GetUnixTime (GetUTCdate())
	-- Update SMVolume Table - if SMVolume Operation
	UPDATE VOL
	SET VOL.MountStatusUpdateTime = @x_currentTime
	FROM #tblSMUpdateVolProgress TMPVOL
		JOIN SMVolume VOL
			ON TMPVOL.MountVolumeId = 0
				AND VOL.SMVolumeId = TMPVOL.SMVolumeId
	-- Update SMVolume Table - if SMMountVolume Operation
	UPDATE MVOL
	SET MVOL.MountStatusUpdateTime = @x_currentTime
	FROM #tblSMUpdateVolProgress TMPVOL
		JOIN SMMountVolume MVOL
			ON TMPVOL.MountVolumeId > 0
				AND MVOL.Id = TMPVOL.MountVolumeId
				AND MVOL.SMVolumeId = TMPVOL.SMVolumeId
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION
SET @o_ErrorCode = 60366 /*E_MM_SM_SP_IS_UPDATE_VOL_MNT_STATUS_TIME_FAILED */
	SET @o_ErrorStr ='ERROR: PROC(' + ERROR_PROCEDURE() +
					'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
					'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
					'), INFO: ' + ERROR_MESSAGE() + '.'
END CATCH
PROC_END:
SELECT @o_ErrorCode, @o_ErrorStr
IF OBJECT_ID('tempdb.dbo.#tblSMUpdateVolProgress') IS NOT NULL DROP TABLE #tblSMUpdateVolProgress
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateVolumeProgress')
	delete from GxQscripts where name = 'MM_SMUpdateVolumeProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateVolumeProgress')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateVolumeProgress'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateVolumeProgress',  '00010001000200010000', 'MM_SMUpdateVolumeProgress', '00010001000200010000')
GO

