

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateVolSnapsSMT.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMUpdateVolSnapsSMT.sp,v $ $Id: MM_SMUpdateVolSnapsSMT.sp,v 1.1.2.19 2020/09/24 23:59:26 cmarella Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMUpdateVolSnapsSMT')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMUpdateVolSnapsSMT <<<'
	drop procedure MM_SMUpdateVolSnapsSMT
END
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateVolSnapsSMT')
	delete from GxQscripts where name = 'MM_SMUpdateVolSnapsSMT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateVolSnapsSMT')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateVolSnapsSMT'
GO
print '... Creating Procedure: MM_SMUpdateVolSnapsSMT'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateVolSnapsSMT
  @i_xmlTextInput XML
AS
  DECLARE @o_xmlTextOutput XML--OUT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
    -- Input Paramters from XML String
    DECLARE @x_opCode               INT = 0
    DECLARE @x_flags                INT = 0
    DECLARE @x_SMArrayId            NVARCHAR(2048) = N''
    DECLARE @x_SMControlHostId      INT = -1
    DECLARE @x_NasClientId			INT = -1
    DECLARE @x_ExtDataSetId         NVARCHAR(2048) = N''
    DECLARE @x_oldVServer           NVARCHAR(2048) = N''
    DECLARE @x_newVServer           NVARCHAR(2048) = N''
    DECLARE @x_oldVolume            NVARCHAR(2048) = N''
    DECLARE @x_newVolume            NVARCHAR(2048) = N''
	DECLARE @o_ErrorCode  INTEGER
	DECLARE @o_ErrorStr   VARCHAR(MAX)
    -- Local Constants
    DECLARE @C_OPCODE_BEGIN                                 INT = 0
    DECLARE @C_OPCODE_VOLUME_RENAME                         INT = 1
    DECLARE @C_OPCODE_SNAP_RENAME                           INT = 2
    DECLARE @C_OPCODE_ARRAY_RENAME                          INT = 3
    DECLARE @C_OPCODE_ASSOC_NASCLIENT_TO_ARRAY              INT = 4
    DECLARE @C_OPCODE_ARRAY_IF_RENAME                       INT = 5
    DECLARE @C_OPCODE_DFM_DATASET_DELETE                    INT = 6
    DECLARE @C_OPCODE_VOLUME_MOVE                           INT = 7
    DECLARE @C_OPCODE_ARRAY_MIGRATION                       INT = 8
    DECLARE @C_OPCODE_PRERUN                                INT = 9
    DECLARE @C_OPCODE_POSTRUN                               INT = 10
    DECLARE @C_OPCODE_ARRAY_UNIQUEID                        INT = 11
    DECLARE @C_OPCODE_OCUM_RENAME                           INT = 12
    DECLARE @C_OPCODE_SVM_RENAME                            INT = 13
    DECLARE @C_OPCODE_SET_VSERVER_CONFIG                    INT = 14
	DECLARE @C_OPCODE_FIX_MISSING_SNAP_METADATA				INT = 15
    DECLARE @C_OPCODE_END                                   INT = 16
    DECLARE @C_FLAGS_SET_VALUE								INT = 1
    DECLARE @C_FLAGS_OVERRIDE_VALUE							INT = 2
    DECLARE @C_FLAGS_CLEANUP_TEMP_SNAP_TABLES				INT = 4
    DECLARE @C_FLAGS_UPDATE_TEMP_SNAP_TABLES				INT = 8
    DECLARE @C_FLAGS_UPDATE_PERM_SNAP_TABLES				INT = 16
	/*NLR Support: Set the flag to update SMReplica* tables for volume/array/svm rename and volume move operations */
    DECLARE @C_FLAGS_NLR_UPDATE_SMREPLICA_TABLES			INT = 32
	/*SVM Rename for snaps on cluster client */
	DECLARE @C_FLAGS_SVMRENAME_UPDATE_ONLY_SNAP_TABLES		INT = 64
    -- Local Variables
    DECLARE @l_arrayNum             INT = -1
	IF (OBJECT_ID('tempdb.dbo.#tblPackedMetadata') IS NOT NULL)
		DROP TABLE #tblPackedMetadata
	CREATE TABLE #tblPackedMetadata(
			MetadataId              INT PRIMARY KEY,
			SMSnapId                INT,
			PruneFlags              INT,
			Metadata                NVARCHAR(MAX)
			)
	IF (OBJECT_ID('tempdb.dbo.#tblMetadataRows') IS NOT NULL)
		DROP TABLE #tblMetadataRows
	CREATE TABLE #tblMetadataRows(
			MetadataId              INT,
            MetadataType            INT DEFAULT 0,
			MetadataRow             NVARCHAR(MAX)
			)
	CREATE CLUSTERED INDEX MDR_IDX1 ON #tblMetadataRows(MetadataId, MetadataType)
	IF (OBJECT_ID('tempdb.dbo.#tblMetadata') IS NOT NULL)
		DROP TABLE #tblMetadata
	CREATE TABLE #tblMetadata(
			MetadataId              INT,
			SMSnapId                INT,
			MetadataType            INT,
			Metadata                NVARCHAR(MAX)
			)
	CREATE CLUSTERED INDEX MD_IDX1 ON #tblMetadata(MetadataId, MetadataType)
	IF (OBJECT_ID('tempdb.dbo.#tblArrayInfo') IS NOT NULL)
		DROP TABLE #tblArrayInfo
	CREATE TABLE #tblArrayInfo(
        MetadataId              INT,
        MetadataType            INT,
        SMSnapId                INT,
        ArrayName               NVARCHAR(1024),
        ArrayNameIdx            INT,
        VolumeName              NVARCHAR(2048),
        VolumeNameIdx           INT
        )
	CREATE CLUSTERED INDEX TAI_IDX1 ON #tblArrayInfo(MetadataType, MetadataId)
	IF (OBJECT_ID('tempdb.dbo.#tblArrayUniqueID') IS NOT NULL)
		DROP TABLE #tblArrayUniqueID
	CREATE TABLE #tblArrayUniqueID(
        SMControlHostID         INT,
        UniqueID                NVARCHAR(1024)
        )
    -- Initialize the Output Parameters
    SET @o_ErrorCode        = 0
    SET @o_ErrorStr         = ''
    -- XML Structure for MM_SMUpdateVolSnapsSMT
    /*
    -- Test XML string
	<MM_SMUpdateVolSnapsSMT><Entities><Entity><OpCode>array rename code</OpCode><SMControlHostId>controlhostid</SMControlHostId><SMArrayId>ArrayName</SMArrayId ></Entity></Entities></MM_SMUpdateVolSnapsSMT>
    <MM_SMUpdateVolSnapsSMT>
		<Entities>
			<Entity>
				<OpCode></OpCode>
				<Flags></Flags>
				<SMControlHostId></SMControlHostId>
				<OldSVM></OldSVM>
				<NewSVM></NewSVM>
				<SMArrayId></SMArrayId>
				<ExtDataSetId></ExtDataSetId>
				<ArrayUniqueID>
					<SMControlHost SMControlHostID=1 UniqueID="4082367488"/>
					<SMControlHost SMControlHostID=2 UniqueID="dda14a39-1705-11e3-a9aa-123478563412"/>
				</ArrayUniqueID>
				<BatchUpdateSMTSnapTbls>
					<BatchNumber>1</BatchNumber>
					<BatchSize>1</BatchSize>
					<SMT_SMSnap SMSnapId="978" SnapStatus="5" SnapSourceDevice="{idatype:native_netapp,type:native_netapp,filer:hfiler2.testlab.commvault.com,volume:/vol/SMT_nas_mv2_new,path:/vol/SMT_nas_mv2_new}"/>
					<SMT_SMVolume SMVolumeId="978" SourcePath="/vol/SMT_nas_mv2_new" SourceGUID="/vol/SMT_nas_mv2_new" SourceDevice=""/>
					<SMT_SMMetadata RefType="2" RefId="978" MetaData="2#3#6|::|172.19.69.131|SMT_nas_mv2_new|SP_2_363_978_1488513064|/vol/SMT_nas_mv2_new|::||..|3#33|::|hfiler2.testlab.commvault.com|::||..|"/>
				</BatchUpdateSMTSnapTbls>
			</Entity>
		</Entities>
    </MM_SMUpdateVolSnapsSMT>
    */
    -- Initialize and set the values for Input Parameters
    -- Opcode
    SET @x_opCode = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/OpCode') R(ref)), 0)
    IF (@x_opCode < @C_OPCODE_BEGIN) OR (@x_opCode >= @C_OPCODE_END)
    BEGIN
        SET @o_ErrorCode = 1
        SET @o_ErrorStr = 'OpCode [' + CONVERT(NVARCHAR(8), @x_opCode) + '] sent to MM_SMUpdateVolSnapsSMT is invalid.'
        GOTO PROC_EXIT
    END
    -- Flags
    SET @x_flags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/Flags') R(ref)), 0)
    IF @x_flags < 0
    BEGIN
        SET @o_ErrorCode = 2
        SET @o_ErrorStr = 'Flags [' + CONVERT(NVARCHAR(8), @x_flags) + '] sent to MM_SMUpdateVolSnapsSMT is invalid.'
        GOTO PROC_EXIT
    END
 	-- Update SNAP Tables. Should be flag based, as some of the operations like setArrayUniqueID,
	-- nasclient-Array association, preRun, postRun, etc will NOT update SNAP tables.
    IF ((@x_flags & @C_FLAGS_CLEANUP_TEMP_SNAP_TABLES = @C_FLAGS_CLEANUP_TEMP_SNAP_TABLES) OR
        (@x_flags & @C_FLAGS_UPDATE_TEMP_SNAP_TABLES = @C_FLAGS_UPDATE_TEMP_SNAP_TABLES)   OR
        (@x_flags & @C_FLAGS_UPDATE_PERM_SNAP_TABLES = @C_FLAGS_UPDATE_PERM_SNAP_TABLES))
	BEGIN
	   -- In each batch, update the transient SMT_* snap tables from the XML content sent.
		-- Cleanup temporary tables. This is good to do for every first batch. We also cleanup at the end of the operation.
		IF(@x_flags & @C_FLAGS_CLEANUP_TEMP_SNAP_TABLES = @C_FLAGS_CLEANUP_TEMP_SNAP_TABLES)
		BEGIN
			-- TRUNCATE TEMPORARY SNAP TABLES
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMSnap*/
			EXEC SQLUtilTruncateTable 'SMT_SMSnap'
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMVolume*/
			EXEC SQLUtilTruncateTable 'SMT_SMVolume'
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMMetadata*/
			EXEC SQLUtilTruncateTable 'SMT_SMMetadata'
		END
		--Flag to update temporary tables.
		IF(@x_flags & @C_FLAGS_UPDATE_TEMP_SNAP_TABLES = @C_FLAGS_UPDATE_TEMP_SNAP_TABLES)
		BEGIN
			IF(@x_opCode = @C_OPCODE_FIX_MISSING_SNAP_METADATA)
			BEGIN
				INSERT INTO SMT_SMSnap(SMSnapId, SnapSourceDevice, Flags)
				SELECT R.ref.value('@SMSnapId', 'int'), R.ref.value('@SnapSourceDevice', 'nvarchar(1024)'), ISNULL(R.ref.value('@SnapStatus', 'int'), 5)
				FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/BatchUpdateSMTSnapTbls/SMT_SMSnap') R(ref)
			END
			ELSE
			BEGIN
				INSERT INTO SMT_SMSnap(SMSnapId, SnapSourceDevice)
				SELECT R.ref.value('@SMSnapId', 'int'), R.ref.value('@SnapSourceDevice', 'nvarchar(1024)')
				FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/BatchUpdateSMTSnapTbls/SMT_SMSnap') R(ref)
			END
			INSERT INTO SMT_SMVolume(SMVolumeId, SourcePath, SourceGUID, SourceDevice)
			SELECT R.ref.value('@SMVolumeId', 'int'), R.ref.value('@SourcePath', 'nvarchar(1024)'), R.ref.value('@SourceGUID', 'nvarchar(1024)'), R.ref.value('@SourceDevice', 'nvarchar(1024)')
			FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/BatchUpdateSMTSnapTbls/SMT_SMVolume') R(ref)
			INSERT INTO SMT_SMMetadata(RefType, RefId, MetaData)
			SELECT R.ref.value('@RefType', 'int'), R.ref.value('@RefId', 'int'), R.ref.value('@MetaData', 'nvarchar(MAX)')
			FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/BatchUpdateSMTSnapTbls/SMT_SMMetadata') R(ref)
		END
		-- BatchNumber is not set while updating main tables.
		-- Update main tables and truncate temporary tables.
		-- Continue with the rest of the operations as required for each opCode.
		ELSE IF(@x_flags & @C_FLAGS_UPDATE_PERM_SNAP_TABLES = @C_FLAGS_UPDATE_PERM_SNAP_TABLES)
		BEGIN
			IF (@C_OPCODE_VOLUME_MOVE = @x_opCode) -- Need to update SMControlHostId for volume move/migration
			BEGIN
				SET @x_SMControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMControlHostId') R(ref)), 0)
				IF @x_SMControlHostId <= 0
				BEGIN
					SET @o_ErrorCode = 3
					SET @o_ErrorStr = 'For Volume Migration operation, passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + ']. is invalid.'
					GOTO PROC_EXIT
				END
				-- Update ControlHostId for modified snaps
				UPDATE SMSnap
				SET ControlHostId = @x_SMControlHostId
				FROM
					SMSnap(NOLOCK) SNAP
					INNER JOIN SMT_SMMetadata(NOLOCK) METADATA1 ON METADATA1.RefId = SNAP.SMSnapId
					INNER JOIN SMMetaData(NOLOCK) METADATA
						ON METADATA.RefId = METADATA1.RefId
						AND METADATA.RefType = METADATA1.RefType
				SET @o_ErrorCode = @@ERROR
				IF @o_ErrorCode <> 0
				BEGIN
					SET @o_ErrorStr = 'Failed to update ControlHostId in SMSnap.tbl'
					GOTO PROC_EXIT
				END
			END
			IF(@x_opCode = @C_OPCODE_FIX_MISSING_SNAP_METADATA)
			BEGIN
				-- Update SMSnap table entries
				UPDATE SMSnap
				SET UniqueIdentifier = SNAP1.SnapSourceDevice,
					Snapstatus 		 = SNAP1.Flags
				FROM
					SMT_SMSnap(NOLOCK) SNAP1
					INNER JOIN SMSnap(NOLOCK) SNAP ON SNAP.SMSnapId = SNAP1.SMSnapId
			END
			ELSE
			BEGIN
				-- Update SMSnap table entries
				UPDATE SMSnap
				SET SnapSourceDevice = SNAP1.SnapSourceDevice
				FROM
					SMT_SMSnap(NOLOCK) SNAP1
					INNER JOIN SMSnap(NOLOCK) SNAP ON SNAP.SMSnapId = SNAP1.SMSnapId
			END
			SET @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to update SMSnap.tbl'
				GOTO PROC_EXIT
			END
			-- Update SMVolume table entries
			UPDATE SMVolume
			SET SourcePath = VOL1.SourcePath, SourceGUID = VOL1.SourceGUID, SourceDevice = VOL1.SourceDevice
			FROM
				SMT_SMVolume AS VOL1,
				SMVolume AS VOL
			WHERE VOL.SMVolumeId = VOL1.SMVolumeId
			SET @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to update SMVolume.tbl'
				GOTO PROC_EXIT
			END
			-- Update SMMetadata table entries
			UPDATE SMMetaData
			SET MetaData = METADATA1.MetaData
			FROM
				SMT_SMMetadata AS METADATA1,
				SMMetaData AS METADATA
			WHERE METADATA.RefId = METADATA1.RefId
					AND METADATA.RefType = METADATA1.RefType
			SET @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to update SMMetaData.tbl'
				GOTO PROC_EXIT
			END
			-- TRUNCATE TEMPORARY SNAP TABLES
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMSnap*/
			EXEC SQLUtilTruncateTable 'SMT_SMSnap'
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMVolume*/
			EXEC SQLUtilTruncateTable 'SMT_SMVolume'
			/*CLEANUP EXISTING ENTRIES IN TABLE SMT_SMMetadata*/
			EXEC SQLUtilTruncateTable 'SMT_SMMetadata'
		END
	END
    SET @x_SMArrayId = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMArrayId') R(ref)), N'')
    IF (@C_OPCODE_ARRAY_RENAME = @x_opCode)  -- Array Rename
    BEGIN
		SET @x_SMControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMControlHostId') R(ref)), 0)
        IF @x_SMArrayId = '' OR @x_SMControlHostId <= 0
        BEGIN
            SET @o_ErrorCode = 3
            SET @o_ErrorStr = 'For Array Rename, NewArray name[' + @x_SMArrayId + '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		IF NOT EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ControlHostId = @x_SMControlHostId)
		BEGIN
        	SET @o_ErrorCode = 4
            SET @o_ErrorStr = 'ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + '] sent to MM_SMUpdateVolSnapsSMT does not exist.'
	        GOTO PROC_EXIT
		END
        UPDATE SMControlHost
        SET SMArrayId = @x_SMArrayId
        WHERE ControlHostId = @x_SMControlHostId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update SMControlHost.tbl'
            GOTO PROC_EXIT
		END
        UPDATE SMArray
        SET ArrayName = @x_SMArrayId
        WHERE ClientId IN (SELECT distinct ClientId FROM SMControlHost (NOLOCK) WHERE ControlHostId = @x_SMControlHostId)
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update SMArray.tbl'
            GOTO PROC_EXIT
        END
        DELETE SMHostAlias
        WHERE RefId = @x_SMControlHostId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entries in SMHostAlias.tbl'
            GOTO PROC_EXIT
        END
        DELETE SMEndPoint
        WHERE ClientId IN (SELECT distinct ClientId FROM SMControlHost (NOLOCK) WHERE ControlHostId =  @x_SMControlHostId )
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entries in SMEndPoint.tbl'
            GOTO PROC_EXIT
        END
        DELETE SMConfigsList
WHERE MasterConfigId = 132 AND ArrayId = @x_SMControlHostId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entries in SMConfigsList.tbl'
            GOTO PROC_EXIT
        END
	END
    ELSE IF ((@C_OPCODE_SVM_RENAME = @x_opCode) AND
			(@x_flags & @C_FLAGS_SVMRENAME_UPDATE_ONLY_SNAP_TABLES = 0))  -- SVM Rename with SVM as an Array entry. For Cluster client, should not update any of following tables.
    BEGIN
		SET @x_SMControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMControlHostId') R(ref)), 0)
		SET @x_oldVServer = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/OldSVM') R(ref)), N'')
		SET @x_newVServer = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/NewSVM') R(ref)), N'')
        IF @x_oldVServer = '' OR @x_newVServer = '' OR @x_SMControlHostId <= 0
        BEGIN
            SET @o_ErrorCode = 12
            SET @o_ErrorStr = 'For SVM rename, OldSVM name[' + @x_oldVServer + '] or NewSVM name [' + @x_newVServer + '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		IF NOT EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ControlHostId = @x_SMControlHostId)
		BEGIN
        	SET @o_ErrorCode = 13
            SET @o_ErrorStr = 'ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + '] sent to MM_SMUpdateVolSnapsSMT does not exist.'
	        GOTO PROC_EXIT
		END
		-- Delete old SVM entry in SMHostAlias
		DELETE  SMHostAlias
		WHERE   RefType = 5 AND RefId = @x_SMControlHostId AND AliasName = @x_oldVServer
		SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete old SVM name in SMHostAlias.tbl'
            GOTO PROC_EXIT
        END
		-- Insert new SVM entry in SMHostAlias
		INSERT  INTO SMHostAlias
		SELECT  5, @x_SMControlHostId, 0, 0, @x_newVServer, GETUTCDATE(), 0, NEWID(), 0, 0, 0, 0, N''
		WHERE   @x_newVServer NOT IN (SELECT AliasName from SMHostAlias (NOLOCK) WHERE RefId = @x_SMControlHostId)
		SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
		BEGIN
			SET @o_ErrorStr = N'Failed to add the new SVM name in SMHostAlias.tbl'
			GOTO PROC_EXIT
		END
		-- Update SMEndPoint
		UPDATE SMEndPoint
		SET Address = @x_newVServer
		WHERE ClientId IN (SELECT distinct ClientId FROM SMControlHost (NOLOCK) WHERE ControlHostId =  @x_SMControlHostId)
			AND Address = @x_oldVServer
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update entry in SMEndPoint.tbl'
            GOTO PROC_EXIT
        END
		-- delete old SVM entry in SMConfigsList
		DELETE SMConfigsList
WHERE  MasterConfigId = 132 AND ArrayId = @x_SMControlHostId AND ValueStr = @x_oldVServer
		SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
           SET @o_ErrorStr = 'Failed to delete old SVM name in SMConfigsList.tbl'
            GOTO PROC_EXIT
        END
	    DECLARE @currTime INTEGER = dbo.GetUnixTime(GetUTCDate())
		-- Insert new SVM entry in SMConfigsList table
        INSERT  INTO SMConfigsList
SELECT  132, @x_SMControlHostId, @x_SMControlHostId, 3,
                0, 1, 1, 0,
                0, 0, H_ALIAS.AliasName,
                @currTime, 0, 2, newid(), 1, H_ALIAS.Id
        FROM    SMHostAlias (NOLOCK) H_ALIAS
				LEFT OUTER JOIN SMConfigsList (NOLOCK) CFG ON H_ALIAS.Id = CFG.RefId
WHERE   H_ALIAS.RefType = 5
                AND H_ALIAS.RefId = @x_SMControlHostId
                AND H_ALIAS.AliasName = @x_newVServer
                AND CFG.ValueStr IS NULL
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to insert new SVM name in SMConfigsList.tbl'
            GOTO PROC_EXIT
        END
		-- Update SVM entry in App_ClientProp table
		UPDATE APP_ClientProp
		SET attrVal = @x_newVServer
		WHERE componentNameId  = (SELECT TOP 1 ClientId FROM SMControlHost (NOLOCK) WHERE ControlHostId =  @x_SMControlHostId)
			AND attrName = 'NAS vServer Name'
			AND attrVal = @x_oldVServer
			AND modified = 0
		SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
		BEGIN
			SET @o_ErrorStr = N'Failed to update the new SVM name in APP_ClientProp.'
			GOTO PROC_EXIT
		END
	END
    ELSE IF (@C_OPCODE_ASSOC_NASCLIENT_TO_ARRAY = @x_opCode)  -- Assoicate NasClient To Array
    BEGIN
        SET @x_NasClientId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/NasClientId') R(ref)), 0)
        IF @x_SMArrayId = '' OR @x_NasClientId <= 0
        BEGIN
            SET @o_ErrorCode = 5
            SET @o_ErrorStr = 'In NasClient to Array association, Array name [' + @x_SMArrayId + '] or passed-in NAS ClientId [' + CONVERT(NVARCHAR(8), @x_NasClientId)  + '] is invalid.'
	        GOTO PROC_EXIT
        END
		IF NOT EXISTS (SELECT 1 FROM APP_Client (NOLOCK) WHERE id = @x_NasClientId)
        BEGIN
            SET @o_ErrorCode = 6
            SET @o_ErrorStr = 'In NasClient to Array association, ClientId [' + CONVERT(NVARCHAR(8), @x_NasClientId)  + '] passed does not exist in DB.'
	        GOTO PROC_EXIT
        END
        UPDATE SMControlHost
        SET ClientId = @x_NasClientId
        WHERE SMArrayId = @x_SMArrayId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update SMControlHost.tbl'
            GOTO PROC_EXIT
        END
        UPDATE SMArray
        SET ClientId = @x_NasClientId
        WHERE ArrayName = @x_SMArrayId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update SMArray.tbl'
            GOTO PROC_EXIT
		END
	END
    ELSE IF (@C_OPCODE_DFM_DATASET_DELETE = @x_opCode)  -- Delete DataSet Info for externally deleted dataset
    BEGIN
		-- Check whether the given array exists or not
		IF @x_SMArrayId <> ''
		BEGIN
			SET @l_arrayNum = (SELECT TOP 1 ControlHostId FROM SMControlHost (NOLOCK) WHERE SMArrayId = @x_SMArrayId)
			IF @l_arrayNum IS NULL
			BEGIN
				SET @o_ErrorCode = 10
				SET @o_ErrorStr = 'No entry found for Array [' + @x_SMArrayId + '].'
				GOTO PROC_EXIT
			END
		END
        SET @x_ExtDataSetId = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/ExtDataSetId') R(ref)), N'')
        IF @x_SMArrayId = '' OR @x_ExtDataSetId = ''
        BEGIN
            SET @o_ErrorCode = 7
            SET @o_ErrorStr = 'Invalid Array Name [' + @x_SMArrayId + '] or ExtDataSetId [' + @x_ExtDataSetId  + '] passed.'
            GOTO PROC_EXIT
        END
        IF NOT EXISTS (SELECT 1 FROM SMDataSet (NOLOCK) WHERE ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum)
        BEGIN
            SET @o_ErrorCode = 8
            SET @o_ErrorStr = 'ExtDataSetId [' + @x_ExtDataSetId  + '] for array ['+ @x_SMArrayId +'] does not exist in DB.'
            GOTO PROC_EXIT
        END
		--delete SMSnapToDatasetMap
        DELETE SMSnapToDatasetMap WHERE DataSetId IN (
        SELECT datasetid FROM SMDataSet WHERE ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum)
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entry from SMSnapToDatasetMap.tbl'
            RETURN
        END
        --delete SMSnapToDatasetMemberMap
        DELETE SMSnapToDatasetMemberMap WHERE DSMemberId IN (
        SELECT DataSetMemberId FROM SMDataSetMember WHERE DataSetId IN
        (SELECT datasetid FROM SMDataSet WHERE ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum))
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entry from SMSnapToDatasetMemberMap.tbl'
            RETURN
        END
        --delete SMDataSetMember
        DELETE SMDataSetMember WHERE DataSetId IN (
        SELECT datasetid FROM SMDataSet WHERE ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum)
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entry from SMDataSetMember.tbl'
            RETURN
        END
        --delete SMDataSet
        DELETE SMDataSet WHERE ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to delete entry from SMDataSet.tbl'
            RETURN
        END
        --delete SMDataSetToSubClientMap
        DELETE SMDataSetToSubClientMap where DataSetId IN (
        SELECT datasetid from SMDataSet where ExtDataSetId = @x_ExtDataSetId and ControlHostId = @l_arrayNum)
        SET @o_ErrorCode = @@Error
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = N'Failed to delete entry from SMDataSetToSubClientMap.tbl'
            GOTO PROC_EXIT
        END
	END
    ELSE IF (@C_OPCODE_PRERUN = @x_opCode)
	BEGIN
		/*CLEANUP EXISTING ENTRIES IN TABLE SMSnapSMT*/
		EXEC SQLUtilTruncateTable 'SMSnapSMT'
		/*Get all snap entries related to Vault/Mirror copies made from snaps of ALL ArrayControllers*/
		INSERT  INTO #tblPackedMetadata
		SELECT  MD.MetadataId, MD.RefId, MD.PruneFlags, SUBSTRING(MD.Metadata, CHARINDEX('#', MD.Metadata) + 1, LEN(MD.Metadata))
		FROM    SMMetaData (NOLOCK) MD
				INNER JOIN SMSnap (NOLOCK) SNAP
					ON SNAP.SMSnapId = MD.RefId
		WHERE	SNAP.SnapShotEngineId = 3
				AND MD.RefType = 2
		INSERT  INTO #tblMetadataRows (MetadataId,MetadataRow)
		SELECT  PMD.MetadataId, SUBSTRING(SPLIT.Data, CHARINDEX('#', SPLIT.Data) + 1, LEN(SPLIT.Data))
		FROM    #tblPackedMetadata PMD CROSS APPLY SplitStringMaxLen(PMD.Metadata, '|..|' ) SPLIT
		UPDATE  #tblMetadataRows
		SET     MetadataType = SUBSTRING(MetadataRow, 0, CHARINDEX('|::|', MetadataRow))
		DELETE #tblMetadataRows
WHERE MetadataType NOT IN (6, 29)
		INSERT  INTO #tblMetadata
		SELECT  MDR.MetadataId, PMD.SMSnapId, MDR.MetadataType, SPLIT.Data
		FROM    #tblMetadataRows MDR CROSS APPLY SplitStringMaxLen(MDR.MetadataRow, '|::|' ) SPLIT
				INNER JOIN #tblPackedMetadata PMD ON MDR.MetadataId = PMD.MetadataId
WHERE   SPLIT.Id = 2 AND MDR.MetadataType IN (6, 29)
		INSERT  INTO #tblArrayInfo
		SELECT  MetadataId, MetadataType, SMSnapId, '', CHARINDEX('|', Metadata), '', 0
FROM    #tblMetadata WHERE MetadataType IN (6, 29)
		UPDATE  #tblArrayInfo
		SET     ArrayName = SUBSTRING(MD.Metadata, 1, TAI.ArrayNameIdx-1), VolumeNameIdx = CHARINDEX('|', Metadata, ArrayNameIdx+1)
		FROM    #tblArrayInfo TAI
				INNER JOIN #tblMetadata MD
				ON TAI.MetadataId = MD.MetadataId
				AND TAI.MetadataType = MD.MetadataType
AND MD.MetadataType IN (6, 29)
		UPDATE  #tblArrayInfo
		SET     VolumeName = SUBSTRING(Metadata, ArrayNameIdx+1, (VolumeNameIdx - (ArrayNameIdx+1)))
		FROM    #tblArrayInfo TAI
				INNER JOIN #tblMetadata MD
				ON TAI.MetadataId = MD.MetadataId
				AND TAI.MetadataType = MD.MetadataType
AND MD.MetadataType IN (6, 29)
		INSERT  INTO SMSnapSMT(SMSnapId, MetadataId, MetadataType, ArrayName, VolumeName)
		SELECT  TAI.SMSnapId, TAI.MetadataId, TAI.MetadataType, TAI.ArrayName, TAI.VolumeName
		FROM    #tblArrayInfo TAI
				LEFT OUTER JOIN SMSnapSMT SNAP WITH(NOLOCK)
				ON TAI.SMSnapId = SNAP.SMSnapId
				AND TAI.MetadataId = SNAP.MetadataId
				AND TAI.MetadataType = SNAP.MetadataType
		WHERE   SNAP.SMSnapId IS NULL
		ORDER BY TAI.SMSnapId, TAI.MetadataId, TAI.MetadataType
	END
    ELSE IF (@C_OPCODE_POSTRUN = @x_opCode)
	BEGIN
		/*CLEANUP ENTRIES FROM SMSnapSMT TABLE*/
		EXEC SQLUtilTruncateTable 'SMSnapSMT'
	END
    ELSE IF (@C_OPCODE_ARRAY_UNIQUEID = @x_opCode)
	BEGIN
		INSERT INTO #tblArrayUniqueID
        SELECT R.ref.value('@SMControlHostID', 'int'), R.ref.value('@UniqueID', 'nvarchar(1024)')
		FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/ArrayUniqueID/SMControlHost') R(ref)
		/*Set UniqueID if not present*/
		IF((@x_flags & @C_FLAGS_SET_VALUE) = @C_FLAGS_SET_VALUE)
		BEGIN
			UPDATE SMControlHost
			SET UniqueIdentifier = TAI.UniqueID
			FROM SMControlHost Host
				INNER JOIN #tblArrayUniqueID TAI
				ON Host.ControlHostId = TAI.SMControlHostID
			WHERE Host.UniqueIdentifier = ''
		END
		/*Override UniqueID*/
		ELSE IF((@x_flags & @C_FLAGS_OVERRIDE_VALUE) = @C_FLAGS_OVERRIDE_VALUE)
		BEGIN
			UPDATE SMControlHost
			SET UniqueIdentifier = TAI.UniqueID
			FROM SMControlHost Host
				INNER JOIN #tblArrayUniqueID TAI
				ON Host.ControlHostId = TAI.SMControlHostID
		END
	END
    ELSE IF (@C_OPCODE_OCUM_RENAME = @x_opCode)
	BEGIN
		SET @x_SMControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMControlHostId') R(ref)), 0)
        IF @x_SMArrayId = '' OR @x_SMControlHostId <= 0
        BEGIN
            SET @o_ErrorCode = 3
            SET @o_ErrorStr = 'For OCUM Rename, NewArray name[' + @x_SMArrayId + '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		IF NOT EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ControlHostId = @x_SMControlHostId)
		BEGIN
        	SET @o_ErrorCode = 4
            SET @o_ErrorStr = 'ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + '] sent to MM_SMUpdateVolSnapsSMT does not exist.'
	        GOTO PROC_EXIT
		END
        UPDATE SMControlHost
        SET SMArrayId = @x_SMArrayId
        WHERE ControlHostId = @x_SMControlHostId
        SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
        BEGIN
            SET @o_ErrorStr = 'Failed to update SMControlHost.tbl'
            GOTO PROC_EXIT
		END
	END
    ELSE IF (@C_OPCODE_SET_VSERVER_CONFIG = @x_opCode)
	BEGIN
	    -- Using existing temp table as fields are similar
		INSERT INTO #tblArrayUniqueID
        SELECT R.ref.value('@SMControlHostID', 'int'), R.ref.value('@vServerConfig', 'nvarchar(1024)')
		FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/vServerConfig/SMControlHost') R(ref)
		/*Set vserver config if not present*/
		IF((@x_flags & @C_FLAGS_SET_VALUE) = @C_FLAGS_SET_VALUE)
		BEGIN
			UPDATE CFG
			SET ValueStr = TAI.UniqueID
			FROM SMConfigs CFG
				INNER JOIN SMMasterConfigs MCFG
					ON CFG.MasterConfigId = MCFG.Id
				INNER JOIN #tblArrayUniqueID TAI
					ON CFG.ArrayId = TAI.SMControlHostID
WHERE  CFG.AssocType = 3
				   AND MCFG.KeyName = 'SMCONFIG_NAME_CLUSTER_SVM'
				   AND LEN(CFG.ValueStr) = 0
		END
		/*Override vserver config*/
		ELSE IF((@x_flags & @C_FLAGS_OVERRIDE_VALUE) = @C_FLAGS_OVERRIDE_VALUE)
		BEGIN
			UPDATE CFG
			SET ValueStr = TAI.UniqueID
			FROM SMConfigs CFG
				INNER JOIN SMMasterConfigs MCFG
					ON CFG.MasterConfigId = MCFG.Id
				INNER JOIN #tblArrayUniqueID TAI
					ON CFG.ArrayId = TAI.SMControlHostID
WHERE  CFG.AssocType = 3
				   AND MCFG.KeyName = 'SMCONFIG_NAME_CLUSTER_SVM'
		END
	END
    /*Update SMReplicaEntities for NLR snaps during Volume Rename/SVM Rename/Volume Move */
	IF (((@C_OPCODE_VOLUME_RENAME = @x_opCode) OR
		 (@C_OPCODE_SVM_RENAME = @x_opCode) OR
		 (@C_OPCODE_VOLUME_MOVE = @x_opCode)) AND
		 (@x_flags & @C_FLAGS_NLR_UPDATE_SMREPLICA_TABLES = @C_FLAGS_NLR_UPDATE_SMREPLICA_TABLES))  -- NLR Volume/SVM Rename
    BEGIN
		SET @x_SMControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMControlHostId') R(ref)), 0)
		SET @x_oldVolume = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/OldVol') R(ref)), N'')
		SET @x_newVolume = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/NewVol') R(ref)), N'')
		SET @x_oldVServer = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/OldSVM') R(ref)), N'')
		SET @x_newVServer = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/NewSVM') R(ref)), N'')
	    SET @x_SMArrayId = ISNULL(( SELECT R.ref.value('.', 'nvarchar(2048)') FROM @i_xmlTextInput.nodes('/MM_SMUpdateVolSnapsSMT/Entities/Entity/SMArrayId') R(ref)), N'') --oldarray ArrayName
		IF (@C_OPCODE_VOLUME_RENAME = @x_opCode) AND (@x_oldVolume = '' OR @x_newVolume = '' OR @x_oldVServer = '' OR @x_SMControlHostId <= 0)
        BEGIN
            SET @o_ErrorCode = 14
            SET @o_ErrorStr = 'For NLR Volume rename, oldVolume name [' + @x_oldVolume + '] or newVolume name [' + @x_newVolume +
							  '] or vserver name [' + @x_oldVServer + '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId) + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		ELSE IF (@C_OPCODE_SVM_RENAME = @x_opCode) AND (@x_oldVServer = '' OR @x_newVServer = '' OR @x_SMControlHostId <= 0)
        BEGIN
            SET @o_ErrorCode = 16
            SET @o_ErrorStr = 'For NLR SVM rename, oldSVM name [' + @x_oldVServer + '] or newSVM name [' + @x_newVServer +
							  '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId) + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		ELSE IF (@C_OPCODE_VOLUME_MOVE = @x_opCode) AND (@x_oldVolume = '' OR @x_oldVServer = '' OR
				 @x_newVServer = '' OR @x_SMArrayId = '' OR @x_SMControlHostId <= 0)
        BEGIN
            SET @o_ErrorCode = 18
            SET @o_ErrorStr = 'For NLR Volume Move, oldSVM name [' + @x_oldVServer + '] or newSVM name [' + @x_newVServer +
							  '] or oldVolume name [' + @x_oldVolume + '] or oldArray name [' + @x_SMArrayId +
							  '] or passed-in ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId) + ']. is invalid.'
	        GOTO PROC_EXIT
        END
		IF NOT EXISTS (SELECT 1 FROM SMControlHost (NOLOCK) WHERE ControlHostId = @x_SMControlHostId)
		BEGIN
        	SET @o_ErrorCode = 15
            SET @o_ErrorStr = 'ControlHostId [' + CONVERT(NVARCHAR(8), @x_SMControlHostId)  + '] sent to MM_SMUpdateVolSnapsSMT does not exist.'
	        GOTO PROC_EXIT
		END
		-- Update EntityName entry in SMReplicaEntities table
 		IF(@C_OPCODE_VOLUME_RENAME = @x_opCode)
		BEGIN
			UPDATE SMReplicaEntities
			SET EntityName = @x_oldVServer+':'+@x_newVolume
			WHERE ArrayNum =  @x_SMControlHostId
				AND EntityName = @x_oldVServer+':'+@x_oldVolume
		END
 		ELSE IF(@C_OPCODE_SVM_RENAME = @x_opCode)
		BEGIN
			UPDATE SMReplicaEntities
			SET EntityName = @x_newVServer + ':' + SUBSTRING(EntityName, CHARINDEX(':',EntityName)+1, LEN(EntityName))
			WHERE
				ArrayNum =  @x_SMControlHostId
				AND SUBSTRING(EntityName, 0, CHARINDEX(':',EntityName)) = @x_oldVServer
		END
 		ELSE IF(@C_OPCODE_VOLUME_MOVE = @x_opCode)
		BEGIN
			-- Check whether the given array (source array) exists or not.
			-- Note that @x_SMControlHostId refers to the target array.
			SET @l_arrayNum = (SELECT TOP 1 ControlHostId FROM SMControlHost (NOLOCK) WHERE SMArrayId = @x_SMArrayId)
			IF @l_arrayNum IS NULL
			BEGIN
				SET @o_ErrorCode = 19
				SET @o_ErrorStr = 'No entry found for Array [' + @x_SMArrayId + '].'
				GOTO PROC_EXIT
			END
			-- If volume is rehosted with same name on target array
			IF @x_newVolume = ''
			BEGIN
				-- Update ArrayNum and EntityName
				UPDATE SMReplicaEntities
				SET EntityName = @x_newVServer + ':' + SUBSTRING(EntityName, CHARINDEX(':',EntityName)+1, LEN(EntityName)),
					ArrayNum =  @x_SMControlHostId
				WHERE
					ArrayNum =  @l_arrayNum -- refers to oldArray
					AND EntityName = @x_oldVServer+':'+@x_oldVolume
			END
			ELSE
			BEGIN
				-- If volume is rehosted with new name on target array
				-- Update ArrayNum and EntityName
				UPDATE SMReplicaEntities
				SET EntityName = @x_newVServer+':'+@x_newVolume,
					ArrayNum =  @x_SMControlHostId
				WHERE
					ArrayNum =  @l_arrayNum -- refers to oldArray
					AND EntityName = @x_oldVServer+':'+@x_oldVolume
			END
		END
		SET @o_ErrorCode = @@ERROR
        IF @o_ErrorCode <> 0
		BEGIN
			SET @o_ErrorStr = N'Failed to update EntityName in SMReplicaEntities.'
			GOTO PROC_EXIT
		END
	END
PROC_EXIT:
    IF @o_ErrorCode = 0
        SET @o_ErrorStr =  'Operation with opcode['+ CONVERT(VARCHAR(60), @x_opCode) + '] completed successfully at '   + CONVERT(VARCHAR(60), GETDATE())+'.'
    ELSE
    BEGIN
		SET @o_ErrorStr =  'Operation with opcode['+ CONVERT(VARCHAR(60), @x_opCode) + '] failed at ' + CONVERT(VARCHAR(60), GETDATE()) +
							'. Error [' + CONVERT(VARCHAR(10), @o_ErrorCode) + ':' + @o_ErrorStr + '].'
		raiserror('MM_SMUpdateVolSnapsSMT: %d: %s',16,1, @o_ErrorCode, @o_ErrorStr);
    END
	SET @o_xmlTextOutput = (SELECT @o_ErrorCode AS '@errorCode', @o_ErrorStr AS '@errorMessage'
							FOR XML PATH('MM_SMUpdateVolSnapsSMT_Resp'),TYPE )
	SELECT @o_xmlTextOutput
	-- Drop all temporary tables.
	IF (OBJECT_ID('tempdb.dbo.#tblPackedMetadata') IS NOT NULL)
		DROP TABLE #tblPackedMetadata
	IF (OBJECT_ID('tempdb.dbo.#tblMetadataRows') IS NOT NULL)
		DROP TABLE #tblMetadataRows
	IF (OBJECT_ID('tempdb.dbo.#tblMetadata') IS NOT NULL)
		DROP TABLE #tblMetadata
	IF (OBJECT_ID('tempdb.dbo.#tblArrayInfo') IS NOT NULL)
		DROP TABLE #tblArrayInfo
	IF (OBJECT_ID('tempdb.dbo.#tblArrayUniqueID') IS NOT NULL)
		DROP TABLE #tblArrayUniqueID
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateVolSnapsSMT')
	delete from GxQscripts where name = 'MM_SMUpdateVolSnapsSMT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateVolSnapsSMT')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateVolSnapsSMT'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateVolSnapsSMT',  '00010001000200190000', 'MM_SMUpdateVolSnapsSMT', '00010001000200190000')
GO

