

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateStatusForLVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMUpdateStatusForLVM <<<'

IF EXISTS (select * from sysobjects where name='MM_SMUpdateStatusForLVM')
	drop procedure MM_SMUpdateStatusForLVM
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateStatusForLVM')
	delete from GxQscripts where name = 'MM_SMUpdateStatusForLVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateStatusForLVM')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateStatusForLVM'
GO
print '... Creating Procedure: MM_SMUpdateStatusForLVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateStatusForLVM
  @i_xmlText XML
AS
  DECLARE @o_SMVolumeId integer
  DECLARE @o_Status integer
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	/*
	'<MM_SMUpdateStatusForLVM>
		<Volume Id="1" Status="90">
		<Volume Id="2" Status="99">
		<Volume Id="3" Status="98">
		<Snap Id="4" Status="98">
		<Snap Id="5" Status="99">
		<Snap Id="6" Status="98">
	</MM_SMUpdateStatusForLVM>'
	*/
	DECLARE @tblVol TABLE(
		SMVolumeId INT,
		MountStatusInp INT,
		MountStatus INT
	)
	DECLARE @tblSnap TABLE(
		SMSnapId INT,
		SnapStatus INT
	)
	DECLARE @errorString	nvarchar(1024) = ''
	DECLARE @errorCode INT = 0
	INSERT INTO @tblVol
	SELECT	R.ref.value('./@Id','int') ,
			R.ref.value('./@Status','int') ,
			R.ref.value('./@Status','int')
	FROM	@i_xmlText.nodes('/MM_SMUpdateStatusForLVM/Volume') R(ref)
	INSERT INTO @tblSnap
	SELECT	R.ref.value('./@Id','int') ,
			R.ref.value('./@Status','int')
	FROM	@i_xmlText.nodes('/MM_SMUpdateStatusForLVM/Snap') R(ref)
BEGIN TRY
	BEGIN TRANSACTION SnapUpdateStatusForLVM
	-- Update the snap status in the DB only when it is changed
	UPDATE	SNAP
	SET		SnapStatus = INP_SNAP.SnapStatus
	FROM	SMSnap SNAP INNER JOIN @tblSnap INP_SNAP ON INP_SNAP.SMSnapId = SNAP.SMSnapId
	WHERE	SNAP.SnapStatus <> INP_SNAP.SnapStatus
	-- Get all the dependent snaps from the DB
	UPDATE	@tblVol
	SET		MountStatus = 98
	WHERE	SMVolumeId IN (
	SELECT	distinct VOL.SMVolumeId
	FROM	@tblVol INP_VOL INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = INP_VOL.SMVolumeId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
WHERE	SNAP.SnapStatus <> 20 /*DELETED*/ AND INP_VOL.MountStatus <> 98 /*SM_VS_DEL_FAILED*/
	)
	UPDATE VOL
	SET		MountStatus = INP_VOL.MountStatus
	FROM	SMVolume VOL INNER JOIN @tblVol INP_VOL ON VOL.SMVolumeId = INP_VOL.SMVolumeId
	WHERE	INP_VOL.MountStatus <> VOL.MountStatus
	COMMIT TRANSACTION SnapUpdateStatusForLVM
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
    IF XACT_STATE() <> 0
        ROLLBACK TRANSACTION SnapUpdateStatusForLVM
    SELECT  0, 0, @errorCode, @errorString
	RETURN
END CATCH
	-- Return only the changed snap status
	SELECT	SMVolumeId, MountStatus, 0, ''
	FROM	@tblVol
	WHERE	MountStatus <> MountStatusInp
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateStatusForLVM')
	delete from GxQscripts where name = 'MM_SMUpdateStatusForLVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateStatusForLVM')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateStatusForLVM'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateStatusForLVM',  '00000000000000000000', 'MM_SMUpdateStatusForLVM', '00000000000000000000')
GO

