

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateReconStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMUpdateReconStatus <<<'

IF EXISTS (select * from sysobjects where name='MM_SMUpdateReconStatus')
	drop procedure MM_SMUpdateReconStatus
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateReconStatus')
	delete from GxQscripts where name = 'MM_SMUpdateReconStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateReconStatus')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateReconStatus'
GO
print '... Creating Procedure: MM_SMUpdateReconStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateReconStatus
  @req XML 
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
<MM_SMUpdateReconStatus>
	<OpType>%d</OpType> --0:update,1:delete
	<SnapShotEngineId>%d</SnapShotEngineId>
	<ControlHostId>%d</ControlHostId>
	<ReconJobId>%d</ReconJobId>
	<ReconHostId>%d</ReconHostId>
	<FirstSMSnapId>%d</FirstSMSnapId>
	<LastSMSnapId>%d</LastSMSnapId>
	<TotalSnaps>%d</TotalSnaps>
	<InvalidSnaps>%d</InvalidSnaps>
</MM_SMUpdateReconStatus>
*/
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
DECLARE @i_OpType INT = 0
SET @i_OpType = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/OpType') R(ref)), 0)
DECLARE @i_SnapShotEngineId INT = 0
SET @i_SnapShotEngineId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/SnapShotEngineId') R(ref)), 0)
DECLARE @i_ControlHostId INT = 0
SET @i_ControlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/ControlHostId') R(ref)), 0)
DECLARE @i_CommCellId INT = 2
DECLARE @i_ReconJobId INT = 0
SET @i_ReconJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/ReconJobId') R(ref)), 0)
DECLARE @i_ReconHostId INT = 0
SET @i_ReconHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/ReconHostId') R(ref)), 0)
DECLARE @i_FirstSMSnapId INT = 0
SET @i_FirstSMSnapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/FirstSMSnapId') R(ref)), 0)
DECLARE @i_LastSMSnapId INT = 0
SET @i_LastSMSnapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/LastSMSnapId') R(ref)), 0)
DECLARE @i_TotalSnaps INT = 0
SET @i_TotalSnaps = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/TotalSnaps') R(ref)), 0)
DECLARE @i_InvalidSnaps INT = -1
SET @i_InvalidSnaps = ISNULL(( SELECT R.ref.value('.', 'int') FROM @req.nodes('/MM_SMUpdateReconStatus/InvalidSnaps') R(ref)), -1)
--In starting of new recon job, if there are job details for input controlHost then delete job details from SMReconStats
IF @i_OpType=1
BEGIN
	IF EXISTS (SELECT TOP 1 RS.ReconStatId
				FROM SMReconStats RS WITH (NOLOCK)
				WHERE RS.ControlHostId = @i_ControlHostId AND RS.ReconJobId != @i_ReconJobId AND RS.CommCellId = @i_CommCellId
			  )
	BEGIN
		BEGIN TRAN DeleteOldJob
			DELETE FROM SMReconStats
			WHERE ControlHostId = @i_ControlHostId AND CommCellId = @i_CommCellId AND ReconJobId != @i_ReconJobId
			SELECT @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to delete previous job details in SMReconStats.'
				ROLLBACK TRAN DeleteOldJob
				GOTO SP_EXIT
			END
		COMMIT TRAN DeleteOldJob
	END
END
ELSE --update table
BEGIN
	DECLARE @reconStatId INT = -1
	SET @reconStatId = (SELECT ReconStatId
						FROM SMReconStats WITH (NOLOCK)
						WHERE SnapShotEngineId = @i_SnapShotEngineId AND ControlHostId = @i_ControlHostId AND CommCellId = @i_CommCellId
						AND ReconJobId = @i_ReconJobId AND ReconHostId = @i_ReconHostId AND FirstSMSnapId = @i_FirstSMSnapId AND LastSMSnapId = @i_LastSMSnapId
						)
	IF @reconStatId !=-1 --update
	BEGIN
		BEGIN TRAN SMReconSTatsUpdate
			UPDATE SMReconStats
			SET InvalidSnaps = @i_InvalidSnaps, UpdateTime = GETUTCDATE()
			WHERE ReconStatId = @reconStatId
			SELECT @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to update entry in SMReconStats.'
				ROLLBACK TRAN SMReconSTatsUpdate
				GOTO SP_EXIT
			END
		COMMIT TRAN SMReconSTatsUpdate
	END
	ELSE --insert entry
	BEGIN
		BEGIN TRAN SMReconSTatsInsert
		INSERT INTO SMReconStats(SnapShotEngineId, ControlHostId, CommCellId, ReconJobId, ReconHostId, FirstSMSnapId, LastSMSnapId, TotalSnaps, InvalidSnaps,CreationTime,UpdateTime)
		VALUES(@i_SnapShotEngineId, @i_ControlHostId, @i_CommCellId, @i_ReconJobId, @i_ReconHostId, @i_FirstSMSnapId, @i_LastSMSnapId, @i_TotalSnaps, @i_InvalidSnaps,GETUTCDATE(),GETUTCDATE())
		SELECT @o_ErrorCode = @@ERROR
			IF @o_ErrorCode <> 0
			BEGIN
				SET @o_ErrorStr = 'Failed to insert entry in SMReconStats.'
				ROLLBACK TRAN SMReconSTatsInsert
				GOTO SP_EXIT
			END
		COMMIT TRAN SMReconSTatsInsert
	END
END
SP_EXIT:
SELECT @o_ErrorCode, @o_ErrorStr
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateReconStatus')
	delete from GxQscripts where name = 'MM_SMUpdateReconStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateReconStatus')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateReconStatus'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateReconStatus',  '00000000000000000000', 'MM_SMUpdateReconStatus', '00000000000000000000')
GO

