

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateMAStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMUpdateMAStats.sp,v $ $Id: MM_SMUpdateMAStats.sp,v 1.1.2.2 2020/10/04 01:06:49 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMUpdateMAStats')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMUpdateMAStats <<<'
	drop procedure MM_SMUpdateMAStats
END
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateMAStats')
	delete from GxQscripts where name = 'MM_SMUpdateMAStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateMAStats')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateMAStats'
GO
print '... Creating Procedure: MM_SMUpdateMAStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateMAStats
  @i_inputXML XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
<MM_SMUpdateMAStats>
    <HostId>2</HostId>
    <OpType>2</OpType>
    <ActionFlags>3</ActionFlags>
</MM_SMUpdateMAStats>
*/
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
DECLARE @CURRENT_UNIX_TIME INTEGER = dbo.GetUnixTime(GETUTCDATE())
DECLARE @MM_SM_OPTYPE_DELETE_SNAP INTEGER	= 1
DECLARE @MM_SM_OPTYPE_MOUNT_SNAP INTEGER	= 2
DECLARE @MM_SM_OPTYPE_REVERT_SNAP INTEGER	= 4
DECLARE @MM_SM_OPTYPE_RECON_SNAP INTEGER	= 7
DECLARE @HostId INTEGER	= 0
DECLARE @Flags BIGINT	= 0
DECLARE @OpType INTEGER	= 0
SELECT
	@HostId = ISNULL(R.ref.value('(HostId)[1]', 'int'), 0) ,
	@Flags = ISNULL(R.ref.value('(ActionFlags)[1]', 'bigint'), 0) ,
	@OpType = ISNULL(R.ref.value('(OpType)[1]', 'int'), 0)
FROM @i_inputXML.nodes('/MM_SMUpdateMAStats') R(ref)
BEGIN TRY
	IF NOT EXISTS ( SELECT 1 FROM SMMAStats	WHERE HostId = @HostId)
	BEGIN
		IF @OpType = @MM_SM_OPTYPE_MOUNT_SNAP
		BEGIN
			INSERT INTO SMMAStats
			(HostId,MountCount,LastMountTimestamp,ModifiedTime)
			VALUES
			(@HostId,1,@CURRENT_UNIX_TIME,@CURRENT_UNIX_TIME)
		END
		ELSE IF @OpType = @MM_SM_OPTYPE_RECON_SNAP
		BEGIN
			INSERT INTO SMMAStats
			(HostId,ReconCount,LastReconTimestamp,ModifiedTime)
			VALUES
			(@HostId,1,@CURRENT_UNIX_TIME,@CURRENT_UNIX_TIME)
		END
		ELSE IF (@OpType = @MM_SM_OPTYPE_DELETE_SNAP)
		BEGIN
			INSERT INTO SMMAStats
			(HostId,PruneCount,LastPruneTimestamp,ModifiedTime)
			VALUES
			(@HostId,1,@CURRENT_UNIX_TIME,@CURRENT_UNIX_TIME)
		END
	END
	ELSE
	BEGIN
		IF @OpType = @MM_SM_OPTYPE_MOUNT_SNAP
		BEGIN
			UPDATE SMMAStats
			SET
				MountCount =MountCount+1,
				LastMountTimestamp = @CURRENT_UNIX_TIME,
				ModifiedTime = @CURRENT_UNIX_TIME
			WHERE HostId = @HostId
		END
		ELSE IF @OpType = @MM_SM_OPTYPE_RECON_SNAP
		BEGIN
			UPDATE SMMAStats
			SET
				ReconCount =ReconCount+1,
				LastReconTimestamp = @CURRENT_UNIX_TIME,
				ModifiedTime = @CURRENT_UNIX_TIME
			WHERE HostId = @HostId
		END
		ELSE IF (@OpType = @MM_SM_OPTYPE_DELETE_SNAP)
		BEGIN
			UPDATE SMMAStats
			SET
				PruneCount =PruneCount+1,
				LastPruneTimestamp = @CURRENT_UNIX_TIME,
				ModifiedTime = @CURRENT_UNIX_TIME
			WHERE HostId = @HostId
		END
	END
	SELECT 0,''
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_ErrorCode = ERROR_NUMBER()
	SET @o_ErrorStr  = ERROR_MESSAGE()
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	;THROW
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateMAStats')
	delete from GxQscripts where name = 'MM_SMUpdateMAStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateMAStats')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateMAStats'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateMAStats',  '00010001000200020000', 'MM_SMUpdateMAStats', '00010001000200020000')
GO

