

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateDSReplicationInfo.sp] ---------- 

	-- ----------------------------------------------------------------------
	--
	--           Copyright (c) 2007  CommVault Systems, Inc.
	--                  All rights reserved.
	--
	--
	--        This is unpublished proprietary source code of CommVault
	--        Systems, Inc. The copyright notice above does not evidence
	--        any actual or intended publication of such source code.
	-- ----------------------------------------------------------------------*/
	-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMUpdateDSReplicationInfo.sp,v $ $Id: MM_SMUpdateDSReplicationInfo.sp,v 1.1.2.13 2020/01/30 00:14:06 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMUpdateDSReplicationInfo')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMUpdateDSReplicationInfo <<<'
	drop procedure MM_SMUpdateDSReplicationInfo
END
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateDSReplicationInfo')
	delete from GxQscripts where name = 'MM_SMUpdateDSReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateDSReplicationInfo')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateDSReplicationInfo'
GO
print '... Creating Procedure: MM_SMUpdateDSReplicationInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMUpdateDSReplicationInfo
  @i_xmltextinput XML,
  @i_options INTEGER 
AS
  DECLARE @o_errorcode INTEGER  
  DECLARE @o_errorstr VARCHAR(255)-- this will turn off message: "xxx ROWS affected".
SET NOCOUNT ON
/*
<MM_SMUpdateDSReplicationInfo>
   <JobId>12345</JobId>
   <CopyId>36</CopyId>
</MM_SMUpdateDSReplicationInfo>
*/
DECLARE @currenttime datetime =  getutcdate()
DECLARE @jobid INT = -1
DECLARE @copyId INT = 0
DECLARE @vsclientid INT = 0
DECLARE @pairId INT = 0
DECLARE @arrayNum INT = 0
declare @sourceCopyId int =0
-- snap aux copy for VSA V2.1 is enabled bydefault and INSIEL project is enabled by default on SP20
-- enabling it by default but keeping the key for one SP ( incase needed to disable it by putting 0 )
DECLARE @VSAV2SnapCopyEnabled int =1
SET @VSAV2SnapCopyEnabled = ISNULL((SELECT value FROM GXGlobalParam WITH (READUNCOMMITTED) WHERE name = N'VSAV2SnapCopyEnabled' AND modified = 0), 1)
IF ( @VSAV2SnapCopyEnabled  = 0)
RETURN
SET @jobid = @i_xmlTextInput.value('(/MM_SMUpdateDSReplicationInfo/JobId)[1]', 'int')
SET @copyId = @i_xmlTextInput.value('(/MM_SMUpdateDSReplicationInfo/CopyId)[1]', 'int')
/* if current job is a child job ( != masterjobid ) and for replica copy , and flags set for CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/
IF NOT EXISTS
(
	SELECT 1
	FROM smvolume WITH (READUNCOMMITTED)
	WHERE jobid = @jobid
		AND MasterJobId <> @jobid
		AND copyid = @copyId
AND volumeflags & CAST(4294967296 AS BIGINT) = 4294967296  /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/
)
RETURN
BEGIN TRY
	BEGIN TRANSACTION MM_SMUpdateDSReplicationInfo
-- Table Variable
IF object_id('tempdb.dbo.#tblDSReplication') IS NOT Null DROP TABLE #tblDSReplication
CREATE TABLE #tblDSReplication (
	id INT identity(1, 1)
	,clientId INT
,DSName NVARCHAR(255)
,DSGuid NVARCHAR(255)
	,ArrayNum INT
,Metadata NVARCHAR(2048)
,VolumeName NVARCHAR(255)
	,sourceDatastoreid INT
	,pairId int
	,sourceArrayNum int
	, dstDatastoreId int,
sourceVolumeName nvarchar(255),
sourceMetaData nvarchar(2048),
sourceDeviceid nvarchar(2048),
	replicaGroupId int,
	smSnapId int
	)
	INSERT INTO #tblDSReplication
	SELECT DISTINCT volume.OriginClientId
		,NULL
		,NULL
		,SMR.TgtArrayNum
		,M.MetaData
		,NULL
		,0
		,smr.ReplicaPairId
		,SMR.SrcArrayNum
		,0,
		NULL,
		NULL,
		snap.SnapSourceDevice,
		repGrp.ReplicaGroupId,
		snap.SMSnapId
	FROM SMVolume volume WITH (READUNCOMMITTED)
	INNER JOIN SMVolSnapMap volmap WITH (READUNCOMMITTED) ON volmap.SMVolumeId = volume.SMVolumeId
		AND jobid = @jobId
	INNER JOIN smsnap snap WITH (READUNCOMMITTED) ON snap.SMSnapId = volmap.SMSnapId
	INNER JOIN SMMetaData M WITH (READUNCOMMITTED) ON M.RefId = snap.SMSnapId
		AND M.RefType = 2
		AND volume.CopyId = @copyId
	INNER JOIN SMSnapToReplicaGroupMap grpMap WITH (READUNCOMMITTED) ON snap.SMSnapId = grpMap.SMSnapId
	INNER JOIN SMReplicaGroup repGRP WITH (READUNCOMMITTED) ON grpMap.ReplicaGroupId = repGRP.ReplicaGroupId
	INNER JOIN SMReplicaEntities repEntity WITH (READUNCOMMITTED) ON repEntity.ReplicaEntityId = repGRP.TgtEntityId
	INNER JOIN SMReplicaEntities repEntitySrc WITH (READUNCOMMITTED) ON repEntitySrc.ReplicaEntityId = repGRP.SrcEntityId
	INNER JOIN SMArrayReplicaPairs SMR WITH (READUNCOMMITTED) 	on repEntity.ArrayNum = SMR.TgtArrayNum and repEntitySrc.ArrayNum = SMR.SrcArrayNum
	AND ArchGroupCopyId = @copyId
	select @sourceCopyId = sourceCopyId from archgroupcopy where id = @copyId
	update DS
	set sourceMetaData = M.Metadata
	from #tblDSReplication DS
	INNER JOIN SMVolume volume WITH (READUNCOMMITTED)
	on volume.jobid = @jobid
	INNER JOIN SMVolSnapMap volmap WITH (READUNCOMMITTED) ON volmap.SMVolumeId = volume.SMVolumeId
	INNER JOIN smsnap snap WITH (READUNCOMMITTED) ON snap.SMSnapId = volmap.SMSnapId
	INNER JOIN SMMetaData M WITH (READUNCOMMITTED) ON M.RefId = snap.SMSnapId
		AND M.RefType = 2
		AND volume.CopyId = @sourceCopyId
		and DS.sourceDeviceid = snap.SnapSourceDevice
	DECLARE @Metadata TABLE (metadata NVARCHAR(MAX))
	SELECT  @vsclientid  = app.clientid
	FROM APP_Application app WITH (READUNCOMMITTED)
	INNER JOIN JMJobDataLink WITH (READUNCOMMITTED) ON parentAppid = id
	WHERE childJobId = @jobid
	update DS
	set pairId = ReplicaPairId
	FROM #tblDSReplication DS
	INNER JOIN SMArrayReplicaPairs SMR WITH (READUNCOMMITTED)
	on DS.ArrayNum = SMR.TgtArrayNum
	WHERE ArchGroupCopyId = @copyId
	update #tblDSReplication
	set metadata = substring(metadata, CHARINDEX('3#6', metadata), len(metadata))
	update #tblDSReplication
	set sourceMetaData = substring(sourceMetaData, CHARINDEX('3#6', sourceMetaData), len(sourceMetaData))
	UPDATE DS
	SET DSName = T.Datastore
		,sourceVolumeName = T.Volume
		,DSGUid = T.DSGuid
	FROM #tblDSReplication DS
	INNER JOIN (
		SELECT DS.id
			,max(CASE
					WHEN R.id = 18
						THEN DATA
					ELSE NULL
					END) AS Datastore
			,max(CASE
					WHEN R.id = 4
						THEN DATA
					ELSE NULL
					END) AS Volume
			,max(CASE
					WHEN R.id = 20
						THEN DATA
					ELSE NULL
					END) AS DSGuid
		FROM #tblDSReplication DS
		CROSS APPLY SplitStringMaxLen(sourceMetaData, '|') R
		GROUP BY DS.id
		) T ON DS.id = T.id
	UPDATE DS
	SET
		VolumeName = T.Volume
	FROM #tblDSReplication DS
	INNER JOIN (
		SELECT DS.id
			,max(CASE
					WHEN R.id = 4
						THEN DATA
					ELSE NULL
					END) AS Volume
		FROM #tblDSReplication DS
		CROSS APPLY SplitStringMaxLen(Metadata, '|') R
		GROUP BY DS.id
		) T ON DS.id = T.id
	DECLARE @DSOut table
	(
		srcDatastoreId int,
		arrayNum int,
		actionval nvarchar(256),
		destDatastoreId int,
		VolumeName nvarchar(256)
	)
	DECLARE @DestDSOut table
	(
		dstDatastoreId int,
		srcDatastoreId int
	)
	MERGE SMVMDatastore src
    USING ( select distinct DSguid, DSName, ArrayNum, sourceArrayNum, sourceVolumeName, VolumeName from #tblDSReplication ) as dst
		ON src.VirtualClientId = @vsclientid
			AND src.DSGuid = dst.DSGuid
			AND src.ArrayNum = dst.sourceArrayNum
			AND src.VolumeName = dst.sourceVolumeName
	WHEN MATCHED
		THEN
			UPDATE
			SET DSName = dst.DSName
				,VolumeName = dst.sourceVolumeName
	WHEN NOT MATCHED
		THEN
			INSERT (
				VirtualClientId
				,DSName
				,DSGuid
				,ArrayNum
				,VolumeName
				,Flags
				)
			VALUES (
				@vsclientid
				,dst.DSName
				,dst.DSGuid
				,dst.sourceArrayNum
				,dst.sourceVolumeName
				,0
				)
				OUTPUT  inserted.id, dst.Arraynum,  $action,0, dst.VolumeName INTO @DSOut;
	MERGE SMVMDatastore src
	USING @DSOut AS dst
	on dst.actionval !='INSERT'
	WHEN NOT MATCHED
		THEN
			INSERT (
				VirtualClientId
				,DSName
				,DSGuid
				,ArrayNum
				,VolumeName
				,Flags
				)
			values( 1,
			        'DS_NAME',
					'DS_GUID',
					 arraynum,
					 VolumeName,
					 0
				)
		OUTPUT  inserted.id, dst.srcDatastoreId INTO @DestDSOut;
	UPDATE DS
	SET sourceDatastoreid = SDS.id
	FROM #tblDSReplication DS
	INNER JOIN SMVMDatastore SDS WITH (READUNCOMMITTED) ON DS.DSGuid = SDS.DSGuid
		AND DS.sourceArrayNum = SDS.ArrayNum
		AND DS.sourceVolumeName = SDS.VolumeName
		UPDATE DS
	SET dstDatastoreId = DSout.dstDatastoreId
	FROM #tblDSReplication DS
	INNER JOIN @DestDSOut DSout
	on DS.sourceDatastoreid = DSout.srcDatastoreId
		UPDATE DS
	SET dstDatastoreId = map.destinationDatastoreid
	FROM #tblDSReplication DS
	INNER JOIN SMVMReplicationMap map
	on DS.sourceDatastoreid = map.sourceDatastoreId
	where DS.dstDatastoreId =0
	UPDATE SDS
	SET VolumeName = DS.VolumeName
	FROM SMVMDatastore SDS with (nolock)
	INNER JOIN #tblDSReplication DS
	on SDS.Id = DS.dstDatastoreId
	where DS.VolumeName != SDS.VolumeName
	MERGE SMVMReplicationMap  src
	USING ( select distinct clientId, sourceDatastoreid, pairId, dstDataStoreId, replicaGroupId  from #tblDSReplication ) as dst
		ON src.clientId = dst.clientId
			AND src.sourceDatastoreid = dst.sourceDatastoreid
			AND src.Pairid = dst.pairId
			and src.ReplicaCopyId = @copyId
	WHEN MATCHED
		THEN
			UPDATE
			SET updateTime = @currenttime,
			    ReplicaGroupId = dst.replicaGroupId,
				lastsyncjobid = @jobid
	WHEN NOT MATCHED
		THEN
			INSERT (
				ClientId
				,SourceDataStoreId
				,DestinationDataStoreId
				,PairId
				,UpdateTime
				,Flags
				,ReplicaGroupId
				,RelationshipStatus
				,LastSyncJobId
				,ReplicaCopyId
				)
			VALUES (
				dst.clientId
				,dst.sourceDatastoreid
				,dst.dstDataStoreId
				,dst.pairId
				,@currenttime
				,0
				,dst.replicaGroupId
				,0
				,@jobid
				,@copyId
				);
--
-- insert smsnap and datastore id into SMVMDatastoreToSnapMap.
-- FOR source datastore
MERGE SMVMDatastoreToSnapMap  snapMap
	USING ( select distinct sourceDatastoreid, smSnapId  from #tblDSReplication ) as dst1
		ON
	        snapMap.smvmdatastoreid = dst1.sourceDatastoreid
			AND snapMap.smSnapId = dst1.smSnapid
	WHEN NOT MATCHED
		THEN
			INSERT (
				smvmdatastoreid
				, smsnapid
				, flags
				)
			VALUES (
				dst1.sourceDatastoreid
				,dst1.smSnapid
				, 0
				);
-- For DESTINATION datastore
 MERGE SMVMDatastoreToSnapMap  snapMap
	USING ( select distinct dstDatastoreid, smSnapId from #tblDSReplication ) as dst2
		ON
	        snapMap.smvmdatastoreid = dst2.dstDatastoreid
			AND snapMap.smSnapId = dst2.smSnapid
	WHEN NOT MATCHED
		THEN
			INSERT (
				smvmdatastoreid
				, smsnapid
				, flags
				)
			VALUES (
				dst2.dstDatastoreid
				,dst2.smSnapid
				, 0
				);
	IF object_id('tempdb.dbo.#tblDSReplication') IS NOT Null DROP TABLE #tblDSReplication
	COMMIT TRANSACTION MM_SMUpdateDSReplicationInfo
END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION MM_SMUpdateDSReplicationInfo
	SET @o_errorcode = error_number()
	SET @o_errorstr = error_message()
END CATCH
SELECT @o_errorcode
	,@o_errorstr
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateDSReplicationInfo')
	delete from GxQscripts where name = 'MM_SMUpdateDSReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateDSReplicationInfo')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateDSReplicationInfo'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateDSReplicationInfo',  '00010001000200130000', 'MM_SMUpdateDSReplicationInfo', '00010001000200130000')
GO

