

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMUpdateArrayClientId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMUpdateArrayClientId.sp,v $ $Id: MM_SMUpdateArrayClientId.sp,v 1.1.2.2 2020/12/18 10:34:44 mmani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMUpdateArrayClientId')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMUpdateArrayClientId <<<'
	drop procedure MM_SMUpdateArrayClientId
END
IF EXISTS (select * from GxQscripts where name='MM_SMUpdateArrayClientId')
	delete from GxQscripts where name = 'MM_SMUpdateArrayClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateArrayClientId')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateArrayClientId'
GO
print '... Creating Procedure: MM_SMUpdateArrayClientId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMUpdateArrayClientId
  @i_xmlTextInput XML,
  @i_reserveInt INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
SET XACT_ABORT ON
-- XML Structure for MM_SMUpdateArrayClientId
/*
	<MM_SMUpdateArrayClientId>
		<Array ClientId="1052" ArrayNum="60" ArrayId = "172.24.31.87"/>
	</MM_SMUpdateArrayClientId>
*/
----------------------
SET @o_ErrorCode = 0
SET @o_ErrorStr  = N''
--Validate  Input XML
IF @i_xmlTextInput IS NULL
BEGIN
SET @o_ErrorCode = 60373 /*E_MM_SM_SP_IS_UPDATE_ARRAY_CLIENT_ID_FAILED */
    SET @o_ErrorStr = 'Input xml parameter cannot be empty.'
    GOTO PROC_END
END
DECLARE @CLIENT_PROP_NAS_TYPE           VARCHAR(32) 	= 'NAS Client Type'
DECLARE @CLIENT_PROP_VSERVER_NAME       VARCHAR(32) 	= 'NAS vServer Name'
DECLARE @TmpError						VARCHAR(1024) 	=  N''
-- Create Table from XML Input
IF OBJECT_ID('tempdb.dbo.#tblSMUpdateArrayClientId') IS NOT NULL DROP TABLE #tblSMUpdateArrayClientId
CREATE TABLE #tblSMUpdateArrayClientId (ArrayNum NVARCHAR(512), NewClientId int, OldClientId int)
IF OBJECT_ID('tempdb.dbo.#tblAppClientProp') IS NOT NULL DROP TABLE #tblAppClientProp
CREATE TABLE #tblAppClientProp (ClientId INT, attrName NVARCHAR(2048), attrType INT, attrVal NVARCHAR(2048), modified INT)
INSERT INTO #tblSMUpdateArrayClientId(ArrayNum, NewClientId, OldClientId)
SELECT	R.ref.value('@ArrayNum', 'NVARCHAR(512)') AS ArrayNum,
		R.ref.value('@ClientId','int' ) AS NewClientId,
		0 AS OldClientId
FROM @i_xmlTextInput.nodes('/MM_SMUpdateArrayClientId/Array') R(ref)
--Validate  Input XML from Temp Table
IF NOT EXISTS (SELECT 1 FROM #tblSMUpdateArrayClientId)
BEGIN
SET @o_ErrorCode = 60373 /*E_MM_SM_SP_IS_UPDATE_ARRAY_CLIENT_ID_FAILED */
    SET @o_ErrorStr = 'No ArrayNum or ClientId found in input xml'
    GOTO PROC_END
END
--Validate ControlHostId in SMControlHost
SET @TmpError = (
					SELECT  TOP 1 TMPARR.ArrayNum
					FROM    #tblSMUpdateArrayClientId TMPARR
					LEFT JOIN
							SMControlHost SMCtrlHost
					ON      SMCtrlHost.ControlHostId = TMPARR.ArrayNum
					WHERE   SMCtrlHost.ControlHostId IS NULL
					)
IF @TmpError IS NOT NULL
BEGIN
SET @o_ErrorCode = 60373 /*E_MM_SM_SP_IS_UPDATE_ARRAY_CLIENT_ID_FAILED */
	SET @o_ErrorStr ='ArrayNum ['+  @TmpError +'] not found on SMControlHost table.'
	GOTO PROC_END
END
--Validate App_Client Id
SET @TmpError = (
					SELECT  TOP 1 CAST(TMPARR.NewClientId AS VARCHAR(128))
					FROM    #tblSMUpdateArrayClientId TMPARR
					LEFT JOIN
							App_Client APPCLI
					ON      APPCLI.id = TMPARR.NewClientId
					WHERE   APPCLI.id IS NULL
					)
IF @TmpError IS NOT NULL
BEGIN
SET @o_ErrorCode = 60373 /*E_MM_SM_SP_IS_UPDATE_ARRAY_CLIENT_ID_FAILED */
	SET @o_ErrorStr ='Invalid Client id ['+  @TmpError +'] found'
	GOTO PROC_END
END
--Start Updating Client Id
BEGIN TRY
	BEGIN TRANSACTION UpdateArrayClientId
	--Update the input table to hold the old/exisiting clientID corresponding to the array
	UPDATE #tblSMUpdateArrayClientId
	SET
	OldClientId = HOST.ClientId
	FROM #tblSMUpdateArrayClientId TMPARR
	INNER JOIN SMControlHost HOST ON TMPARR.ArrayNum = HOST.ControlHostId
	--If array is cluster - change the PMClientId in the APP_VMToPMMap table
	IF EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE PMClientId IN (SELECT OldClientId FROM #tblSMUpdateArrayClientId))
	BEGIN
		UPDATE PVMAP
		SET
		PVMAP.PMClientId=TMPARR.NewClientId
		FROM APP_VMToPMMap PVMAP INNER JOIN #tblSMUpdateArrayClientId TMPARR ON TMPARR.OldClientId = PVMAP.PMClientId
	END
	--If array is vserver - update the VMClientId - If the new vserver client already exists, then update the PMCLientID to that of the exisitng vservers PMClientID
	IF EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE VMClientId IN (SELECT NewClientId FROM #tblSMUpdateArrayClientId))
	BEGIN
		UPDATE PVMAP
		SET PVMAP.PMClientId = T1.PMCLientID
		FROM APP_VMToPMMap PVMAP
		INNER JOIN
		(SELECT PVMAP1.PMCLientID, PVMAP1.VMClientId, TMPARR.NewClientId FROM APP_VMToPMMap PVMAP1 INNER JOIN #tblSMUpdateArrayClientId TMPARR ON PVMAP1.VMClientId=TMPARR.OldClientId)T1
		ON PVMAP.VMClientId = T1.NewClientId
	END
	--If the new vserver client does not exist
	UPDATE PVMAP
	SET PVMAP.VMClientId=TMPARR.NewClientId
	FROM APP_VMToPMMap PVMAP INNER JOIN
	(SELECT NewClientId, OldClientId
	FROM #tblSMUpdateArrayClientId TMPARR
	WHERE NOT EXISTS (SELECT 1
						  FROM APP_VMToPMMap PMVM
						  WHERE TMPARR.NewClientId = PMVM.PMClientId OR TMPARR.NewClientId= PMVM.VMClientId)) TMPARR ON TMPARR.OldClientId = PVMAP.VMClientId
	-- Update SMArray Table
	UPDATE ARRAY
	SET
	ARRAY.ClientId = TMPARR.NewClientId
	FROM #tblSMUpdateArrayClientId  as TMPARR
	INNER JOIN SMControlHost as HOST ON TMPARR.ArrayNum = HOST.ControlHostId
	INNER JOIN SMArray as ARRAY ON HOST.ClientId = ARRAY.ClientId
	-- Update SMControlHost Table
	UPDATE SMControlHost
	SET
	SMControlHost.Clientid = TMPARR.NewClientId
	FROM SMControlHost
	JOIN #tblSMUpdateArrayClientId AS TMPARR ON TMPARR.ArrayNum = SMControlHost.ControlHostId
	-- Get the NAS client property belonging to the oldclient
	INSERT INTO #tblAppClientProp
	SELECT TMPARR.OldClientId, CLIENTPROP.attrName, CLIENTPROP.attrType, CLIENTPROP.attrVal, CLIENTPROP.modified
	FROM   #tblSMUpdateArrayClientId AS TMPARR INNER JOIN APP_ClientProp AS CLIENTPROP ON TMPARR.OldClientId = CLIENTPROP.componentNameId
	WHERE CLIENTPROP.attrName IN (@CLIENT_PROP_NAS_TYPE,@CLIENT_PROP_VSERVER_NAME) AND CLIENTPROP.modified = 0
	--Update the NAS client properties for the new client
	MERGE APP_ClientProp TGT
	USING (SELECT ClientId, NewClientId, attrName, attrType, attrVal, modified
		   FROM #tblSMUpdateArrayClientId AS TMPARR
		   INNER JOIN #tblAppClientProp AS TMPPROP ON TMPPROP.ClientID = TMPARR.OldClientID)SRC
	ON TGT.componentNameId = SRC.NewClientId AND TGT.attrName = SRC.attrName AND TGT.modified = SRC.modified
	WHEN MATCHED
	THEN UPDATE SET
		TGT.attrVal = SRC.attrVal
	WHEN NOT MATCHED BY TARGET
	THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES (SRC.NewClientId,SRC.attrName,SRC.attrType, SRC.attrVal,dbo.GetUnixTime(GETUTCDATE()), 0,0 );
	COMMIT TRANSACTION UpdateArrayClientId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION UpdateArrayClientId
SET @o_ErrorCode = 60373 /*E_MM_SM_SP_IS_UPDATE_ARRAY_CLIENT_ID_FAILED */
	SET @o_ErrorStr ='ERROR: PROC(' + ERROR_PROCEDURE() +
					'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
					'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
					'), INFO: ' + ERROR_MESSAGE() + '.'
END CATCH
PROC_END:
SELECT @o_ErrorCode, @o_ErrorStr
IF OBJECT_ID('tempdb.dbo.#tblSMUpdateArrayClientId') IS NOT NULL DROP TABLE #tblSMUpdateArrayClientId
IF OBJECT_ID('tempdb.dbo.#tblAppClientProp') IS NOT NULL DROP TABLE #tblAppClientProp
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMUpdateArrayClientId')
	delete from GxQscripts where name = 'MM_SMUpdateArrayClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMUpdateArrayClientId')
	delete from GXDBVersions where aliasname = 'MM_SMUpdateArrayClientId'
GO

insert into GXDBVersions values(2, 'MM_SMUpdateArrayClientId',  '00010001000200020000', 'MM_SMUpdateArrayClientId', '00010001000200020000')
GO

