

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMSpoolCopyUnpickedForBackupCopyReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMSpoolCopyUnpickedForBackupCopyReport.sp,v $ $Id: MM_SMSpoolCopyUnpickedForBackupCopyReport.sp,v 1.1.2.1 2020/12/18 05:47:08 bbrindavan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMSpoolCopyUnpickedForBackupCopyReport')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMSpoolCopyUnpickedForBackupCopyReport <<<'
	drop procedure MM_SMSpoolCopyUnpickedForBackupCopyReport
END
IF EXISTS (select * from GxQscripts where name='MM_SMSpoolCopyUnpickedForBackupCopyReport')
	delete from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSpoolCopyUnpickedForBackupCopyReport')
	delete from GXDBVersions where aliasname = 'MM_SMSpoolCopyUnpickedForBackupCopyReport'
GO
print '... Creating Procedure: MM_SMSpoolCopyUnpickedForBackupCopyReport'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMSpoolCopyUnpickedForBackupCopyReport
AS
DECLARE @SM_REPT_OP_TYPE_SPOOLCOPY	INTEGER	=	2		/* SM_REPT_OP_TYPE_SPOOLCOPY */
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SELECT DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, VOL.JobId, VOL.CopyId, VOL.CommCellId, VOL.CreationTime, VOL.RetryCount, VOL.SourceClientId, VOL.OriginClientId,
        VOL.SourcePath, VOL.OriginSourcePath, VOL.AppId, VOL.AppTypeId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatus , 'N/A', 'N/A', 'N/A',APPTYPE.name, @SM_REPT_OP_TYPE_SPOOLCOPY  /* @SM_REPT_OP_TYPE_SPOOLCOPY */
FROM    SMVolume VOL WITH (READUNCOMMITTED)
        INNER JOIN  SMVolSnapMap MAP WITH (READUNCOMMITTED) ON VOL.SMVolumeId = MAP.SMVolumeId
        INNER JOIN  SMSnap SNAP WITH (READUNCOMMITTED) ON SNAP.SMSnapId = MAP.SMSnapId
        INNER JOIN  APP_iDAType APPTYPE WITH (READUNCOMMITTED) ON APPTYPE.type = VOL.AppTypeId
		INNER JOIN  JMJobSnapshotStats as jmJob WITH (READUNCOMMITTED) ON jmJob.jobId = VOL.JobId
		INNER JOIN	ArchGroupCopy as spCopy WITH (READUNCOMMITTED) ON  spCopy.archGroupId = jmJob.archGrpId
		INNER JOIN	ArchAgingRule as agingRule WITH (READUNCOMMITTED) ON agingRule.CopyId = spCopy.Id
		INNER JOIN	ArchGroup as sp WITH (READUNCOMMITTED) ON sp.Id = spCopy.archGroupId
		INNER JOIN  APP_Client CLNT WITH (READUNCOMMITTED) ON CLNT.id = (CASE WHEN VOL.AppTypeId =13 THEN VOL.OriginClientId
														   ELSE VOL.SourceClientId END)
		INNER JOIN  APP_Application APP WITH (READUNCOMMITTED) ON VOL.AppId = APP.id
        INNER JOIN  APP_BackupSetName BS WITH (READUNCOMMITTED) ON BS.id = APP.backupSet
	WHERE agingRule.retentionDays 		= 0   					AND
		  agingRule.fullCycles 	 		= 0	  					AND   	-- spool copy
		  jmJob.materializationStatus 	> 100 					AND		-- backup not done  (For BACKUP/AUXCOPY)
		  jmJob.disabled 				in (1,16,32,64)	  		AND		-- backup copy unpicked (CVA_DONOTCOPY_FLAG/CVA_SYSTEM_DONOTCOPY/CVA_AUXCOPY_SKIPPED/CVA_BAD_JOB_FLAG)
VOL.MountStatus 				< 90			-- Snap deletion not tried 90 or 90
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyReport')
	delete from GxQscripts where name = 'MM_SMSpoolCopyUnpickedForBackupCopyReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMSpoolCopyUnpickedForBackupCopyReport')
	delete from GXDBVersions where aliasname = 'MM_SMSpoolCopyUnpickedForBackupCopyReport'
GO

insert into GXDBVersions values(2, 'MM_SMSpoolCopyUnpickedForBackupCopyReport',  '00010001000200010000', 'MM_SMSpoolCopyUnpickedForBackupCopyReport', '00010001000200010000')
GO

